	SUBROUTINE SUPMAP(JPROJ,POLAT,POLON,RROT,PL1,PL2,PL3,PL4,JJLTS,
	1 JGRID,JUS,IER)
C
C THIS SUBROUTINE TRANSLATES ARGUMENTS, COMPUTES BOUNDS AND INITIALIZES
C OUTPUT DEVICE
C
	COMMON /SUPMP1/ DTR,ILF,PHIOC,SINR,U2,CONE,EPS,ILTS,
	1 PI,TOVPI,V,CON1,ICROSS,IOUT,POLONG,U,VEPS,CON2,IPROJ,
	2 RLAT,UEPS,VMAX,COSO,IFST,JGR,RLON,UMAX,VMIN,COSR,IGO,OV90,
	3 RTD,UMIN,VOLD,DI,IGOLD,PHIA,SGN,UOLD,V1,DS,IGRID,PHIO,
	4 SINO,U1,V2,DSRDI,IIER
	DIMENSION PL1(2),PL2(2),PL3(2),PL4(2)
	COMMON /SUPMP2/ ICF,SPLAT(2)
	REAL LAT1,LAT2
	EQUIVALENCE (PLA1,AUMIN),(PLA2,AUMAX),(PLA3,AVMIN),(PLA4,AVMAX)
	EQUIVALENCE (PHIA,LAT1),(ROT,LAT2)
C
	DATA PART /1./
	DATA PLTRES /1024./
	DATA RESLIM /10./
C
	SQU(X) = X*X
	TAN(X) = SIN(X)/COS(X)
C
C ENTRY POINT. COPY ARGUMENTS
C
	IPROJ = JPROJ
	PHIA = POLAT
	POLONG = POLON
	ROT = RROT
	PLA1 = PL1(1)
	PLA2 = PL2(1)
	PLA3 = PL3(1)
	PLA4 = PL4(1)
	ILTS = JJLTS
	IGRID = JGRID
	IOUT = JUS
C
C INITIALIZATION
C
	PHIO = POLON
	PHIOC = 540.-PHIO
	ICROSS = 0
	IIER = 0
	ILF = 0
C
C COMPUTE CONSTANTS APPROPRIATE TO EACH PROJECTION
C
	IF (IPROJ .NE. 3) GOTO 30
C
C LAMBERT CONFORMAL CONIC (3)
C
	SGN = SIGN(1.,.5*(LAT1+LAT2))
	CHI1 = (90.-SGN*LAT1)*DTR
	IF (LAT1 .EQ. LAT2) GOTO 20
	CHI2 = (90.-SGN*LAT2)*DTR
	CONE = ALOG(SIN(CHI1)/SIN(CHI2))/ALOG(TAN(.5*CHI1)/TAN(.5*CHI2))
	GOTO 60
C
20	CONE = COS(CHI1)
	GOTO 60
C
C THE OTHERS
C
30	X1 = ROT*DTR
	X2 = PHIA*DTR
	SINR = SIN(X1)
	COSR = COS(X1)
	SINO = SIN(X2)
	COSO = COS(X2)
	IF (IPROJ-7) 60,67,40
C
C CYLINDRICAL PROJECTIONS (8,9,10)
C
40	IF (PHIA .NE. 0.) GOTO 42
	IF (ROT .EQ. 0.) GOTO 45
	IF (ABS(ROT) .EQ. 180.) GOTO 50
42	SINO1 = COSO*COSR
	COSO1 = SQRT(CON1-SINO1*SINO1)
	OVC1 = 1./COSO1
	PHIO = PHIO-ATAN2(SINR*OVC1,-COSR*SINO*OVC1)*RTD
	PHIOC = 540.-PHIO
	SINR = SINR*COSO*OVC1
	COSR = -SINO*OVC1
	SINO = SINO1
	COSO = COSO1
	GOTO 60
C
C USE SIMPLE TRANSFORMATIONS FOR CYLINDRICAL PROJECTIONS IF
C ROT = POLAT = 0. I.E. IPROJ = 11,12,13
C
45	SINO = 1.
	IPROJ = IPROJ+3
	GOTO 55
C
50	SINO = -1.
	PHIO = PHIO+180.
	PHIOC = PHIOC+180.
55	COSO = 0.
	SINR = 0.
	COSR = 1.
	ILF = 1
C
C ILTS = 1 THE MAXIMUM USEFUL AREA IS PLOTTED
C
60	GOTO (61,62,62,61,61,66,67,68,66,70,68,66,70),IPROJ
C
C STEREOGRAPHIC (1), LAMBERT EQUAL AREA (4), GNOMONIC (5)
C
61	UMIN = -2.
	VMIN = -2.
	UMAX = 2.
	VMAX = 2.
	GOTO 80
C
C ORTHOGRAPHIC (2), LAMBERT CONFORMAL CONIC (3)
C
62	UMIN = -1.
	VMIN = -1.
	UMAX = 1.
	VMAX = 1.
	GOTO 80
C
C AZIMUTHAL EQUIDISTANT (6), MERCATOR WITH ARBITRARY POLE (9),
C MERCATOR (12)
C
66	UMAX = PI
	VMAX = PI
	UMIN = -PI
	VMIN = -PI
	GOTO 80
C
C DUMMY -- ERROR EXIT (7)
C
67	IIER = 33
C 33 SUPMAP-ATTEMPT TO USE NON-EXISTANT PROJECTION
	GOTO 700
C
C CYLINDRICAL EQUIDISTANT (8,11)
C
68	UMAX = 180.
	UMIN = -180.
	VMAX = 90.
	VMIN = -90.
	GOTO 80
C
C MOLLWEIDE TYPE (10,13)
C
70	UMAX = 2.
	UMIN = -2.
	VMAX = 1.
	VMIN = -1.
C
80	UEPS = .5*(UMAX-UMIN)
	VEPS = .5*(VMAX-VMIN)
	IF (IPROJ .EQ. 3) UEPS = 180.
C
C COMPUTE THE APPROPRIATE MAP BOUNDARIES
C
	ICF = 0
	SPLAT(2) = 90.
	SPLAT(1) = -90.
	GOTO (100,200,300,400,500),ILTS
C
100	IF (IPROJ .EQ. 4 .OR. IPROJ .EQ. 6 .OR. IPROJ .GE. 8) ICF = 1
	GOTO 600
C
C ILTS = 2 (PL1,PL2) IN UPPER RIGHT (PL3,PL4) IN LOWER LEFT
C
200	RLAT = PLA1
	RLON = PLA2
	CALL QCON
	U1 = U
	V1 = V
	RLAT = PLA3
	RLON = PLA4
	CALL QCON
	UMAX = AMAX1(U1,U)
	UMIN = AMIN1(U1,U)
	VMAX = AMAX1(V1,V)
	VMIN = AMIN1(V1,V)
	GOTO 600
C
C ILTS = 3 SET PLOT LIMITS DIRECTLY
C
300	UMAX = PLA2
	UMIN = PLA1
	VMAX = PLA4
	VMIN = PLA3
	GOTO 600
C
C ILTS = 4 USE ANGULAR DISTANCES TO SET PLOT LIMITS
C
400	COSUMI = COS(AUMIN*DTR)
	SINUMI = SQRT(CON1-COSUMI*COSUMI)
	COSUMA = COS(AUMAX*DTR)
	SINUMA = SQRT(CON1-COSUMA*COSUMA)
	COSVMI = COS(AVMIN*DTR)
	SINVMI = SQRT(CON1-COSVMI*COSVMI)
	COSVMA = COS(AVMAX*DTR)
	SINVMA = SQRT(CON1-COSVMA*COSVMA)
	GOTO (401,402,403,404,405,406,67,408,409,410,408,409,410)
	1 ,IPROJ
C
C STEREOGRAPHIC (1)
C
401	UMAX = (1.-COSUMA)/SINUMA
	UMIN = -(1.-COSUMI)/SINUMI
	VMAX = (1.-COSVMA)/SINVMA
	VMIN = -(1.-COSVMI)/SINVMI
	GOTO 600
C
C ORTHOGRAPHIC (2)
C
402	IF (AMAX1(AUMIN,AUMAX,AVMIN,AVMAX) .GT. 90.) GOTO 900
	UMAX = SINUMA
	UMIN = -SINUMI
	VMAX = SINVMA
	VMIN = -SINVMI
	GOTO 600
C
C LAMBERT CONFORMAL CONIC (3)
C
403	IIER = 34
C 34 SUPMAP-MAP LIMITS INAPPROPRIATE
	GOTO 700
C
C LAMBERT EQUAL AREA (4)
C
404	UMAX = (1.+COSUMA)/SINUMA
	UMIN = (1.+COSUMI)/SINUMI
	VMAX = (1.+COSVMA)/SINVMA
	VMIN = (1.+COSVMI)/SINVMI
	UMAX = 2./SQRT(1.+UMAX*UMAX)
	UMIN = -2./SQRT(1.+UMIN*UMIN)
	VMAX = 2./SQRT(1.+VMAX*VMAX)
	VMIN = -2./SQRT(1.+VMIN*VMIN)
	GOTO 600
C
C GNOMONIC (5)
C
405	IF (AMAX1(AUMIN,AUMAX,AVMIN,AVMAX) .GE. 90.) GOTO 900
	UMAX = SINUMA/COSUMA
	UMIN = -SINUMI/COSUMI
	VMAX = SINVMA/COSVMA
	VMIN = -SINVMI/COSVMI
	GOTO 600
C
C AZIMUTHAL EQUIDISTANT (6)
C
406	UMAX = AUMAX*DTR
	UMIN = -AUMIN*DTR
	VMAX = AVMAX*DTR
	VMIN = -AVMIN*DTR
	GOTO 600
C
C CYLINDRICAL EQUIDISTANT (8,11)
C
408	UMAX = AUMAX
	UMIN = -AUMIN
	VMAX = AVMAX
	VMIN = -AVMIN
	GOTO 600
C
C MERCATOR (9,12)
C
409	IF (AMAX1(AVMIN,AVMAX) .GE. 90.) GOTO 900
	UMAX = AUMAX*DTR
	UMIN = -AUMIN*DTR
	VMAX = ALOG((1.+SINVMA)/COSVMA)
	VMIN = -ALOG((1.+SINVMI)/COSVMI)
	GOTO 600
C
C MOLLWEIDE TYPE (10,13)
C
410	UMAX = AUMAX*OV90
	UMIN = -AUMIN*OV90
	VMAX = SINVMA
	VMIN = -SINVMI
	GOTO 600
C
C ILTS = 5 USE FOUR EDGE POINTS TO SET LIMITS
C
500	PLB1 = PL1(2)
	RLAT = PLA1
	RLON = PLB1+EPS
	CALL QCON
	UMIN = U
	PLB2 = PL2(2)
	RLAT = PLA2
	RLON = PLB2-EPS
	CALL QCON
	UMAX = U
	PLB3 = PL3(2)
	RLAT = PLA3
	RLON = PLB3
	CALL QCON
	VMIN = V
	PLB4 = PL4(2)
	RLAT = PLA4
	RLON = PLB4
	CALL QCON
	VMAX = V
C
C COMPUTE MAP LIMITS FOR PLOT
C
600	DU = UMAX-UMIN
	DV = VMAX-VMIN
	IF (DU .EQ. 0. .OR. DV .EQ. 0.) GOTO 905
	IF (DU .GT. DV) GOTO 610
	Y1 = .5*(1.-PART)
	Y2 = 1.-Y1
	X1 = .5*(1.-PART*DU/DV)
	X2 = 1.-X1
	GOTO 620
C
610	X1 = .5*(1.-PART)
	X2 = 1.-X1
	Y1 = .5*(1.-PART*DV/DU)
	Y2 = 1.-Y1
620	IF (AMIN1(X2-X1,Y2-Y1)*PLTRES .LT. RESLIM) GOTO 905
	CALL SET (X1,X2,Y1,Y2,UMIN,UMAX,VMIN,VMAX,1)
	DS = SQU(((X2-X1)*PLTRES)/DU)
	DSRDI = SQRT(DS/DI)
700	IER = IIER
	RETURN
C
C ERROR RETURNS
C
900	IIER = 35
C 35 SUPMAP-ANGULAR LIMITS TOO GREAT
	GOTO 700
C
905	IIER = 36
C 36 SUPMAP-MAP HAS ZERO AREA
	GOTO 700
C
	END
	SUBROUTINE SET(X1,X2,Y1,Y2,UMIN,UMAX,VMIN,VMAX,LTYPE)
	COMMON /PLOT/ XA,XB,YA,YB,XC,XD,YC,YD
	DX = X2 - X1
	DY = Y2 - Y1
	IF (DY/DX .GT. 512./640.) GOTO 100
	R = 640./DX
	GOTO 200
C
100	R = 512./DY
200	XA = 320.-R*DX/2
	XB = 320.+R*DX/2
	YA = 256.-R*DY/2
	YB = 256.+R*DY/2
	XC = UMIN
	XD = UMAX
	YC = VMIN
	YD = VMAX
	CALL VCG
	RETURN
	END
	SUBROUTINE VCG
	IMPLICIT INTEGER*2 (A-Z)
	CALL GCRS(-1)
	CALL HLSMAP(0,0,100,100)
	CALL HLSMAP(1,60,50,100)
	CALL HLSMAP(2,120,50,100)
	CALL HLSMAP(3,180,50,100)
	CALL HLSMAP(4,240,50,100)
	CALL HLSMAP(5,300,50,100)
	CALL HLSMAP(6,360,50,100)
	CALL HLSMAP(7,0,0,0)
	CALL CLRGR(0)
	CALL CLRGR(7)
	CALL CHRSEL(0)
	CALL CHGMAG(1,1)
	CALL SETPV(0,0)
	CALL SETFPV(7)
	CALL FPSEL(0,0)
	RETURN
	END
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  