.TL
A CHU Receiver/Modem System
.AU
Marcus Leech, VE3MDL
.PP
This describes a system for the reception and demodulation of the
digital time-of-day signals provided by Canada's national time service, CHU.
This system is used primarily to allow computers to synchronize their
time-of-day (TOD) clocks to a national or international standard.
The clock provided by CHU gives the time-of-day in UTC, the 
international time scale.
CHU maintains this time using a number of atomic (Cs
.SM
137
.LG
) clocks.
.SH System overview
.PP
The system consists of three primary modules that can be constructed
independently from one another.
If you already have a good 
HF
receiver, for example, the RF section
can be omitted.
The three modules are:
.I "RF Section",
.I "Filter Section",
and the
.I "Modem/Digital Section".
.SH
RF Section
.PP
The first module is a simple superheterodyne receiver with diode-switched
local oscillators to tune the receiver to either 7.335 or 3.330 MHz.
It uses single-conversion with an IF at 455kHz.
Since the frequency is selected by the DTR interface pin on the computer,
the computer software can make a decision about which frequency to
receive on.
.PP
The front-end has a 7.400MHz low-pass filter to restrict the bandwidth of
the receiver front-end.
Following that is a broad-band amplifier made from a 2N4401 NPN transistor.
The output from this amplifier is coupled to a gate of a dual-gate MOSFET
transistor, a 3N204 via a 3.2MHz high-pass PI section.
The other gate has the local oscillator signal on it (LO).
This MOSFET acts as a mixer to produce an IF at 455kHz.
The mixer output is passed through a 455kHz low-pass to remove the other
mixer product (LO+INPUT).
The output of this low-pass is connected to a gain-controlled IF amplifier,
another 2N4401.
The output of this 2N4401 is coupled into a
a high-pass PI matching section which feeds the 2nd IF amplifier.
The output of the 2nd IF amplifier is fed through a 455kHz IF transformer
to a half-wave detector.
The output of this 2nd 2N4401 is also coupled into a 
long-integration-time (~1sec)
detector that is used to provide AGC bias to the 1ST IF amplifier through
a DC amplifier, a 2N3904.
.SH
Filter Section
.PP
The demodulated output from the detector is fed into a resistive power-divider
formed by three 2.2K resistors.
Each leg of this power-divider is fed into an active band-pass filter formed
from 1/4 of a TL084 and some passive components.
These filters are of moderate Q (6.0) and are centered on the
.B "originate mode"
receive frequencies of 2025HZ and 2225HZ.
The outputs of these filters are fed to a resistive combiner.
The resulting combined output is fed to a low-Q (3.0) bandpass centered at
2125HZ; this frequency is exactly half-way between 2025HZ and 2225HZ.
This provides enough filtering to reduce the number of false carrier detects
to an acceptable level.
.SH
Modem/Digital Section
.PP
The filtered audio signal from the
.B "Filter Section"
is fed into the inputs of the 74HC942 (or 74HC943 if you wish to use a
single-supply part) modem IC.
The various parameters of the IC are set up to allow demodulation of the
CHU signal.
In particular, CDT, CDA, and FTLC values are chosen so as to provide
fast carrier acquisition by the modem.
The DCD and RD outputs of the modem IC are fed into a single-supply
RS-232 driver IC, a MAX-232.
The MAX-232 also acts as a receiver for the DTR signal, which is used to
select the receiver frequency.
.KS
.PP
The signal arriving on 
.B RD
is asynchronous and coded in nibble-reversed BCD.
There is a leading \'6\' nibble to indicate start-of-code.
After accounting for nibble-reversal, here\'s what the time-code looks like:
.sp 1
.TS
center box tab(~);
c | c || c | c || c | c || c | c || c | c .
6~Y~Y~Y~H~H~M~M~S~S
.TE
.sp 1
In the above,
.B YYY
is the current year-day,
.B "HH MM SS"
are the hours, minutes and seconds (in UTC) respectively.
The stop-bit of the last character of the time-code occurs exactly 500ms
after the time indicated in the time-code.
That means that the real time-of-day is
.I timecode
+
.B 500ms.
.KE
.SH
Software
.PP
Software is available to synchronize several types of computer systems to
the output of this receiver/modem.
.SH
Bibliography
.sp 1
A.G. Mungall,
.I "Canada\'s Time Service",
NRCC Publication, 1983
.sp 1
National Semiconductor,
.I "74HC942 Data Sheet"
