package loc;

#
#  create new location object.
#  $loc1 = loc->new()           create with default (0,0)
#  $loc2 = loc->new(x,y)        create with (x,y)
#  $loc3 = $loc1->new()         clone $loc1
#
sub new
{
    my $r_loc;
    my $pck = shift;    # first parameter is class name
    if (ref($pck))
    # called as instance method $locobject->new()
    {
	$r_loc = { "x" => $pck->{"x"},
		   "y" => $pck->{"y"}
		 };
    }
    else
    # called as class method loc->new()
    {
	if (@_)
	{
	    my $p1 = shift;
	    if (ref($p1) eq "loc")
	    {
		$r_loc = { "x" => $p1->{"x"},
			   "y" => $p1->{"y"}
			 };
	    }
	    else
	    {
		my $p2 = shift;
		$r_loc = { "x" => $p1,
			   "y" => $p2
			 };
	    }
	}
	else
	{
	    $r_loc = { "x" => 0,
		       "y" => 0
		     };
	}
    }
    bless $r_loc, 'loc';
    return $r_loc;
}


#
#  let $loc be equal to $loc2 or P(x,y)
#  $loc->eq(x,y)
#  $loc->eq($loc2)
#
sub eq
{
    my $r_loc = shift;
    my $p1 = shift;
    if (ref($p1) eq "loc")
    {
	$r_loc->{"x"} = $p1->{"x"};
	$r_loc->{"y"} = $p1->{"y"};
    }
    else
    {
	my $p2 = shift;
	$r_loc->{"x"} = $p1;
	$r_loc->{"y"} = $p2;
    }
}


#
#  adds offset $loc2 or vec(x,y) to $loc
#  $loc->translate(x,y)
#  $loc->translate($loc2)
#
sub translate
{
    my $r_loc = shift;
    my $p1 = shift;
    if (ref($p1) eq "loc")
    {
	$r_loc->{"x"} += $p1->{"x"};
	$r_loc->{"y"} += $p1->{"y"};
    }
    else
    {
	my $p2 = shift;
	$r_loc->{"x"} += $p1;
	$r_loc->{"y"} += $p2;
    }
}


#
#  rotates around origin counterclockwise
#  $loc->rotate(phi)
#
sub rotate
{
    my $r_loc = shift;
    my $p1 = shift;
    $p1 *= $::pi/180;
    my ($x, $y) = ($r_loc->{"x"}, $r_loc->{"y"});
    $r_loc->{"x"} = $x*cos($p1) - $y*sin($p1);
    $r_loc->{"y"} = $x*sin($p1) + $y*cos($p1);
}


# show values
# $loc->dump( [name] )
sub dump
{
    my $r_loc = shift;
    my $name = shift;
    printf "%s (LOC): x = %f, y = %f\n", $name, $r_loc->{"x"}, $r_loc->{"y"};
}

1;
