#include "checker.h"
#include <fcntl.h>
#include <stdarg.h>

#undef open

int
open(const char *file, int oflag, ...)
{
  chkr_check_addr(&file, sizeof(char*), CHKR_RO);
  chkr_check_addr(&oflag, sizeof(int*), CHKR_RO);
  chkr_check_str(file, CHKR_RO);
  
  if (oflag & O_CREAT)
    {
      int *mode = &oflag + 1;		/* not really portable */
      chkr_check_addr(mode, sizeof(int), CHKR_RO);
      return chkr_open(file, oflag, *mode);
    }

  return chkr_open(file, oflag);
}
