#include <stddef.h>	/* for offsetof() macro */
#include <stdlib.h>
#include <OI/oi.H>
#include "MaxValHexEF.H"

//	cache of internal form for translation function mapping and default translations
static	OI_compiled_action_table	compiledActions = NULL;
static	OI_translation_table		*defaultTranslations = NULL;

OI_class	*HexEntryField::clsp = NULL;

void
reg_HexEntryField()
{
	HexEntryField::clsp = OI_register_class(
		"HexEntryField","OI_entry_field",
		(OI_class_init_memfnp)&HexEntryField::init,
		(OI_make_minimal_memfnp)&HexEntryField::make_minimal );
}

HexEntryField*
create_HexEntryField( const char *np, OI_number len, char *labp, char *defp )
{
		HexEntryField		*p;

	p = new HexEntryField(np,len,labp,defp);
	if (p && (p->error_status() < 0)) {
		p->del();
		p = NULL;
	}
	return(p);
}

OI_bool
HexEntryField::init(
	OI_connection	*conp)	// pointer to connection being initialized
{
				// define resoure "Maximum"
	static		OI_resource	resources[] = {
#define Offset(fld) offsetof(HexEntryField,fld)
			{"maximum","Maximum",OI_r_Long,sizeof(long),Offset(mx_val),
				0,0,NULL,NULL,NULL_PMF,NULL,OI_RM_MDL_ALL},
#undef Offset
			};
		//	define mapping between text form of translation function and function address
	static		OI_actions_rec stringActions[] = {
			{ "clear",	NULL, NULL,
				(OI_translation_memfnp)&HexEntryField::clear
			},
	};
		//	define default translation
	static		char *translations = 
				"Ctrl	<Key>0: clear()		\n\
				";
	
	if (! clsp->class_initialized()) {
		//	convert translation function mappings to internal form
		compiledActions = OI_compile_action_table( stringActions, OI_count(stringActions));
		//	convert default translations to internal form
		if (defaultTranslations = OI_parse_translation_table(translations))
			defaultTranslations->set_keep();
		//	register resources with class
		clsp->set_resources(&resources[0],OI_count(resources));
		clsp->mark_initialized(  conp );
	}
	return( OI_YES );
}
HexEntryField::HexEntryField (
			const char		*usr_namp,
			OI_number		len,
			char			*labp,
			char			*defp)
			: OI_entry_field(clsp,usr_namp,len,labp,defp,len)
{
	construct();
}
HexEntryField::HexEntryField (
			OI_class		*clasp,
			const char		*usr_namp,
			OI_number		len,
			char			*labp,
			char			*defp)
			: OI_entry_field(clasp,usr_namp,len,labp,defp,len)
{
	construct();
}
void
HexEntryField::construct()
{
	OI_number	len;
	if (error_status() >= 0) {
		set_entry_chk(this,(OI_ef_entry_chk_memfnp)&HexEntryField::entry_chk);
		set_char_chk(this,(OI_ef_char_chk_memfnp)&HexEntryField::char_chk);
		if (compiledActions)
			//	make translation function available to object
			push_compiled_actions(compiledActions);
			//	apply default translations to object
		if(defaultTranslations)
			override_translations(defaultTranslations);
		//	set up default maximum value to be largest hex of length len
		mx_val = 0;
		len = max_length();
		while (len--)
			mx_val = (mx_val << 4) | 0xf;
	}
}
OI_ef_char_chk_status
HexEntryField::char_chk(
	OI_entry_field		*,
	void			*,
	OI_number		n,		// char position and first time sync flag
	char			c)		// char typed by user
{
	OI_ef_char_chk_status	ok ;		// return status

	ok = OI_EF_CHAR_CHK_BAD ;
	if ((n >= 0) && isxdigit(c))
		ok = OI_EF_CHAR_CHK_INSERT ;
	return(ok) ;
}
OI_ef_entry_chk_status
HexEntryField::entry_chk (OI_entry_field*,void*)
{
	OI_ef_entry_chk_status	ok;
	long			n;

	ok = OI_EF_ENTRY_CHK_OK;
	if (part_text()) {
		if (n = strtol(part_text(),NULL,16) > mx_val) {
			push_help_str("Maximum value exceeded",OI_YES);
			ok = OI_EF_ENTRY_CHK_BAD;
		}
	}
	return(ok);
}
HexEntryField*
HexEntryField::make_minimal( const char *nam, OI_minimal_type typ )
{
	HexEntryField	*p;

	if (typ == OI_UIB_MINIMAL)
		p = create_HexEntryField( nam, 8, "Hex: " );
	else
		p = create_HexEntryField( nam, 8 );
	return( p );
}
void
HexEntryField::clone_adjust( OI_d_tech* dtp )
{
	OI_entry_field::clone_adjust( dtp );
	if (dtp->is_derived_from( HexEntryField::clsp )) {
		mx_val = ((HexEntryField*)dtp)->max_value();
	}
	return;
}
