/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	tab.H
 *
 *	Functions(s):
 *
 *	Description:
 *		Tab group manipulation header
 *
 *	RCSid = "$Id: tab.H,v 4.1.1.1 1993/06/01 22:57:03 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_tab_H
#define OI_tab_H

	class OI_d_tech;

#define		OI_TAB_LIST_SIZE	16

class	OI_tab_obj {
	protected:
			OI_d_tech	*objp;				/* This object. */
		class	OI_tab_obj	*nxt;				/* Next object. */
		class	OI_tab_obj	*pre;				/* Previous object. */
	public:
					OI_tab_obj(OI_d_tech * = NULL);
			OI_tab_obj	*next()					{return(nxt);}
			OI_tab_obj	*prev()					{return(pre);}
		virtual	OI_tab_obj	*child();
		virtual	OI_d_tech	*object();
		virtual	OI_bool		is_leaf();
			OI_d_tech	*do_next();
			OI_d_tech	*do_prev();
			OI_d_tech	*do_next_tab();
			OI_d_tech	*do_prev_tab();
		virtual	void		set_next(OI_d_tech*);
			void		set_next_object(OI_tab_obj *n)		{nxt = n;}
			void		set_prev_object(OI_tab_obj *p)		{pre = p;}
			OI_tab_obj	*end_of_link();
			OI_tab_obj	*start_of_link();
};

class	OI_tab_group : public	OI_tab_obj {
			OI_d_tech	*chld_objp;
		class	OI_tab_obj	*chld;
	public:
					OI_tab_group(OI_d_tech * =NULL);
		virtual	OI_tab_obj	*child();
		virtual	OI_d_tech	*object();
		virtual	OI_bool		is_leaf();
		virtual	void		set_next(OI_d_tech*);
			OI_d_tech	*tab_traverse_next();
			OI_d_tech	*tab_traverse_prev();
};
#endif /* OI_tab_H */
