/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	scrltxt.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_scroll_text class header
 *
 *	RCSid = "$Id: scrltxt.H,v 4.16.1.1 1993/06/01 22:56:39 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_scrltxt_H
#define OI_scrltxt_H

#ifndef OI_bastxt_H
#include <OI/bastxt.H>
#endif /* OI_bastxt_H */

		// class forward reference declarations
		class	OI_box;
		class	OI_multi_text;
		class	OI_panner;
		class	OI_scroll_bar;
		class	OI_mdl_scroll_text;

 /* ctl_bits private bits */
#define			OI_SCROLL_TEXT_PAN_MOVE		0x1	/* 1 => 2D panner move, don't do single dimensional moves */
#define			OI_SCROLL_TEXT_MOTION_CALLBACK	0x2	/* 1 => controlled object callbacks for motion events */
#define			OI_SCROLL_TEXT_SPAN_UPDATE	0x4	/* 1 => update span/viewport/handle appearance when span/view changes */

	class OI_scroll_text : public OI_base_text {	/* scrollable text in a box */
		static	OI_class		*scroll_bar_clsp ;	/* ptr to prototype for scrollbars */
		static	OI_class		*panner_clsp ;		/* ptr to prototype for panner */
		static	OI_class		*multi_text_clsp ;	/* ptr to prototype for multi_text */
			OI_mdl_scroll_text	*mdl_dep ;		/* ptr to model dependent aspects of object */
			unsigned long		ctl_bits ;		/* object specific control bits */
			OI_controller_visibility	ctlr_vis;	// controller visibility mode
			OI_number		in_my_ctr ;		/* 0 => not in my constructor */
			OI_number		ctlr_typ ;		/* types of controllers this object has */
			OI_gravity		vw_grav ;		/* viewport gravity, for when controllers come and go */
			OI_multi_text		*mlttxt ;		/* ptr to underlying multi_text object */
	 public:
		static	OI_class		*clsp ;			/* ptr to class record */

	 private:
			void		construct(OI_number,OI_number,OI_number,OI_number,OI_number) ;
			void		clear_in_my_constructor() ;
		virtual	void		controller_space(OI_number*, OI_number*);
			OI_bool		in_my_constructor() ;
			OI_stat		new_view_size(OI_number,OI_number) ;
			OI_bool		res_auto_controller_visibility(void *);		// OBSOLETE
			OI_bool		res_click_select(void *);
			OI_bool		res_collapse(void *);				// OBSOLETE
			OI_bool		res_controllers(void *);
			OI_bool		res_motion_callback(void *);
			OI_bool		res_controller_visibility(void *);
			OI_bool		res_span_update(void *);
			void		resize(OI_d_tech*,void*) ;			/* resize callback */
			void		set_in_my_constructor() ;
			void		viewport_metrics(OI_number*,OI_number*,OI_number*,OI_number*) ;	/* determine viewport size metrics */
	 protected:
					OI_scroll_text(OI_class *clsp, const char *usr_namp, OI_number ctl, OI_number vl,
						OI_number vc, OI_number mxl=0, OI_number mxc=0)
						: OI_base_text(clsp,usr_namp)
						{ construct(ctl,vl,vc,mxl,mxc); }
			OI_bool		adj_ctlr_vis(OI_controller_visibility) ;	// adjust ctlr visibility based on viewport, text size
		virtual	OI_d_tech	*callback_object(XrmQuark) ;
			OI_d_tech	*interior_obj(const char *namp) ;
		virtual	void		new_model(OI_model_type) ;
//			void		set_auto_controller_visibility(OI_bool,OI_bool=OI_NO) ;	/* turn on/off based on object_box size */
		virtual	OI_stat		set_text_cb(OI_text_fnp fp, OI_callback *objp, OI_text_memfnp mfp) ;	/* set text */

	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	OUT-OF-PLACE DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		These functions should be under DOCUMENTED MEMBER FUNCTIONS, but are here to prevent C++
		//		from generating out-of-line functions for them due to forward references
		//
		//-------------------------------------------------------------------------------------------------		
			OI_multi_text	*multi_text()			{ return(mlttxt); }	/* get ptr to multi_text */
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
					OI_scroll_text (const char*,OI_number,OI_number,OI_number,OI_number=0,OI_number=0) ;
												/* constructor */
					~OI_scroll_text() ;
		virtual	void		allow_abs_associate();
		virtual	OI_d_tech	*associate_parent(OI_d_tech* =NULL) ;
			void		change_controllers(OI_number) ;				/* change which controllers are present */
		virtual	void		clone_adjust(OI_d_tech*) ;
			OI_number	controllers()			{ return(ctlr_typ); }
		virtual	void		disallow_abs_associate();
		virtual	OI_d_tech	*focus_obj() ;						/* get ptr to actual obj to receive focus */
		virtual	void		font_resize();
		static	OI_bool		init(OI_connection*) ;
		virtual	OI_stat		insert_chars_gen(OI_number,OI_number,OI_number,const char*,OI_number* =NULL,OI_number* =NULL,
						OI_bool=OI_NO,OI_char_encode_type=OI_char_encode_none) ;
		virtual	OI_stat		insert_line_gen(OI_number,OI_bool,const char*,OI_char_encode_type) ;
		virtual	OI_bool		is_write_resq(XrmQuark);
 		virtual	OI_line		*line(OI_number lin);
		static	OI_scroll_text	*make_minimal(const char*,OI_minimal_type) ;
		virtual	OI_bool		new_right_margin(OI_number) ;
		virtual	OI_stat		new_size(OI_number,OI_number);
			char		*initial_file() ;
			void		make_visible(long,OI_number) ;				/* make sure position is visible */
		virtual	void		new_bkg_pixmap(OI_pixmap *);
 		virtual	OI_string	*ply_text(OI_number lin);
			void		set_initial_file(const char *fp) ;
		virtual	OI_d_tech	*val_assoc(OI_d_tech*) ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE MEMBER FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

			void			allow_auto_controller_visibility(OI_bool=OI_YES) ;
			void			allow_collapse() ;				// use set_controller_visibility
			void			disallow_auto_controller_visibility() ;		// use set_controller_visibility
			void			disallow_collapse() ;				// use set_controller_visibility
			OI_bool			is_auto_controller_visibility() ;		// use controller_visibility
			OI_bool			is_collapse() ;					// use controller_visibility
		virtual	void			set_char_chk(OI_mt_char_chk_fnp fp=NULL, void *argp=NULL) ; // use set_char_check
		virtual	void			set_char_chk(OI_callback *objp, OI_mt_char_chk_memfnp mfp=NULL, void *argp=NULL) ; // use set_char_check
		virtual	void			set_entry_chk(OI_mt_entry_chk_fnp fp=NULL, void *argp=NULL) ;	// use set_entry_check
		virtual	void			set_entry_chk(OI_callback *objp, OI_mt_entry_chk_memfnp mfp=NULL, void *argp=NULL) ;	// use set_entry_check

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	void		allow_click_select() ;
		virtual	void		allow_inactive_cursor() ;
		virtual	void		allow_kb_input() ;
		virtual	void		allow_wrap() ;
		virtual	OI_stat		append_file(const char *fn, OI_bool scroll=OI_NO) ;	/* append contents of file to text */
		virtual	OI_stat		append_file(FILE *fp, OI_bool scroll=OI_NO) ;		/* append contents of file to text */
		virtual	OI_stat		append_string(const char *str,OI_bool scroll=OI_NO) ;	/* append contents of string to text */
		virtual	PIXEL		bkg_paint_pixel() ;
		virtual	OI_pixmap	*bkg_pixmap();
		virtual	OI_number	char_width() ;
		virtual	OI_char_encode_type	char_encode_type() ;
		virtual	OI_stat		char_xy_position(OI_number, OI_number, long*, long*) ;
		virtual	void		clear_enhance(OI_number) ;
		virtual	void		clear_modified() ;
		virtual	void		clear_prog_modified() ;
		virtual	void		clear_user_modified() ;
		virtual	OI_stat		create() ;
		virtual	char		*current_file() ;
		virtual	OI_number	cursor_char() ;
		virtual	OI_number	cursor_column() ;
		virtual	OI_number	cursor_line() ;
		virtual	OI_stat		delete_chars(OI_number l,OI_number c,OI_number n) ;
		virtual	OI_stat		delete_line(OI_number l) ;
		virtual	OI_stat		delete_lines(OI_number l,OI_number n) ;
		virtual	void		disallow_click_select() ;
		virtual	void		disallow_inactive_cursor() ;
		virtual	void		disallow_kb_input() ;
		virtual	void		disallow_wrap() ;
		virtual	OI_bool		exec_cmd(const char *str,OI_base_text *outp=NULL,OI_base_text *errp=NULL,OI_bool append=OI_NO) ;
												/* exec text or string as commands */
		virtual	OI_bool		find_string(OI_number*,OI_number*,const char*,OI_bool=OI_NO,OI_bool=OI_NO);
		virtual	OI_enhance	get_enhance(OI_number,OI_number) ;
		virtual	OI_bool		is_click_select() ;
		virtual	OI_bool		is_inactive_cursor() ;
		virtual	OI_bool		is_kb_input() ;
		virtual	OI_bool		is_modified() ;
		virtual	OI_bool		is_prog_modified() ;
		virtual	OI_bool		is_user_modified() ;
		virtual	OI_bool		is_wrap() ;
		virtual	OI_number	line_height() ;
		virtual	OI_number	line_width(OI_number l) ;
		virtual	OI_number	max_chars() ;
		virtual	OI_number	max_lines() ;
		virtual	OI_number	max_n_chars() ;
		virtual	OI_number	max_n_pixels() ;
		virtual	OI_mt_mode	mode() ;
		virtual	OI_number	n_lines() ;
		virtual	OI_d_tech	*next_child(OI_d_tech*);				/* get child from property list */
		virtual	OI_number	num_props();
		virtual	OI_d_tech	*numbered_child(OI_number n);
		virtual	OI_stat		output_text(const char *fn, OI_bool append=OI_NO) ;	/* write text to file */
		virtual	OI_stat		output_text(FILE *fp, OI_bool append=OI_NO) ;		/* write text to file */
		virtual	void		remove_enhance(OI_number,OI_number,OI_number,OI_enhance) ;
		virtual	OI_stat		replace_chars(OI_number,OI_number,OI_number,const char*) ;
		virtual	OI_stat		replace_line(OI_number,const char*) ;
		virtual	void		resume_layout(OI_bool=OI_YES);
		virtual	OI_number	right_margin() ;
		virtual	OI_bool		selection_coords(OI_number *slin, OI_number *schr, OI_number *elin, OI_number *echr) ;
												/* return coords of selection */
		virtual char		*selection_data(Atom) ;					/* get selection's data */
		virtual	char		*selection_data(const char *) ;				/* get selection's data */
		virtual	void		set_char_chg(OI_mt_char_chg_fnp fp, void *argp=NULL) ;
		virtual	void		set_char_chg(OI_callback *objp, OI_mt_char_chg_memfnp mfp, void *argp=NULL) ;
		virtual	void		set_char_check(OI_mt_char_check_fnp fp=NULL, void *argp=NULL) ;
		virtual	void		set_char_check(OI_callback *objp, OI_mt_char_check_memfnp mfp=NULL, void *argp=NULL) ;
		virtual	void		set_char_encode_type(OI_char_encode_type t) ;
		virtual	void		set_click(OI_click_fnp fp, void *argp=NULL) ;
		virtual	void		set_click(OI_callback *objp, OI_click_memfnp mfp, void *argp=NULL) ;
		virtual	void		set_cols(OI_number mx_c) ;
		virtual	void		set_cursor(Cursor);
		virtual	void		set_cursor(int csr) ;
		virtual void		set_cursor(const char *, const char *);
		virtual void		set_cursor(Pixmap, Pixmap, unsigned int, unsigned int);
		virtual	void		set_enhance(OI_number,OI_number,OI_number,OI_enhance,const char*,const char*,const char* =NULL) ;
		virtual	void		set_enhance(OI_number,OI_number,OI_number,OI_enhance,PIXEL=OI_UNKNOWN_PIXEL,PIXEL=OI_UNKNOWN_PIXEL,
						const char* =NULL) ;
		virtual	void		set_entry_check(OI_mt_entry_check_fnp fp=NULL, void *argp=NULL) ;
		virtual	void		set_entry_check(OI_callback *objp, OI_mt_entry_check_memfnp mfp=NULL, void *argp=NULL) ;
		virtual	OI_stat		set_lines(OI_number) ;
		virtual	void		set_mode(OI_mt_mode md) ;
		virtual	OI_stat		set_position(OI_number l, OI_number c, OI_psn_type t=OI_psn_default) ;
		virtual	OI_bool		set_right_margin(OI_number) ;
		virtual	OI_stat		set_tab_width(OI_number tw) ;				/* set # chars in tab width increment */
		virtual	OI_stat		set_tabs_custom(OI_number *, OI_number, OI_number =8) ;	/* set custom tabstops table */
		virtual	OI_stat		set_text_to_file(const char *fn) ;			/* set text to contents of file */
		virtual	OI_stat		set_text_to_file(FILE *fp) ;				/* set text to contents of file */
		virtual	OI_stat		set_text_to_string(const char *str) ;
		virtual	OI_stat		set_view_size(OI_number,OI_number) ;
		virtual	OI_d_tech	*subobject(const char*) ;				/* find child */
		virtual	OI_d_tech	*subobject(XrmQuark) ;
		virtual	OI_number	tab_width() ;						/* # chars in tab width increment */
		virtual	char		*text(OI_number l) ;
		virtual	void		ulcwf(OI_number *uln, OI_number *uch) ;
		virtual	OI_number	ulcwf_char() ;
		virtual	OI_number	ulcwf_line() ;
		virtual	OI_number	ulcwf_pixel() ;
		virtual	void		view_size(OI_number *vln, OI_number *vch) ;
		virtual	OI_number	view_n_chars() ;
		virtual	OI_number	view_n_lines() ;
		virtual	Window		X_window() ;						/* get object's X_window id */
		virtual	OI_stat		view_char_position(long x,long y,OI_number *lp,OI_number *cp) ;
												/* get ln/ch posn for xy posn in viewport */
		virtual	OI_stat		xy_char_position(long x,long y,OI_number *lp,OI_number *cp) ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void			allow_motion_callback()	;
			void			allow_span_update() ;
			OI_scroll_bar		*bottom_scroll_bar() ;
			void			data_changed() ;
			void			disallow_motion_callback() ;
			void			disallow_span_update() ;
			void			handle_loc(long*,long*) ;
			long			handle_loc_x() ;
			long			handle_loc_y() ;
			OI_scroll_bar		*horz_scroll_bar() ;
			OI_bool			is_motion_callback()		{ return(OI_bool)((ctl_bits&OI_SCROLL_TEXT_MOTION_CALLBACK)!=0); }
			OI_bool			is_span_update()		{ return(OI_bool)((ctl_bits&OI_SCROLL_TEXT_SPAN_UPDATE)!=0); }
			OI_scroll_bar		*left_scroll_bar() ;
			OI_panner		*panner() ;
			OI_scroll_bar		*right_scroll_bar() ;
			void			set_controllers(OI_number,OI_number) ;			/* set span & hdl/view loc of ctlr objs */
			OI_stat			set_handle_loc(long,long) ;				/* position horizontally and vertically */
			OI_stat			set_handle_loc_x(long) ;				/* position horizontally */
			OI_stat			set_handle_loc_y(long) ;				/* position vertically */
		static	void			set_multi_text_class(OI_class *p)	{ multi_text_clsp=p; }
		static	void			set_multi_text_class(const char *) ;
		static	void			set_panner_class(OI_class *p)		{ panner_clsp=p; }
		static	void			set_panner_class(const char *) ;
		static	void			set_scroll_bar_class(OI_class *p)	{ scroll_bar_clsp=p; }
		static	void			set_scroll_bar_class(const char *) ;
			void			set_controller_visibility(OI_controller_visibility) ;	// set controller visibility mode
			OI_controller_visibility	controller_visibility() ;				// controller visibility mode
			OI_scroll_bar		*top_scroll_bar() ;
			OI_scroll_bar		*vert_scroll_bar() ;
		virtual	void			wrap(OI_number=0,OI_number=0) ;

	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_scroll_text	*oi_create_scroll_text(const char*,OI_number,OI_number,OI_number,OI_number=0,OI_number=0) ;

#endif /* OI_scrltxt_H */
