/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	pmptdlg.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_prompt_dialog_box class header
 *
 *	RCSid = "$Id: pmptdlg.H,v 4.4.1.1 1993/06/01 22:56:05 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef	OI_pmptdlg_H
#define	OI_pmptdlg_H

#ifndef OI_dlgbox_H
#include <OI/dlgbox.H>
#endif /* OI_dlgbox_H */

#ifndef OI_entfld_H
#include <OI/entfld.H>
#endif /* OI_entfld_H */

	// class forward reference declarations
	class OI_mdl_prompt_dialog_box;
	class OI_entry_field;

#define	OI_prompt_db_def_ef_width	50	/* Default entryfield width. */
#define	OI_PROMPT_DB_DEF_EF_WIDTH	OI_prompt_db_def_ef_width

class OI_prompt_dialog_box : public OI_dialog_box {
			OI_mdl_prompt_dialog_box	*mdl_dep;	/* pointer to model dependent prompt dlg box. */
	 public:
		static	OI_class		*clsp ;			/* ptr to class record */
	 private:
			void			construct(OI_number,OI_number,const char*,const char*,OI_number) ;
	 protected:
			OI_bool			def_menu;		/* True if menu is default. */
	 protected:
						OI_prompt_dialog_box(OI_class *, const char *, OI_number =OI_prompt_db_def_ef_width,
							const char * ="Selection", const char * =NULL, OI_number =-1, OI_number =-1,
							OI_menu_cell ** =NULL) ;
						OI_prompt_dialog_box(OI_class *, const char *, OI_number, const char *, const char *,
							OI_number, OI_number, OI_cell_spec *) ;
		virtual	void			new_model(OI_model_type) ;
	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void			clone_adjust(OI_d_tech*) ;
		static	OI_bool			init(OI_connection*) ;
		static	OI_prompt_dialog_box	*make_minimal(const char*,OI_minimal_type) ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		

						OI_prompt_dialog_box(const char *, OI_number =OI_prompt_db_def_ef_width,
							const char * ="Selection", const char * =NULL,
							OI_number =-1, OI_number =-1, OI_menu_cell ** = NULL);
						OI_prompt_dialog_box(const char *, OI_number, const char *, const char *, OI_number,
							OI_number, OI_cell_spec *);
						~OI_prompt_dialog_box();
		virtual	char			*alpha_value() ;
			OI_bool			is_default_menu()		{return(def_menu);}
		virtual	OI_d_tech		*next_child(OI_d_tech*);			/* get child from property list */
		virtual	OI_number		num_props() ;
                virtual	OI_d_tech		*numbered_child(OI_number n) ;
		virtual	OI_bool			user_layout_ok() ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			OI_entry_field		*entry_field() ;
			char			*selection_label() ;
			char			*selection_part_text() ;
			char			*selection_text() ;
			void			set_selection_default_text(const char *vp, OI_bool chk=OI_YES) ;
			void			set_selection_label(const char *lp) ;
			void			set_selection_text(const char *vp, OI_bool chk=OI_YES) ;
};

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	OBSOLETED FUNCTIONS	
//		Functions below this point were once documented in the programmer's manual under
//		this object, but are now obsolete and will be removed in a future release.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
OI_prompt_dialog_box *oi_prompt_dialog_box(const char*, OI_number =OI_prompt_db_def_ef_width, const char* ="Selection ", const char* =NULL,
			OI_number =-1, OI_number =-1, OI_menu_cell** = NULL);

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
OI_prompt_dialog_box *oi_create_prompt_dialog_box(const char*, OI_number =OI_prompt_db_def_ef_width, const char* ="Selection ",
			const char* =NULL, OI_number =-1, OI_number =-1, OI_cell_spec* =NULL);
OI_prompt_dialog_box *oi_create_prompt_dialog_box(const char*, OI_number, const char*, const char*, OI_number, OI_number, OI_menu_cell**);

#endif /* OI_pmptdlg_H */
