/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	panner.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_panner class header
 *
 *	RCSid = "$Id: panner.H,v 4.9.1.1 1993/06/01 22:55:56 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_panner_H
#define OI_panner_H

#ifndef OI_wdtech_H
#include <OI/wdtech.H>
#endif /* OI_wdtech_H */

	// class forward reference declarations
	class OI_panner;
	class OI_mdl_panner;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Definitions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		


#ifdef TYPEDEF_MEMFN
	typedef	void	(OI_scroll_2d_fn)(class OI_panner*,void*,OI_scroll_event,long,long) ;
				/* scroll_2d callback function */
	typedef	void	(OI_callback::OI_scroll_2d_memfn)(class OI_panner*,void*,OI_scroll_event,long,long) ;
				/* scroll_2d callback member function */
#endif /* TYPEDEF_MEMFN */
	typedef	void	(*OI_scroll_2d_fnp)(class OI_panner*,void*,OI_scroll_event,long,long) ;
				/* scroll_2d callback function */
	typedef	void	(OI_callback::*OI_scroll_2d_memfnp)(class OI_panner*,void*,OI_scroll_event,long,long) ;
				/* scroll_2d callback member function */

#ifdef TYPEDEF_MEMFN
	typedef	void	(OI_pan_paint_fn)(OI_panner*,void*,XExposeEvent*) ;			/* pan paint callback function */
	typedef	void	(OI_callback::OI_pan_paint_memfn)(OI_panner*,void*,XExposeEvent*) ;	/* pan paint callback member function */
#endif /* TYPEDEF_MEMFN */
	typedef	void	(*OI_pan_paint_fnp)(OI_panner*,void*,XExposeEvent*) ;			/* pan paint callback function */
	typedef	void	(OI_callback::*OI_pan_paint_memfnp)(OI_panner*,void*,XExposeEvent*) ;	/* pan paint callback member function */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	END OF DOCUMENTED SECTION
		//
		//-------------------------------------------------------------------------------------------------		

#define		OI_PAN_VW_BDR_WID	1	/* default panner viewport window border width */
#define		OI_PAN_DELTA		5	/* default # pixels/user unit move (unused at the moment) */

	class OI_panner : public OI_w_d_tech {
			OI_mdl_panner	*mdl_dep ;			/* ptr to model dependent aspects of OI_box object */
			long		obj_span_x ;			/* size of object being scrolled; arbitrary units */
			long		obj_span_y ;			/* size of object being scrolled; arbitrary units */
			long		view_span_x ;			/* size of viewport to object, same units as object_span */
			long		view_span_y ;			/* size of viewport to object, same units as object_span */
			OI_number	obj_pix_x ;			/* # pixels per obj in x direction (the real object) */
			OI_number	obj_pix_y ;			/* # pixels per object in y direction */
			OI_number	pw_siz_x ;			/* size of viewport, pixels, includes border */
			OI_number	pw_siz_y ;			/* size of viewport, pixels, includes border */
			long		pw_psn_x ;			/* loc of upper left corner pan window in scrolled obj; units 0 - obj_span-1 */
			long		pw_psn_y ;			/* loc of upper left corner pan window in scrolled obj; units 0 - obj_span-1 */
			OI_number	pw_org_x ;			/* upper left corner of pan window,pixels (0-n) */
			OI_number	pw_org_y ;			/* upper left corner of pan window, pixels (0-n) */
			OI_number	last_x ;			/* pixel coordinate of ptr in viewport window at last event */
			OI_number	last_y ;			/* pixel coordinate of ptr in viewport window at last event */
			OI_number	delta ;				/* # pixels mouse movement per object unit movement */
			OI_number	pw_bdr_wid ;			/* # pixels in border for viewport */
			unsigned int	btn ;				/* needed to insure proper release when other buttons pressed */
	 protected:
		static	XrmQuark	q_cbCtlr2d ;			/* quark for scroll callback */
		static	XrmQuark	q_cbPanPaint ;			/* quark for panner paint callback */
	 public:
		static	OI_class	*clsp ;				/* ptr to class record */
	 private:
			void		construct(OI_number, OI_number, OI_scroll_2d_fnp, OI_callback*, OI_scroll_2d_memfnp, void*,
						OI_pan_paint_fnp, OI_callback*, OI_pan_paint_memfnp, void*) ;
			void		res_height(void *);
			void		res_width(void *);
	 protected:
					OI_panner(OI_class *clsp, const char *usr_namp, OI_number w, OI_number h,
						OI_scroll_2d_fnp fp_2d=NULL, OI_callback *op_2d=NULL, OI_scroll_2d_memfnp mfp_2d=NULL,
						void *ap_2d=NULL, OI_pan_paint_fnp fp_pt=NULL, OI_callback *op_pt=NULL,
						OI_pan_paint_memfnp mfp_pt=NULL, void *ap_pt=NULL) ;
			OI_stat		create() ;			/* create in X environment */
		virtual	void		new_model(OI_model_type) ;
			OI_number	pw_pix_org_x(long) ;		/* get x origin of pan window (0-m) given origin in user units (0-n) */
			OI_number	pw_pix_org_y(long) ;		/* get y origin of pan window (0-m) given origin in user units (0-n) */
			OI_number	pw_pix_siz_x(long) ;		/* get x size of pan window (no borders included) given size in user units */
			OI_number	pw_pix_siz_y(long) ;		/* get y size of pan window (no borders included) given size in user units */
			void		draw_pw() ;			/* draw panner window */
			void		chg_pw(OI_number,OI_number,OI_number,OI_number) ;	/* move/resize panner window */
	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
					OI_panner(const char*,OI_number,OI_number,
						OI_scroll_2d_fnp=NULL,OI_callback* =NULL,OI_scroll_2d_memfnp=NULL,void* =NULL,
						OI_pan_paint_fnp=NULL,OI_callback* =NULL,OI_pan_paint_memfnp=NULL,void* =NULL) ;
					~OI_panner() ;
			void		clone_adjust(OI_d_tech*) ;
		friend	void		dmpOI_panner(OI_panner*) ;			/* diagnostic dump procedure */
		static	OI_bool		init(OI_connection*) ;
		static	OI_panner	*make_minimal(const char*,OI_minimal_type) ;
		virtual	void		min_outside_size(OI_number,OI_number,OI_number*,OI_number*) ;
			void		moveit(OI_number, OI_number);
		virtual	OI_stat		new_size(OI_number,OI_number);
		virtual	void		paint(const XEvent*, void* =NULL) ;		/* for exposure events (for pan_events init) */
			OI_number	pix_x();
			OI_number	pix_y();
			void		res_pix_x(void *);
			void		res_pix_y(void *);
			void		res_span_x(void *);
			void		res_span_y(void *);
			void		res_view_x(void *);
			void		res_view_y(void *);

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE MEMBER FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		
			long		obj_size_x()	{return(obj_span_x);}	/* use span_x() */
			long		obj_size_y()	{return(obj_span_y);}	/* use span_y() */
			long		pan_span_x()	{return(view_span_x);}	/* use view_x() */
			long		pan_span_y()	{return(view_span_y);}	/* use view_y() */
			long		pan_psn_x()	{return(pw_psn_x);}	/* use view_psn_x() */
			long		pan_psn_y()	{return(pw_psn_y);}	/* use view_psn_y() */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void		change_action(OI_scroll_2d_fnp fp, void *argp=NULL) ;
			void		change_action(OI_callback *objp, OI_scroll_2d_memfnp mfp, void *argp=NULL) ;
			void		change_arg(void *argp) ;
			void		change_paint(OI_pan_paint_fnp fp, void *argp=NULL) ;
			void		change_paint(OI_callback *objp, OI_pan_paint_memfnp mfp, void *argp=NULL) ;
			void		change_paint_arg(void *argp) ;
			void		data_changed() ;			/* update image, data changed, span/view did not */
			void		*get_arg() ;
			void		*get_paint_arg() ;
			long		span_x()		{ return(obj_span_x); }	/* x size of object being panned, user units */
			long		span_y()		{ return(obj_span_y); }	/* y size of object being panned, user units */
			OI_number	paint_height() ;
			OI_number	paint_org_x() ;
			OI_number	paint_org_y() ;
			OI_number	paint_width() ;
			OI_number	pan_loc_x()	{return(pw_org_x);}	/* x position of upper left corner of viewport, pixels (0 - extent.x-1) */
			OI_number	pan_loc_y()	{return(pw_org_y);}	/* y position of upper left corner of viewport, pixels (0 - extent.y-1) */
			OI_number	pan_size_x()	{return(pw_siz_x);}	/* x size of panner viewport, pixels */
			OI_number	pan_size_y()	{return(pw_siz_y);}	/* y size of panner viewport, pixels */
			OI_stat		set_pan_win_loc(long,long) ;		/* set position (upper left corner) of pan window within obj_span */
			OI_stat		set_pix(OI_number,OI_number) ;		/* set # pixels occupied by one unit of object in each direction */
			OI_stat		set_span(long,long) ;			/* set span of object being panned (user units) */
			OI_stat		set_view(long,long) ;			/* set span of viewport (user units) */
			long		view_psn_x()	{ return(pw_psn_x); }	/* x psn of upper left corner of viewport, user coordinates (0 - obj_span-1) */
			long		view_psn_y()	{ return(pw_psn_y); }	/* y psn of upper left corner of viewport, user coordinates (0 - obj_span-1) */
			long		view_x()	{ return(view_span_x); }	/* x size of panner viewport, user units */
			long		view_y()	{ return(view_span_y); }	/* y size of panner viewport, user units */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED TRANSLATIONS FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under the
		//		translations available for this object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void		press(OI_d_tech *, const XEvent *, const char* const *, unsigned int*);
			void		motion(OI_d_tech *, const XEvent *, const char* const *, unsigned int*);
			void		release(OI_d_tech *, const XEvent *, const char* const *, unsigned int*);
			void		scroll_unit_left(OI_d_tech *, const XEvent *, const char* const *, unsigned int*);
			void		scroll_unit_right(OI_d_tech *, const XEvent *, const char* const *, unsigned int*);
			void		scroll_unit_up(OI_d_tech *, const XEvent *, const char* const *, unsigned int*);
			void		scroll_unit_down(OI_d_tech *, const XEvent *, const char* const *, unsigned int*);
			void		scroll_view_left(OI_d_tech *, const XEvent *, const char* const *, unsigned int*);
			void		scroll_view_right(OI_d_tech *, const XEvent *, const char* const *, unsigned int*);
			void		scroll_view_up(OI_d_tech *, const XEvent *, const char* const *, unsigned int*);
			void		scroll_view_down(OI_d_tech *, const XEvent *, const char* const *, unsigned int*);
			void		scroll_max_left(OI_d_tech *, const XEvent *, const char* const *, unsigned int*);
			void		scroll_max_right(OI_d_tech *, const XEvent *, const char* const *, unsigned int*);
			void		scroll_max_up(OI_d_tech *, const XEvent *, const char* const *, unsigned int*);
			void		scroll_max_down(OI_d_tech *, const XEvent *, const char* const *, unsigned int*);
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
		OI_panner	*oi_create_panner_cb(const char*,OI_number x,OI_number y,
					OI_scroll_2d_fnp fp,OI_callback *objp,OI_scroll_2d_memfnp mfp,void *argp,
					OI_pan_paint_fnp pfp,OI_callback *pobjp,OI_pan_paint_memfnp pmfp,void *pargp) ;

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
		OI_panner	*oi_create_panner(const char *name,OI_number x,OI_number y,OI_scroll_2d_fnp fp=NULL,void *argp=NULL,
					OI_pan_paint_fnp pfp=NULL,void *pargp=NULL) ;

		OI_panner	*oi_create_panner(const char *name,OI_number x,OI_number y,OI_callback *objp,OI_scroll_2d_memfnp mfp,
					void *argp=NULL, OI_pan_paint_fnp pfp=NULL,void *pargp=NULL) ;

		OI_panner	*oi_create_panner(const char *name,OI_number x,OI_number y,OI_scroll_2d_fnp fp,void *argp,
					OI_callback *pobjp,OI_pan_paint_memfnp pmfp,void *pargp=NULL) ;

		OI_panner	*oi_create_panner(const char *name,OI_number x,OI_number y,OI_callback *objp,OI_scroll_2d_memfnp mfp,
					void *argp,OI_callback *pobjp,OI_pan_paint_memfnp pmfp,void *pargp=NULL) ;

#endif /* OI_panner_H */
