/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	lngsrvinp.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_lang_server_input class header
 *
 *	RCSid = "$Id: lngsrvinp.H,v 4.5.1.1 1993/06/01 22:55:27 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_lngsrvinp_H
#define OI_lngsrvinp_H

#ifndef OI_wdtech_H
#include <OI/wdtech.H>
#endif /* OI_wdtech_H */

#ifndef OI_lngsrv_H
#include <OI/lngsrv.H>
#endif /* OI_lngsrv_H */


 /* private control bits */
#define		OI_LS_INP_ACT		0x1	/* 1 => language server in use (translations installed to pass events to server */
#define		OI_LS_INP_PASTE_AT_PTR	0x2	/* 1 => mouse paste goes at pointer location */

	class	OI_lang_server_input : public OI_w_d_tech	{		/* object which can use language server input */
		 private:
			unsigned long		ctl_bits ;			/* object private control bits */
			char			*lsrv_namp ;			/* ptr to server name; delete when res_lang_server gets resource value passed as arg */
			OI_lang_server		*lsrvp ;			/* ptr to language server object */
			OI_lang_focus		lsrv_focusin_typ ;		/* type of language server focus in action */
			OI_translation_table	*saved_translations;		/* saved translations */
			OI_translation_table	*input_cvt_translations;	/* input conversion translations */
			XComposeStatus		cmp_st ;			/* # characters matched so far in compose sequence */
			OI_key			lst_op ;			/* last op, used to track cursor up/down movements, compose cancel */
		 protected:
		static	XrmQuark		q_pasteAtPointer;
		 public:
		static	OI_class		*clsp ;				/* ptr to class record */

		 private:
			void			res_lang_server(void*) ;	/* resolve and load language server object */
			void			res_paste_at_pointer(void*) ;
		 protected:
						OI_lang_server_input(OI_class*, const char*) ;
						~OI_lang_server_input() ;
			XComposeStatus		*compose_state()		{ return(&cmp_st); }
			OI_lang_server		*lang_server()			{ return(lsrvp); }	/* get pointer to language server for object */
			OI_bool			lang_server_in_use()		{ return(OI_bool)((ctl_bits&OI_LS_INP_ACT) != 0); }
			OI_key			last_op()			{ return(lst_op); }
			void			set_lang_server_in_use()	{ ctl_bits |= OI_LS_INP_ACT; }
			void			clear_lang_server_in_use()	{ ctl_bits &= ~OI_LS_INP_ACT; }
		virtual	void			focus_in(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			set_saved_translations(OI_translation_table *t)	{ saved_translations=t; }
			OI_translation_table	*get_saved_translations()	{ return(saved_translations); }
			void			set_input_cvt_translations(OI_translation_table *t)	{ input_cvt_translations=t; }
			OI_translation_table	*get_input_cvt_translations()	{ return(input_cvt_translations); }
			void			set_last_op(OI_key k)		{ lst_op=k; }

		 public:
	 /* functions restricted to toolkit use */
		static	OI_bool			init(class OI_connection*) ;
			OI_bool			is_write_resq(XrmQuark);
	 /* normal public functions */
			OI_lang_focus		lang_server_focusin_action()	{ return(lsrv_focusin_typ); }
			void			set_lang_server_focusin_action(OI_lang_focus f)	{ lsrv_focusin_typ=f; }
			void			allow_paste_at_pointer();
			void			disallow_paste_at_pointer();
			OI_bool			is_paste_at_pointer()		{ return(((ctl_bits & OI_LS_INP_PASTE_AT_PTR) != 0) ? OI_yes : OI_no); }
		} ;

#endif /* OI_lngsrvinp_H */
