/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.interpreter.instruction;

import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.Term;
import gnu.prolog.vm.BacktrackInfo;
import gnu.prolog.vm.Environment;
import gnu.prolog.vm.PrologCode;
import gnu.prolog.vm.PrologCodeListener;
import gnu.prolog.vm.PrologCodeUpdatedEvent;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.interpreter.CallBacktrackInfo;
import gnu.prolog.vm.interpreter.ExecutionState;
import gnu.prolog.vm.interpreter.instruction.Instruction;

public class ICall
extends Instruction
implements PrologCodeListener {
    public CompoundTermTag tag;
    public transient PrologCode code;

    public ICall(CompoundTermTag tag) {
        this.tag = tag;
    }

    public String toString() {
        return this.codePosition + ": call " + this.tag.functor.value + "/" + this.tag.arity;
    }

    @Override
    public int execute(ExecutionState state, BacktrackInfo bi) throws PrologException {
        PrologCode code;
        Term[] args;
        boolean backtrack;
        CallBacktrackInfo cbi = (CallBacktrackInfo)bi;
        if (cbi != null) {
            backtrack = true;
            args = cbi.args;
            code = cbi.code;
        } else {
            backtrack = false;
            int arity = this.tag.arity;
            args = new Term[arity];
            for (int i = arity - 1; i >= 0; --i) {
                args[i] = state.popPushDown().dereference();
            }
            this.ensureLoaded(state.interpreter.getEnvironment());
            code = this.code;
        }
        int rc = code.execute(state.interpreter, backtrack, args);
        switch (rc) {
            case 0: {
                state.pushBacktrackInfo(state.getCallBacktrackInfo(this.codePosition, args, code, this.tag));
                rc = 0;
                break;
            }
            case 1: {
                rc = 0;
                break;
            }
            case -1: {
                rc = -1;
            }
        }
        return rc;
    }

    @Override
    public void prologCodeUpdated(PrologCodeUpdatedEvent evt) {
        this.code = null;
    }

    @Override
    public void install(Environment env) {
        env.addPrologCodeListener(this.tag, this);
    }

    @Override
    public void uninstall(Environment env) {
        env.removePrologCodeListener(this.tag, this);
    }

    protected void ensureLoaded(Environment env) throws PrologException {
        if (this.code == null) {
            this.code = env.getPrologCode(this.tag);
        }
    }
}

