# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._resource_graph_client_operations import (
    build_resource_change_details_request,
    build_resource_changes_request,
    build_resources_history_request,
    build_resources_request,
)
from .._vendor import ResourceGraphClientMixinABC

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class ResourceGraphClientOperationsMixin(ResourceGraphClientMixinABC):
    @overload
    async def resources(
        self, query: _models.QueryRequest, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.QueryResponse:
        """Queries the resources managed by Azure Resource Manager for scopes specified in the request.

        :param query: Request specifying query and its options. Required.
        :type query: ~azure.mgmt.resourcegraph.models.QueryRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: QueryResponse or the result of cls(response)
        :rtype: ~azure.mgmt.resourcegraph.models.QueryResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def resources(
        self, query: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.QueryResponse:
        """Queries the resources managed by Azure Resource Manager for scopes specified in the request.

        :param query: Request specifying query and its options. Required.
        :type query: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: QueryResponse or the result of cls(response)
        :rtype: ~azure.mgmt.resourcegraph.models.QueryResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def resources(self, query: Union[_models.QueryRequest, IO], **kwargs: Any) -> _models.QueryResponse:
        """Queries the resources managed by Azure Resource Manager for scopes specified in the request.

        :param query: Request specifying query and its options. Is either a model type or a IO type.
         Required.
        :type query: ~azure.mgmt.resourcegraph.models.QueryRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: QueryResponse or the result of cls(response)
        :rtype: ~azure.mgmt.resourcegraph.models.QueryResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.QueryResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(query, (IO, bytes)):
            _content = query
        else:
            _json = self._serialize.body(query, "QueryRequest")

        request = build_resources_request(
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.resources.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("QueryResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    resources.metadata = {"url": "/providers/Microsoft.ResourceGraph/resources"}

    @overload
    async def resources_history(
        self, request: _models.ResourcesHistoryRequest, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """List all snapshots of a resource for a given time interval.

        :param request: Request specifying the query and its options. Required.
        :type request: ~azure.mgmt.resourcegraph.models.ResourcesHistoryRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JSON or the result of cls(response)
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def resources_history(self, request: IO, *, content_type: str = "application/json", **kwargs: Any) -> JSON:
        """List all snapshots of a resource for a given time interval.

        :param request: Request specifying the query and its options. Required.
        :type request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JSON or the result of cls(response)
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def resources_history(self, request: Union[_models.ResourcesHistoryRequest, IO], **kwargs: Any) -> JSON:
        """List all snapshots of a resource for a given time interval.

        :param request: Request specifying the query and its options. Is either a model type or a IO
         type. Required.
        :type request: ~azure.mgmt.resourcegraph.models.ResourcesHistoryRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JSON or the result of cls(response)
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-06-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-06-01-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(request, (IO, bytes)):
            _content = request
        else:
            _json = self._serialize.body(request, "ResourcesHistoryRequest")

        request = build_resources_history_request(
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.resources_history.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("object", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    resources_history.metadata = {"url": "/providers/Microsoft.ResourceGraph/resourcesHistory"}

    @overload
    async def resource_changes(
        self,
        parameters: _models.ResourceChangesRequestParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ResourceChangeList:
        """List changes to a resource for a given time interval.

        :param parameters: the parameters for this request for changes. Required.
        :type parameters: ~azure.mgmt.resourcegraph.models.ResourceChangesRequestParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResourceChangeList or the result of cls(response)
        :rtype: ~azure.mgmt.resourcegraph.models.ResourceChangeList
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def resource_changes(
        self, parameters: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.ResourceChangeList:
        """List changes to a resource for a given time interval.

        :param parameters: the parameters for this request for changes. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResourceChangeList or the result of cls(response)
        :rtype: ~azure.mgmt.resourcegraph.models.ResourceChangeList
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def resource_changes(
        self, parameters: Union[_models.ResourceChangesRequestParameters, IO], **kwargs: Any
    ) -> _models.ResourceChangeList:
        """List changes to a resource for a given time interval.

        :param parameters: the parameters for this request for changes. Is either a model type or a IO
         type. Required.
        :type parameters: ~azure.mgmt.resourcegraph.models.ResourceChangesRequestParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResourceChangeList or the result of cls(response)
        :rtype: ~azure.mgmt.resourcegraph.models.ResourceChangeList
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2020-09-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2020-09-01-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ResourceChangeList] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "ResourceChangesRequestParameters")

        request = build_resource_changes_request(
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.resource_changes.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ResourceChangeList", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    resource_changes.metadata = {"url": "/providers/Microsoft.ResourceGraph/resourceChanges"}

    @overload
    async def resource_change_details(
        self,
        parameters: _models.ResourceChangeDetailsRequestParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[_models.ResourceChangeData]:
        """Get resource change details.

        :param parameters: The parameters for this request for resource change details. Required.
        :type parameters: ~azure.mgmt.resourcegraph.models.ResourceChangeDetailsRequestParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of ResourceChangeData or the result of cls(response)
        :rtype: list[~azure.mgmt.resourcegraph.models.ResourceChangeData]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def resource_change_details(
        self, parameters: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.ResourceChangeData]:
        """Get resource change details.

        :param parameters: The parameters for this request for resource change details. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of ResourceChangeData or the result of cls(response)
        :rtype: list[~azure.mgmt.resourcegraph.models.ResourceChangeData]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def resource_change_details(
        self, parameters: Union[_models.ResourceChangeDetailsRequestParameters, IO], **kwargs: Any
    ) -> List[_models.ResourceChangeData]:
        """Get resource change details.

        :param parameters: The parameters for this request for resource change details. Is either a
         model type or a IO type. Required.
        :type parameters: ~azure.mgmt.resourcegraph.models.ResourceChangeDetailsRequestParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of ResourceChangeData or the result of cls(response)
        :rtype: list[~azure.mgmt.resourcegraph.models.ResourceChangeData]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2020-09-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2020-09-01-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.ResourceChangeData]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "ResourceChangeDetailsRequestParameters")

        request = build_resource_change_details_request(
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.resource_change_details.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("[ResourceChangeData]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    resource_change_details.metadata = {"url": "/providers/Microsoft.ResourceGraph/resourceChangeDetails"}
