/*
 * Decompiled with CFR 0.152.
 */
package cc.gammasoft.date;

import cc.gammasoft.date.DateModel;
import cc.gammasoft.date.DatePickerTableCellEditor;
import cc.gammasoft.date.DatePickerTableCellRenderer;
import cc.gammasoft.date.DefaultDateModel;
import cc.gammasoft.date.DefaultPickerButton;
import cc.gammasoft.date.MonthView;
import cc.gammasoft.date.PickerButton;
import cc.gammasoft.date.PickerEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.DateFormatter;

public class DatePicker
extends JComponent
implements ChangeListener {
    private MonthView monthView;
    private DatePickerTableCellEditor cellEditor;
    private DatePickerTableCellRenderer cellRenderer;
    private SimpleDateFormat dateFormat;
    private JPanel monthPanel;
    private DateModel dateModel;
    private DateFormatter formatter;
    private PickerEditor editor;
    private JPanel panelPop;
    private JPopupMenu popup = new JPopupMenu(){
        Dimension d = new Dimension(183, 142);

        public Dimension getPreferredSize() {
            Dimension temp = super.getPreferredSize();
            if (temp.width > this.d.width) {
                return super.getPreferredSize();
            }
            return this.d;
        }
    };
    private PickerButton buttonPop = new DefaultPickerButton();

    public DatePicker() {
        this((SimpleDateFormat)DateFormat.getDateInstance(3), Calendar.getInstance());
    }

    public DatePicker(SimpleDateFormat dateFormat) {
        this(dateFormat, Calendar.getInstance());
    }

    public DatePicker(Calendar calendar) {
        this((SimpleDateFormat)DateFormat.getDateInstance(3), calendar);
    }

    public DatePicker(SimpleDateFormat dateFormat, Calendar calendar) {
        this.initComponents();
        this.setDateFormat(dateFormat);
        this.dateModel = new DefaultDateModel();
        this.setDateModel(this.dateModel);
        this.dateModel.addChangeListener(this);
        this.dateModel.setValue(calendar);
    }

    private void initComponents() {
        this.monthView = new MonthView();
        this.monthView.setBorder(null);
        this.popup.setBorder(null);
        this.popup.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        this.popup.add(this.monthView);
        this.setLayout(new BorderLayout());
        this.formatter = new DateFormatter();
        this.editor = new PickerEditor(this.formatter);
        this.add(this.editor);
        this.editor.setFocusLostBehavior(3);
        this.editor.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DatePicker.this.setModelValueFromEditor();
            }
        });
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (DatePicker.this.editor.isEditable() && DatePicker.this.editor.isRequestFocusEnabled()) {
                    DatePicker.this.editor.requestFocus();
                } else if (DatePicker.this.isRequestFocusEnabled()) {
                    DatePicker.this.requestFocus();
                }
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.popup.setDoubleBuffered(true);
        this.popup.setFocusable(false);
        this.setPopupButton(this.buttonPop);
    }

    private void setModelValueFromEditor() {
        if (this.popup.isVisible()) {
            return;
        }
        boolean error = false;
        if (this.editor.getText().equals("")) {
            this.dateModel.setValue((Calendar)null);
            this.editor.setValue(null);
            return;
        }
        this.dateModel.removeChangeListener(this);
        try {
            this.editor.commitEdit();
            Date date = (Date)this.editor.getValue();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            this.dateModel.setValue(calendar);
            this.editor.setValue(this.dateModel.getValue().getTime());
        }
        catch (Exception ex) {
            error = true;
        }
        this.dateModel.addChangeListener(this);
        if (error) {
            this.dateModel.fireValueChanged();
        }
    }

    public void setDateFormat(SimpleDateFormat dateFormat) {
        if (dateFormat == null) {
            throw new RuntimeException("Null Date Format");
        }
        this.dateFormat = dateFormat;
        this.monthView.getWeekDayPanel().setWeekDayNames(this.dateFormat, 0);
        this.monthView.getMonthYearPanel().setMonthNames(this.dateFormat, 0);
        this.formatter.setFormat(dateFormat);
        if (this.dateModel != null && this.dateModel.getValue() != null) {
            this.editor.setValue(this.dateModel.getValue().getTime());
        }
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateModel(DateModel dateModel) {
        if (dateModel == null) {
            throw new NullPointerException("Null Date Model");
        }
        this.dateModel = dateModel;
        this.monthView.getDatePanel().setDateModel(dateModel);
        this.monthView.getMonthYearPanel().setDateModel(dateModel);
    }

    public DateModel getDateModel() {
        return this.dateModel;
    }

    public JFormattedTextField getEditor() {
        return this.editor;
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    public PickerButton getPopButton() {
        return this.buttonPop;
    }

    public void setPopupButton(PickerButton button) {
        if (button == null) {
            throw new NullPointerException("Null Picker button");
        }
        button.initButton(this);
        this.remove(this.buttonPop);
        this.buttonPop = button;
        this.add((Component)this.buttonPop, "East");
        this.revalidate();
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.dateModel) {
            if (this.dateModel.getValue() != null) {
                this.editor.setValue(this.dateModel.getValue().getTime());
            } else {
                this.editor.setValue(null);
                this.editor.setText("");
            }
            this.popup.setVisible(false);
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.set(2, this.monthView.getMonthYearPanel().getMonth());
            calendar.set(1, this.monthView.getMonthYearPanel().getYear());
            this.monthView.getDatePanel().setView(calendar);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.dateModel.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.dateModel.removeChangeListener(listener);
    }

    public Calendar getValue() {
        return this.dateModel.getValue();
    }

    public void setValue(Calendar calendar) {
        this.dateModel.setValue(calendar);
    }

    public void setValue(String SQLDate) {
        this.dateModel.setValue(SQLDate);
    }

    public void setSQLDate(String SQLDate) {
        this.dateModel.setSQLDate(SQLDate);
    }

    public void setTimestamp(String timeStamp) {
        this.dateModel.setTimestamp(timeStamp);
    }

    public String getSQLDateValue() {
        return this.dateModel.getSQLDateValue();
    }

    public String getTimestampValue() {
        return this.dateModel.getTimestampValue();
    }

    public void setMonthNames(SimpleDateFormat dateFormat, int type) {
        this.monthView.getMonthYearPanel().setMonthNames(dateFormat, type);
        this.dateModel.fireValueChanged();
    }

    public void setWeekDayNames(SimpleDateFormat dateFormat, int weekDayType) {
        this.monthView.getWeekDayPanel().setWeekDayNames(dateFormat, weekDayType);
        this.dateModel.fireValueChanged();
    }

    public TableCellRenderer getCellRenderer() {
        if (this.cellRenderer == null) {
            this.cellRenderer = new DatePickerTableCellRenderer(this.getDateFormat());
        }
        return this.cellRenderer;
    }

    public TableCellEditor getCellEditor() {
        if (this.cellEditor == null) {
            this.cellEditor = new DatePickerTableCellEditor(this);
        }
        return this.cellEditor;
    }

    public void setFont(Font monthViewFont) {
        super.setFont(monthViewFont);
        this.monthView.setFont(monthViewFont);
    }

    public void setForeground(Color foreground) {
        super.setForeground(foreground);
        this.monthView.setForeground(foreground);
    }

    public MonthView getMonthView() {
        return this.monthView;
    }

    public void setEditorFont(Font font) {
        this.editor.setFont(font);
    }

    public Font getEditorFont() {
        return this.editor.getFont();
    }

    public void setEditorForeground(Color color) {
        this.editor.setForeground(color);
    }

    public Color getEditorForeground() {
        return this.editor.getForeground();
    }

    public void setEditorBackground(Color color) {
        this.editor.setBackground(color);
    }

    public Color getEditorBackground() {
        return this.editor.getBackground();
    }
}

