<?php

$OLT_ON_SENGIES = array(
	'google' => array('google.'),
	'yahoo' => array('search.yahoo.'),
	'msn' => array('search.msn.'),
	'aol' => array('search.aol.'),
	'altavista' => array('altavista.'),
	'lycos' => array('search.lycos.')
	);
require_once('inc/encoding.php');


//////////////////////////////////////////////////////////////////////////////////////////////////


function exist_and_notblank($array, $name)
{
	return (isset($array[$name]) && strlen($array[$name])>0);
}

function insert_se_query($hit_id, $se_id, $query)
{
	global $conf_db_pref;
	$query = addslashes($query);
	$sql = "INSERT INTO {$conf_db_pref}searches (hit_id, searcher, query) VALUES ($hit_id, $se_id, '$query')";
	return query_insert($sql);
}
//////////////////////////////////////////////////////////////////////////////////////////////////


//	-	-	-	-	-	-	-	-	-	-	-	-	-	GOOGLE
function check_ref_google
($hit_id, $path, $query_vars)
{
	if ($path == '/search')
	{
		if (exist_and_notblank($query_vars, 'q'))
		{
			insert_se_query($hit_id, SEID_GOOGLE, $query_vars['q']);
		}
	}
}

//	-	-	-	-	-	-	-	-	-	-	-	-	-	YAHOO
function check_ref_yahoo
($hit_id, $path, $query_vars)
{
	if ($path == '/search')
	{
		if (exist_and_notblank($query_vars, 'p'))
		{
			insert_se_query($hit_id, SEID_YAHOO, $query_vars['p']);
		}
	}
}

//	-	-	-	-	-	-	-	-	-	-	-	-	-	MSN
function check_ref_msn
($hit_id, $path, $query_vars)
{
	if ($path == '/results.aspx')
	{
		if (exist_and_notblank($query_vars, 'q'))
		{
			insert_se_query($hit_id, SEID_MSN, $query_vars['q']);
		}
	}
}

//	-	-	-	-	-	-	-	-	-	-	-	-	-	AOL
function check_ref_aol
($hit_id, $path, $query_vars)
{
	if ($path == '/aol/search')
	{
		if (exist_and_notblank($query_vars, 'query'))
		{
			insert_se_query($hit_id, SEID_AOL, $query_vars['query']);
		}
	}
}

//	-	-	-	-	-	-	-	-	-	-	-	-	-	ALTAVISTA
function check_ref_altavista
($hit_id, $path, $query_vars)
{
	if ($path == '/web/results')
	{
		if (exist_and_notblank($query_vars, 'q'))
		{
			insert_se_query($hit_id, SEID_ALTAVISTA, $query_vars['q']);
		}
	}
}

//	-	-	-	-	-	-	-	-	-	-	-	-	-	LYCOS
function check_ref_lycos
($hit_id, $path, $query_vars)
{
	if ($path == '/')
	{
		if (exist_and_notblank($query_vars, 'query'))
		{
			insert_se_query($hit_id, SEID_LYCOS, $query_vars['query']);
		}
	}
}


/*
//	-	-	-	-	-	-	-	-	-	-	-	-	-	YANDEX
function check_ref_yandex
($hit_id, $path, $query_vars)
{
	if ($path == '/yandsearch' || $path == '/yandpage')
	{
		if (exist_and_notblank($query_vars, 'text'))
		{
			insert_se_query($hit_id, SEID_YANDEX, $query_vars['text']);
		}
	}
}

//	-	-	-	-	-	-	-	-	-	-	-	-	-	GOOGLE
function check_ref_google
($hit_id, $path, $query_vars)
{
	if ($path == '/search')
	{
		if (exist_and_notblank($query_vars, 'q'))
		{
			$query = utf8_to_cp1251($query_vars['q']);
			insert_se_query($hit_id, SEID_GOOGLE, $query);
		}
	}
}

//	-	-	-	-	-	-	-	-	-	-	-	-	-	RAMBLER
function check_ref_rambler
($hit_id, $path, $query_vars)
{
	//TODO: fix rambler
	if (!exist_and_notblank($query_vars, 'words')) return;
	$words = $query_vars['words'];
	$top100 = false;
	if ($path == '/srch')
	{
		if (exist_and_notblank($query_vars, 'set'))
		{
			if ($query_vars['set'] == 'top100')
				$top100 = true;
		}
	}
	elseif ($path == '/cgi-bin/counter_search')
	{
		$top100 = true;
	}
	else return;
	
	//if ($top100)//TODO: and oe != 1251
	//{
	//	$words = convert_cyr_string($words, 'k', 'w');
	//}
	
	insert_se_query($hit_id, SEID_RAMBLER, $words);
}

//	-	-	-	-	-	-	-	-	-	-	-	-	-	MAIL.RU
function check_ref_mailru
($hit_id, $path, $query_vars)
{
	if ($path == '/search')
	{
		if (exist_and_notblank($query_vars, 'q'))
		{
			insert_se_query($hit_id, SEID_MAILRU, $query_vars['q']);
		}
	}
}

//	-	-	-	-	-	-	-	-	-	-	-	-	-	APORT
function check_ref_aport
($hit_id, $path, $query_vars)
{
	if (exist_and_notblank($query_vars, 'r'))
	{
		insert_se_query($hit_id, SEID_APORT, $query_vars['r']);
	}
}

//	-	-	-	-	-	-	-	-	-	-	-	-	-	WEBALTA
function check_ref_webalta
($hit_id, $path, $query_vars)
{
	if ($path == '/search')
	{
		if (exist_and_notblank($query_vars, 'q'))
		{
			$query = utf8_to_cp1251($query_vars['q']);
			insert_se_query($hit_id, SEID_WEBALTA, $query);
		}
	}
}
//////////////////////////////////////////////////////////////////////////////////////////////////
*/


function process_referrer($ref, $hit_id)
{
	global $OLT_ON_SENGIES;
	$url_parsed = parse_url($ref);
	$r_host = strtolower($url_parsed['host']);
	$r_path = strtolower($url_parsed['path']);
	parse_str($url_parsed['query'], $r_query);
	
	foreach ($OLT_ON_SENGIES as $engine => $accepted_hosts) 
	{
		foreach ($accepted_hosts as $host)
		{
			if (strpos($r_host, $host) !== false)
			{
				$checker = "check_ref_" . $engine;
				$checker($hit_id, $r_path, $r_query);
				return ;
			}
		}
	}	
}






?>
