<?php
define('RM_GET', 1);
define('RM_POST', 2);

define('RM_GETPOST', 3);


if( !get_magic_quotes_gpc() )
{
	if( is_array($_GET) )
	{
		while( list($k, $v) = each($_GET) )
		{
			if( is_array($_GET[$k]) )
			{
				while( list($k2, $v2) = each($_GET[$k]) )
				{
					$_GET[$k][$k2] = addslashes($v2);
				}
				@reset($_GET[$k]);
			}
			else
			{
				$_GET[$k] = addslashes($v);
			}
		}
		@reset($_GET);
	}

	if( is_array($_POST) )
	{
		while( list($k, $v) = each($_POST) )
		{
			if( is_array($_POST[$k]) )
			{
				while( list($k2, $v2) = each($_POST[$k]) )
				{
					$_POST[$k][$k2] = addslashes($v2);
				}
				@reset($_POST[$k]);
			}
			else
			{
				$_POST[$k] = addslashes($v);
			}
		}
		@reset($_POST);
	}

	if( is_array($_COOKIE) )
	{
		while( list($k, $v) = each($_COOKIE) )
		{
			if( is_array($_COOKIE[$k]) )
			{
				while( list($k2, $v2) = each($_COOKIE[$k]) )
				{
					$_COOKIE[$k][$k2] = addslashes($v2);
				}
				@reset($_COOKIE[$k]);
			}
			else
			{
				$_COOKIE[$k] = addslashes($v);
			}
		}
		@reset($_COOKIE);
	}
}

class Request {
	
	function is_set($method, $key) {
		if ($method == RM_GET)
		{
			return array_key_exists($key, $_GET);
		}
		if ($method == RM_POST)
		{
			return array_key_exists($key, $_POST);
		}
		return false;
	}
	
    function getVar($method, $key, $default = null)  {
    	
		if (Request::is_set(RM_GET, $key)) {
			return $_GET[$key];
		}
		if (Request::is_set(RM_POST, $key))
		{
			return $_POST[$key];
		}
		return $default;
    }
    
    function getInt($method, $key, $default = null) {
    	return intval(Request::getVar($method, $key, $default));
    }
    
    function getArray($method, $key, $default = null) {
    	$arr = Request::getVar($method, $key, null);
    	return is_array($arr) ? $arr : $default;
    }
    
    function getString($method, $key, $default = null, $maxlen=0, $trim = true)
    {
    	$val = Request::getVar($method, $key, $default);
    	if ($trim) {
    		$val = trim($val);
    	}
    	if (($maxlen>0) && (strlen($val)>$maxlen)) {
    		$val = substr($val, 0, $maxlen);
    	}
    	return $val;
    }
}
?>