(*--------------------------------------------------------------------------*)
(*                   LogTen --- Calculate base 10 logarithm                 *)
(*--------------------------------------------------------------------------*)

FUNCTION LogTen( X: REAL ) : REAL;

(*--------------------------------------------------------------------------*)
(*                                                                          *)
(*     Function:  LogTen                                                    *)
(*                                                                          *)
(*     Purpose:   Calculates base ten logarithm                             *)
(*                                                                          *)
(*     Calling Sequence:                                                    *)
(*                                                                          *)
(*        Logval := LogTen( X: REAL ) : REAL;                               *)
(*                                                                          *)
(*           X      --- value to find logarithm of                          *)
(*                                                                          *)
(*           Logval --- resultant logarithm (X > 0);                        *)
(*                      = 0 if X <= 0.                                      *)
(*                                                                          *)
(*     Calls:  LN                                                           *)
(*                                                                          *)
(*--------------------------------------------------------------------------*)

BEGIN (* LogTen *)

   IF X <= 0.0 THEN
      LogTen := 0.0
   ELSE
      LogTen := LN( X ) * LNTenInv;

END   (* LogTen *);