(* Oletetaan, ett{ k{yt|ss{ on neli|nmuotoinen pelilauta, jonka    *)
(* yhdess{ nurkassa on yksi pelinappula. T{m{ nappula saa siirty{  *)
(* yhdell{ askelella JOKO 3 askelta vaaka- tai pystyrivin suuntaan *)
(* TAI 2 askelta vinorivin suuntaan. Ongelma: anna tarvittavat     *)
(* siirrot, joiden j{lkeen nappula on k{ynyt joka ruudussa. (Vain  *)
(* kerran kussakin ruudussa.)                                      *)
(*                                                                 *)
(*  T{m{ ohjelma ratkaisee ongelman sivu*sivu kokoisella laudalla. *)
(*  Siirtoj{rjestys kuvataan numeroilla 1..25.                     *)
(*  Ratkaisun hakeminen tapahtuu ruudulla reaaliaikaisesti.        *)
(*  Jos l|yd{t ratkaisun 10*10 sokkelossa, haluaisin kuulla siit{. *)
(*                                                                 *)
(*  Ohjelma on kirjoitettu Turbo Pascal 4.0:lla, muttei ole kovin  *)
(*  laiteriippuvaista koodia.                                      *)
(*                                                                 *)
(*                                    Jari Karjala                 *)
(*                                    t33869n@saha.hut.fi          *)

Program Esimerkki_Siita_Miten_Ratkaistaan_Ongelma_Rekursiivisesti;

Uses
  crt;          (* UNIT joka sis{lt{{ proceduurit GoToXY ja ClrScr *)

Const
  sivu            = 5;
  alku_x          = 1;
  alku_y          = 1;
  siirrot         : array [1..8] of array[1..2] of integer =
                             (( 0, 3), ( 2, 2), ( 3, 0), ( 2,-2),
                              ( 0,-3), (-2,-2), (-3, 0), (-2, 2));
Var
  valmis          : boolean;
  a,b,laskuri     : integer;
  PeliLauta       : array[1..sivu,1..sivu] of integer;


procedure Siirry(x,y:integer);
var
  a,x1,y1:integer;
begin
  if not valmis then begin        (* Jatketaan kunnes kaikissa ruudut k{yty  *)
    a:=1;
    while (a<9) and not valmis do begin
      x1:=x+siirrot[a,1];                      (* Seuraavat siirtoehdokkaat  *)
      y1:=y+siirrot[a,2];
      if (x1>=1) and (x1<=sivu) and (y1>=1) and (y1<=sivu) then
        if PeliLauta[x1,y1]=0 then begin       (* Onko ruutu vapaa ?         *)
          inc(laskuri);
          if laskuri>=sqr(sivu) then valmis:=true;
          PeliLauta[x1,y1]:=laskuri;           (* T{ytet{{n se               *)
          GoToXY(x1*4,y1); write(laskuri);     (* P{ivitet{{n n{ytt|         *)
          Siirry(x1,y1);                       (* Edet{{n seuraavaan ruutuun *)
          if not valmis then begin
            PeliLauta[x1,y1]:=0;               (* Poistetaan v{{r{ siirto    *)
            dec(laskuri);
            GoToXY(x1*4,y1); write('    ');    (* Tyhjennet{{n ruutu n{yt|lt{*)
          end  (* if *)
        end;   (* if *)
      inc(a)                                   (* Kokeillaan kaikki suunnat  *)
    end (* while *)
  end   (* if *)
end;

begin
  ClrScr;
  for a:=1 to sivu do                          (* Nollataan PeliLauta        *)
    for b:=1 to sivu do begin
      GoToXY(a*4,b); write('.');
      PeliLauta[a,b]:=0;
    end;
  GoToXY(4*alku_x,alku_y); write(1);

  Laskuri:=1; valmis:=false;
  PeliLauta[alku_x,alku_y]:=1;                 (* Merkit{{n l{ht|ruutu      *)

    Siirry(alku_x,alku_y);                     (* Varsinainen ratkaiseminen *)

  GoToXY(1,21);
  writeln('Valmis !!');
end.
