/*
 * Decompiled with CFR 0.152.
 */
package Sav.Z;

import Sav.Processor.Association;
import Sav.Processor.Concept;
import Sav.Processor.DataList;
import Sav.Processor.Long1;
import Sav.Processor.Memory;
import Sav.TParser.Fielder;
import Sav.Z.DataBase;
import Sav.Z.Error;
import Sav.Z.Expression;
import Sav.Z.Failure;
import Sav.Z.Lexis;
import Sav.Z.Procedure;
import Sav.Z.Session;
import Sav.Z.Statement;
import Sav.Z.ZException;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;

class Table
implements Lexis {
    public static char FNC = (char)45;
    static int B_LENGTH = 131072;
    Procedure proc;
    Session ss;
    DataBase db;
    Association base;
    File fData0;
    File fData;
    File file0;
    File file;
    int pSource;
    int pData0;
    int pData;
    String sInput;
    Expression expr;
    Expression expr0;
    String line;
    DataList list0;
    DataList list;
    int iLine0;
    int iLine;
    int pos0;
    int pos;
    int iCol0;
    int colNum;
    boolean[] bCol;
    Expression[] eRow;
    LineNumberReader lnr;
    boolean analysing;

    Table(Procedure procedure) throws IOException {
        int n2;
        int n3;
        int n4;
        this.proc = procedure;
        this.expr = procedure.expr;
        this.ss = this.expr.stm.ss;
        this.db = this.expr.stm.ss.db;
        this.base = this.db.base;
        if (procedure.file != null) {
            this.fData = this.fData0 = procedure.fData0;
            this.file = this.file0 = procedure.file0;
            this.pSource = this.expr.begin;
            this.iLine0 = 1;
            return;
        }
        String string = this.expr.stm.text;
        int n5 = string.length();
        int n6 = 0;
        for (n4 = this.expr.end; n4 < n5 && (n6 = (int)string.charAt(n4)) <= 32; ++n4) {
        }
        if (n6 == 60) {
            n3 = n4 + 1;
            n2 = (n4 = Fielder.passQuote(string, n4, '>')) < n5 ? n4 - 1 : n4;
        } else {
            n2 = n3 = n4;
        }
        this.iLine0 = this.expr.stm.getLineNumber();
        for (n4 = this.expr.stm.begin(); n4 < n3; ++n4) {
            n6 = string.charAt(n4);
            if (n6 != 10) continue;
            ++this.iLine0;
        }
        this.pData = this.pData0 = n3;
        this.sInput = string.substring(n3, n2);
    }

    void analyse() {
        this.analysing = true;
        String string = this.ss.getProcess();
        boolean bl2 = false;
        if (this.file0 == null) {
            bl2 = this.analyse1();
        } else {
            if (!this.file0.exists()) {
                return;
            }
            if (this.file0.isDirectory()) {
                String[] stringArray = this.file0.list(new TableFilter(this));
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    this.fData = new File(this.fData0, stringArray[i2]);
                    this.file = new File(this.file0, stringArray[i2]);
                    bl2 = this.analyse1();
                    if (bl2) {
                        continue;
                    }
                    break;
                }
            } else {
                bl2 = this.analyse1();
            }
        }
        this.file = this.file0;
        this.fData = this.fData0;
        if (string != null) {
            this.ss.setProcess(string);
        }
        this.analysing = false;
        if (!bl2) {
            throw new ZException();
        }
    }

    boolean analyse1() {
        this.pData = this.pData0;
        this.pos = 0;
        Exception exception = null;
        this.iLine = this.iLine0 - 1;
        try {
            if (this.file == null) {
                this.lnr = new LineNumberReader(new StringReader(this.sInput));
            } else {
                FileReader fileReader = new FileReader(this.file);
                this.lnr = new LineNumberReader(fileReader, B_LENGTH);
                this.lnr.mark(B_LENGTH);
            }
            this.analyse2();
        }
        catch (ZException zException) {
            exception = zException;
        }
        catch (Exception exception2) {
            exception2.printStackTrace();
            new Error(this.ss, exception2, this.pSource, this.fData, this.pData, this.iLine, this.pos + 1);
            exception = exception2;
        }
        this.free();
        this.ss.clearDataLine();
        this.ss.clearProcess();
        return exception == null;
    }

    void analyse2() throws IOException {
        int n2 = this.ss.countErrors();
        this.analyseSchema();
        int n3 = this.ss.countErrors();
        if (n3 > n2) {
            return;
        }
        if (this.line == null) {
            return;
        }
        this.ss.setProcess(String.valueOf(String.valueOf(new StringBuffer("Analyzing table ").append(this.fData).append("..."))));
        this.nextLine();
        while (this.line != null) {
            this.ss.setDataLine(this.iLine);
            this.analyseLine();
            this.nextLine();
        }
    }

    void analyseSchema() throws IOException {
        int n2;
        this.nextLine();
        if (this.line == null) {
            return;
        }
        this.colNum = 1;
        Fielder fielder = new Fielder(this.line.substring(this.pos0));
        while (fielder.hasNext()) {
            fielder.nextPos();
            ++this.colNum;
        }
        this.bCol = new boolean[this.colNum];
        this.eRow = new Expression[this.colNum];
        if (this.proc.eAttr0 != null) {
            this.iCol0 = this.proc.eAttr0.cnc.toInteger();
            if (this.iCol0 >= this.colNum || this.iCol0 == 0) {
                this.proc.eAttr0.warnErr0("Key attribute number is beyond");
                if (!this.analysing) {
                    throw new ZException();
                }
                return;
            }
        } else {
            this.iCol0 = 1;
        }
        this.bCol[this.iCol0] = true;
        Expression expression = (Expression)this.proc.attrList.getFirst();
        if (expression == null && this.proc.eAttr0 == null) {
            for (n2 = 1; n2 < this.colNum; ++n2) {
                this.bCol[n2] = true;
            }
        }
        while (expression != null) {
            n2 = expression.cnc.toInteger();
            if (n2 >= this.colNum || n2 == 0 || n2 == this.iCol0) {
                expression.warnErr0("Attribute number is beyond");
                if (!this.analysing) {
                    throw new ZException();
                }
            } else {
                this.bCol[n2] = true;
            }
            expression = (Expression)this.proc.attrList.getNext();
        }
        this.analyseLine0();
    }

    void analyseLine0() {
        Expression expression;
        int n2 = 192;
        this.list0 = new DataList();
        int n3 = this.line.length();
        int n4 = 0;
        this.pos = this.pos0;
        while (this.pos < n3) {
            Statement statement = new Statement(this.expr.stm, this.pSource, this.fData, this.pData, this.iLine, this.line, this.pos);
            if (!this.bCol[++n4]) {
                this.list0.add(null);
            } else {
                statement.analyse(this.ss, null, n2);
                if (this.expr.stm.hasErrors() && !this.analysing) {
                    throw new ZException();
                }
                expression = statement.expression;
                if (n4 == this.iCol0) {
                    this.expr0 = expression;
                    this.list0.add(expression);
                } else if (expression.index == -10) {
                    this.bCol[n4] = false;
                    this.list0.add(null);
                } else {
                    this.list0.add(59, (Object)expression);
                }
            }
            this.pos = statement.end();
        }
        expression = (Expression)this.list0.getFirst();
        while (expression == null) {
            expression = (Expression)this.list0.getNext();
        }
        if (expression == null) {
            this.list0 = null;
            new Error(this.ss, this.pSource, this.fData, this.pData, this.iLine, this.pos0, "Missing attribute names");
            if (!this.analysing) {
                throw new ZException();
            }
        }
    }

    void execute() {
        String string = this.ss.getProcess();
        ZException zException = null;
        try {
            if (this.file0 == null) {
                this.execute1();
            } else {
                if (!this.file0.exists()) {
                    Expression expression = (Expression)this.expr.list.getFirst();
                    expression.warnFail("is not found");
                    return;
                }
                if (this.file0.isDirectory()) {
                    String[] stringArray = this.file0.list(new TableFilter(this));
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        this.fData = new File(this.fData0, stringArray[i2]);
                        this.file = new File(this.file0, stringArray[i2]);
                        this.execute1();
                    }
                } else {
                    this.execute1();
                }
            }
        }
        catch (ZException zException2) {
            zException = zException2;
        }
        this.fData = this.fData0;
        this.file = this.file0;
        if (string != null) {
            this.ss.setProcess(string);
        }
        if (zException != null) {
            throw zException;
        }
    }

    void execute1() {
        this.pData = this.pData0;
        this.pos = 0;
        Throwable throwable = null;
        ZException zException = null;
        this.iLine = this.iLine0 - 1;
        try {
            if (this.fData != null) {
                this.ss.setProcess(String.valueOf(String.valueOf(new StringBuffer("Reading table ").append(this.fData).append("..."))));
            } else {
                this.ss.setProcess("Reading table...");
            }
            if (this.file == null) {
                this.lnr = new LineNumberReader(new StringReader(this.sInput));
            } else {
                FileReader fileReader = new FileReader(this.file);
                this.lnr = new LineNumberReader(fileReader, B_LENGTH);
                this.lnr.mark(B_LENGTH);
            }
            this.executeSchema();
            if (this.line == null) {
                this.free();
                return;
            }
            this.execute2();
        }
        catch (ZException zException2) {
            zException = zException2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new Failure(this.ss, exception, this.pSource, this.fData, this.pData, this.iLine, this.pos + 1);
            throwable = exception;
        }
        this.free();
        this.ss.clearDataLine();
        this.ss.clearProcess();
        if (throwable != null) {
            throw new ZException(throwable.toString());
        }
        if (zException != null) {
            throw zException;
        }
    }

    void executeSchema() throws IOException {
        int n2 = this.ss.countErrors();
        this.analyseSchema();
        int n3 = this.ss.countErrors();
        if (n3 > n2) {
            throw new ZException();
        }
        if (this.line == null) {
            return;
        }
        if (this.expr0.index != -10) {
            if (!this.expr0.execute(null)) {
                throw new ZException();
            }
            this.expr0.cnc = this.expr0.ass.getIfOne();
            if (this.expr0.cnc == null) {
                this.expr0.warnFail("Ambiguous key attribute name");
                throw new ZException();
            }
            this.expr0.ass.setSense(57);
        }
        DataList dataList = new DataList();
        DataList dataList2 = new DataList();
        int n4 = 0;
        Expression expression = (Expression)this.list0.getFirst();
        while (this.list0.hasCurrent()) {
            ++n4;
            if (expression != null && expression != this.expr0) {
                if (!expression.execute(null)) {
                    throw new ZException();
                }
                if (expression.cnc == null) {
                    expression.cnc = expression.ass.getIfOne();
                    if (expression.cnc == null) {
                        expression.warnFail("Ambiguous attribute name");
                        throw new ZException();
                    }
                }
                expression.ass.setSense(57);
                dataList2.add(expression);
                dataList.add(58, (Object)expression.ass);
            }
            expression = (Expression)this.list0.getNext();
        }
        if (this.expr0.index != -10) {
            dataList = this.db.insertSchema(this.expr0.ass, dataList, dataList2);
            if (!dataList2.isEmpty()) {
                this.expr0.warnFail("", dataList2, "Non-describable schema");
                throw new ZException();
            }
            if (dataList != null) {
                Association association = this.expr0.ass.get();
                this.db.insertACRelation(association, dataList);
            }
        }
    }

    void execute2() throws IOException {
        Long1 long1 = Memory.init();
        this.nextLine();
        while (this.line != null) {
            this.ss.setDataLine(this.iLine);
            int n2 = this.ss.countErrors();
            this.analyseLine();
            int n3 = this.ss.countErrors();
            if (this.ss.comm.isOff() || n3 > n2) {
                return;
            }
            if (this.fitRow()) {
                Expression expression = this.eRow[0];
                if (expression.ass != null || expression.execute(this.expr0.ass)) {
                    this.execute3();
                    this.execute4();
                    this.execute5();
                    Memory.control(long1, this.base);
                }
            }
            this.nextLine();
        }
    }

    boolean fitRow() throws IOException {
        if (this.list == null) {
            return false;
        }
        int n2 = 0;
        this.list.init();
        Expression expression = (Expression)this.list0.getFirst();
        while (this.list0.hasCurrent()) {
            Expression expression2 = (Expression)this.list.getNext();
            ++n2;
            if (expression != null) {
                int n3 = expression == this.expr0 ? 0 : n2;
                if (expression2 == null) {
                    if (n3 == 0) {
                        return false;
                    }
                    this.eRow[n3] = null;
                } else {
                    Expression expression3 = this.eRow[n3];
                    if (expression3 == null) {
                        this.eRow[n3] = expression2;
                    } else if (expression3.index > 6) {
                        this.eRow[n3] = expression2;
                    } else if (expression3.index != expression2.index || expression3.end - expression3.begin != expression2.end - expression2.begin) {
                        this.eRow[n3] = expression2;
                    } else if (expression3.cnc == null || expression2.cnc == null || !expression3.cnc.equals(expression2.cnc)) {
                        this.eRow[n3] = expression2;
                    }
                }
            }
            expression = (Expression)this.list0.getNext();
        }
        return true;
    }

    void execute3() throws IOException {
        int n2 = 0;
        Expression expression = (Expression)this.list0.getFirst();
        while (this.list0.hasCurrent()) {
            Expression expression2;
            if ((expression2 = this.eRow[++n2]) != null && (expression2.ass == null || expression2.index == -3)) {
                expression2.execute(expression.ass);
            }
            expression = (Expression)this.list0.getNext();
        }
    }

    void execute4() throws IOException {
        Expression expression = this.eRow[0];
        Association association = expression.ass;
        DataList dataList = new DataList();
        dataList.add(59, (Object)association);
        Concept concept = null;
        if (expression.cnc != null) {
            concept = this.expr0.index == -10 ? expression.cnc : new Concept(this.expr0.cnc, 57, expression.cnc);
        }
        int n2 = 0;
        Expression expression2 = (Expression)this.list0.getFirst();
        while (this.list0.hasCurrent()) {
            Expression expression3;
            if ((expression3 = this.eRow[++n2]) != null && expression3.ass != null && expression3.ass.hasDenotation()) {
                if (expression3.cnc != null) {
                    this.base.con(expression2.cnc);
                    this.base.con(57);
                    this.base.con(expression3.cnc);
                    if (concept != null) {
                        this.base.setConnect(59, concept);
                    } else {
                        this.base.setConnect(59, association);
                    }
                    this.base.regain();
                } else {
                    dataList.getFirst();
                    dataList.setType(59);
                    this.base.setConnection(expression3.ass, dataList);
                }
            }
            expression2 = (Expression)this.list0.getNext();
        }
        dataList = null;
    }

    void execute5() throws IOException {
        Expression expression;
        Expression expression2;
        int n2;
        DataList dataList = null;
        Expression expression3 = this.eRow[0];
        if (expression3.cnc != null) {
            if (this.expr0.index != -10) {
                this.base.con(this.expr0.cnc);
                this.base.con(57);
            }
            this.base.con(expression3.cnc);
            n2 = 0;
            expression2 = (Expression)this.list0.getFirst();
            while (this.list0.hasCurrent()) {
                if ((expression = this.eRow[++n2]) != null && expression.ass != null) {
                    if (expression.cnc != null) {
                        Concept concept = new Concept(expression2.cnc, 57, expression.cnc);
                        this.base.setConnect(59, concept);
                    } else if (dataList == null) {
                        dataList = new DataList();
                    }
                }
                expression2 = (Expression)this.list0.getNext();
            }
            this.base.regain();
        } else {
            dataList = new DataList();
        }
        if (dataList != null) {
            n2 = 0;
            expression2 = (Expression)this.list0.getFirst();
            while (this.list0.hasCurrent()) {
                if ((expression = this.eRow[++n2]) != null && expression.ass != null && (expression.cnc == null || expression3.cnc == null)) {
                    dataList.add(59, (Object)expression.ass);
                }
                expression2 = (Expression)this.list0.getNext();
            }
            this.base.setConnection(expression3.ass, dataList);
            dataList = null;
        }
    }

    void nextLine() throws IOException {
        if (this.line != null) {
            this.pData += this.line.length();
            ++this.pData;
            this.pos = 0;
        }
        ++this.iLine;
        this.line = this.lnr.readLine();
        if (this.line == null) {
            return;
        }
        Fielder fielder = new Fielder(this.line);
        this.pos = this.pos0 = fielder.passSpace();
        if (this.pos0 < this.line.length()) {
            return;
        }
        this.nextLine();
    }

    void analyseLine() {
        Expression expression;
        int n2 = 192;
        this.list = new DataList();
        this.list0.init();
        int n3 = this.line.length();
        int n4 = 0;
        this.pos = this.pos0;
        while (this.pos < n3) {
            Expression expression2 = (Expression)this.list0.getNext();
            ++n4;
            Statement statement = new Statement(this.expr.stm, this.pSource, this.fData, this.pData, this.iLine, this.line, this.pos);
            if (!this.list0.hasCurrent()) {
                new Error(statement, statement.begin(), "Indefinite attribute name");
                if (!this.analysing) {
                    throw new ZException();
                }
            } else if (expression2 == null) {
                this.list.add(null);
            } else {
                statement.analyse(this.ss, expression2, n2);
                if (this.expr.stm.hasErrors() && !this.analysing) {
                    throw new ZException();
                }
                expression = statement.expression;
                if (expression2 == this.expr0) {
                    if (expression.index == -10) {
                        this.list = null;
                        break;
                    }
                    this.list.add(expression);
                } else if (expression.index == -10) {
                    this.list.add(null);
                } else {
                    this.list.add(expression);
                }
            }
            this.pos = statement.end();
        }
        if (this.list != null) {
            expression = (Expression)this.list.getFirst();
            while (expression == null) {
                expression = (Expression)this.list.getNext();
            }
            if (expression == null) {
                this.list = null;
            }
        }
    }

    void free() {
        try {
            this.lnr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class TableFilter
    implements FilenameFilter {
        TableFilter(Table table) {
        }

        public boolean accept(File file, String string) {
            return string.endsWith(".tab");
        }
    }
}

