<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


    
<% PageUtils.jspStart(request); %>



<% 

// Added this after finding an apparent bug in Tomcat: the page was cutting itself off after
// exactly 8K of output; this is the default buffer, so I increase the buffer here (this should
// absolutely not be necessary, but it does seem to fix the problem):
%>
<% // @ // REMOVING because later version of Tomcat choked on it: oh, Tomcat...  page buffer="200" %>



<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>
<%@ page import="com.workroll.app.util.*" %>
 
<% PageUtils.setRequiredLoginStatus("user",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ISSUES,request); %>
<% PageUtils.setSubsection(WorkRollConstants.SUBSECTION_ISSUES_CLOSED,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%
//if (true) throw new Exception("This is the description text.");
%>

<%! 
       
%>

<%
IssueFilter filter=controller.getSessionInfo().getCurrentFilter();

// No matter how user has filtered for status (possibly having set the filter on a different list), we want to show closed issues here:
if (filter!=null && filter.getStatuses()!=IssueFilter.CLOSED_ONLY)
{
	filter=(IssueFilter)filter.clone();
	filter.setStatuses(IssueFilter.CLOSED_ONLY);
}

// Following arrays for use by staticList.jsp:
ArrayList issuesForPreview=null;
String[] headerNames={"ID","By","To","Status","Priority","Project","Instance","Opened","Due","Description",""};
int[] colWidths={35,60,60,67,67,80,80,72,57,215,44}; 

if (controller.getClient().isNav())
{
	adjustWidthsForNav(colWidths);
}

%>
<%
// Include expects these vars (constant defined in include itself):
int listType=LIST_TYPE_STANDARD;
String staticListSortName=controller.getParam("sn","openDateSort");
boolean staticListSortAscending=controller.getParamAsBoolean("asc",false);
boolean staticListDoFilterIfFound=true;
boolean isActiveIssues=false;

%>


<%@ include file="includes/staticListTop.jsp" %>
      
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
 
<SCRIPT src=../global/HashMap.js></script>

<%@ include file="../global/headInclude.jsp" %>

<%@ include file="js/issuesHeadInclude.jsp" %>

<script>

var numIssues="<%=issues.size()%>"

var minimumInitialRows=0
var rowsToAddAsNeeded=0
</script>  



<script language="JavaScript">

<%@ include file="js/msToLabelsMap.jsp" %>


var sortName="<%=controller.getParam("sn","openDateSort")%>"
var sortAscending=<%=controller.getParamAsBoolean("asc",false)%>


function reopenIssue(issueId)
{
	openDialogWithCallback("issues/reopenIssue.jsp?id="+issueId, "reopenWin", 265, 325, false, true, "reopenIssueCALLBACK")
}
function reopenIssueCALLBACK(reloadList)
{
	if (reloadList)
	{
		top.location.href=""+top.location.href
	}
	
}

function applyFilter()
{
	openDialogWithCallback("issues/filterInput.jsp", "filterWin", 437, 737, false, true, "applyFilterCALLBACK")
}
function applyFilterCALLBACK(changesMade)
{
	if (changesMade)
	{
		var url=""
			+"closed.jsp?"
			+"asc="+sortAscending+"&"
			+"sn="+sortName
		top.location.replace(url)
	}
}


function removeFilter()
{
	if (generalConfirm("OK to remove the current filter and show all closed issues?"))
	{
		location.replace
		(
			"removeFilter.jsp?isForClosedList=true&retQ="
			+escape
			(
				"asc="+sortAscending
				+"&sn="+sortName
			)
		)

	}
}




function init()
{
}

</script> 


  

<style type="text/css">
xBODY {visibility:hidden; }
#colHeadersDiv {top:155px; left:18px; position:absolute; }

#rightContentDiv {z-index:99; top:125px; left:790px; position:absolute; }

.dataCellWidthConstraint {position:relative; top:0px; left:0px; overflow:hidden;}

.dataCellLeft {border-bottom:1px solid #A2A278; padding:4px; padding-top:3px; padding-bottom:3px; overflow:hidden; font-size:11px; font-family:arial,helvetica; }
.dataCell {border-left:1px solid #A2A278; border-bottom:1px solid #A2A278; padding:4px; padding-top:3px; padding-bottom:3px; overflow:hidden; font-size:11px; font-family:arial,helvetica; }
.dataCellHighlighted {border-bottom:1px solid #A2A278; border-left:1px solid #B36B00; padding:4px; padding-top:3px; padding-bottom:3px; overflow:hidden; font-size:11px; font-family:arial,helvetica; }
.filterDetailFont {font-family:arial,helvetica; font-size:11px; color:#444434; }
.filteredFieldFont {color:#494949; font-weight:bold;}

#filterInfoHeader {z-index:99; border:1px solid #7f7f5e; 
background-color:#F2F2E1; padding:2px; font-size:11px; width:848px; font-family:arial,helvetica; color:#a2a27a; }

#filterInfoText {z-index:99; border:1px solid #7f7f5e; background-color:#ffffff; padding:2px; font-size:11px; border-top:0px solid #000000; 
font-family:arial,helvetica; width:848px; }

#filterInfo {}

#noIssuesIndicator {position:relative; top:10px; left:185px; width:460px; text-align:center; border:1px solid #a2a278; background-color:#e2e2b1; padding:4px; font-family:arial,helvetica; font-size:11px; color:#000000; }
a {color:#870000;}

</style>
</head>

<%@ include file="../global/bodyOpen.jsp" %>


<%
	for (int i=0; i<sortNames.length; i++)
	{
		%>
		<MAP NAME=<%=sortNames[i]%>Map>
		<AREA alt="sort by this column (ascending order)" SHAPE=RECT COORDS=0,0,11,7 HREF="closed.jsp?sn=<%=sortNames[i]%>&asc=true">
		<AREA alt="sort by this column (descending order)" SHAPE=RECT COORDS=0,7,11,14 HREF="closed.jsp?sn=<%=sortNames[i]%>&asc=false">
		</MAP>
		<%
	}

%>
 
  


<div id=mainDiv style="width:500px;" class=mainDivClass>


<form action="javascript:void(0)" onsubmit="return false" name=mainForm id=mainForm>
<input type=hidden name=numUsers id=numUsers value="10">
<font class=bodyFont> 
<span style="width:750px;">
<span class=firstSentenceFont>This is the list of closed issues<%=HelpManager.helpLink("closedIssuesList",request)%>.</span> Sort<%=HelpManager.helpLink("sort",request)%> by clicking <img src=../images/sortUpTextArrow.gif height=6 width=11 align=absmiddle> or <img src=../images/sortDownTextArrow.gif height=6 width=11 align=absmiddle>. Closed issues<%=HelpManager.helpLink("closedIssue",request)%> cannot be edited<%=HelpManager.helpLink("editing",request)%>; to edit a closed issue, you must first reopen<%=HelpManager.helpLink("reopening",request)%> it by clicking "reopen." Issue-filter<%=HelpManager.helpLink("filter",request)%> information appears at the top of the list. (Click "active" above to view issues that are active<%=HelpManager.helpLink("activeIssue",request)%>, i.e. not closed.)<%=HtmlUtils.doubleLB(request)%>



<br></font>
<%
boolean isActiveListFooter=false;
String filterTableWidth="842";

%>
<%@ include file="includes/filterInfo.jsp" %>
<%=HtmlUtils.spacer(4, 1, request)%><BR>


<%@ include file="includes/staticList.jsp" %>




</form>
</div>




<%@ include file="../global/bodyClose.jsp" %>

</html>


<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

