// BEGIN /js/HashMap.js

function HashMap() {
	this.get=_HashMap_get
	this.put=_HashMap_put 
	this.keys=_HashMap_keys
	this.values=_HashMap_values
	this.containsKey=_HashMap_containsKey
	this.containsValue=_HashMap_containsValue
	this.isEmpty=_HashMap_isEmpty
	this.size=_HashMap_size
	this.remove=_HashMap_remove
	this.clear=_HashMap_clear
	this.clone=_HashMap_clone
	this.toString=_HashMap_toString
	this.keysArray=new Array() // private field, parallel to valuesArray
	this.valuesArray=new Array() // private field, parallel to keysArray
}

function _HashMap_get(key) 
{
	for (var i=0; i<this.keysArray.length; i++) {
		if (this.keysArray[i]==key) {
			return this.valuesArray[i]
		}
	}
	return null
}

function _HashMap_put(key,value) 
{
	if (this.containsKey(key))
	{
		this.remove(key)
	}

	this.keysArray[this.keysArray.length]=key
	this.valuesArray[this.valuesArray.length]=value
}

function _HashMap_keys() 
{
	var retVal=new Array()
	for (var i=0; i<this.keysArray.length; i++) {
		retVal[retVal.length]=this.keysArray[i]
	}
	return retVal
}

function _HashMap_values() 
{
	var retVal=new Array()
	for (var i=0; i<this.valuesArray.length; i++) {
		retVal[retVal.length]=this.valuesArray[i]
	}
	return retVal
}

function _HashMap_sortedValues(sortFn)
{
	var retVal=this.values()
	retVal.sort(sortFn)
	return retVal
}

function _HashMap_containsKey(key) 
{
	for (var i=0; i<this.keysArray.length; i++) {
		if (this.keysArray[i]==key) {
			return true
		}
	}
	return false
}

function _HashMap_containsValue(value) 
{
	for (var i=0; i<this.valuesArray.length; i++) {
		if (this.valuesArray[i]==key) {
			return true
		}
	}
	return false
}

function _HashMap_isEmpty() 
{
	return (this.keysArray.length==0)
}

function _HashMap_size() 
{
	return this.keysArray.length
}

function _HashMap_remove(key) 
{
	var newKeysArray=new Array()
	var newValuesArray=new Array()
	for (var i=0; i<this.keysArray.length; i++) {
		if (this.keysArray[i]!=key) {
			newKeysArray[newKeysArray.length]=this.keysArray[i]
			newValuesArray[newValuesArray.length]=this.valuesArray[i]
		}
	}
	this.keysArray=newKeysArray
	this.valuesArray=newValuesArray
}

function _HashMap_clear() 
{
	this.keysArray=new Array()
	this.valuesArray=new Array()
}

function _HashMap_clone() 
{
	var ret=new HashMap()
	for (var i=0; i<this.keysArray.length; i++)
	{
		ret.put(this.keysArray[i],this.valuesArray[i])
	}
	return ret
}
function _HashMap_toString()
{
	if (this.keysArray==null)
	{
		return "[null]"
	}
	var ret="["
	for (var i=0; i<this.keysArray.length; i++)
	{
		ret+=this.keysArray[i]+":"+this.valuesArray[i]+";"
	}
	ret+="](size="+this.keysArray.length+")"
	return ret
}




// END /js/HashMap.js
