/*
 * Copyright (c) 1998-2005 Servertec. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 * 
 * CopyrightVersion 1.0
 */

import stec.pp.pp;

/**
  * the tPP class is used to demonstrate the pp API.
  *
  * <p>
  * displays <b>ok</b>, if <b>a</b> is defined to some value that evaluates to <b>1</b>.
  * displays <b>error</b>, if <b>a</b> is not defined as to some value that evaluates to <b>1</b>.
  *
  * <p>
  * @version 1.0.0, 08/27/98
  * @author Servertec<br>
  *         Manuel J. Goyenechea
  */

public class tPP
{
    public static void main(String args[])
    {
        try
        {
            pp mypp = new pp();
            
            mypp.displayLogo = false;
            //mypp.verboseMessages = true;
            //mypp.removeComments = false;
            //mypp.removeBlankLines = false;
            //mypp.warningMessages = false;
            //mypp.embeddedQuotes = false;
            //mypp.generateLineDirectives = true;
            
            mypp.define("a", "1.0");
            mypp.define("max(a,b) (a>=b)?a:b");
            
            String input = "#if a == 1\n";
            input += "#message ok\n";
            input += "#else\n";
            input += "#message error\n";
            input += "#endif\n";
            input += "max(1,2)";
            
            System.out.println(mypp.preprocess(input));
        }
        catch(Exception e)
        {
            e.printStackTrace();
        }
    }    
}
