package demo;

import com.japisoft.formula.*;
import com.japisoft.formula.lib.*;
import com.japisoft.formula.lib.standard.*;

/** Sample for showing the content of the default mathematical library. This
 * library is increased by a new function that compute the opposite of its first
 * argument */
public class Demo {

    static class CustomFunction extends AbstractFunction {
	public CustomFunction() {
	    super( "opp", 1 );
	} 
	public Variant evaluate( ListOfArgument args ) {
	    return new Variant( -( getFirstArgument( args ) ) );
	}
    }

    public static void main( String[] _args) {
	Lib mLib = LibManager.getLib();
	System.out.println( "Current mathematical library :" + mLib );

	// Show all functions for the current library

	Function[] mFunctions = mLib.getFunctions();
	for ( int i = 0; i < mFunctions.length; i++ ) {
	    System.out.println( "- " + mFunctions[ i ] );
	}

	// Add a new function

	((AbstractLib)mLib).install( new CustomFunction() );

	// Evaluate it

	ListOfArgument args = new ListOfArgument();
	args.addVariant( new Variant( 10.4 ) );

	System.out.println( "Evaluate new function : " + mLib.evaluate( "opp", args ) );

    }
}
