/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.formula.node;

import com.japisoft.formula.SymbolResolverException;
import com.japisoft.formula.Variant;
import com.japisoft.formula.node.AbstractNode;
import com.japisoft.formula.node.EvaluateException;
import com.japisoft.formula.node.NodeContext;

public class VariableNode
extends AbstractNode {
    public String getVariableName() {
        return this.getContent();
    }

    public void setVariableName(String string) {
        this.setContent(string);
    }

    public void addChildNode(AbstractNode abstractNode) {
        throw new RuntimeException("Invalid operation on variable " + this.getVariableName());
    }

    public Object evaluate(NodeContext nodeContext) throws EvaluateException {
        if (nodeContext.getSymbolResolver() == null) {
            throw new EvaluateException(this.getPos(), "Bad resolver for symbol : '" + this.getVariableName() + "'");
        }
        try {
            Variant variant = nodeContext.getSymbolResolver().getValue(this.getVariableName());
            if (variant == null) {
                throw new EvaluateException("Cannot evaluate " + this.getVariableName());
            }
            if (variant.isBigDecimal()) {
                return variant.getBigDecimalValue();
            }
            if (variant.isDouble()) {
                return new Double(variant.getDoubleValue());
            }
            if (variant.isString()) {
                return variant.getStringValue();
            }
            if (variant.isBoolean()) {
                return new Boolean(variant.getBooleanValue());
            }
            return null;
        }
        catch (SymbolResolverException symbolResolverException) {
            throw new EvaluateException(symbolResolverException.getMessage());
        }
    }
}

