/*
 * Decompiled with CFR 0.152.
 */
package se.bysoft.sureshot.gui.browser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import java.util.Stack;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import se.bysoft.sureshot.debug.Assertion;
import se.bysoft.sureshot.gui.util.GuiHelper;
import se.bysoft.sureshot.gui.util.Updatable;
import se.bysoft.sureshot.gui.util.UpdateCaller;
import se.bysoft.sureshot.util.image.ImageLoaderException;
import se.bysoft.sureshot.util.image.ImageLoaderImpl;

public class MiniBrowser
extends JPanel
implements Observer,
Updatable {
    public static int BACK_IMAGE_INDEX = 0;
    public static int BACK_OVER_IMAGE_INDEX = 1;
    public static int BACK_PRESSED_IMAGE_INDEX = 2;
    public static int HOME_IMAGE_INDEX = 3;
    public static int HOME_OVER_IMAGE_INDEX = 4;
    public static int HOME_PRESSED_IMAGE_INDEX = 5;
    public static int GLOBE_STATIC_IMAGE_INDEX = 6;
    public static int GLOBE_ANIMATED_IMAGE_INDEX = 7;
    public static int ICON_IMAGE_INDEX = 8;
    public static int MAX_IMAGE_INDEX = 9;
    private final JEditorPane _htmlPane = new JEditorPane();
    private final JTextField _address = new JTextField(40);
    private final JButton _backButton = new JButton();
    private final JButton _homeButton = new JButton();
    private final JLabel _staticGlobeLabel;
    private final JLabel _animatedGlobeLabel;
    private final JFrame _frame;
    private final String _title;
    private final BrowserModel _model;
    private int _modelLocationState = 0;

    public MiniBrowser(String string, String[] stringArray, JFrame jFrame, String string2) throws ImageLoaderException {
        this._frame = jFrame;
        this._title = string2;
        this._frame.setTitle(this._title);
        this._model = new BrowserModel(string);
        this._model.addObserver(this);
        Image[] imageArray = new ImageLoaderImpl().load(stringArray);
        this._frame.setIconImage(imageArray[ICON_IMAGE_INDEX]);
        this.setLayout(new BorderLayout());
        ImageIcon imageIcon = new ImageIcon(imageArray[GLOBE_ANIMATED_IMAGE_INDEX]);
        ImageIcon imageIcon2 = new ImageIcon(imageArray[GLOBE_STATIC_IMAGE_INDEX]);
        ImageIcon imageIcon3 = new ImageIcon(imageArray[BACK_IMAGE_INDEX]);
        ImageIcon imageIcon4 = new ImageIcon(imageArray[BACK_OVER_IMAGE_INDEX]);
        ImageIcon imageIcon5 = new ImageIcon(imageArray[BACK_PRESSED_IMAGE_INDEX]);
        ImageIcon imageIcon6 = new ImageIcon(imageArray[HOME_IMAGE_INDEX]);
        ImageIcon imageIcon7 = new ImageIcon(imageArray[HOME_OVER_IMAGE_INDEX]);
        ImageIcon imageIcon8 = new ImageIcon(imageArray[HOME_PRESSED_IMAGE_INDEX]);
        this._homeButton.setToolTipText("<html>Home</html>");
        this._backButton.setIcon(imageIcon3);
        this._backButton.setRolloverIcon(imageIcon4);
        this._backButton.setPressedIcon(imageIcon5);
        this._homeButton.setIcon(imageIcon6);
        this._homeButton.setRolloverIcon(imageIcon7);
        this._homeButton.setPressedIcon(imageIcon8);
        this._backButton.setOpaque(false);
        this._homeButton.setOpaque(false);
        this._backButton.setBorder(null);
        this._homeButton.setBorder(null);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this._backButton);
        jPanel.add(this._homeButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this._htmlPane.setBorder(null);
        this._htmlPane.setEditable(false);
        this._htmlPane.addHyperlinkListener(new Hyperactive());
        JScrollPane jScrollPane = new JScrollPane(this._htmlPane);
        jScrollPane.setPreferredSize(new Dimension(600, 600));
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jPanel2.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(Color.white);
        jPanel3.add(new JLabel("Address: "));
        jPanel3.add(this._address);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBackground(Color.white);
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel.setAlignmentX(0.0f);
        jPanel3.setAlignmentX(0.0f);
        jPanel4.add(jPanel);
        jPanel4.add(jPanel3);
        this._animatedGlobeLabel = new JLabel(imageIcon);
        this._staticGlobeLabel = new JLabel(imageIcon2);
        this._animatedGlobeLabel.setOpaque(false);
        this._staticGlobeLabel.setOpaque(false);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBackground(Color.white);
        jPanel5.add(this._animatedGlobeLabel);
        jPanel5.add(this._staticGlobeLabel);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBackground(Color.white);
        jPanel6.setLayout(new BorderLayout());
        jPanel6.add((Component)jPanel5, "East");
        jPanel6.add((Component)jPanel4, "West");
        this.add((Component)jPanel6, "North");
        NavigationListener navigationListener = new NavigationListener();
        this._backButton.addActionListener(navigationListener);
        this._homeButton.addActionListener(navigationListener);
        this._address.addActionListener(navigationListener);
        this._htmlPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("page")) {
                    MiniBrowser.this._model.pageLoadFinished();
                }
            }
        });
        this.update(this._model, null);
    }

    public void update(Observable observable, Object object) {
        SwingUtilities.invokeLater(new UpdateCaller(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateView() {
        BrowserModel browserModel = this._model;
        synchronized (browserModel) {
            if (this._modelLocationState < this._model.getLocationState()) {
                this._address.setText(this._model.getCurrentUrl());
                new PageLoader(this._model.getCurrentUrl(), this._model, this._frame).start();
            }
            this._animatedGlobeLabel.setVisible(this._model.isLoading());
            this._staticGlobeLabel.setVisible(!this._model.isLoading());
            this._backButton.setEnabled(false);
            this._backButton.setEnabled(true);
            this._backButton.setRolloverEnabled(this._model.canGoBack());
            String string = this._model.canGoBack() ? "<html>Go back to " + this._model.getPreviousUrl() + "</html>" : "";
            this._backButton.setToolTipText(string);
            if (!this._model.isLoading()) {
                this._frame.setTitle(this._getTitle() + " - " + this._title);
            }
            this._modelLocationState = this._model.getLocationState();
        }
    }

    private String _getTitle() {
        String string = this._htmlPane.getText();
        int n = string.indexOf("<title>") + 7;
        int n2 = string.indexOf("</title>");
        if (n == -1 || n2 == -1 || n >= n2) {
            return "";
        }
        return string.substring(n, n2);
    }

    public static void main(String[] stringArray) {
        try {
            boolean bl;
            String string;
            String string2 = string = stringArray != null && stringArray.length >= 1 ? stringArray[0] : "http://www.bysoft.se/sureshot/";
            boolean bl2 = stringArray.length >= 2 ? !stringArray[1].equals("debug") : (bl = true);
            boolean bl3 = stringArray.length >= 3 ? !stringArray[2].equals("dispose") : true;
            String[] stringArray2 = new String[MAX_IMAGE_INDEX];
            stringArray2[MiniBrowser.BACK_IMAGE_INDEX] = bl ? "/graphics/jbrowser/back.gif" : "E:\\products\\jbrowser\\graphics\\jbrowser\\back.gif";
            stringArray2[MiniBrowser.BACK_OVER_IMAGE_INDEX] = bl ? "/graphics/jbrowser/back_over.gif" : "E:\\products\\jbrowser\\graphics\\jbrowser\\back_over.gif";
            stringArray2[MiniBrowser.BACK_PRESSED_IMAGE_INDEX] = bl ? "/graphics/jbrowser/back.gif" : "E:\\products\\jbrowser\\graphics\\jbrowser\\back.gif";
            stringArray2[MiniBrowser.HOME_IMAGE_INDEX] = bl ? "/graphics/jbrowser/home.gif" : "E:\\products\\jbrowser\\graphics\\jbrowser\\home.gif";
            stringArray2[MiniBrowser.HOME_OVER_IMAGE_INDEX] = bl ? "/graphics/jbrowser/home_over.gif" : "E:\\products\\jbrowser\\graphics\\jbrowser\\home_over.gif";
            stringArray2[MiniBrowser.HOME_PRESSED_IMAGE_INDEX] = bl ? "/graphics/jbrowser/home.gif" : "E:\\products\\jbrowser\\graphics\\jbrowser\\home.gif";
            stringArray2[MiniBrowser.GLOBE_STATIC_IMAGE_INDEX] = bl ? "/graphics/jbrowser/globe_static.gif" : "E:\\products\\jbrowser\\graphics\\jbrowser\\globe_static.gif";
            stringArray2[MiniBrowser.GLOBE_ANIMATED_IMAGE_INDEX] = bl ? "/graphics/jbrowser/globe_animated.gif" : "E:\\products\\jbrowser\\graphics\\jbrowser\\globe_animated.gif";
            stringArray2[MiniBrowser.ICON_IMAGE_INDEX] = bl ? "/graphics/jbrowser/icon.gif" : "E:\\products\\jbrowser\\graphics\\jbrowser\\icon.gif";
            JFrame jFrame = new JFrame();
            MiniBrowser miniBrowser = new MiniBrowser(string, stringArray2, jFrame, "JBrowser");
            jFrame.setBackground(Color.white);
            jFrame.getContentPane().add(miniBrowser);
            if (bl3) {
                jFrame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        System.exit(0);
                    }
                });
            }
            jFrame.pack();
            GuiHelper.center(jFrame);
            jFrame.setVisible(true);
        }
        catch (ImageLoaderException imageLoaderException) {
            JOptionPane.showMessageDialog(null, imageLoaderException, "Error", 0);
        }
    }

    private static class BrowserModel
    extends Observable {
        private final Stack _urlStack = new Stack();
        private final String _homepage;
        private int _locationState = 0;
        private boolean _isLoading = false;

        public BrowserModel(String string) {
            this._homepage = string;
            this._urlStack.push(this._homepage);
            ++this._locationState;
        }

        public synchronized void back() {
            if (this._urlStack.size() > 1) {
                ++this._locationState;
                this._urlStack.pop();
                this._notifyChange();
            }
        }

        public synchronized void home() {
            this._urlStack.push(this._homepage);
            ++this._locationState;
            this._notifyChange();
        }

        public synchronized void gotoPage(String string) {
            this._urlStack.push(string);
            ++this._locationState;
            this._notifyChange();
        }

        public synchronized String getCurrentUrl() {
            return (String)this._urlStack.peek();
        }

        public synchronized String getPreviousUrl() {
            return (String)this._urlStack.elementAt(this._urlStack.size() - 2);
        }

        public synchronized int getLocationState() {
            return this._locationState;
        }

        public synchronized boolean canGoBack() {
            return this._urlStack.size() > 1;
        }

        public synchronized void newPageLoading() {
            this._isLoading = true;
            this._notifyChange();
        }

        public synchronized void pageLoadFinished() {
            this._isLoading = false;
            this._notifyChange();
        }

        public synchronized boolean isLoading() {
            return this._isLoading;
        }

        private synchronized void _notifyChange() {
            this.setChanged();
            this.notifyObservers();
        }
    }

    private class NavigationListener
    implements ActionListener {
        private NavigationListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == MiniBrowser.this._address) {
                MiniBrowser.this._model.gotoPage(MiniBrowser.this._address.getText());
            } else if (object == MiniBrowser.this._backButton) {
                MiniBrowser.this._model.back();
            } else if (object == MiniBrowser.this._homeButton) {
                MiniBrowser.this._model.home();
            } else {
                Assertion.assertion(false);
            }
        }
    }

    private class Hyperactive
    implements HyperlinkListener {
        private Hyperactive() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
                if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                    HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                    hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
                } else {
                    MiniBrowser.this._model.gotoPage(hyperlinkEvent.getURL().toString());
                }
            }
        }
    }

    private class PageLoader
    extends Thread
    implements Runnable {
        private final String _url;
        private final BrowserModel _model;
        private final JFrame _frame;

        public PageLoader(String string, BrowserModel browserModel, JFrame jFrame) {
            this._url = string;
            this._model = browserModel;
            this._frame = jFrame;
        }

        public void run() {
            try {
                this._model.newPageLoading();
                MiniBrowser.this._htmlPane.setPage(this._url);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this._frame, iOException, "Error", 0);
                this._model.pageLoadFinished();
            }
        }
    }
}

