/*
 * Decompiled with CFR 0.152.
 */
package stec.pos;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Stack;
import stec.pos.ByteArray;
import stec.pos.Common;
import stec.pos.Index;
import stec.pos.IndexInstance;
import stec.pos.IndexReference;
import stec.pos.IndexStoreInstance;
import stec.pos.ValuesIndexInstance;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class CheckIndex {
    private boolean else;
    private boolean byte;
    private boolean e;
    private boolean char = true;
    private IndexReference int;
    private boolean void;
    private boolean c;
    private boolean if;
    private long g;
    private long for;
    private long new;
    private long goto;
    private long null;
    private long try;
    private long f;
    private long h;
    private long i;
    private long case;
    private long a;
    private long b;
    private long do;
    private long d;
    private boolean long;

    public static final void main(String[] stringArray) throws Throwable {
        Common.logo("Persistent Index Checker");
        if (stringArray.length < 1) {
            System.out.println("Usage: <java> stec.pos.CheckIndex <options> <index>");
            System.out.println();
            System.out.println("Options:");
            System.out.println("-d            do not display progress");
            System.out.println("-l            check links");
            System.out.println("-u            display utilization");
            System.out.println("-v            verbose messages");
            return;
        }
        CheckIndex.check(stringArray);
    }

    public static final boolean check(String[] stringArray) throws Throwable {
        String string;
        int n;
        CheckIndex checkIndex = new CheckIndex();
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).charAt(0) == '-'; ++n) {
            if (string.equalsIgnoreCase("-d")) {
                checkIndex.char = false;
                continue;
            }
            if (string.equalsIgnoreCase("-l")) {
                checkIndex.byte = true;
                continue;
            }
            if (string.equalsIgnoreCase("-u")) {
                checkIndex.e = true;
                continue;
            }
            if (string.equalsIgnoreCase("-v")) {
                checkIndex.else = true;
                continue;
            }
            System.out.println("Invalid parameter: ".concat(String.valueOf(String.valueOf(string))));
            return false;
        }
        if (n >= n2) {
            System.out.println("Index was not specified.");
            return false;
        }
        try {
            if (!checkIndex.a(stringArray[n])) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception exception) {
            throw Common.getRootCause(exception);
        }
        return true;
    }

    public static final boolean check(String[] stringArray, String[] stringArray2) {
        boolean bl = true;
        int n = stringArray2.length;
        String[] stringArray3 = new String[n + 1];
        System.arraycopy(stringArray2, 0, stringArray3, 0, n);
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray[i];
            System.out.print(String.valueOf(String.valueOf(string)).concat(": "));
            stringArray3[n] = string;
            try {
                boolean bl2 = CheckIndex.check(stringArray3);
                if (bl2) {
                    System.out.println("PASSED");
                    continue;
                }
                bl = false;
                System.out.println("FAILED");
                continue;
            }
            catch (Throwable throwable) {
                bl = false;
                System.out.println("FAILED");
                throwable.printStackTrace();
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean a(String string) throws Exception {
        block80: {
            boolean bl;
            block79: {
                boolean bl2;
                block78: {
                    boolean bl3;
                    block77: {
                        boolean bl4;
                        block76: {
                            boolean bl5;
                            block75: {
                                boolean bl6;
                                block74: {
                                    boolean bl7;
                                    block73: {
                                        boolean bl8;
                                        block72: {
                                            boolean bl9;
                                            block71: {
                                                boolean bl10;
                                                block70: {
                                                    boolean bl11;
                                                    block69: {
                                                        boolean bl12;
                                                        block68: {
                                                            boolean bl13;
                                                            block67: {
                                                                boolean bl14;
                                                                block66: {
                                                                    boolean bl15;
                                                                    block65: {
                                                                        boolean bl16;
                                                                        block64: {
                                                                            File file;
                                                                            if (this.else) {
                                                                                System.out.println("Checking index");
                                                                            }
                                                                            String string2 = String.valueOf(String.valueOf(string)).concat(".keys.index");
                                                                            if (this.else) {
                                                                                System.out.println("Index: ".concat(String.valueOf(String.valueOf(string2))));
                                                                            }
                                                                            if (!(file = new File(string2)).exists()) {
                                                                                System.out.println("Index does not exist: ".concat(String.valueOf(String.valueOf(string2))));
                                                                                return false;
                                                                            }
                                                                            if (file.isDirectory()) {
                                                                                System.out.println("Index can not be a directory: ".concat(String.valueOf(String.valueOf(string2))));
                                                                                return false;
                                                                            }
                                                                            this.g = file.length();
                                                                            if (this.else) {
                                                                                System.out.println("Index file length: ".concat(String.valueOf(String.valueOf(this.g))));
                                                                            }
                                                                            if (this.g < (long)42) {
                                                                                System.out.println("Index file length is too small.");
                                                                                System.out.println("Mimimum index file length: 42");
                                                                                System.out.println("Current index file length: ".concat(String.valueOf(String.valueOf(this.g))));
                                                                                return false;
                                                                            }
                                                                            RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "r");
                                                                            try {
                                                                                randomAccessFile.seek(4L);
                                                                                byte by = randomAccessFile.readByte();
                                                                                if (by == 8 || by == 13 || by == 14 || by == 11 || by == 15 || by == 9) {
                                                                                    this.void = true;
                                                                                }
                                                                                randomAccessFile.seek(9L);
                                                                                byte by2 = randomAccessFile.readByte();
                                                                                if (by2 == -1) {
                                                                                    this.if = true;
                                                                                } else if (by2 == 8 || by2 == 13 || by2 == 14 || by2 == 11 || by2 == 15 || by2 == 9) {
                                                                                    this.c = true;
                                                                                }
                                                                                Object var8_7 = null;
                                                                            }
                                                                            catch (Throwable throwable) {
                                                                                Object var8_8 = null;
                                                                                randomAccessFile.close();
                                                                                throw throwable;
                                                                            }
                                                                            randomAccessFile.close();
                                                                            if (this.void) {
                                                                                string2 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(".keys").append(".store")));
                                                                                if (this.else) {
                                                                                    System.out.println("Keys store: ".concat(String.valueOf(String.valueOf(string2))));
                                                                                }
                                                                                if (!(file = new File(string2)).exists()) {
                                                                                    System.out.println("Keys store does not exist: ".concat(String.valueOf(String.valueOf(string2))));
                                                                                    return false;
                                                                                }
                                                                                if (file.isDirectory()) {
                                                                                    System.out.println("Keys store can not be a directory: ".concat(String.valueOf(String.valueOf(string2))));
                                                                                    return false;
                                                                                }
                                                                                this.new = file.length();
                                                                                if (this.else) {
                                                                                    System.out.println("Keys store file length: ".concat(String.valueOf(String.valueOf(this.new))));
                                                                                }
                                                                                if (this.new < (long)27) {
                                                                                    System.out.println("Keys store file length is too small.");
                                                                                    System.out.println("Minimum keys store file length: 27");
                                                                                    System.out.println("Current keys store file length: ".concat(String.valueOf(String.valueOf(this.new))));
                                                                                    return false;
                                                                                }
                                                                            }
                                                                            if (this.if) {
                                                                                string2 = String.valueOf(String.valueOf(string)).concat(".values.index");
                                                                                if (this.else) {
                                                                                    System.out.println("Values index: ".concat(String.valueOf(String.valueOf(string2))));
                                                                                }
                                                                                if (!(file = new File(string2)).exists()) {
                                                                                    System.out.println("Values index does not exist: ".concat(String.valueOf(String.valueOf(string2))));
                                                                                    return false;
                                                                                }
                                                                                if (file.isDirectory()) {
                                                                                    System.out.println("Values index can not be a directory: ".concat(String.valueOf(String.valueOf(string2))));
                                                                                    return false;
                                                                                }
                                                                                this.for = file.length();
                                                                                if (this.else) {
                                                                                    System.out.println("Values index file length: ".concat(String.valueOf(String.valueOf(this.for))));
                                                                                }
                                                                                if (this.for < (long)29) {
                                                                                    System.out.println("Values index file length is too small.");
                                                                                    System.out.println("Minimum values index file length: 29");
                                                                                    System.out.println("Current values index file length: ".concat(String.valueOf(String.valueOf(this.for))));
                                                                                    return false;
                                                                                }
                                                                                RandomAccessFile randomAccessFile2 = new RandomAccessFile(String.valueOf(String.valueOf(string)).concat(".values.index"), "r");
                                                                                try {
                                                                                    randomAccessFile2.seek(4L);
                                                                                    byte by = randomAccessFile2.readByte();
                                                                                    if (by == 8 || by == 13 || by == 14 || by == 11 || by == 15 || by == 9) {
                                                                                        this.c = true;
                                                                                    }
                                                                                    Object var12_28 = null;
                                                                                }
                                                                                catch (Throwable throwable) {
                                                                                    Object var12_29 = null;
                                                                                    randomAccessFile2.close();
                                                                                    throw throwable;
                                                                                }
                                                                                randomAccessFile2.close();
                                                                            }
                                                                            if (this.c) {
                                                                                string2 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(".values").append(".store")));
                                                                                if (this.else) {
                                                                                    System.out.println("Values store: ".concat(String.valueOf(String.valueOf(string2))));
                                                                                }
                                                                                if (!(file = new File(string2)).exists()) {
                                                                                    System.out.println("Values store does not exist: ".concat(String.valueOf(String.valueOf(string2))));
                                                                                    return false;
                                                                                }
                                                                                if (file.isDirectory()) {
                                                                                    System.out.println("Values store can not be a directory: ".concat(String.valueOf(String.valueOf(string2))));
                                                                                    return false;
                                                                                }
                                                                                this.goto = file.length();
                                                                                if (this.else) {
                                                                                    System.out.println("Values store file length: ".concat(String.valueOf(String.valueOf(this.goto))));
                                                                                }
                                                                                if (this.goto < (long)27) {
                                                                                    System.out.println("Values store file length is too small.");
                                                                                    System.out.println("Minimum values store file length: 27");
                                                                                    System.out.println("Current values store file length: ".concat(String.valueOf(String.valueOf(this.goto))));
                                                                                    return false;
                                                                                }
                                                                            }
                                                                            if (this.else) {
                                                                                System.out.println();
                                                                            }
                                                                            this.int = Index.if(string);
                                                                            if (this.int == null) {
                                                                                System.out.println("Index is in use: ".concat(String.valueOf(String.valueOf(string))));
                                                                                return false;
                                                                            }
                                                                            try {
                                                                                if (!this.null()) {
                                                                                    bl16 = false;
                                                                                    Object var14_31 = null;
                                                                                    break block64;
                                                                                }
                                                                                if (this.void && !this.a(this.int.i.v, "key", this.new)) {
                                                                                    bl15 = false;
                                                                                    break block65;
                                                                                }
                                                                                if (this.if && !this.char()) {
                                                                                    bl14 = false;
                                                                                    break block66;
                                                                                }
                                                                                if (this.c) {
                                                                                    if (this.if) {
                                                                                        if (!this.a(this.int.i.M.new, "value", this.goto)) {
                                                                                            bl13 = false;
                                                                                            break block67;
                                                                                        }
                                                                                    } else if (!this.a(this.int.i.goto, "value", this.goto)) {
                                                                                        bl12 = false;
                                                                                        break block68;
                                                                                    }
                                                                                }
                                                                                if (!this.void()) {
                                                                                    bl11 = false;
                                                                                    break block69;
                                                                                }
                                                                                if (this.void && !this.a(this.int.i.v, "key")) {
                                                                                    bl10 = false;
                                                                                    break block70;
                                                                                }
                                                                                if (this.if && !this.else()) {
                                                                                    bl9 = false;
                                                                                    break block71;
                                                                                }
                                                                                if (this.c) {
                                                                                    if (this.if) {
                                                                                        if (!this.a(this.int.i.M.new, "value")) {
                                                                                            bl8 = false;
                                                                                            break block72;
                                                                                        }
                                                                                    } else if (!this.a(this.int.i.goto, "value")) {
                                                                                        bl7 = false;
                                                                                        break block73;
                                                                                    }
                                                                                }
                                                                                if (this.byte) {
                                                                                    if (!this.do()) {
                                                                                        bl6 = false;
                                                                                        break block74;
                                                                                    }
                                                                                    if (this.void && !this.for()) {
                                                                                        bl5 = false;
                                                                                        break block75;
                                                                                    }
                                                                                    if (this.if && !this.int()) {
                                                                                        bl4 = false;
                                                                                        break block76;
                                                                                    }
                                                                                    if (this.c) {
                                                                                        if (this.if) {
                                                                                            if (!this.case()) {
                                                                                                bl3 = false;
                                                                                                break block77;
                                                                                            }
                                                                                        } else if (!this.new()) {
                                                                                            bl2 = false;
                                                                                            break block78;
                                                                                        }
                                                                                    }
                                                                                }
                                                                                if (!this.long()) {
                                                                                    bl = false;
                                                                                    break block79;
                                                                                }
                                                                                this.goto();
                                                                                if (this.e) {
                                                                                    this.a();
                                                                                }
                                                                                break block80;
                                                                            }
                                                                            catch (Throwable throwable) {
                                                                                Object var14_48 = null;
                                                                                this.int.close();
                                                                                throw throwable;
                                                                            }
                                                                        }
                                                                        this.int.close();
                                                                        return bl16;
                                                                    }
                                                                    Object var14_32 = null;
                                                                    this.int.close();
                                                                    return bl15;
                                                                }
                                                                Object var14_33 = null;
                                                                this.int.close();
                                                                return bl14;
                                                            }
                                                            Object var14_34 = null;
                                                            this.int.close();
                                                            return bl13;
                                                        }
                                                        Object var14_35 = null;
                                                        this.int.close();
                                                        return bl12;
                                                    }
                                                    Object var14_36 = null;
                                                    this.int.close();
                                                    return bl11;
                                                }
                                                Object var14_37 = null;
                                                this.int.close();
                                                return bl10;
                                            }
                                            Object var14_38 = null;
                                            this.int.close();
                                            return bl9;
                                        }
                                        Object var14_39 = null;
                                        this.int.close();
                                        return bl8;
                                    }
                                    Object var14_40 = null;
                                    this.int.close();
                                    return bl7;
                                }
                                Object var14_41 = null;
                                this.int.close();
                                return bl6;
                            }
                            Object var14_42 = null;
                            this.int.close();
                            return bl5;
                        }
                        Object var14_43 = null;
                        this.int.close();
                        return bl4;
                    }
                    Object var14_44 = null;
                    this.int.close();
                    return bl3;
                }
                Object var14_45 = null;
                this.int.close();
                return bl2;
            }
            Object var14_46 = null;
            this.int.close();
            return bl;
        }
        Object var14_47 = null;
        this.int.close();
        return true;
    }

    private final boolean null() throws Exception {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.else) {
            System.out.println("Checking index header");
        }
        if (this.else) {
            System.out.println("Index type: ".concat(String.valueOf(String.valueOf(this.int.i.Z))));
        }
        if (this.int.i.Z != 8) {
            System.out.println("Index type mismatch.");
            System.out.println("Required index type: 8");
            System.out.println("Current index type: ".concat(String.valueOf(String.valueOf(this.int.i.Z))));
            return false;
        }
        if (this.else) {
            System.out.println("Index version: ".concat(String.valueOf(String.valueOf(this.int.i.Q))));
        }
        if (this.int.i.Q != 256) {
            System.out.println("Index version mismatch.");
            System.out.println("Required index version: 256");
            System.out.println("Current index version: ".concat(String.valueOf(String.valueOf(this.int.i.Q))));
            return false;
        }
        if (this.else) {
            System.out.println("Index flags: ".concat(String.valueOf(String.valueOf(this.int.i.P))));
        }
        if (this.else) {
            System.out.println("Index key class name: ".concat(String.valueOf(String.valueOf(this.int.i.u))));
        }
        if (this.int.i.u == null) {
            System.out.println("Index key class name cannot be null.");
            return false;
        }
        if (this.int.i.u.length() == 0) {
            System.out.println("Index key class name cannot be empty.");
            return false;
        }
        if (this.int.i.u.equals("java.lang.Byte")) {
            n4 = 1;
            n3 = 1;
        } else if (this.int.i.u.equals("java.lang.Character")) {
            n4 = 2;
            n3 = 2;
        } else if (this.int.i.u.equals("java.lang.Short")) {
            n4 = 3;
            n3 = 2;
        } else if (this.int.i.u.equals("java.lang.Integer")) {
            n4 = 4;
            n3 = 4;
        } else if (this.int.i.u.equals("java.lang.Long")) {
            n4 = 5;
            n3 = 8;
        } else if (this.int.i.u.equals("java.lang.Float")) {
            n4 = 6;
            n3 = 4;
        } else if (this.int.i.u.equals("java.lang.Double")) {
            n4 = 7;
            n3 = 8;
        } else if (this.int.i.u.equals("java.util.Date")) {
            n4 = 12;
            n3 = 8;
        } else if (this.int.i.u.equals("java.math.BigInteger")) {
            n4 = 13;
            n3 = 8;
        } else if (this.int.i.u.equals("java.math.BigDecimal")) {
            n4 = 14;
            n3 = 8;
        } else if (this.int.i.u.equals("java.lang.String")) {
            n4 = 8;
            n3 = 8;
        } else if (this.int.i.u.equals("stec.pos.Blob")) {
            n4 = 11;
            n3 = 8;
        } else if (this.int.i.u.equals("[B")) {
            n4 = 15;
            n3 = 8;
        } else {
            if (!Thread.currentThread().getContextClassLoader().loadClass("java.io.Serializable").isAssignableFrom(Thread.currentThread().getContextClassLoader().loadClass(this.int.i.u))) {
                System.out.println("Index key class must implement java.io.Serializable: ".concat(String.valueOf(String.valueOf(this.int.i.u))));
                return false;
            }
            n4 = 9;
            n3 = 8;
        }
        if (this.else) {
            System.out.println("Index key entry type: ".concat(String.valueOf(String.valueOf(this.int.i.if))));
        }
        if (this.else) {
            System.out.println("Index key entry length: ".concat(String.valueOf(String.valueOf(this.int.i.g))));
        }
        if (this.int.i.if != n4) {
            System.out.println("Index key entry type does not match key class.");
            System.out.println("Estimated key entry type: ".concat(String.valueOf(String.valueOf(n4))));
            System.out.println("Current key entry type: ".concat(String.valueOf(String.valueOf(this.int.i.if))));
            return false;
        }
        if (this.int.i.g != n3) {
            System.out.println("Index key entry length does not match key class.");
            System.out.println("Estimated key entry length: ".concat(String.valueOf(String.valueOf(n3))));
            System.out.println("Current key entry length: ".concat(String.valueOf(String.valueOf(this.int.i.g))));
            return false;
        }
        if (this.else) {
            System.out.println("Index value class name: ".concat(String.valueOf(String.valueOf(this.int.i.q))));
        }
        if (this.int.i.q == null) {
            System.out.println("Index value class name cannot be null.");
            return false;
        }
        if (this.int.i.q.length() == 0) {
            System.out.println("Index value class name cannot be empty.");
            return false;
        }
        if (this.int.i.S) {
            n2 = -1;
            n = 8;
        } else if (this.int.i.q.equals("java.lang.Byte")) {
            n2 = 1;
            n = 1;
        } else if (this.int.i.q.equals("java.lang.Boolean")) {
            n2 = 10;
            n = 1;
        } else if (this.int.i.q.equals("java.lang.Character")) {
            n2 = 2;
            n = 2;
        } else if (this.int.i.q.equals("java.lang.Short")) {
            n2 = 3;
            n = 2;
        } else if (this.int.i.q.equals("java.lang.Integer")) {
            n2 = 4;
            n = 4;
        } else if (this.int.i.q.equals("java.lang.Long")) {
            n2 = 5;
            n = 8;
        } else if (this.int.i.q.equals("java.lang.Float")) {
            n2 = 6;
            n = 4;
        } else if (this.int.i.q.equals("java.lang.Double")) {
            n2 = 7;
            n = 8;
        } else if (this.int.i.q.equals("java.util.Date")) {
            n2 = 12;
            n = 8;
        } else if (this.int.i.q.equals("java.math.BigInteger")) {
            n2 = 13;
            n = 8;
        } else if (this.int.i.q.equals("java.math.BigDecimal")) {
            n2 = 14;
            n = 8;
        } else if (this.int.i.q.equals("java.lang.String")) {
            n2 = 8;
            n = 8;
        } else if (this.int.i.q.equals("stec.pos.Blob")) {
            n2 = 11;
            n = 8;
        } else if (this.int.i.q.equals("[B")) {
            n2 = 15;
            n = 8;
        } else {
            if (!Thread.currentThread().getContextClassLoader().loadClass("java.io.Serializable").isAssignableFrom(Thread.currentThread().getContextClassLoader().loadClass(this.int.i.q))) {
                System.out.println("Index value class must implement java.io.Serializable: ".concat(String.valueOf(String.valueOf(this.int.i.q))));
                return false;
            }
            n2 = 9;
            n = 8;
        }
        if (this.else) {
            System.out.println("Index value entry type: ".concat(String.valueOf(String.valueOf(this.int.i.y))));
        }
        if (this.int.i.y != n2) {
            System.out.println("Index value entry type does not match value class.");
            System.out.println("Estimated value entry type: ".concat(String.valueOf(String.valueOf(n2))));
            System.out.println("Current value entry type: ".concat(String.valueOf(String.valueOf(this.int.i.y))));
            return false;
        }
        if (this.else) {
            System.out.println("Index value entry length: ".concat(String.valueOf(String.valueOf(this.int.i.D))));
        }
        if (this.int.i.D != n) {
            System.out.println("Index value entry length does not match value class.");
            System.out.println("Estimated value entry length: ".concat(String.valueOf(String.valueOf(n))));
            System.out.println("Current value entry length: ".concat(String.valueOf(String.valueOf(this.int.i.D))));
            return false;
        }
        if (this.else) {
            System.out.println("Index order: ".concat(String.valueOf(String.valueOf(this.int.i.x))));
        }
        if (this.int.i.x < 2) {
            System.out.println("Index order must be at least two (2): ".concat(String.valueOf(String.valueOf(this.int.i.x))));
            return false;
        }
        if (this.else) {
            System.out.println("Index maximum page count: ".concat(String.valueOf(String.valueOf(this.int.i.long))));
        }
        if (this.else) {
            System.out.println("Index page count: ".concat(String.valueOf(String.valueOf(this.int.i.B))));
        }
        if (this.int.i.B < 0) {
            System.out.println("Index page count must be at least zero (0): ".concat(String.valueOf(String.valueOf(this.int.i.B))));
            return false;
        }
        if (this.int.i.long != -1 && this.int.i.B > this.int.i.long) {
            System.out.println("Index page count exceeds maximum page count.");
            System.out.println("Index maximum page count: ".concat(String.valueOf(String.valueOf(this.int.i.long))));
            System.out.println("Index page count: ".concat(String.valueOf(String.valueOf(this.int.i.B))));
            return false;
        }
        if (this.else) {
            System.out.println("Index root page number: ".concat(String.valueOf(String.valueOf(this.int.i.T))));
        }
        if (this.int.i.T < 0 && this.int.i.T != -1) {
            System.out.println("Index root page number is not valid: ".concat(String.valueOf(String.valueOf(this.int.i.T))));
            return false;
        }
        if (this.int.i.T != -1 && this.int.i.long != -1 && this.int.i.T > this.int.i.long) {
            System.out.println("Index root page number exceeds maximum page count.");
            System.out.println("Index maximum page count: ".concat(String.valueOf(String.valueOf(this.int.i.long))));
            System.out.println("Index root page number: ".concat(String.valueOf(String.valueOf(this.int.i.T))));
            return false;
        }
        int n5 = this.int.i.char;
        if (this.else) {
            System.out.println("Index free list page number: ".concat(String.valueOf(String.valueOf(n5))));
        }
        if (n5 < -1) {
            System.out.println("Index free list page number is not valid: ".concat(String.valueOf(String.valueOf(n5))));
            return false;
        }
        if (n5 >= this.int.i.B) {
            System.out.println("Index free list page number exceeds page count.");
            System.out.println("Index page count: ".concat(String.valueOf(String.valueOf(this.int.i.B))));
            System.out.println("Index free list page number: ".concat(String.valueOf(String.valueOf(n5))));
            return false;
        }
        if (this.else) {
            System.out.println("Index free count: ".concat(String.valueOf(String.valueOf(this.int.i.C))));
        }
        if (this.else) {
            System.out.println("Index total entry count: ".concat(String.valueOf(String.valueOf(this.int.i.int))));
        }
        if (this.int.i.int < 0) {
            System.out.println("Index total entry count must be at least zero (0): ".concat(String.valueOf(String.valueOf(this.int.i.int))));
            return false;
        }
        long l = this.int.i.long == -1 ? (long)this.int.i.Y + (long)this.int.i.B * (long)this.int.i.n : (long)this.int.i.Y + (long)this.int.i.long * (long)this.int.i.n;
        if (Common.old_jvm) {
            if (this.g < l) {
                System.out.println("Index file length is too small.");
                System.out.println("Current index file length: ".concat(String.valueOf(String.valueOf(this.g))));
                System.out.println("Estimated index file length: ".concat(String.valueOf(String.valueOf(l))));
                return false;
            }
        } else if (this.g != l) {
            System.out.println("Index file length is not correct.");
            System.out.println("Current index file length: ".concat(String.valueOf(String.valueOf(this.g))));
            System.out.println("Estimates index file length: ".concat(String.valueOf(String.valueOf(l))));
            return false;
        }
        if (this.else) {
            System.out.println();
        }
        return true;
    }

    private final boolean a(IndexStoreInstance indexStoreInstance, String string, long l) throws Exception {
        if (this.else) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Checking ").append(string).append(" store header"))));
        }
        if (this.else) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" store type: ").append(indexStoreInstance.if))));
        }
        if (indexStoreInstance.if != 9) {
            System.out.println(String.valueOf(String.valueOf(string)).concat(" store type mismatch."));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Required ").append(string).append(" store type: ").append(9))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Current ").append(string).append(" store type: ").append(indexStoreInstance.if))));
            return false;
        }
        if (this.else) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" store version: ").append(indexStoreInstance.do))));
        }
        if (indexStoreInstance.do != 256) {
            System.out.println(String.valueOf(String.valueOf(string)).concat("store version mismatch."));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Required ").append(string).append(" store version: ").append(256))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Current ").append(string).append(" store version: ").append(indexStoreInstance.do))));
            return false;
        }
        if (this.else) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" store page length: ").append(indexStoreInstance.a))));
        }
        if (indexStoreInstance.a < 1) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" store page length must be at least one (1): ").append(indexStoreInstance.a))));
            return false;
        }
        if (this.else) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" store maximum page count: ").append(this.int.i.long))));
        }
        if (this.else) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" store page count: ").append(this.int.i.B))));
        }
        if (indexStoreInstance.e < 0) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" store page count must be at least zero (0): ").append(indexStoreInstance.e))));
            return false;
        }
        if (indexStoreInstance.j != -1 && indexStoreInstance.e > indexStoreInstance.j) {
            System.out.println(String.valueOf(String.valueOf(string)).concat(" store page count exceeds maximum page count."));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" store maximum page count: ").append(indexStoreInstance.j))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" store page count: ").append(indexStoreInstance.e))));
            return false;
        }
        int n = indexStoreInstance.case;
        if (this.else) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" free list page number: ").append(n))));
        }
        if (n < -1) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" free list is not valid: ").append(n))));
            return false;
        }
        if (n >= indexStoreInstance.e) {
            System.out.println(String.valueOf(String.valueOf(string)).concat(" free list page number exceeds page count."));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" file list page count: ").append(indexStoreInstance.e))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append("file list page number: ").append(n))));
            return false;
        }
        if (this.else) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" free count: ").append(indexStoreInstance.h))));
        }
        if (this.else) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" record count: ").append(indexStoreInstance.c))));
        }
        if (indexStoreInstance.c < 0) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" record count must be at least zero (0): ").append(indexStoreInstance.c))));
            return false;
        }
        if (indexStoreInstance.c > indexStoreInstance.e) {
            System.out.println(String.valueOf(String.valueOf(string)).concat(" record count exceeds page count."));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" page count: ").append(indexStoreInstance.e))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" record count: ").append(indexStoreInstance.c))));
            return false;
        }
        long l2 = indexStoreInstance.j == -1 ? 27L + (5L + (long)indexStoreInstance.a) * (long)indexStoreInstance.e : 27L + (5L + (long)indexStoreInstance.a) * (long)indexStoreInstance.j;
        if (Common.old_jvm) {
            if (l < l2) {
                System.out.println(String.valueOf(String.valueOf(string)).concat(" store file length is too small."));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Current ").append(string).append(" store file length: ").append(l))));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Estimated ").append(string).append(" store file length: ").append(l2))));
                return false;
            }
        } else if (l != l2) {
            System.out.println(String.valueOf(String.valueOf(string)).concat(" store file length is not correct."));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Current ").append(string).append(" store file length: ").append(l))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Estimated ").append(string).append(" store file length: ").append(l2))));
            return false;
        }
        if (this.else) {
            System.out.println();
        }
        return true;
    }

    private final boolean char() throws Exception {
        int n;
        int n2;
        if (this.else) {
            System.out.println("Checking values index header");
        }
        ValuesIndexInstance valuesIndexInstance = this.int.i.M;
        if (this.else) {
            System.out.println("Values index type: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.J))));
        }
        if (valuesIndexInstance.J != 10) {
            System.out.println("Values index type mismatch.");
            System.out.println("Required values index type: 10");
            System.out.println("Current values index type: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.J))));
            return false;
        }
        if (this.else) {
            System.out.println("Values index version: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.B))));
        }
        if (valuesIndexInstance.B != 256) {
            System.out.println("Values index version mismatch.");
            System.out.println("Required values index version: 256");
            System.out.println("Current values index version: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.B))));
            return false;
        }
        if (this.else) {
            System.out.println("Values index flags: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.A))));
        }
        if (valuesIndexInstance.h.equals("java.lang.Byte")) {
            n2 = 1;
            n = 1;
        } else if (valuesIndexInstance.h.equals("java.lang.Boolean")) {
            n2 = 10;
            n = 1;
        } else if (valuesIndexInstance.h.equals("java.lang.Character")) {
            n2 = 2;
            n = 2;
        } else if (valuesIndexInstance.h.equals("java.lang.Short")) {
            n2 = 3;
            n = 2;
        } else if (valuesIndexInstance.h.equals("java.lang.Integer")) {
            n2 = 4;
            n = 4;
        } else if (valuesIndexInstance.h.equals("java.lang.Long")) {
            n2 = 5;
            n = 8;
        } else if (valuesIndexInstance.h.equals("java.lang.Float")) {
            n2 = 6;
            n = 4;
        } else if (valuesIndexInstance.h.equals("java.lang.Double")) {
            n2 = 7;
            n = 8;
        } else if (valuesIndexInstance.h.equals("java.util.Date")) {
            n2 = 12;
            n = 8;
        } else if (valuesIndexInstance.h.equals("java.math.BigInteger")) {
            n2 = 13;
            n = 8;
        } else if (valuesIndexInstance.h.equals("java.math.BigDecimal")) {
            n2 = 14;
            n = 8;
        } else if (valuesIndexInstance.h.equals("java.lang.String")) {
            n2 = 8;
            n = 8;
        } else if (valuesIndexInstance.h.equals("stec.pos.Blob")) {
            n2 = 11;
            n = 8;
        } else if (valuesIndexInstance.h.equals("[B")) {
            n2 = 15;
            n = 8;
        } else {
            if (!Thread.currentThread().getContextClassLoader().loadClass("java.io.Serializable").isAssignableFrom(Thread.currentThread().getContextClassLoader().loadClass(valuesIndexInstance.h))) {
                System.out.println("Values index value class must implement java.io.Serializable: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.h))));
                return false;
            }
            n2 = 9;
            n = 8;
        }
        if (this.else) {
            System.out.println("Values index value entry type: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.m))));
        }
        if (valuesIndexInstance.m != n2) {
            System.out.println("Values index value entry type does not match value class.");
            System.out.println("Estimated values index entry type: ".concat(String.valueOf(String.valueOf(n2))));
            System.out.println("Current values index entry type: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.m))));
            return false;
        }
        if (this.else) {
            System.out.println("Values index value entry length: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.r))));
        }
        if (valuesIndexInstance.r != n) {
            System.out.println("Values index value entry length does not match value class.");
            System.out.println("Estimated values index entry length: ".concat(String.valueOf(String.valueOf(n))));
            System.out.println("Current values index entry length: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.r))));
            return false;
        }
        if (this.else) {
            System.out.println("Values index order: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.l))));
        }
        if (valuesIndexInstance.l < 2) {
            System.out.println("Values index order must be at least two (2): ".concat(String.valueOf(String.valueOf(valuesIndexInstance.l))));
            return false;
        }
        if (this.else) {
            System.out.println("Values index maximum page count: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.byte))));
        }
        if (this.else) {
            System.out.println("Values index page count: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.o))));
        }
        if (valuesIndexInstance.o < 0) {
            System.out.println("Values index page count must be at least zero (0): ".concat(String.valueOf(String.valueOf(valuesIndexInstance.o))));
            return false;
        }
        if (valuesIndexInstance.byte != -1 && valuesIndexInstance.o > valuesIndexInstance.byte) {
            System.out.println("Values index page count exceeds maximum page count.");
            System.out.println("Values index maximum page count: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.byte))));
            System.out.println("Values index page count: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.o))));
            return false;
        }
        int n3 = valuesIndexInstance.try;
        if (this.else) {
            System.out.println("Values index free list page number: ".concat(String.valueOf(String.valueOf(n3))));
        }
        if (n3 < -1) {
            System.out.println("Values index free list page number is not valid: ".concat(String.valueOf(String.valueOf(n3))));
            return false;
        }
        if (n3 >= valuesIndexInstance.o) {
            System.out.println("Values index free list page number exceeds page count.");
            System.out.println("Values index page count: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.o))));
            System.out.println("Values index free list page number: ".concat(String.valueOf(String.valueOf(n3))));
            return false;
        }
        if (this.else) {
            System.out.println("Values index free count: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.p))));
        }
        long l = valuesIndexInstance.byte == -1 ? (long)valuesIndexInstance.I + (long)valuesIndexInstance.o * (long)valuesIndexInstance.e : (long)valuesIndexInstance.I + (long)valuesIndexInstance.byte * (long)valuesIndexInstance.e;
        if (Common.old_jvm) {
            if (this.for < l) {
                System.out.println("Values index file length is too small.");
                System.out.println("Current values index file length: ".concat(String.valueOf(String.valueOf(this.for))));
                System.out.println("Estimated values index file length: ".concat(String.valueOf(String.valueOf(l))));
                return false;
            }
        } else if (this.for != l) {
            System.out.println("Values index file length is not correct.");
            System.out.println("Current values index file length: ".concat(String.valueOf(String.valueOf(this.for))));
            System.out.println("Estimates values index file length: ".concat(String.valueOf(String.valueOf(l))));
            return false;
        }
        if (this.else) {
            System.out.println();
        }
        return true;
    }

    private final boolean void() throws IOException {
        if (this.else) {
            System.out.println("Checking index free list");
        }
        int n = this.int.i.char;
        int n2 = 0;
        int n3 = this.int.i.C;
        int n4 = this.int.i.B;
        this.int.i.J = this.int.i.H;
        while (n != -1) {
            ++n2;
            if (this.else && this.char) {
                Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n2))).append(" - ").append(n3).append(": ").append((int)((double)n2 / (double)n3 * 100.0)).append("%"))));
                this.long = true;
            }
            if (n < 0) {
                if (this.long) {
                    System.out.println();
                    this.long = false;
                }
                System.out.println("Index page number is not valid: ".concat(String.valueOf(String.valueOf(n))));
                return false;
            }
            if (n >= n4) {
                if (this.long) {
                    System.out.println();
                    this.long = false;
                }
                System.out.println("Index page exceeds page count.");
                System.out.println("Index page count: ".concat(String.valueOf(String.valueOf(n4))));
                System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(n))));
                return false;
            }
            this.int.i.if(n);
            byte by = ByteArray.getByte(this.int.i.J, 0);
            if (by != 0) {
                if (this.long) {
                    System.out.println();
                    this.long = false;
                }
                System.out.println("Index page is not available.");
                System.out.println("Index page flags: ".concat(String.valueOf(String.valueOf(by))));
                System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(n))));
                return false;
            }
            n = ByteArray.getInt(this.int.i.J, 1);
        }
        if (this.long) {
            System.out.println();
            this.long = false;
        }
        if (n2 != this.int.i.C) {
            System.out.println("Index free list page count is not correct.");
            System.out.println("Current index free list page count: ".concat(String.valueOf(String.valueOf(this.int.i.C))));
            System.out.println("Estimated index free list page count: ".concat(String.valueOf(String.valueOf(n2))));
            return false;
        }
        return true;
    }

    private final boolean a(IndexStoreInstance indexStoreInstance, String string) throws Exception {
        if (this.else) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Checking ").append(string).append(" free list"))));
        }
        int n = indexStoreInstance.case;
        int n2 = 0;
        int n3 = indexStoreInstance.h;
        int n4 = indexStoreInstance.e;
        while (n != -1) {
            ++n2;
            if (this.else && this.char) {
                Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n2))).append(" - ").append(n3).append(": ").append((int)((double)n2 / (double)n3 * 100.0)).append("%"))));
                this.long = true;
            }
            if (n < 0) {
                if (this.long) {
                    System.out.println();
                    this.long = false;
                }
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" page number is not valid: ").append(n))));
                return false;
            }
            if (n >= n4) {
                if (this.long) {
                    System.out.println();
                    this.long = false;
                }
                System.out.println(String.valueOf(String.valueOf(string)).concat(" page exceeds page count."));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" page count: ").append(n4))));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" page number: ").append(n))));
                return false;
            }
            indexStoreInstance.try(n);
            byte by = ByteArray.getByte(indexStoreInstance.new, 0);
            if (by != 0) {
                if (this.long) {
                    System.out.println();
                    this.long = false;
                }
                System.out.println(String.valueOf(String.valueOf(string)).concat(" page is not available."));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" page flags: ").append(by))));
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" page number: ").append(n))));
                return false;
            }
            n = ByteArray.getInt(indexStoreInstance.new, 1);
        }
        if (this.long) {
            System.out.println();
            this.long = false;
        }
        if (n2 != indexStoreInstance.h) {
            System.out.println(String.valueOf(String.valueOf(string)).concat(" free list page count is not correct."));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Current ").append(string).append(" free list page count: ").append(indexStoreInstance.h))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Estimates ").append(string).append(" free list page count: ").append(n2))));
            return false;
        }
        return true;
    }

    private final boolean else() throws Exception {
        if (this.else) {
            System.out.println("Checking values index free list");
        }
        ValuesIndexInstance valuesIndexInstance = this.int.i.M;
        int n = valuesIndexInstance.try;
        int n2 = 0;
        int n3 = valuesIndexInstance.p;
        int n4 = valuesIndexInstance.o;
        valuesIndexInstance.v = valuesIndexInstance.u;
        while (n != -1) {
            ++n2;
            if (this.else && this.char) {
                Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n2))).append(" - ").append(n3).append(": ").append((int)((double)n2 / (double)n3 * 100.0)).append("%"))));
                this.long = true;
            }
            if (n < 0) {
                if (this.long) {
                    System.out.println();
                    this.long = false;
                }
                System.out.println("Values index page number is not valid: ".concat(String.valueOf(String.valueOf(n))));
                return false;
            }
            if (n >= n4) {
                if (this.long) {
                    System.out.println();
                    this.long = false;
                }
                System.out.println("Values index page exceeds page count.");
                System.out.println("Values index page count: ".concat(String.valueOf(String.valueOf(n4))));
                System.out.println("Values index page number: ".concat(String.valueOf(String.valueOf(n))));
                return false;
            }
            valuesIndexInstance.if(n);
            byte by = ByteArray.getByte(valuesIndexInstance.v, 0);
            if (by != 0) {
                if (this.long) {
                    System.out.println();
                    this.long = false;
                }
                System.out.println("Values index page is not available.");
                System.out.println("Values index page flags: ".concat(String.valueOf(String.valueOf(by))));
                System.out.println("Values index page number: ".concat(String.valueOf(String.valueOf(n))));
                return false;
            }
            n = ByteArray.getInt(valuesIndexInstance.v, 1);
        }
        if (this.long) {
            System.out.println();
            this.long = false;
        }
        if (n2 != valuesIndexInstance.p) {
            System.out.println("Values index free list page count is not correct.");
            System.out.println("Current values index free list page count: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.p))));
            System.out.println("Estimated values index free list page count: ".concat(String.valueOf(String.valueOf(n2))));
            return false;
        }
        return true;
    }

    private final boolean long() throws IOException {
        if (this.else) {
            System.out.println("Checking index entries");
        }
        Object object = null;
        Object object2 = null;
        int n = 0;
        int n2 = this.int.size();
        boolean bl = true;
        this.int.first();
        while (this.int.next()) {
            Object object3 = this.int.getCurrentKey();
            ++n;
            if (this.else && this.char) {
                Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n))).append(" - ").append(n2).append(": ").append((int)((double)n / (double)n2 * 100.0)).append("%"))));
                this.long = true;
            }
            Object object4 = this.int.getCurrentValue();
            if (bl) {
                bl = false;
            } else {
                int n3 = this.int.i.do(object3, object);
                if (n3 == 0) {
                    if (!this.int.duplicates()) {
                        if (this.long) {
                            System.out.println();
                            this.long = false;
                        }
                        System.out.println("Duplicates are not supported.");
                        System.out.println("Current key: ".concat(String.valueOf(String.valueOf(object3))));
                        System.out.println("Last key: ".concat(String.valueOf(String.valueOf(object))));
                        return false;
                    }
                } else if (n3 < 0) {
                    if (this.long) {
                        System.out.println();
                        this.long = false;
                    }
                    if (this.int.ascending()) {
                        System.out.println("Current key must be greater than last key.");
                    } else {
                        System.out.println("Current key must be less than last key.");
                    }
                    System.out.println("Current key: ".concat(String.valueOf(String.valueOf(object3))));
                    System.out.println("Last key: ".concat(String.valueOf(String.valueOf(object))));
                    return false;
                }
            }
            object = object3;
            object2 = object4;
        }
        if (this.long) {
            System.out.println();
            this.long = false;
        }
        if (n != this.int.i.int) {
            System.out.println("Index entry count does not equal total entry count.");
            System.out.println("Current index total entry count: ".concat(String.valueOf(String.valueOf(this.int.i.int))));
            System.out.println("Estimates total entry count: ".concat(String.valueOf(String.valueOf(n))));
            return false;
        }
        return true;
    }

    private final boolean do() throws IOException {
        block71: {
            byte by;
            if (this.else) {
                System.out.println("Checking index links");
            }
            this.int.i.J = this.int.i.H;
            if (this.int.i.T != -1) {
                this.int.i.if(this.int.i.T);
                by = ByteArray.getByte(this.int.i.J, 0);
                if (by != 1) {
                    System.out.println("Index root page is not correct: ".concat(String.valueOf(String.valueOf(this.int.i.T))));
                    return false;
                }
            }
            int n = this.int.i.B;
            for (int i = 0; i < n; ++i) {
                byte by2;
                int n2;
                int n3;
                if (this.else && this.char) {
                    Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(i + 1))).append(" - ").append(n).append(": ").append((int)(((double)i + 1.0) / (double)n * 100.0)).append("%"))));
                    this.long = true;
                }
                this.int.i.if(i);
                by = ByteArray.getByte(this.int.i.J, 0);
                int n4 = ByteArray.getInt(this.int.i.J, 1);
                if (n4 < -1) {
                    if (this.long) {
                        System.out.println();
                        this.long = false;
                    }
                    System.out.println("Index next page number is not correct.");
                    System.out.println("Index next page number: ".concat(String.valueOf(String.valueOf(n4))));
                    System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (n4 >= n) {
                    if (this.long) {
                        System.out.println();
                        this.long = false;
                    }
                    System.out.println("Index next page number exceeds index page count.");
                    System.out.println("Index next page number: ".concat(String.valueOf(String.valueOf(n4))));
                    System.out.println("Index page count: ".concat(String.valueOf(String.valueOf(n))));
                    System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (n4 == i) {
                    if (this.long) {
                        System.out.println();
                        this.long = false;
                    }
                    System.out.println("Index next page number cannot be the same as the current page number.");
                    System.out.println("Index next page number: ".concat(String.valueOf(String.valueOf(n4))));
                    System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (by == 0) {
                    n3 = 0;
                    n2 = this.int.i.char;
                    this.int.i.J = this.int.i.F;
                    while (n2 != -1) {
                        if (n2 == i) {
                            ++n3;
                        }
                        this.int.i.if(n2);
                        n2 = ByteArray.getInt(this.int.i.J, 1);
                    }
                    this.int.i.J = this.int.i.H;
                    if (n3 == 0) {
                        if (this.long) {
                            System.out.println();
                            this.long = false;
                        }
                        System.out.println("Index page marked as available was not found on free list: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (n3 > 1) {
                        if (this.long) {
                            System.out.println();
                            this.long = false;
                        }
                        System.out.println("Index page marked as available was found multiple times on free list.");
                        System.out.println("Index page reference count: ".concat(String.valueOf(String.valueOf(n3))));
                        System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                } else if (by == 1) {
                    int n5;
                    int n6 = ByteArray.getInt(this.int.i.J, 5);
                    if (n6 > this.int.i.x * 2) {
                        if (this.long) {
                            System.out.println();
                            this.long = false;
                        }
                        System.out.println("Index entry count cannot exceed index order * 2 is not correct.");
                        System.out.println("Estimated index entry count: ".concat(String.valueOf(String.valueOf(this.int.i.x * 2))));
                        System.out.println("Current index entry count: ".concat(String.valueOf(String.valueOf(n6))));
                        System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (n4 != -1) {
                        this.int.i.J = this.int.i.F;
                        this.int.i.if(n4);
                        by2 = ByteArray.getByte(this.int.i.J, 0);
                        if (by2 != by) {
                            if (this.long) {
                                System.out.println();
                                this.long = false;
                            }
                            System.out.println("Index entry next link is to a page whose flags are not the same.");
                            System.out.println("Index next page flags: ".concat(String.valueOf(String.valueOf(by2))));
                            System.out.println("Index page flags: ".concat(String.valueOf(String.valueOf(by))));
                            System.out.println("Index next page number: ".concat(String.valueOf(String.valueOf(n4))));
                            System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                            return false;
                        }
                        this.int.i.J = this.int.i.H;
                    }
                    if (!this.a(i)) {
                        if (this.long) {
                            System.out.println();
                            this.long = false;
                        }
                        System.out.println("Index page number could not be found.");
                        System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    for (n2 = 0; n2 < n6; ++n2) {
                        int n7;
                        int n8;
                        n5 = ByteArray.getInt(this.int.i.J, 9 + this.int.i.null * n2 + 0);
                        if (n5 < -1) {
                            if (this.long) {
                                System.out.println();
                                this.long = false;
                            }
                            System.out.println("Index entry previous page number is not correct.");
                            System.out.println("Index previous page number: ".concat(String.valueOf(String.valueOf(n5))));
                            System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(n2))));
                            System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                            return false;
                        }
                        if (n5 >= n) {
                            if (this.long) {
                                System.out.println();
                                this.long = false;
                            }
                            System.out.println("Index entry previous page number exceeds page count.");
                            System.out.println("Index previous page number: ".concat(String.valueOf(String.valueOf(n5))));
                            System.out.println("Index page count: ".concat(String.valueOf(String.valueOf(n))));
                            System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(n2))));
                            System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                            return false;
                        }
                        if (n5 == i) {
                            if (this.long) {
                                System.out.println();
                                this.long = false;
                            }
                            System.out.println("Index entry previous page number cannot be the same as the current page number.");
                            System.out.println("Index previous page number: ".concat(String.valueOf(String.valueOf(n5))));
                            System.out.println("Index current page number: ".concat(String.valueOf(String.valueOf(i))));
                            System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(n2))));
                            System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                            return false;
                        }
                        if (n5 != -1) {
                            this.int.i.J = this.int.i.F;
                            this.int.i.if(n5);
                            by2 = ByteArray.getByte(this.int.i.J, 0);
                            if (by2 != by) {
                                if (this.long) {
                                    System.out.println();
                                    this.long = false;
                                }
                                System.out.println("Index entry previous link is to a page whose flags are not the same.");
                                System.out.println("Previous page flags: ".concat(String.valueOf(String.valueOf(by2))));
                                System.out.println("Index page flags: ".concat(String.valueOf(String.valueOf(by))));
                                System.out.println("Index previous page number: ".concat(String.valueOf(String.valueOf(n5))));
                                System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(n2))));
                                System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                                return false;
                            }
                            this.int.i.J = this.int.i.H;
                        }
                        if (this.void) {
                            n8 = ByteArray.getInt(this.int.i.J, 9 + this.int.i.null * n2 + 4 + 4);
                            if (n8 < 0) {
                                if (this.long) {
                                    System.out.println();
                                    this.long = false;
                                }
                                System.out.println("Index entry key record length must be at least zero (0).");
                                System.out.println("Index entry key record length: ".concat(String.valueOf(String.valueOf(n8))));
                                System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(n2))));
                                System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                                return false;
                            }
                            n7 = ByteArray.getInt(this.int.i.J, 9 + this.int.i.null * n2 + 4 + 0);
                            if (n7 == -1) {
                                if (this.long) {
                                    System.out.println();
                                    this.long = false;
                                }
                                System.out.println("Index entry key base page number is not correct.");
                                System.out.println("Index entry key base page number: ".concat(String.valueOf(String.valueOf(n7))));
                                System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(n2))));
                                System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                                return false;
                            }
                            this.int.i.v.try(n7);
                            by2 = ByteArray.getByte(this.int.i.v.new, 0);
                            if (by2 != 1) {
                                if (this.long) {
                                    System.out.println();
                                    this.long = false;
                                }
                                System.out.println("Index entry keys store base page number cannot reference a free page.");
                                System.out.println("Index entry keys store base page number: ".concat(String.valueOf(String.valueOf(n7))));
                                System.out.println("Index entry keys store page flags: ".concat(String.valueOf(String.valueOf(by2))));
                                System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(n2))));
                                System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                                return false;
                            }
                        }
                        if (this.if) {
                            int n9 = ByteArray.getInt(this.int.i.J, 9 + this.int.i.null * n2 + 4 + this.int.i.g + 4);
                            if (n9 < 1) {
                                if (this.long) {
                                    System.out.println();
                                    this.long = false;
                                }
                                System.out.println("Index entry values index record count must be at least one (1).");
                                System.out.println("Index entry values index record count: ".concat(String.valueOf(String.valueOf(n9))));
                                System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(n2))));
                                System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                                return false;
                            }
                            n7 = ByteArray.getInt(this.int.i.J, 9 + this.int.i.null * n2 + 4 + this.int.i.g + 0);
                            if (n7 == -1) {
                                if (this.long) {
                                    System.out.println();
                                    this.long = false;
                                }
                                System.out.println("Index entry values index base page number is not correct.");
                                System.out.println("Index entry values index base page number: ".concat(String.valueOf(String.valueOf(n7))));
                                System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(n2))));
                                System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                                return false;
                            }
                            this.int.i.M.v = this.int.i.M.u;
                            this.int.i.M.if(n7);
                            by2 = ByteArray.getByte(this.int.i.M.v, 0);
                            if (by2 != 1) {
                                if (this.long) {
                                    System.out.println();
                                    this.long = false;
                                }
                                System.out.println("Index entry values index base page number is not correct.");
                                System.out.println("Index entry values index base page number: ".concat(String.valueOf(String.valueOf(n7))));
                                System.out.println("Index entry values index page flags: ".concat(String.valueOf(String.valueOf(by2))));
                                System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(n2))));
                                System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                                return false;
                            }
                            if (!this.c || (n3 = this.if(n7)) == n9) continue;
                            if (this.long) {
                                System.out.println();
                                this.long = false;
                            }
                            System.out.println("Index entry values index record count is not correct.");
                            System.out.println("Estimated value count: ".concat(String.valueOf(String.valueOf(n3))));
                            System.out.println("Current value count: ".concat(String.valueOf(String.valueOf(n9))));
                            System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(n2))));
                            System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                            return false;
                        }
                        if (!this.c) continue;
                        n8 = ByteArray.getInt(this.int.i.J, 9 + this.int.i.null * n2 + 4 + this.int.i.g + 4);
                        if (n8 < 0) {
                            if (this.long) {
                                System.out.println();
                                this.long = false;
                            }
                            System.out.println("Index entry value record length must be at least zero (0).");
                            System.out.println("Index entry value record length: ".concat(String.valueOf(String.valueOf(n8))));
                            System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(n2))));
                            System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                            return false;
                        }
                        n7 = ByteArray.getInt(this.int.i.J, 9 + this.int.i.null * n2 + 4 + this.int.i.g + 0);
                        if (n7 == -1) {
                            if (this.long) {
                                System.out.println();
                                this.long = false;
                            }
                            System.out.println("Index entry value base page number is not correct.");
                            System.out.println("Index entry value base page number: ".concat(String.valueOf(String.valueOf(n7))));
                            System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(n2))));
                            System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                            return false;
                        }
                        this.int.i.goto.try(n7);
                        by2 = ByteArray.getByte(this.int.i.v.new, 0);
                        if (by2 == 1) continue;
                        if (this.long) {
                            System.out.println();
                            this.long = false;
                        }
                        System.out.println("Index entry values store base page number is not correct.");
                        System.out.println("Index entry values store base page number: ".concat(String.valueOf(String.valueOf(n7))));
                        System.out.println("Index entry values store page flags: ".concat(String.valueOf(String.valueOf(by2))));
                        System.out.println("Index entry index: ".concat(String.valueOf(String.valueOf(n2))));
                        System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    n3 = 0;
                    if (i == this.int.i.char) {
                        ++n3;
                    }
                    if (i == this.int.i.T) {
                        ++n3;
                    }
                    for (n2 = 0; n2 < n; ++n2) {
                        if (i == n2) continue;
                        this.int.i.J = this.int.i.F;
                        this.int.i.if(n2);
                        by2 = ByteArray.getByte(this.int.i.J, 0);
                        if (by2 == 1) {
                            int n10 = ByteArray.getInt(this.int.i.J, 1);
                            if (i == n10) {
                                ++n3;
                            }
                            n6 = ByteArray.getInt(this.int.i.J, 5);
                            for (int j = 0; j < n6; ++j) {
                                n5 = ByteArray.getInt(this.int.i.J, 9 + this.int.i.null * j + 0);
                                if (i != n5) continue;
                                ++n3;
                            }
                        }
                        this.int.i.J = this.int.i.H;
                    }
                    if (n3 == 0) {
                        if (this.long) {
                            System.out.println();
                            this.long = false;
                        }
                        System.out.println("Used page was not found mapped to index entry: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (n3 > 1) {
                        if (this.long) {
                            System.out.println();
                            this.long = false;
                        }
                        System.out.println("Used page was found mapped to multiple index pages.");
                        System.out.println("Index page referecne count: ".concat(String.valueOf(String.valueOf(n3))));
                        System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                } else {
                    if (this.long) {
                        System.out.println();
                        this.long = false;
                    }
                    System.out.println("Index page flags are not correct.");
                    System.out.println("Index page flags: ".concat(String.valueOf(String.valueOf(by))));
                    System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (n4 == -1) continue;
                this.int.i.J = this.int.i.F;
                this.int.i.if(n4);
                by2 = ByteArray.getByte(this.int.i.J, 0);
                if (by2 != by) {
                    if (this.long) {
                        System.out.println();
                        this.long = false;
                    }
                    System.out.println("Index page next link is to a page whose flags are not the same.");
                    System.out.println("Index next page flags: ".concat(String.valueOf(String.valueOf(by2))));
                    System.out.println("Index page flags: ".concat(String.valueOf(String.valueOf(by))));
                    System.out.println("Index next page number: ".concat(String.valueOf(String.valueOf(n4))));
                    System.out.println("Index page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                this.int.i.J = this.int.i.H;
            }
            if (!this.long) break block71;
            System.out.println();
            this.long = false;
        }
        return true;
    }

    private final boolean for() throws Exception {
        block29: {
            if (this.else) {
                System.out.println("Checking keys store links");
            }
            IndexStoreInstance indexStoreInstance = this.int.i.v;
            int n = indexStoreInstance.e;
            for (int i = 0; i < n; ++i) {
                byte by;
                int n2;
                int n3;
                if (this.else && this.char) {
                    Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(i + 1))).append(" - ").append(n).append(": ").append((int)(((double)i + 1.0) / (double)n * 100.0)).append("%"))));
                    this.long = true;
                }
                indexStoreInstance.try(i);
                byte by2 = ByteArray.getByte(indexStoreInstance.new, 0);
                int n4 = ByteArray.getInt(indexStoreInstance.new, 1);
                if (n4 < -1) {
                    if (this.long) {
                        System.out.println();
                        this.long = false;
                    }
                    System.out.println("Keys store next page number is not correct.");
                    System.out.println("Keys store next page number: ".concat(String.valueOf(String.valueOf(n4))));
                    System.out.println("Keys store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (n4 >= n) {
                    if (this.long) {
                        System.out.println();
                        this.long = false;
                    }
                    System.out.println("Keys store next page number exceeds keys store page count.");
                    System.out.println("Keys store next page number: ".concat(String.valueOf(String.valueOf(n4))));
                    System.out.println("Keys store page count: ".concat(String.valueOf(String.valueOf(n))));
                    System.out.println("Keys store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (n4 == i) {
                    if (this.long) {
                        System.out.println();
                        this.long = false;
                    }
                    System.out.println("Keys store next page number cannot be the same as the current page number.");
                    System.out.println("Keys store next page number: ".concat(String.valueOf(String.valueOf(n4))));
                    System.out.println("Keys store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (by2 == 0) {
                    n3 = 0;
                    n2 = indexStoreInstance.case;
                    while (n2 != -1) {
                        if (n2 == i) {
                            ++n3;
                        }
                        indexStoreInstance.try(n2);
                        n2 = ByteArray.getInt(indexStoreInstance.new, 1);
                    }
                    if (n3 == 0) {
                        if (this.long) {
                            System.out.println();
                            this.long = false;
                        }
                        System.out.println("Keys store page marked as available was not found on free list: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (n3 > 1) {
                        if (this.long) {
                            System.out.println();
                            this.long = false;
                        }
                        System.out.println("Keys store page marked as available was found multiple times on free list.");
                        System.out.println("Keys store reference count: ".concat(String.valueOf(String.valueOf(n3))));
                        System.out.println("Keys store page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                } else if (by2 == 1) {
                    n3 = 0;
                    if (i == indexStoreInstance.case) {
                        ++n3;
                    }
                    for (n2 = 0; n2 < n; ++n2) {
                        indexStoreInstance.try(n2);
                        int n5 = ByteArray.getInt(indexStoreInstance.new, 1);
                        if (i != n5) continue;
                        ++n3;
                    }
                    this.int.i.J = this.int.i.H;
                    int n6 = this.int.i.B;
                    for (n2 = 0; n2 < n6; ++n2) {
                        this.int.i.if(n2);
                        by = ByteArray.getByte(this.int.i.J, 0);
                        if (by != 1) continue;
                        int n7 = ByteArray.getInt(this.int.i.J, 5);
                        for (int j = 0; j < n7; ++j) {
                            int n8 = ByteArray.getInt(this.int.i.J, 9 + this.int.i.null * j + 4 + 0);
                            int n9 = ByteArray.getInt(this.int.i.J, 9 + this.int.i.null * j + 4 + 4);
                            if (i != n8) continue;
                            ++n3;
                        }
                    }
                    if (n3 == 0) {
                        if (this.long) {
                            System.out.println();
                            this.long = false;
                        }
                        System.out.println("Used keys store page was not found mapped to index entry: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (n3 > 1) {
                        if (this.long) {
                            System.out.println();
                            this.long = false;
                        }
                        System.out.println("Used keys store page was found mapped to multiple index entries.");
                        System.out.println("Keys store page reference count: ".concat(String.valueOf(String.valueOf(n3))));
                        System.out.println("Keys store page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                } else {
                    if (this.long) {
                        System.out.println();
                        this.long = false;
                    }
                    System.out.println("Keys store page flags are not correct.");
                    System.out.println("Keys store page flags: ".concat(String.valueOf(String.valueOf(by2))));
                    System.out.println("Keys store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (n4 == -1) continue;
                indexStoreInstance.try(n4);
                by = ByteArray.getByte(indexStoreInstance.new, 0);
                if (by == by2) continue;
                if (this.long) {
                    System.out.println();
                    this.long = false;
                }
                System.out.println("Keys store page next link is to a page whose flags are not the same.");
                System.out.println("Next keys store page flags: ".concat(String.valueOf(String.valueOf(by))));
                System.out.println("Keys store page flags: ".concat(String.valueOf(String.valueOf(by2))));
                System.out.println("Next keys store page number: ".concat(String.valueOf(String.valueOf(n4))));
                System.out.println("Keys store page number: ".concat(String.valueOf(String.valueOf(i))));
                return false;
            }
            if (!this.long) break block29;
            System.out.println();
            this.long = false;
        }
        return true;
    }

    private final boolean new() throws Exception {
        block29: {
            if (this.else) {
                System.out.println("Checking values store links");
            }
            IndexStoreInstance indexStoreInstance = this.int.i.goto;
            int n = indexStoreInstance.e;
            for (int i = 0; i < n; ++i) {
                byte by;
                int n2;
                int n3;
                if (this.else && this.char) {
                    Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(i + 1))).append(" - ").append(n).append(": ").append((int)(((double)i + 1.0) / (double)n * 100.0)).append("%"))));
                    this.long = true;
                }
                indexStoreInstance.try(i);
                byte by2 = ByteArray.getByte(indexStoreInstance.new, 0);
                int n4 = ByteArray.getInt(indexStoreInstance.new, 1);
                if (n4 < -1) {
                    if (this.long) {
                        System.out.println();
                        this.long = false;
                    }
                    System.out.println("Values store next page number is not correct.");
                    System.out.println("Values store next page number: ".concat(String.valueOf(String.valueOf(n4))));
                    System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (n4 >= n) {
                    if (this.long) {
                        System.out.println();
                        this.long = false;
                    }
                    System.out.println("Values store next page number exceeds values store page count.");
                    System.out.println("Values store next page number: ".concat(String.valueOf(String.valueOf(n4))));
                    System.out.println("Values store page count: ".concat(String.valueOf(String.valueOf(n))));
                    System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (n4 == i) {
                    if (this.long) {
                        System.out.println();
                        this.long = false;
                    }
                    System.out.println("Values store next page number cannot be the same as the current page number.");
                    System.out.println("Values store next page number: ".concat(String.valueOf(String.valueOf(n4))));
                    System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (by2 == 0) {
                    n3 = 0;
                    n2 = indexStoreInstance.case;
                    while (n2 != -1) {
                        if (n2 == i) {
                            ++n3;
                        }
                        indexStoreInstance.try(n2);
                        n2 = ByteArray.getInt(indexStoreInstance.new, 1);
                    }
                    if (n3 == 0) {
                        if (this.long) {
                            System.out.println();
                            this.long = false;
                        }
                        System.out.println("Values store page marked as available was not found on free list: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (n3 > 1) {
                        if (this.long) {
                            System.out.println();
                            this.long = false;
                        }
                        System.out.println("Values store page marked as available was found multiple times on free list.");
                        System.out.println("Values store page reference count: ".concat(String.valueOf(String.valueOf(n3))));
                        System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                } else if (by2 == 1) {
                    n3 = 0;
                    if (i == indexStoreInstance.case) {
                        ++n3;
                    }
                    for (n2 = 0; n2 < n; ++n2) {
                        indexStoreInstance.try(n2);
                        int n5 = ByteArray.getInt(indexStoreInstance.new, 1);
                        if (i != n5) continue;
                        ++n3;
                    }
                    this.int.i.J = this.int.i.H;
                    int n6 = this.int.i.B;
                    for (n2 = 0; n2 < n6; ++n2) {
                        this.int.i.if(n2);
                        by = ByteArray.getByte(this.int.i.J, 0);
                        if (by != 1) continue;
                        int n7 = ByteArray.getInt(this.int.i.J, 5);
                        for (int j = 0; j < n7; ++j) {
                            int n8 = ByteArray.getInt(this.int.i.J, 9 + this.int.i.null * j + 4 + this.int.i.g + 0);
                            int n9 = ByteArray.getInt(this.int.i.J, 9 + this.int.i.null * j + 4 + this.int.i.g + 4);
                            if (i != n8) continue;
                            ++n3;
                        }
                    }
                    if (n3 == 0) {
                        if (this.long) {
                            System.out.println();
                            this.long = false;
                        }
                        System.out.println("Used values store page was not found mapped to index entry: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (n3 > 1) {
                        if (this.long) {
                            System.out.println();
                            this.long = false;
                        }
                        System.out.println("Used values store page was found mapped to multiple index entries.");
                        System.out.println("Values store reference count: ".concat(String.valueOf(String.valueOf(n3))));
                        System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                } else {
                    if (this.long) {
                        System.out.println();
                        this.long = false;
                    }
                    System.out.println("Values store page flags are not correct.");
                    System.out.println("Values store page flags: ".concat(String.valueOf(String.valueOf(by2))));
                    System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (n4 == -1) continue;
                indexStoreInstance.try(n4);
                by = ByteArray.getByte(indexStoreInstance.new, 0);
                if (by == by2) continue;
                if (this.long) {
                    System.out.println();
                    this.long = false;
                }
                System.out.println("Values store page next link is to a page whose flags are not the same.");
                System.out.println("Next values store page flags: ".concat(String.valueOf(String.valueOf(by))));
                System.out.println("Values store page flags: ".concat(String.valueOf(String.valueOf(by2))));
                System.out.println("Next values store page number: ".concat(String.valueOf(String.valueOf(n4))));
                System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                return false;
            }
            if (!this.long) break block29;
            System.out.println();
            this.long = false;
        }
        return true;
    }

    private final boolean case() throws Exception {
        block29: {
            if (this.else) {
                System.out.println("Checking values store links");
            }
            IndexStoreInstance indexStoreInstance = this.int.i.M.new;
            int n = indexStoreInstance.e;
            for (int i = 0; i < n; ++i) {
                byte by;
                int n2;
                int n3;
                if (this.else && this.char) {
                    Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(i + 1))).append(" - ").append(n).append(": ").append((int)(((double)i + 1.0) / (double)n * 100.0)).append("%"))));
                    this.long = true;
                }
                indexStoreInstance.try(i);
                byte by2 = ByteArray.getByte(indexStoreInstance.new, 0);
                int n4 = ByteArray.getInt(indexStoreInstance.new, 1);
                if (n4 < -1) {
                    if (this.long) {
                        System.out.println();
                        this.long = false;
                    }
                    System.out.println("Values store next page number is not correct.");
                    System.out.println("Values store next page number: ".concat(String.valueOf(String.valueOf(n4))));
                    System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (n4 >= n) {
                    if (this.long) {
                        System.out.println();
                        this.long = false;
                    }
                    System.out.println("Values store next page number exceeds values store page count.");
                    System.out.println("Values store next page number: ".concat(String.valueOf(String.valueOf(n4))));
                    System.out.println("Values store page count: ".concat(String.valueOf(String.valueOf(n))));
                    System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (n4 == i) {
                    if (this.long) {
                        System.out.println();
                        this.long = false;
                    }
                    System.out.println("Values store next page number cannot be the same as the current page number.");
                    System.out.println("Values store next page number: ".concat(String.valueOf(String.valueOf(n4))));
                    System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (by2 == 0) {
                    n3 = 0;
                    n2 = indexStoreInstance.case;
                    while (n2 != -1) {
                        if (n2 == i) {
                            ++n3;
                        }
                        indexStoreInstance.try(n2);
                        n2 = ByteArray.getInt(indexStoreInstance.new, 1);
                    }
                    if (n3 == 0) {
                        if (this.long) {
                            System.out.println();
                            this.long = false;
                        }
                        System.out.println("Values store page marked as available was not found on free list: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (n3 > 1) {
                        if (this.long) {
                            System.out.println();
                            this.long = false;
                        }
                        System.out.println("Values store page marked as available was found multiple times on free list.");
                        System.out.println("Values store page reference count: ".concat(String.valueOf(String.valueOf(n3))));
                        System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                } else if (by2 == 1) {
                    n3 = 0;
                    if (i == indexStoreInstance.case) {
                        ++n3;
                    }
                    for (n2 = 0; n2 < n; ++n2) {
                        indexStoreInstance.try(n2);
                        int n5 = ByteArray.getInt(indexStoreInstance.new, 1);
                        if (i != n5) continue;
                        ++n3;
                    }
                    this.int.i.M.v = this.int.i.M.u;
                    int n6 = this.int.i.M.o;
                    for (n2 = 0; n2 < n6; ++n2) {
                        this.int.i.M.if(n2);
                        by = ByteArray.getByte(this.int.i.M.v, 0);
                        if (by != 1) continue;
                        int n7 = ByteArray.getInt(this.int.i.M.v, 5);
                        for (int j = 0; j < n7; ++j) {
                            int n8 = ByteArray.getInt(this.int.i.M.v, 9 + this.int.i.M.case * j + 4 + 0);
                            int n9 = ByteArray.getInt(this.int.i.M.v, 9 + this.int.i.M.case * j + 4 + 4);
                            if (i != n8) continue;
                            ++n3;
                        }
                    }
                    if (n3 == 0) {
                        if (this.long) {
                            System.out.println();
                            this.long = false;
                        }
                        System.out.println("Used values store page was not found mapped to index entry: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (n3 > 1) {
                        if (this.long) {
                            System.out.println();
                            this.long = false;
                        }
                        System.out.println("Used values store page was found mapped to multiple index entries.");
                        System.out.println("Values store page reference count: ".concat(String.valueOf(String.valueOf(n3))));
                        System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                } else {
                    if (this.long) {
                        System.out.println();
                        this.long = false;
                    }
                    System.out.println("Values store page flags are not correct.");
                    System.out.println("Values store page flags: ".concat(String.valueOf(String.valueOf(by2))));
                    System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (n4 == -1) continue;
                indexStoreInstance.try(n4);
                by = ByteArray.getByte(indexStoreInstance.new, 0);
                if (by == by2) continue;
                if (this.long) {
                    System.out.println();
                    this.long = false;
                }
                System.out.println("Values store page next link is to a page whose flags are not the same.");
                System.out.println("Next values store page flags: ".concat(String.valueOf(String.valueOf(by))));
                System.out.println("Values stores page flags: ".concat(String.valueOf(String.valueOf(by2))));
                System.out.println("Next values store page number: ".concat(String.valueOf(String.valueOf(n4))));
                System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                return false;
            }
            if (!this.long) break block29;
            System.out.println();
            this.long = false;
        }
        return true;
    }

    private final boolean int() throws Exception {
        block47: {
            if (this.else) {
                System.out.println("Checking values index links");
            }
            ValuesIndexInstance valuesIndexInstance = this.int.i.M;
            valuesIndexInstance.v = valuesIndexInstance.u;
            int n = valuesIndexInstance.o;
            for (int i = 0; i < n; ++i) {
                byte by;
                int n2;
                int n3;
                if (this.else && this.char) {
                    Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(i + 1))).append(" - ").append(n).append(": ").append((int)(((double)i + 1.0) / (double)n * 100.0)).append("%"))));
                    this.long = true;
                }
                valuesIndexInstance.if(i);
                byte by2 = ByteArray.getByte(valuesIndexInstance.v, 0);
                int n4 = ByteArray.getInt(valuesIndexInstance.v, 1);
                if (n4 < -1) {
                    if (this.long) {
                        System.out.println();
                        this.long = false;
                    }
                    System.out.println("Values index next page number is not correct.");
                    System.out.println("Values index next page number: ".concat(String.valueOf(String.valueOf(n4))));
                    System.out.println("Values index page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (n4 >= n) {
                    if (this.long) {
                        System.out.println();
                        this.long = false;
                    }
                    System.out.println("Values index next page number exceeds values index page count.");
                    System.out.println("Values index next page number: ".concat(String.valueOf(String.valueOf(n4))));
                    System.out.println("Values index page count: ".concat(String.valueOf(String.valueOf(n))));
                    System.out.println("Values index page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (n4 == i) {
                    if (this.long) {
                        System.out.println();
                        this.long = false;
                    }
                    System.out.println("Values index next page number cannot be the same as the current page number.");
                    System.out.println("Values index next page number: ".concat(String.valueOf(String.valueOf(n4))));
                    System.out.println("Values index page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (by2 == 0) {
                    n3 = 0;
                    n2 = valuesIndexInstance.try;
                    valuesIndexInstance.v = valuesIndexInstance.s;
                    while (n2 != -1) {
                        if (n2 == i) {
                            ++n3;
                        }
                        valuesIndexInstance.if(n2);
                        n2 = ByteArray.getInt(valuesIndexInstance.v, 1);
                    }
                    valuesIndexInstance.v = valuesIndexInstance.u;
                    if (n3 == 0) {
                        if (this.long) {
                            System.out.println();
                            this.long = false;
                        }
                        System.out.println("Values index page marked as available was not found on free list: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (n3 > 1) {
                        if (this.long) {
                            System.out.println();
                            this.long = false;
                        }
                        System.out.println("Values index page marked as available was found multiple times on free list.");
                        System.out.println("Values index page reference count: ".concat(String.valueOf(String.valueOf(n3))));
                        System.out.println("Values index page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                } else if (by2 == 1) {
                    int n5;
                    int n6;
                    int n7 = ByteArray.getInt(valuesIndexInstance.v, 5);
                    if (n7 > valuesIndexInstance.l * 2) {
                        if (this.long) {
                            System.out.println();
                            this.long = false;
                        }
                        System.out.println("Values index entry count cannot exceed values index order * 2 is not correct.");
                        System.out.println("Current values index entry count: ".concat(String.valueOf(String.valueOf(valuesIndexInstance.l * 2))));
                        System.out.println("Estimates values index entry count: ".concat(String.valueOf(String.valueOf(n7))));
                        System.out.println("Values index page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (n4 != -1) {
                        valuesIndexInstance.v = valuesIndexInstance.s;
                        valuesIndexInstance.if(n4);
                        by = ByteArray.getByte(valuesIndexInstance.v, 0);
                        if (by != by2) {
                            if (this.long) {
                                System.out.println();
                                this.long = false;
                            }
                            System.out.println("Values index entry next link is to a page whose flags are not the same.");
                            System.out.println("Values index next page flags: ".concat(String.valueOf(String.valueOf(by))));
                            System.out.println("Values index page flags: ".concat(String.valueOf(String.valueOf(by2))));
                            System.out.println("Values index next page number: ".concat(String.valueOf(String.valueOf(n4))));
                            System.out.println("Values index page number: ".concat(String.valueOf(String.valueOf(i))));
                            return false;
                        }
                        valuesIndexInstance.v = valuesIndexInstance.u;
                    }
                    for (n2 = 0; n2 < n7; ++n2) {
                        n6 = ByteArray.getInt(valuesIndexInstance.v, 9 + valuesIndexInstance.case * n2 + 0);
                        if (n6 < -1) {
                            if (this.long) {
                                System.out.println();
                                this.long = false;
                            }
                            System.out.println("Values index entry previous page number is not correct.");
                            System.out.println("Values index entry previous page number: ".concat(String.valueOf(String.valueOf(n4))));
                            System.out.println("Values index entry page number: ".concat(String.valueOf(String.valueOf(i))));
                            return false;
                        }
                        if (n6 >= n) {
                            if (this.long) {
                                System.out.println();
                                this.long = false;
                            }
                            System.out.println("Values index entry previous page number exceeds values index entry page count.");
                            System.out.println("Values index entry previous page number: ".concat(String.valueOf(String.valueOf(n4))));
                            System.out.println("Values index entry page count: ".concat(String.valueOf(String.valueOf(n))));
                            System.out.println("Values index entry page number: ".concat(String.valueOf(String.valueOf(i))));
                            return false;
                        }
                        if (n6 == i) {
                            if (this.long) {
                                System.out.println();
                                this.long = false;
                            }
                            System.out.println("Values index entry previous page number cannot be the same as the current page number.");
                            System.out.println("Values index entry previous page number: ".concat(String.valueOf(String.valueOf(n4))));
                            System.out.println("Values index entry page number: ".concat(String.valueOf(String.valueOf(i))));
                            return false;
                        }
                        if (n6 == -1) continue;
                        valuesIndexInstance.v = valuesIndexInstance.s;
                        valuesIndexInstance.if(n6);
                        by = ByteArray.getByte(valuesIndexInstance.v, 0);
                        if (by != by2) {
                            if (this.long) {
                                System.out.println();
                                this.long = false;
                            }
                            System.out.println("Values index entry previous link is to a page whose flags are not the same.");
                            System.out.println("Values index previous page flags: ".concat(String.valueOf(String.valueOf(by))));
                            System.out.println("Values index page flags: ".concat(String.valueOf(String.valueOf(by2))));
                            System.out.println("Values index previous page number: ".concat(String.valueOf(String.valueOf(n6))));
                            System.out.println("Values index page number: ".concat(String.valueOf(String.valueOf(i))));
                            return false;
                        }
                        valuesIndexInstance.v = valuesIndexInstance.u;
                    }
                    n3 = 0;
                    if (i == valuesIndexInstance.try) {
                        ++n3;
                    }
                    this.int.i.J = this.int.i.H;
                    int n8 = this.int.i.B;
                    for (n2 = 0; n2 < n8; ++n2) {
                        this.int.i.if(n2);
                        by = ByteArray.getByte(this.int.i.J, 0);
                        if (by != 1) continue;
                        n7 = ByteArray.getInt(this.int.i.J, 5);
                        for (n5 = 0; n5 < n7; ++n5) {
                            int n9 = ByteArray.getInt(this.int.i.J, 9 + this.int.i.null * n5 + 4 + this.int.i.g + 0);
                            int n10 = ByteArray.getInt(this.int.i.J, 9 + this.int.i.null * n5 + 4 + this.int.i.g + 4);
                            if (i != n9) continue;
                            ++n3;
                        }
                    }
                    for (n2 = 0; n2 < n; ++n2) {
                        if (i == n2) continue;
                        valuesIndexInstance.v = valuesIndexInstance.s;
                        valuesIndexInstance.if(n2);
                        by = ByteArray.getByte(valuesIndexInstance.v, 0);
                        if (by == 1) {
                            int n11 = ByteArray.getInt(valuesIndexInstance.v, 1);
                            if (i == n11) {
                                ++n3;
                            }
                            n7 = ByteArray.getInt(valuesIndexInstance.v, 5);
                            for (n5 = 0; n5 < n7; ++n5) {
                                n6 = ByteArray.getInt(valuesIndexInstance.v, 9 + valuesIndexInstance.case * n5 + 0);
                                if (i != n6) continue;
                                ++n3;
                            }
                        }
                        valuesIndexInstance.v = valuesIndexInstance.u;
                    }
                    if (n3 == 0) {
                        if (this.long) {
                            System.out.println();
                            this.long = false;
                        }
                        System.out.println("Used values index page page was not found mapped to index entry: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (n3 > 1) {
                        if (this.long) {
                            System.out.println();
                            this.long = false;
                        }
                        System.out.println("Used values index page page was found mapped to multiple index pages.");
                        System.out.println("Values index page reference count: ".concat(String.valueOf(String.valueOf(n3))));
                        System.out.println("Values index page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                } else {
                    if (this.long) {
                        System.out.println();
                        this.long = false;
                    }
                    System.out.println("Values index page flags are not correct.");
                    System.out.println("Values store page flags: ".concat(String.valueOf(String.valueOf(by2))));
                    System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (n4 == -1) continue;
                valuesIndexInstance.v = valuesIndexInstance.s;
                valuesIndexInstance.if(n4);
                by = ByteArray.getByte(valuesIndexInstance.v, 0);
                if (by != by2) {
                    if (this.long) {
                        System.out.println();
                        this.long = false;
                    }
                    System.out.println("Values index page next link is to a page whose flags are not the same.");
                    System.out.println("Next values store page flags: ".concat(String.valueOf(String.valueOf(by))));
                    System.out.println("Values stores page flags: ".concat(String.valueOf(String.valueOf(by2))));
                    System.out.println("Next values store page number: ".concat(String.valueOf(String.valueOf(n4))));
                    System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                valuesIndexInstance.v = valuesIndexInstance.u;
            }
            if (!this.long) break block47;
            System.out.println();
            this.long = false;
        }
        return true;
    }

    private final void byte() throws Exception {
        block7: {
            if (this.else) {
                System.out.println("Generating keys statistics");
            }
            boolean bl = false;
            byte by = this.int.i.if;
            this.i = by == 8 || by == 13 || by == 14 || by == 11 || by == 15 || by == 9 ? (long)this.int.i.v.a : (long)this.int.i.g;
            int n = this.int.i.B;
            for (int i = 0; i < n; ++i) {
                if (this.char) {
                    Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(i + 1))).append(" - ").append(n).append(": ").append((int)((double)(i + 1) / (double)n * 100.0)).append("%"))));
                    bl = true;
                }
                this.int.i.if(i);
                if (ByteArray.getByte(this.int.i.J, 0) != 1) continue;
                int n2 = ByteArray.getInt(this.int.i.J, 5);
                if (by == 8 || by == 13 || by == 14 || by == 11 || by == 15 || by == 9) {
                    for (int j = 0; j < n2; ++j) {
                        int n3 = this.int.i.try(j) + 4;
                        int n4 = ByteArray.getInt(this.int.i.J, n3 + 4);
                        this.null += (long)n4;
                        int n5 = n4 / this.int.i.v.a;
                        if (n5 * this.int.i.v.a < n4) {
                            ++n5;
                        }
                        this.f += (long)n5;
                    }
                } else {
                    this.null += (long)n2 * this.i;
                    this.f += (long)n2;
                }
                this.a += (long)n2;
                this.do += (long)(this.int.i.x * 2);
            }
            if (!bl) break block7;
            System.out.println();
            bl = false;
        }
    }

    private final void try() throws Exception {
        block7: {
            if (this.else) {
                System.out.println("Generating values statistics");
            }
            boolean bl = false;
            byte by = this.int.i.y;
            this.case = by == 8 || by == 13 || by == 14 || by == 11 || by == 15 || by == 9 ? (long)this.int.i.goto.a : (long)this.int.i.D;
            int n = this.int.i.B;
            for (int i = 0; i < n; ++i) {
                if (this.char) {
                    Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(i + 1))).append(" - ").append(n).append(": ").append((int)((double)(i + 1) / (double)n * 100.0)).append("%"))));
                    bl = true;
                }
                this.int.i.if(i);
                if (ByteArray.getByte(this.int.i.J, 0) != 1) continue;
                int n2 = ByteArray.getInt(this.int.i.J, 5);
                if (by == 8 || by == 13 || by == 14 || by == 11 || by == 15 || by == 9) {
                    for (int j = 0; j < n2; ++j) {
                        int n3 = this.int.i.try(j) + 4 + this.int.i.g;
                        int n4 = ByteArray.getInt(this.int.i.J, n3 + 4);
                        this.try += (long)n4;
                        int n5 = n4 / this.int.i.goto.a;
                        if (n5 * this.int.i.goto.a < n4) {
                            ++n5;
                        }
                        this.h += (long)n5;
                    }
                } else {
                    this.try += (long)n2 * this.case;
                    this.h += (long)n2;
                }
                this.b += (long)n2;
                this.d += (long)(this.int.i.x * 2);
            }
            if (!bl) break block7;
            System.out.println();
            bl = false;
        }
    }

    private final void if() throws Exception {
        block7: {
            if (this.else) {
                System.out.println("Generating duplicate values statistics");
            }
            boolean bl = false;
            byte by = this.int.i.M.m;
            this.case = by == 8 || by == 13 || by == 14 || by == 11 || by == 15 || by == 9 ? (long)this.int.i.M.new.a : (long)this.int.i.M.r;
            int n = this.int.i.M.o;
            for (int i = 0; i < n; ++i) {
                if (this.char) {
                    Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(i + 1))).append(" - ").append(n).append(": ").append((int)((double)(i + 1) / (double)n * 100.0)).append("%"))));
                    bl = true;
                }
                this.int.i.M.if(i);
                if (ByteArray.getByte(this.int.i.M.v, 0) != 1) continue;
                int n2 = ByteArray.getInt(this.int.i.M.v, 5);
                if (by == 8 || by == 13 || by == 14 || by == 11 || by == 15 || by == 9) {
                    for (int j = 0; j < n2; ++j) {
                        int n3 = this.int.i.M.byte(j) + 4;
                        int n4 = ByteArray.getInt(this.int.i.M.v, n3 + 4);
                        this.try += (long)n4;
                        int n5 = n4 / this.int.i.M.new.a;
                        if (n5 * this.int.i.M.new.a < n4) {
                            ++n5;
                        }
                        this.h += (long)n5;
                    }
                } else {
                    this.try += (long)n2 * this.case;
                    this.h += (long)n2;
                }
                this.b += (long)n2;
                this.d += (long)(this.int.i.M.l * 2);
            }
            if (!bl) break block7;
            System.out.println();
            bl = false;
        }
    }

    private final void goto() throws Exception {
        IndexInstance indexInstance = this.int.i;
        this.byte();
        if (indexInstance.y == -1) {
            this.if();
        } else {
            this.try();
        }
        if (this.else) {
            System.out.println();
            int n = this.int.i.long();
            System.out.println("Average key page count: ".concat(String.valueOf(String.valueOf(n == 0 ? 0.0 : (double)this.f / (double)n))));
            System.out.println("Average value page count: ".concat(String.valueOf(String.valueOf(n == 0 ? 0.0 : (double)this.h / (double)n))));
            System.out.println("Average key length: ".concat(String.valueOf(String.valueOf(n == 0 ? 0.0 : (double)this.null / (double)n))));
            System.out.println("Average value length: ".concat(String.valueOf(String.valueOf(n == 0 ? 0.0 : (double)this.try / (double)n))));
        }
    }

    private final void a() throws Exception {
        byte by;
        System.out.println();
        System.out.println("Keys index page utilization: ".concat(String.valueOf(String.valueOf(this.int.i.B == 0 ? 0.0 : (double)(this.int.i.B - this.int.i.C) / (double)this.int.i.B * (double)100))));
        byte by2 = this.int.i.y;
        if (by2 == -1) {
            System.out.println("Values index page utilization: ".concat(String.valueOf(String.valueOf(this.int.i.M.o == 0 ? 0.0 : (double)(this.int.i.M.o - this.int.i.M.p) / (double)this.int.i.M.o * (double)100))));
        }
        if ((by = this.int.i.if) == 8 || by == 13 || by == 14 || by == 11 || by == 15 || by == 9) {
            System.out.println("Keys store page utilization: ".concat(String.valueOf(String.valueOf(this.int.i.v.e == 0 ? 0.0 : (double)(this.int.i.v.e - this.int.i.v.h) / (double)this.int.i.v.e * (double)100))));
        }
        if (by2 == -1) {
            by2 = this.int.i.M.m;
            if (by2 == 8 || by2 == 13 || by2 == 14 || by2 == 11 || by2 == 15 || by2 == 9) {
                System.out.println("Values store page utilization: ".concat(String.valueOf(String.valueOf(this.int.i.M.new.e == 0 ? 0.0 : (double)(this.int.i.M.new.e - this.int.i.M.new.h) / (double)this.int.i.M.new.e * (double)100))));
            }
        } else if (by2 == 8 || by2 == 13 || by2 == 14 || by2 == 11 || by2 == 15 || by2 == 9) {
            System.out.println("Values store page utilization: ".concat(String.valueOf(String.valueOf(this.int.i.goto.e == 0 ? 0.0 : (double)(this.int.i.goto.e - this.int.i.goto.h) / (double)this.int.i.goto.e * (double)100))));
        }
        System.out.println("Keys index entry utilization: ".concat(String.valueOf(String.valueOf(this.do == (long)0 ? 0.0 : (double)this.a / (double)this.do * 100.0))));
        System.out.println("Values index entry utilization: ".concat(String.valueOf(String.valueOf(this.d == (long)0 ? 0.0 : (double)this.b / (double)this.d * 100.0))));
        System.out.println("Keys index space utilization: ".concat(String.valueOf(String.valueOf(this.f * this.i == (long)0 ? 0.0 : (double)this.null / (double)(this.f * this.i) * (double)100))));
        System.out.println("Values index space utilization: ".concat(String.valueOf(String.valueOf(this.h * this.case == (long)0 ? 0.0 : (double)this.try / (double)(this.h * this.case) * (double)100))));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean a(int n) throws IOException {
        int n2;
        block16: {
            block15: {
                block14: {
                    this.int.i.J = this.int.i.F;
                    try {
                        byte[] byArray = this.int.i.J;
                        int n3 = this.int.i.T;
                        Stack<int[]> stack = new Stack<int[]>();
                        while (true) {
                            int n4;
                            int n5;
                            int[] nArray;
                            if (n3 != -1) {
                                if (n == n3) {
                                    n2 = 1;
                                    Object var14_11 = null;
                                    this.int.i.J = this.int.i.H;
                                    return n2 != 0;
                                }
                                nArray = new int[]{n3, 0};
                                stack.push(nArray);
                                this.int.i.if(n3);
                                n5 = this.int.i.try(0);
                                n3 = ByteArray.getInt(byArray, n5 + 0);
                                continue;
                            }
                            if (stack.empty()) {
                                n2 = 0;
                                break block14;
                            }
                            nArray = (int[])stack.pop();
                            boolean bl = false;
                            this.int.i.if(nArray[0]);
                            int n6 = ByteArray.getInt(byArray, 5);
                            for (n2 = nArray[1]; n2 < n6; n2 += 1) {
                                n5 = this.int.i.try(n2);
                                n4 = ByteArray.getInt(byArray, n5 + 0);
                                if (n4 == -1) continue;
                                nArray = new int[]{n4, n2};
                                stack.push(nArray);
                                bl = true;
                                n3 = n4;
                                break;
                            }
                            if (!bl) {
                                n4 = ByteArray.getInt(byArray, 1);
                                if (n4 != -1) {
                                    nArray = new int[]{n4, -1};
                                    stack.push(nArray);
                                    bl = true;
                                    n3 = n4;
                                }
                                if (!bl) {
                                    if (stack.empty()) {
                                        n2 = 0;
                                        break block15;
                                    }
                                    nArray = (int[])stack.pop();
                                    this.int.i.if(nArray[0]);
                                    n6 = ByteArray.getInt(byArray, 5);
                                    nArray[1] = nArray[1] + 1;
                                    if (nArray[1] < n6) {
                                        n5 = this.int.i.try(nArray[1]);
                                        n4 = ByteArray.getInt(byArray, n5 + 0);
                                        stack.push(nArray);
                                    } else {
                                        n4 = ByteArray.getInt(byArray, 1);
                                    }
                                    if (n4 != -1) {
                                        n3 = n4;
                                        bl = true;
                                    }
                                }
                            }
                            if (!bl) break;
                        }
                        n2 = 0;
                        break block16;
                    }
                    catch (Throwable throwable) {
                        Object var14_15 = null;
                        this.int.i.J = this.int.i.H;
                        throw throwable;
                    }
                }
                Object var14_12 = null;
                this.int.i.J = this.int.i.H;
                return n2 != 0;
            }
            Object var14_13 = null;
            this.int.i.J = this.int.i.H;
            return n2 != 0;
        }
        Object var14_14 = null;
        this.int.i.J = this.int.i.H;
        return n2 != 0;
    }

    private final int if(int n) throws IOException {
        this.int.i.M.v = this.int.i.M.s;
        try {
            int n2;
            int n3 = 0;
            byte[] byArray = this.int.i.M.v;
            int n4 = n;
            Stack<int[]> stack = new Stack<int[]>();
            while (true) {
                int n5;
                int n6;
                int n7;
                int[] nArray;
                if (n4 != -1) {
                    nArray = new int[]{n4, 0};
                    stack.push(nArray);
                    this.int.i.M.if(n4);
                    n7 = ByteArray.getInt(byArray, 5);
                    n3 += n7;
                    n6 = this.int.i.M.byte(0);
                    n4 = ByteArray.getInt(byArray, n6 + 0);
                    continue;
                }
                if (stack.empty()) break;
                nArray = (int[])stack.pop();
                boolean bl = false;
                this.int.i.M.if(nArray[0]);
                n7 = ByteArray.getInt(byArray, 5);
                for (n2 = nArray[1]; n2 < n7; ++n2) {
                    n6 = this.int.i.M.byte(n2);
                    n5 = ByteArray.getInt(byArray, n6 + 0);
                    if (n5 == -1) continue;
                    nArray = new int[]{n5, n2};
                    stack.push(nArray);
                    bl = true;
                    n4 = n5;
                    break;
                }
                if (!bl) {
                    n5 = ByteArray.getInt(byArray, 1);
                    if (n5 != -1) {
                        nArray = new int[]{n5, -1};
                        stack.push(nArray);
                        bl = true;
                        n4 = n5;
                    }
                    if (!bl) {
                        if (stack.empty()) break;
                        nArray = (int[])stack.pop();
                        this.int.i.M.if(nArray[0]);
                        n7 = ByteArray.getInt(byArray, 5);
                        nArray[1] = nArray[1] + 1;
                        if (nArray[1] < n7) {
                            n6 = this.int.i.M.byte(nArray[1]);
                            n5 = ByteArray.getInt(byArray, n6 + 0);
                            stack.push(nArray);
                        } else {
                            n5 = ByteArray.getInt(byArray, 1);
                        }
                        if (n5 != -1) {
                            n4 = n5;
                            bl = true;
                        }
                    }
                }
                if (!bl) break;
            }
            n2 = n3;
            Object var15_12 = null;
            this.int.i.M.v = this.int.i.M.u;
            return n2;
        }
        catch (Throwable throwable) {
            Object var15_13 = null;
            this.int.i.M.v = this.int.i.M.u;
            throw throwable;
        }
    }
}

