// VCSampleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "VCSample.h"
#include "VCSampleDlg.h"
#include "VaxVoIP.h"
#include "HelpDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CVCSampleDlg dialog

CVCSampleDlg::CVCSampleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CVCSampleDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CVCSampleDlg)

	m_sProxyLoginId = _T("");
	m_sProxyLoginPwd = _T("");
	m_sProxyURI = _T("");
	m_sOutboundProxy = _T("");
	
	m_sPhoneNumber = _T("");
	m_bMicMute = FALSE;
	m_bSpkMute = FALSE;
	m_sWavFile = _T("");
	m_bStartRecording = FALSE;
	m_bEnableEchoNoiseCancel = TRUE;
	m_bEnableMicBoost = FALSE;
	m_bDonotDisturb = FALSE;
	m_bGSM610 = TRUE;
	m_biLBC = TRUE;
	m_bG711ALaw = TRUE;
	m_bG711ULaw = TRUE;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_pVaxVoIP = new CVaxVoIP;
	m_pVaxVoIP->m_pVCSampleDlg = this;

}

void CVCSampleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVCSampleDlg)
	DDX_Control(pDX, IDC_SLIDER_MIC, m_MicSlider);
	DDX_Control(pDX, IDC_SLIDER_SPEAKER, m_SpkSlider);
	DDX_Control(pDX, IDC_LIST_LOG, m_LogList);
	DDX_Text(pDX, IDC_EDIT_PROXY_LOGIN_ID, m_sProxyLoginId);
	DDX_Text(pDX, IDC_EDIT_PROXY_LOGIN_PWD, m_sProxyLoginPwd);
	DDX_Text(pDX, IDC_EDIT_PROXY_URI, m_sProxyURI);
	DDX_Text(pDX, IDC_EDIT_OUTBOUND_PROXY, m_sOutboundProxy);
	DDX_Text(pDX, IDC_EDIT_PHONE_NUMBER, m_sPhoneNumber);
	DDX_Check(pDX, IDC_CHECK_MIC_MUTE, m_bMicMute);
	DDX_Check(pDX, IDC_CHECK_SPK_MUTE, m_bSpkMute);
	DDX_Text(pDX, IDC_EDIT_FILE_NAME, m_sWavFile);
	DDX_Check(pDX, IDC_CHECK_START_RECORDING, m_bStartRecording);
	DDX_Check(pDX, IDC_CHECK_ECHO, m_bEnableEchoNoiseCancel);
	DDX_Check(pDX, IDC_CHECK_MIC_BOOST, m_bEnableMicBoost);
	DDX_Check(pDX, IDC_CHECK_DONOT_DISTURB, m_bDonotDisturb);
	DDX_Check(pDX, IDC_CHECK_GSM610, m_bGSM610);
	DDX_Check(pDX, IDC_CHECK_ILBC, m_biLBC);
	DDX_Check(pDX, IDC_CHECK_G711ALAW, m_bG711ALaw);
	DDX_Check(pDX, IDC_CHECK_G711ULAW, m_bG711ULaw);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CVCSampleDlg, CDialog)
	//{{AFX_MSG_MAP(CVCSampleDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_INIT, OnButtonInit)
	ON_BN_CLICKED(IDC_BUTTON_UNINIT, OnButtonUninit)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON_CLEAR, OnButtonClear)
	ON_BN_CLICKED(IDC_BUTTON_DIAL, OnButtonDial)
	ON_BN_CLICKED(IDC_BUTTON_ACCEPT, OnButtonAccept)
	ON_BN_CLICKED(IDC_BUTTON_REJECT, OnButtonReject)
	ON_BN_CLICKED(IDC_BUTTON_HANGUP, OnButtonHangup)
	ON_BN_CLICKED(IDC_BUTTON_1, OnButton1)
	ON_BN_CLICKED(IDC_BUTTON_2, OnButton2)
	ON_BN_CLICKED(IDC_BUTTON_3, OnButton3)
	ON_BN_CLICKED(IDC_BUTTON_4, OnButton4)
	ON_BN_CLICKED(IDC_BUTTON_5, OnButton5)
	ON_BN_CLICKED(IDC_BUTTON_6, OnButton6)
	ON_BN_CLICKED(IDC_BUTTON_7, OnButton7)
	ON_BN_CLICKED(IDC_BUTTON_8, OnButton8)
	ON_BN_CLICKED(IDC_BUTTON_9, OnButton9)
	ON_BN_CLICKED(IDC_BUTTON_10, OnButton10)
	ON_BN_CLICKED(IDC_BUTTON_11, OnButton11)
	ON_BN_CLICKED(IDC_BUTTON_12, OnButton12)
	ON_WM_HSCROLL()
	ON_BN_CLICKED(IDC_CHECK_SPK_MUTE, OnCheckSpkMute)
	ON_BN_CLICKED(IDC_CHECK_MIC_MUTE, OnCheckMicMute)
	ON_BN_CLICKED(IDC_BUTTON_RESET_RECORDING, OnButtonResetRecording)
	ON_BN_CLICKED(IDC_BUTTON_SAVE_TO_WAVE_FILE, OnButtonSaveToWaveFile)
	ON_BN_CLICKED(IDC_CHECK_START_RECORDING, OnCheckStartRecording)
	ON_BN_CLICKED(IDC_CHECK_ECHO, OnCheckEcho)
	ON_BN_CLICKED(IDC_CHECK_MIC_BOOST, OnCheckMicBoost)
	ON_BN_CLICKED(IDC_CHECK_DONOT_DISTURB, OnCheckDonotDisturb)
	ON_BN_CLICKED(IDC_CHECK_GSM610, OnCheckGsm610)
	ON_BN_CLICKED(IDC_CHECK_ILBC, OnCheckiLBC)
	ON_BN_CLICKED(IDC_CHECK_G711ALAW, OnCheckG711ALaw)
	ON_BN_CLICKED(IDC_CHECK_G711ULAW, OnCheckG711ULaw)
	ON_BN_CLICKED(IDC_BUTTON_HELP, OnButtonHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVCSampleDlg message handlers

BOOL CVCSampleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	m_SpkSlider.SetRange(0,10);
	m_MicSlider.SetRange(0,10);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CVCSampleDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

void CVCSampleDlg::OnOK() 
{
	// TODO: Add extra validation here
	//CDialog::OnOK();
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CVCSampleDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


void CVCSampleDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	if((CSliderCtrl*)pScrollBar == &m_SpkSlider)
	{
		if(TB_THUMBTRACK)
		{
			/***************************************************************
			SetSpkVolume method requires Volume value from 0 to 255 range    
			but the slider range is 0 to 10, so we multiply the slider value 
			to 25 to get the required value to pass to SetSpkVolume method   

							For more detail, please see the method details document
			*****************************************************************/
			
			m_pVaxVoIP->SetSpkVolume(m_SpkSlider.GetPos()	* 25);
		}

	}
	
	
	
	if((CSliderCtrl*)pScrollBar == &m_MicSlider)
	{
		if(TB_THUMBTRACK)
		{
			/***************************************************************
			SetMicVolume method requires Volume value from 0 to 255 range    
			but the slider range is 0 to 10, so we multiply the slider value 
			to 25 to get the required value to pass to SetMicVolume method   

							For more detail, please see the method details document
			*****************************************************************/
			
			m_pVaxVoIP->SetMicVolume(m_MicSlider.GetPos()	* 25);
		}

	}
		
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}



void CVCSampleDlg::OnButtonInit() 
{
	UpdateData();
	
	if(m_sProxyLoginId.IsEmpty())
	{
		MessageBox("Please enter the SIP proxy Login Id.", "SIP Proxy settings", MB_OK|MB_ICONEXCLAMATION);
		return;
	}

	if(m_sProxyURI.IsEmpty())
	{
		MessageBox("Please enter the SIP proxy address or URI.", "SIP Proxy settings", MB_OK|MB_ICONEXCLAMATION);
		return;
	}

	m_pVaxVoIP->SetLicenceKey("TRIAL-LICENSE-KEY");
	
	CString sMyIP = m_pVaxVoIP->GetMyIP();

	/***** Constructing SIP From URI for IP Telephony ***********/
	
	CString sFromURI = m_sProxyLoginId + " <sip:" + m_sProxyLoginId + "@" + sMyIP + ">";
	
	/********************************************************************
	
		Listen Port: default SIP port 5060.
 
		SIP Proxy: SIP Proxy IP or FQDN provided by your service provider.
  
		OutboundProxy: SIP outbound/NAT proxy IP or FQDN provided by your 
		             service provider to use SIP phone behind the NAT.

	*********************************************************************/	
 
	if(!m_pVaxVoIP->Initialize(5060, -1, -1, sFromURI, m_sOutboundProxy, m_sProxyURI, m_sProxyLoginId, m_sProxyLoginPwd))
	{
		m_pVaxVoIP->ErrorMessage();
	}
	else
	{
		
		m_bEnableEchoNoiseCancel = TRUE;
		m_bGSM610 = TRUE;
		m_biLBC = TRUE;
		m_bG711ALaw = TRUE;
		m_bG711ULaw = TRUE;
		
		UpdateData(FALSE);
		
		m_LogList.InsertItem(m_LogList.GetItemCount(), "Registering to SIP Proxy.");
		
		if(!m_pVaxVoIP->RegisterToProxy(5000))
			m_pVaxVoIP->ErrorMessage();
	}
	
}

void CVCSampleDlg::OnButtonUninit() 
{
	m_pVaxVoIP->UnInitialize();
}

void CVCSampleDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	delete m_pVaxVoIP;
}

void CVCSampleDlg::OnButtonClear() 
{
	m_LogList.DeleteAllItems();
}

void CVCSampleDlg::OnButtonDial() 
{
	UpdateData();

	if(m_sPhoneNumber.IsEmpty())
	{
		MessageBox("Please enter a phone number.", "Invalid phone number", MB_OK|MB_ICONEXCLAMATION);
		return;
	}

	/*******************************************************
         Constructing SIP To URI for IP Telephony:
                  sip:PhoneNumber@SIP Proxy
  ********************************************************/
	
	CString sToURI = "sip:" + m_sPhoneNumber + "@" + m_sProxyURI;
	
	CString sMyIP = m_pVaxVoIP->GetMyIP();
		
	if(!m_pVaxVoIP->Connect(sToURI, sMyIP, 7000))
	{
		m_pVaxVoIP->ErrorMessage();
	}
	else
	{
		m_LogList.InsertItem(m_LogList.GetItemCount(), "Dialing....");
	}
	
}

void CVCSampleDlg::OnButtonHangup() 
{
	if(!m_pVaxVoIP->Disconnect())
	{
		m_pVaxVoIP->ErrorMessage();
	}	
}


void CVCSampleDlg::OnButtonAccept() 
{
	CString sMyIP = m_pVaxVoIP->GetMyIP();
		
	if(!m_pVaxVoIP->AcceptCall(sMyIP, 7000))
	{
		m_pVaxVoIP->ErrorMessage();
	}
	else
	{
		CWnd* pWnd = GetDlgItem(IDC_STATIC_INBOUND_CALL);
		pWnd->SetWindowText("");
	}
}


void CVCSampleDlg::OnButtonReject() 
{
	if(!m_pVaxVoIP->RejectCall())
	{
		m_pVaxVoIP->ErrorMessage();
	}	
}


void CVCSampleDlg::OnButton1() 
{
	UpdateData();
	
	m_sPhoneNumber += "1";
	m_pVaxVoIP->DigitDTMF("1", 250); //250 milliseconds.
	
	UpdateData(FALSE);
	
}

void CVCSampleDlg::OnButton2() 
{
	UpdateData();
	
	m_sPhoneNumber += "2";
	m_pVaxVoIP->DigitDTMF("2", 250); //250 milliseconds.
	
	UpdateData(FALSE);
	
}

void CVCSampleDlg::OnButton3() 
{
	UpdateData();
	
	m_sPhoneNumber += "3";
	m_pVaxVoIP->DigitDTMF("3", 250); //250 milliseconds.
	
	UpdateData(FALSE);
}

void CVCSampleDlg::OnButton4() 
{
	UpdateData();
	
	m_sPhoneNumber += "4";
	m_pVaxVoIP->DigitDTMF("4", 250); //250 milliseconds.
	
	UpdateData(FALSE);
}

void CVCSampleDlg::OnButton5() 
{
	UpdateData();
	
	m_sPhoneNumber += "5";
	m_pVaxVoIP->DigitDTMF("5", 250); //250 milliseconds.
	
	UpdateData(FALSE);
}

void CVCSampleDlg::OnButton6() 
{
	UpdateData();
	
	m_sPhoneNumber += "6";
	m_pVaxVoIP->DigitDTMF("6", 250); //250 milliseconds.
	
	UpdateData(FALSE);
}

void CVCSampleDlg::OnButton7() 
{
	UpdateData();
	
	m_sPhoneNumber += "7";
	m_pVaxVoIP->DigitDTMF("7", 250); //250 milliseconds.
	
	UpdateData(FALSE);
}

void CVCSampleDlg::OnButton8() 
{
	UpdateData();
	
	m_sPhoneNumber += "8";
	m_pVaxVoIP->DigitDTMF("8", 250); //250 milliseconds.
	
	UpdateData(FALSE);
}

void CVCSampleDlg::OnButton9() 
{
	UpdateData();
	
	m_sPhoneNumber += "9";
	m_pVaxVoIP->DigitDTMF("9", 250); //250 milliseconds.
	
	UpdateData(FALSE);
}

void CVCSampleDlg::OnButton11() 
{
	UpdateData();
	
	m_sPhoneNumber += "0";
	m_pVaxVoIP->DigitDTMF("0", 250); //250 milliseconds.
	
	UpdateData(FALSE);
}

void CVCSampleDlg::OnButton10() 
{
	m_pVaxVoIP->DigitDTMF("*", 250); //250 milliseconds.
}


void CVCSampleDlg::OnButton12() 
{
	m_pVaxVoIP->DigitDTMF("#", 250); //250 milliseconds.
}



void CVCSampleDlg::OnCheckSpkMute() 
{
	UpdateData();
	m_pVaxVoIP->MuteSpk(m_bSpkMute);
}

void CVCSampleDlg::OnCheckMicMute() 
{
	UpdateData();
	m_pVaxVoIP->MuteMic(m_bMicMute);
}

void CVCSampleDlg::OnButtonResetRecording() 
{
	m_pVaxVoIP->ResetRecording();
}

void CVCSampleDlg::OnButtonSaveToWaveFile() 
{
	UpdateData();
	m_pVaxVoIP->SaveRecordingToWaveFile(m_sWavFile);
}

void CVCSampleDlg::OnCheckStartRecording() 
{
	UpdateData();
		
	if(m_bStartRecording)
		m_pVaxVoIP->StartRecording();
	else
		m_pVaxVoIP->StopRecording();
}

void CVCSampleDlg::OnCheckEcho() 
{
	UpdateData();
	
	if(m_bEnableEchoNoiseCancel)
		m_pVaxVoIP->EnableEchoNoiseCancellation();
	else
		m_pVaxVoIP->DisableEchoNoiseCancellation();
}


void CVCSampleDlg::OnCheckMicBoost() 
{
	UpdateData();
	
	if(m_bEnableMicBoost)
		m_pVaxVoIP->EnableMicBoost();
	else
		m_pVaxVoIP->DisableMicBoost();
}


void CVCSampleDlg::OnCheckDonotDisturb() 
{
	UpdateData();
	
	if(m_bDonotDisturb)
		m_pVaxVoIP->EnableDonotDisturb();
	else
		m_pVaxVoIP->DisableDonotDisturb();	
}

void CVCSampleDlg::OnSuccessToConnect()
{
	int nVol = m_pVaxVoIP->GetMicVolume();
	m_MicSlider.SetPos(nVol/25);

	nVol = m_pVaxVoIP->GetSpkVolume();
	m_SpkSlider.SetPos(nVol/25);
	
	m_bEnableMicBoost = m_pVaxVoIP->IsMicBoostEnable();

	UpdateData(FALSE);
}

void CVCSampleDlg::OnCheckGsm610() 
{
	/**** Codec No 0 represents GSM 6.10 *****/
	
	UpdateData();
	
	if(m_bGSM610)
		m_pVaxVoIP->SelectVoiceCodec(0);
	else
		m_pVaxVoIP->DeselectVoiceCodec(0);	
}

void CVCSampleDlg::OnCheckiLBC() 
{
	/**** Codec No 1 represents iLBC ********/
	
	UpdateData();
	
	if(m_biLBC)
		m_pVaxVoIP->SelectVoiceCodec(1);
	else
		m_pVaxVoIP->DeselectVoiceCodec(1);
	
}

void CVCSampleDlg::OnCheckG711ALaw() 
{
	/**** Codec No 2 represents GSM711 A-Law *****/
	
	UpdateData();
		
	if(m_bG711ALaw)
		m_pVaxVoIP->SelectVoiceCodec(2);
	else
		m_pVaxVoIP->DeselectVoiceCodec(2);

}

void CVCSampleDlg::OnCheckG711ULaw() 
{
	/**** Codec No 3 represents GSM711 U-Law *****/
	
	UpdateData();
		
	if(m_bG711ULaw)
		m_pVaxVoIP->SelectVoiceCodec(3);
	else
		m_pVaxVoIP->DeselectVoiceCodec(3);
}

void CVCSampleDlg::OnButtonHelp() 
{
	CHelpDlg HelpDlg;
	HelpDlg.DoModal();
}
