package test.db;

import org.aris.hldb.CS;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: CustomerDemographics<P>
 *
 * hldbBase template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework.<P>
 *
 * This class template creates classes which query the database using the hldb package. This package
 * uses stored procedures to perform any database operations. See the examples of OODB in order
 * to create a valid configuration file and generate database classes.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
class CustomerDemographicsBase implements Cloneable {
    // dirty bit
    protected boolean isDirty = false;

    // Connection
    protected CS cs;

    // ============================================================================
    // =       Variable declaration, according to table columns.                  =
    // ============================================================================
    protected String CustomerTypeID;
    protected String old_CustomerTypeID; // Old value of the key is kept too
    protected String CustomerDesc;

    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * default constructor, protected.
     */
    protected CustomerDemographicsBase() {
    }

    /**
     * use this to create a new row by calling the setters and then insert().
     */
    public CustomerDemographicsBase(CS cs) {
        this.cs = cs;
    }

    /**
     * Get from primary key(s), queries the database
     */
    public CustomerDemographicsBase(CS cs, String CustomerTypeID)
        throws SQLException {
        this.cs = cs;

        CallableStatement cc = null;
        ResultSet rs = null;

        try {
            cc = cs.allocCS("SELECT_CustomerDemographicsBase");

            cc.setString(1, CustomerTypeID);

            rs = cc.executeQuery();
            rs.next();
            setFromRs(rs);
        } finally {
            if (rs != null) {
                rs.close();
            }

            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *)
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public CustomerDemographicsBase(CS cs, java.sql.ResultSet rs)
        throws java.sql.SQLException {
        this.cs = cs;
        setFromRs(rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        CustomerTypeID = old_CustomerTypeID = rs.getString("CustomerTypeID");
        CustomerDesc = rs.getString("CustomerDesc");
    }

    // ============================================================================
    // =                  Setters and getters                                     =
    // ============================================================================

    /**
     * Getter for CustomerTypeID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getCustomerTypeID() {
        return CustomerTypeID;
    }

    /**
     * Setter for CustomerTypeID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setCustomerTypeID(String value) {
        this.CustomerTypeID = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of CustomerDemographicsBase's by querying table field CustomerTypeID
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfCustomerTypeID(
        int maxResults) throws SQLException {
        return getResultSetWithCustomerTypeIDValueOf(cs, getCustomerTypeID(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of CustomerDemographicsBase's by querying table field CustomerTypeID
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithCustomerTypeIDValueOf(
        CS cs, String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SELECT_CustomerDemographicsBase_CustomerTypeID");
        cc.setMaxRows(maxResults);

        try {
            cc.setString(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of CustomerDemographicsBase's by querying table field CustomerTypeID
     * for equality with the same CustomerTypeID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCustomerTypeID(int maxResults)
        throws SQLException {
        return getLinkedListWithCustomerTypeIDValueOf(cs, getCustomerTypeID(),
            maxResults);
    }

    /**
     * Gets a LinkedList of CustomerDemographicsBase's by querying table field CustomerTypeID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCustomerTypeIDValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCustomerTypeIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new CustomerDemographicsBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of CustomerDemographicsBase's by querying table field CustomerTypeID
     * for equality with the same CustomerTypeID as this instance.
     */
    public Iterator getIteratorWithSameValueOfCustomerTypeID(int maxResults)
        throws SQLException {
        return getIteratorWithCustomerTypeIDValueOf(cs, getCustomerTypeID(),
            maxResults);
    }

    /**
     * Gets an Iterator of CustomerDemographicsBase's by querying table field CustomerTypeID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCustomerTypeIDValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithCustomerTypeIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for CustomerDesc.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getCustomerDesc() {
        return CustomerDesc;
    }

    /**
     * Setter for CustomerDesc.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setCustomerDesc(String value) {
        this.CustomerDesc = value;
        isDirty = true;
    }

    /**
     * Free a callable statement that was returned by any of the class's members
     */
    public void freeCS(CallableStatement callableStatement) {
        cs.freeCS(callableStatement);
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Delete the current object from database
     */
    public int delete() throws SQLException {
        return CustomerDemographicsBase.delete(cs, CustomerTypeID);
    }

    /**
     * Delete an row from database
     */
    public static int delete(CS cs, String CustomerTypeID)
        throws SQLException {
        CallableStatement cc = null;
        int res = 0;

        try {
            cc = cs.allocCS("DELETE_CustomerDemographicsBase");

            cc.setString(1, CustomerTypeID);

            res = cc.executeUpdate();
        } finally {
            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
        return res;
    }

    /**
     * Update the current object to the database (primary keys/autoincrements are not updated)
     */
    public int update() throws SQLException {
        if (isDirty) {
            CallableStatement cc = null;
            int res = 0;

            try {
                cc = cs.allocCS("UPDATE_CustomerDemographicsBase");

                cc.setString(1, getCustomerDesc());

                cc.setString(2, getCustomerTypeID());

                res = cc.executeUpdate();
                isDirty = false;
            } finally {
                cs.freeCS(cc);
            }

            // template/debug was set to >0 during conversion
            return res;
        }

        return -1;
    }

    private void updateOldKeys() {
        // update the old_x old key values
        old_CustomerTypeID = CustomerTypeID;
    }

    /**
     * Updates the object to the database, even the primary keys are updated (but not the autoincrements or autoincr PK's)
     */
    public int updateAll() throws SQLException {
        if (isDirty) {
            CallableStatement cc = null;
            int res = 0;

            try {
                cc = cs.allocCS("UPDATEALL_CustomerDemographicsBase");

                cc.setString(1, getCustomerTypeID());

                cc.setString(2, getCustomerDesc());

                cc.setString(3, old_CustomerTypeID);

                res = cc.executeUpdate();
                isDirty = false;
            } finally {
                cs.freeCS(cc);
            }

            // template/debug was set to >0 during conversion
            updateOldKeys();

            return res;
        }

        return -1;
    }

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        CallableStatement cc = null;

        try {
            cc = cs.allocCS("INSERT_CustomerDemographicsBase");

            cc.setString(1, getCustomerTypeID());

            cc.setString(2, getCustomerDesc());

            cc.executeUpdate();

            updateOldKeys();

            isDirty = false;
        } finally {
            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    public void dump(String prefix) {
        System.out.println(prefix + "CustomerTypeID:" + getCustomerTypeID());

        System.out.println(prefix + "CustomerDesc:" + getCustomerDesc());
    }

    public void dump() {
        dump("");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();

        sb.append(CustomerTypeID);
        sb.append(",");
        sb.append(CustomerDesc);

        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
