package test.db;

import org.aris.hldb.CS;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: Current Product List<P>
 *
 * hldbBase template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework.<P>
 *
 * This class template creates classes which query the database using the hldb package. This package
 * uses stored procedures to perform any database operations. See the examples of OODB in order
 * to create a valid configuration file and generate database classes.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
class Current_Product_ListBase implements Cloneable {
    // dirty bit
    protected boolean isDirty = false;

    // Connection
    protected CS cs;

    // ============================================================================
    // =       Variable declaration, according to table columns.                  =
    // ============================================================================
    protected int ProductID;
    protected String ProductName;

    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * default constructor, protected.
     */
    protected Current_Product_ListBase() {
    }

    /**
     * use this to create a new row by calling the setters and then insert().
     */
    public Current_Product_ListBase(CS cs) {
        this.cs = cs;
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *)
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public Current_Product_ListBase(CS cs, java.sql.ResultSet rs)
        throws java.sql.SQLException {
        this.cs = cs;
        setFromRs(rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        ProductID = rs.getInt("ProductID");
        ProductName = rs.getString("ProductName");
    }

    // ============================================================================
    // =                  Setters and getters                                     =
    // ============================================================================

    /**
     * Getter for ProductID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public int getProductID() {
        return ProductID;
    }

    /**
     * Setter for ProductID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    protected void setProductID(int value) {
        this.ProductID = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Current_Product_ListBase's by querying table field ProductID
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfProductID(
        int maxResults) throws SQLException {
        return getResultSetWithProductIDValueOf(cs, getProductID(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Current_Product_ListBase's by querying table field ProductID
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithProductIDValueOf(CS cs,
        int value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SELECT_Current_Product_ListBase_ProductID");
        cc.setMaxRows(maxResults);

        try {
            cc.setInt(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Current_Product_ListBase's by querying table field ProductID
     * for equality with the same ProductID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfProductID(int maxResults)
        throws SQLException {
        return getLinkedListWithProductIDValueOf(cs, getProductID(), maxResults);
    }

    /**
     * Gets a LinkedList of Current_Product_ListBase's by querying table field ProductID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithProductIDValueOf(CS cs,
        int value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithProductIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Current_Product_ListBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Current_Product_ListBase's by querying table field ProductID
     * for equality with the same ProductID as this instance.
     */
    public Iterator getIteratorWithSameValueOfProductID(int maxResults)
        throws SQLException {
        return getIteratorWithProductIDValueOf(cs, getProductID(), maxResults);
    }

    /**
     * Gets an Iterator of Current_Product_ListBase's by querying table field ProductID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithProductIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        return getLinkedListWithProductIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for ProductName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getProductName() {
        return ProductName;
    }

    /**
     * Setter for ProductName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setProductName(String value) {
        this.ProductName = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Current_Product_ListBase's by querying table field ProductName
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfProductName(
        int maxResults) throws SQLException {
        return getResultSetWithProductNameValueOf(cs, getProductName(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Current_Product_ListBase's by querying table field ProductName
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithProductNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SELECT_Current_Product_ListBase_ProductName");
        cc.setMaxRows(maxResults);

        try {
            cc.setString(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Current_Product_ListBase's by querying table field ProductName
     * for equality with the same ProductName as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfProductName(int maxResults)
        throws SQLException {
        return getLinkedListWithProductNameValueOf(cs, getProductName(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Current_Product_ListBase's by querying table field ProductName
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithProductNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithProductNameValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Current_Product_ListBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Current_Product_ListBase's by querying table field ProductName
     * for equality with the same ProductName as this instance.
     */
    public Iterator getIteratorWithSameValueOfProductName(int maxResults)
        throws SQLException {
        return getIteratorWithProductNameValueOf(cs, getProductName(),
            maxResults);
    }

    /**
     * Gets an Iterator of Current_Product_ListBase's by querying table field ProductName
     * for equality with the "value".
     */
    public static Iterator getIteratorWithProductNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithProductNameValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Free a callable statement that was returned by any of the class's members
     */
    public void freeCS(CallableStatement callableStatement) {
        cs.freeCS(callableStatement);
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        CallableStatement cc = null;

        ResultSet rs = null;

        try {
            cc = cs.allocCS("INSERT_Current_Product_ListBase");

            cc.setString(1, getProductName());

            rs = cc.executeQuery();
            rs.next();

            setProductID(rs.getInt(1));

            isDirty = false;
        } finally {
            if (rs != null) {
                rs.close();
            }

            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    public void dump(String prefix) {
        System.out.println(prefix + "ProductID:" + getProductID());

        System.out.println(prefix + "ProductName:" + getProductName());
    }

    public void dump() {
        dump("");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();

        sb.append(ProductID);
        sb.append(",");
        sb.append(ProductName);

        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
