<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "<xsl:text><![CDATA[ ]]></xsl:text>">
	<!ENTITY nl "<xsl:text><![CDATA[
]]></xsl:text>">
	<!ENTITY copylogo "&#169;">
]>
<!--
	This template is used as the base for making custom class templates for databases.
	
	Author : Konstantine Kougios
	Version: 0.9Beta

-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text" indent="yes" encoding="UTF-8" omit-xml-declaration="yes"/>

<xsl:template match="ROOT">
<!--
	==================================================================================================================
	Start of the template
	==================================================================================================================
-->
# ========================================================================
# <xsl:value-of select="//CLASSINFO/@tableName"/>: Queries.
# SELECT , INSERT and UPDATE Queries for <xsl:value-of select="//CLASSINFO/@tableName"/>
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================

<!--
	==================================================================================================================
	SELECT
	==================================================================================================================
-->
[SELECT_<xsl:value-of select="//CLASSNAME"/>]
{
SELECT * FROM [<xsl:value-of select="//CLASSINFO/@tableName"/>] 
<xsl:if test="count(PRIMARYKEYS/KEY)>0">WHERE
<xsl:for-each select="PRIMARYKEYS/KEY">
	<xsl:if test="position()>1"> AND </xsl:if>[<xsl:value-of select="@column"/>]=?
</xsl:for-each></xsl:if>}
<xsl:for-each select="PRIMARYKEYS/KEY/COLUMN">
	<xsl:value-of select="@dbTypeDef"/>&nl;
</xsl:for-each>

<!--
	==================================================================================================================
	INSERT
	==================================================================================================================
-->
[INSERT_<xsl:value-of select="//CLASSNAME"/>]
{
<xsl:if test="count(COLUMN[@identity='1'])>0">	
-- we will use a transaction in order for identity to be correctly read
begin transaction
</xsl:if>
INSERT INTO [<xsl:value-of select="//CLASSINFO/@tableName"/>]
(<xsl:for-each select="COLUMN[@identity='0' and @dbType!='timestamp']">
	<xsl:if test="position()!=1">,</xsl:if>[<xsl:value-of select="@name"/>]
</xsl:for-each>) 
	VALUES(<xsl:for-each select="COLUMN[@identity='0' and @dbType!='timestamp']"><xsl:if test="position()!=1">,</xsl:if>?</xsl:for-each>)

<xsl:if test="count(COLUMN[@identity='1'])>0">	
SELECT @@IDENTITY
commit transaction
</xsl:if>
}
<xsl:for-each select="COLUMN[@identity='0' and @dbType!='timestamp']">
	<xsl:value-of select="@dbTypeDef"/>&nl;
</xsl:for-each>

<!--
	==================================================================================================================
	UPDATE & UPDATEALL(including non autoincr pk's)
	==================================================================================================================
-->
<!-- UPDATE -->
<xsl:if test="count(COLUMN[@primaryKey='' and @identity='0' and @dbType!='timestamp'])>0">
[UPDATE_<xsl:value-of select="//CLASSNAME"/>]
{
UPDATE [<xsl:value-of select="//CLASSINFO/@tableName"/>] 
SET <xsl:for-each select="COLUMN[@primaryKey='' and @identity='0' and @dbType!='timestamp']"><xsl:if test="position()!=1">,</xsl:if>[<xsl:value-of select="@name"/>]=?</xsl:for-each>
<xsl:if test="count(PRIMARYKEYS/KEY)>0">
	WHERE <xsl:for-each select="PRIMARYKEYS/KEY"><xsl:if test="position()>1"> AND </xsl:if>[<xsl:value-of select="@column"/>]=?</xsl:for-each></xsl:if>
}
<xsl:for-each select="COLUMN[@primaryKey='' and @identity='0' and @dbType!='timestamp']">
	<xsl:value-of select="@dbTypeDef"/>&nl;
</xsl:for-each>
	<xsl:for-each select="PRIMARYKEYS/KEY/COLUMN">
	<xsl:value-of select="@dbTypeDef"/>&nl;
</xsl:for-each>
</xsl:if>
<!-- UPDATE ALL -->
<xsl:if test="count(COLUMN[@identity='0' and @dbType!='timestamp'])>0 and count(COLUMN[@identity='0'])>count(COLUMN[@primaryKey='' and @identity='0'])">
[UPDATEALL_<xsl:value-of select="//CLASSNAME"/>]
{
UPDATE [<xsl:value-of select="//CLASSINFO/@tableName"/>] 
SET <xsl:for-each select="COLUMN[@identity='0' and @dbType!='timestamp']"><xsl:if test="position()!=1">,</xsl:if>[<xsl:value-of select="@name"/>]=?</xsl:for-each>
<xsl:if test="count(PRIMARYKEYS/KEY)>0">
	WHERE <xsl:for-each select="PRIMARYKEYS/KEY"><xsl:if test="position()>1"> AND </xsl:if>[<xsl:value-of select="@column"/>]=?</xsl:for-each></xsl:if>
}
<xsl:for-each select="COLUMN[@identity='0' and @dbType!='timestamp']">
	<xsl:value-of select="@dbTypeDef"/>&nl;
</xsl:for-each>
	<xsl:for-each select="PRIMARYKEYS/KEY/COLUMN">
	<xsl:value-of select="@dbTypeDef"/>&nl;
</xsl:for-each>
</xsl:if>

<!--
	==================================================================================================================
	DELETE
	==================================================================================================================
-->
<xsl:if test="count(PRIMARYKEYS/KEY)>0">
[DELETE_<xsl:value-of select="//CLASSNAME"/>]
{
DELETE FROM [<xsl:value-of select="//CLASSINFO/@tableName"/>] 
WHERE
<xsl:for-each select="PRIMARYKEYS/KEY">
	<xsl:if test="position()>1"> AND </xsl:if>[<xsl:value-of select="@column"/>]=?
</xsl:for-each>}
<xsl:for-each select="PRIMARYKEYS/KEY/COLUMN">
	<xsl:value-of select="@dbTypeDef"/>&nl;
</xsl:for-each>
</xsl:if>

<!--
	==================================================================================================================
	Getters for multiple results
	==================================================================================================================
-->
<xsl:for-each select="COLUMN[@dbType!='text' and @dbType!='ntext' and @javaType!='java.io.InputStream']">
# SELECT for <xsl:value-of select="//CLASSNAME"/>.<xsl:value-of select="@name"/>
[SELECT_<xsl:value-of select="//CLASSNAME"/>_<xsl:value-of select="@name"/>]
{
	SELECT * FROM [<xsl:value-of select="//CLASSINFO/@tableName"/>] WHERE [<xsl:value-of select="@name"/>]=?
}
<xsl:value-of select="@dbTypeDef"/>
</xsl:for-each>
<!--
	==================================================================================================================
	End of the template
	==================================================================================================================
-->

</xsl:template>

</xsl:stylesheet>