/*
 * Decompiled with CFR 0.152.
 */
package org.aris.oodb.db;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import org.aris.dbutils.ColumnInfo;
import org.aris.oodb.db.DbColumnConvert;
import org.aris.oodb.db.DbI;

public class SqlServer
implements DbI {
    private static TreeMap tm = new TreeMap();
    private static Hashtable mapTypes = new Hashtable();

    static {
        mapTypes.put(new Integer(-7), "java.sql.Types.BIT");
        mapTypes.put(new Integer(-4), "java.sql.Types.BLOB");
        mapTypes.put(new Integer(-1), "java.sql.Types.LONGVARCHAR");
        mapTypes.put(new Integer(1), "java.sql.Types.VARCHAR");
        mapTypes.put(new Integer(3), "java.sql.Types.NUMERIC");
        mapTypes.put(new Integer(4), "java.sql.Types.INTEGER");
        mapTypes.put(new Integer(5), "java.sql.Types.SMALLINT");
        mapTypes.put(new Integer(-6), "java.sql.Types.TINYINT");
        mapTypes.put(new Integer(-5), "java.sql.Types.BIGINT");
        mapTypes.put(new Integer(7), "java.sql.Types.REAL");
        mapTypes.put(new Integer(12), "java.sql.Types.VARCHAR");
        mapTypes.put(new Integer(93), "java.sql.Types.DATE");
        mapTypes.put(new Integer(-3), "java.sql.Types.VARBINARY");
        mapTypes.put(new Integer(-2), "java.sql.Types.TIMESTAMP");
        mapTypes.put(new Integer(2), "java.sql.Types.NUMERIC");
        mapTypes.put(new Integer(6), "java.sql.Types.FLOAT");
    }

    public void dumpTypes() {
        System.out.println("\n-------------- DB types found ----------------");
        Iterator it = tm.keySet().iterator();
        while (it.hasNext()) {
            Integer dt = (Integer)it.next();
            DbColumnConvert dbcc = (DbColumnConvert)tm.get(dt);
            System.out.println(dt + "======>");
            dbcc.getCi().dump();
        }
    }

    public DbColumnConvert getJavaType(ColumnInfo ci) {
        boolean nullable = ci.getNULLABLE() == 1;
        DbColumnConvert dbcc = new DbColumnConvert();
        dbcc.setCi(ci);
        String typeName = ci.getTYPE_NAME().replaceAll(" identity", "");
        dbcc.setDbTypeDef(typeName);
        dbcc.setDbType(typeName);
        String mapType = (String)mapTypes.get(new Integer(ci.getDATA_TYPE()));
        if (mapType != null) {
            dbcc.setJava_sql_type(mapType);
        } else {
            System.err.println("WARNING: Type " + ci.getDATA_TYPE() + "/" + ci.getCOLUMN_DEF() + " has no mapping!");
        }
        tm.put(new Integer(ci.getDATA_TYPE()), dbcc);
        switch (ci.getDATA_TYPE()) {
            case -4: 
            case -3: 
            case -2: {
                dbcc.setToXMLAttribute(2);
                dbcc.setJavaType("java.io.InputStream");
                dbcc.setResultSetCall("BinaryStream");
                if (!typeName.equals("binary") && !typeName.equals("varbinary")) break;
                dbcc.setDbTypeDef(String.valueOf(typeName) + "(" + ci.getCOLUMN_SIZE() + ")");
                break;
            }
            case -7: {
                if (!nullable) {
                    dbcc.setJavaType("boolean");
                } else {
                    dbcc.setJavaType("Boolean");
                    dbcc.setAllocate(true);
                    dbcc.setConvertorToPrimitive(".booleanValue()");
                }
                dbcc.setResultSetCall("Boolean");
                break;
            }
            case -6: 
            case 5: {
                if (!nullable) {
                    dbcc.setJavaType("short");
                } else {
                    dbcc.setJavaType("Short");
                    dbcc.setAllocate(true);
                    dbcc.setConvertorToPrimitive(".shortValue()");
                }
                dbcc.setResultSetCall("Short");
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                dbcc.setToXMLAttribute(1);
                dbcc.setJavaType("String");
                dbcc.setResultSetCall("String");
                if (!typeName.equals("nvarchar") && !typeName.equals("nchar") && !typeName.equals("char") && !typeName.equals("varchar")) break;
                dbcc.setDbTypeDef(String.valueOf(typeName) + "(" + ci.getCOLUMN_SIZE() + ")");
                break;
            }
            case 3: {
                if (!nullable) {
                    dbcc.setJavaType("double");
                } else {
                    dbcc.setJavaType("Double");
                    dbcc.setAllocate(true);
                    dbcc.setConvertorToPrimitive(".doubleValue()");
                }
                dbcc.setResultSetCall("Double");
                break;
            }
            case 6: 
            case 7: {
                if (!nullable) {
                    dbcc.setJavaType("float");
                } else {
                    dbcc.setJavaType("Float");
                    dbcc.setAllocate(true);
                    dbcc.setConvertorToPrimitive(".floatValue()");
                }
                dbcc.setResultSetCall("Float");
                break;
            }
            case 4: {
                if (!nullable) {
                    dbcc.setJavaType("int");
                } else {
                    dbcc.setJavaType("Integer");
                    dbcc.setAllocate(true);
                    dbcc.setConvertorToPrimitive(".intValue()");
                }
                dbcc.setResultSetCall("Int");
                break;
            }
            case -5: {
                if (!nullable) {
                    dbcc.setJavaType("long");
                } else {
                    dbcc.setJavaType("Long");
                    dbcc.setAllocate(true);
                    dbcc.setConvertorToPrimitive(".longValue()");
                }
                dbcc.setResultSetCall("Long");
                break;
            }
            case 93: {
                dbcc.setJavaType("java.sql.Date");
                dbcc.setResultSetCall("Date");
                break;
            }
            default: {
                dbcc.setToXMLAttribute(2);
                dbcc.setJavaType(ci.getTYPE_NAME());
                dbcc.setResultSetCall("OODB:UNKNOWN database TYPE");
                System.err.println("SqlServer DbI: Unkown type [" + ci.getTYPE_NAME() + "] with DATA_TYPE=" + ci.getDATA_TYPE() + " at table " + ci.getTABLE_NAME());
            }
        }
        return dbcc;
    }

    public boolean isIdentity(ColumnInfo ci) {
        return ci.getTYPE_NAME().endsWith("identity");
    }

    public boolean isSystemObject(String objName) {
        return objName.equals("dtproperties") | objName.equals("sysconstraints") | objName.equals("syssegments");
    }
}

