//
//  XTBannerContainerView.m
//  XTads
//
//  Created by Rune Berg on 25/12/15.
//  Copyright © 2015 Rune Berg. All rights reserved.
//

#import "XTBannerContainerView.h"
#import "XTLogger.h"
#import "XTAllocDeallocCounter.h"


@interface XTBannerContainerView()

@property NSString *debugName;

@end


@implementation XTBannerContainerView

static XTLogger* logger;
static NSUInteger instanceCount = 0;

+ (void)initialize
{
	logger = [XTLogger loggerForClass:[XTBannerContainerView class]];
}

OVERRIDE_ALLOC_FOR_COUNTER
OVERRIDE_DEALLOC_FOR_COUNTER

- (instancetype)initWithFrame:(NSRect)frameRect
{
	XT_DEF_SELNAME;

	XTBannerContainerView *view = [super initWithFrame:frameRect];
	if (view != nil) {
		_debugName = [NSString stringWithFormat:@"XTBannerContainerView %lu", instanceCount];
		instanceCount += 1;
		
		NSAutoresizingMaskOptions newAMO = NSViewHeightSizable | NSViewWidthSizable;
		[self setAutoresizingMask:newAMO];
		
		[self setTranslatesAutoresizingMaskIntoConstraints:NO];
	}
	XT_TRACE_1(@"%@", _debugName);
	return view;
}

@end
