#charset "us-ascii"
/* 
 *  Copyright (c) 2006 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the TADS 3 Relation Library Extension
 *
 *  operatons.t
 *
 *--------------------------------------------------------------------
 *  THE TADS 3 RELATION OPERATIONS FILE
 *--------------------------------------------------------------------
 */

#include "relation.h"

/*
 *  A function for Complements
 */
Not(set, [sets])
{
    return set.complement(sets...);
}

/*
 *  A function for Disjunctions
 */
Or([sets])
{
    return sets.car().union(sets.cdr()...);
}

/*
 *  A function for Conjunctions
 */
And([sets])
{
    return sets.car().intersect(sets.cdr()...);
}

/*
 *  A function for Exclusive Disjunctions
 */
Xor(p, q)
{
    local pSet, qSet, uPset, uQset;

    if (dataType(p) == TypeList)
    {
        switch(p.length())
        {
            case 2:
                uPset   = p[2];

            case 1: 
                pSet    = p[1];
                break;

            default:
                throw new XorError('Invalid Xor \'p\' parameter. ');
        }
    }
    else if (dataType(p) == TypeObject
        && p.ofKind(SetObject))
    {
        local f;
        pSet    = p;
        for (local r = firstObj(SetObject, ObjAll), f = r; r != nil; 
            r = nextObj(r, SetObject, ObjAll))
        {
            if (f == r)
                uPset   = r.createCopy();
            else uPset  = Or(r, uPset);
        }
    }
    else throw new XorError('Invalid Xor \'p\' parameter. ');

    if (dataType(q) == TypeList)
    {
        switch(q.length())
        {
            case 2:
                uQset   = q[2];

            case 1: 
                qSet    = q[1];
                break;

            default:
                throw new XorError('Invalid Xor \'q\' parameter. ');
        }
    }
    else if (dataType(q) == TypeObject
        && q.ofKind(SetObject))
    {
        local f;
        qSet    = q;
        for (local r = firstObj(SetObject, ObjAll), f = r; r != nil; 
            r = nextObj(r, SetObject, ObjAll))
        {
            if (f == r)
                uQset   = r.createCopy();
            else uQset  = Or(r, uQset);
        }
    }
    else throw new XorError('Invalid Xor \'q\' parameter. ');

    return Or(And(pSet, Not(qSet, uQset)),
        And(Not(pSet, uPset), qSet));
}

/*
 *  A base class for Xor Errors
 */
class XorError: RuntimeError
{
    construct(msg)
    {
        exceptionMessage = msg;
        inherited(0);
    }
}