//
//  XTGameRunnerProtocol.h
//  TadsTerp
//
//  Created by Rune Berg on 19/03/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//
//  ------------------------------------------------------
//  The methods used by osxtads.m to interact with
//  the user interface.
//  ------------------------------------------------------
//

#include "os.h"
#import <Foundation/Foundation.h>
#import "XTGameInputEvent.h"


@class XTBannerHandler;

typedef NS_ENUM(NSInteger, XTadsInputDialogIconId) {
	XTadsInputDialogIconIdNone,
	XTadsInputDialogIconIdWarning,
	XTadsInputDialogIconIdInfo,
	XTadsInputDialogIconIdQuestion,
	XTadsInputDialogIconIdError
};

typedef NS_ENUM(NSInteger, XTadsFileNameDialogFileType) {
	XTadsFileNameDialogFileTypeSavedGame,
	XTadsFileNameDialogFileTypeTranscript,
	XTadsFileNameDialogFileTypeCommandScript,
	XTadsFileNameDialogFileTypeGeneral
};

@protocol XTGameRunnerProtocol <NSObject>

@property BOOL htmlMode;
@property (nonatomic) NSInteger statusMode;
@property BOOL nonstopMode;
@property BOOL isSleeping;

- (void)setHiliteMode:(BOOL)hiliteMode;

- (BOOL)showTerpCopyrightAtGameStart;

- (void)setTads2InternalCharSet:(NSString*)charSet;

- (NSString *)makeString:(const char *)str;

- (NSString *)makeString:(const char *)str len:(size_t)len;

- (const char*)makeCStringInteractive:(NSString *)string;

- (const char*)makeCStringQuiet:(NSString *)string;

- (void)printOutput:(NSString *)s;

- (void)flushOutput;

- (void)showScore:(NSString *)scoreString;

- (void)waitForEvent:(XTGameInputEvent *)event;

- (NSUInteger)waitForAnyKeyPressed;

- (void)showMorePromptAndWaitForKeyPressed;

- (NSString *)waitForCommand;

- (void)sleepFor:(double)seconds;

- (void)clearScreen;

- (void)setGameTitle:(NSString *)title;

- (NSUInteger) inputDialogWithTitle:title
				standardButtonSetId:(NSUInteger)standardButtonSetId
				  customButtomSpecs:(NSArray *)customButtomSpecs
					   defaultIndex:(NSUInteger)defaultIndex
						cancelIndex:(NSUInteger)cancelIndex
							 iconId:(XTadsInputDialogIconId)iconId;

- (NSURL *)getFileNameForFor:(XTadsFileNameDialogFileType)fileType
				 dialogTitle:(NSString *)dialogTitle
		 fileTypeDescription:(NSString *)fileTypeDescription
		   allowedExtensions:(NSArray *)allowedExtensions
				existingFile:(BOOL)existingFile;

//------ Banner API: --------

- (void *)bannerCreate:(void *)parent
				 where:(NSInteger)where
				 other:(void *)other
			   wintype:(NSInteger)wintype //TODO unsigned
				 align:(NSInteger)align   //TODO unsigned
				  size:(NSInteger)size    //TODO unsigned
			 sizeUnits:(NSInteger)sizeUnits  //TODO unsigned
				 style:(NSUInteger)style;

- (void *)bannerCreate:(void *)parent
				 tagId:(NSString *)tagId
				 where:(NSInteger)where
				 other:(void *)other
			   wintype:(NSInteger)wintype //TODO unsigned
				 align:(NSInteger)align   //TODO unsigned
				  size:(NSInteger)size    //TODO unsigned
			 sizeUnits:(NSInteger)sizeUnits  //TODO unsigned
				 style:(NSUInteger)style;

- (void)tagBannerReconfigure:(void *)handle
					   align:(NSUInteger)align
			  sizeToContents:(BOOL)sizeToContents
			  sizeAsPrevious:(BOOL)sizeAsPrevious
						size:(NSUInteger)size
				   sizeUnits:(NSUInteger)sizeUnits
					   style:(NSUInteger)style;

- (void *)bannerHandleForTagId:(NSString *)tagId;

- (XTBannerHandler *)bannerHandlerForHandle:(void *)handle;

- (void)bannerDelete:(void *)banner_handle;

- (void)bannerDeleteAll;

- (void)bannerOrphan:(void *)banner_handle;

- (BOOL)bannerInfo:(void *)banner_handle
			  info:(os_banner_info_t *)info;

- (NSUInteger)bannerWidthInChars:(void *)banner_handle;

- (NSUInteger)bannerHeightInChars:(void *)banner_handle;

- (void)bannerDisplay:(void *)banner_handle
				 text:(NSString *)text;

- (void)bannerFlush:(void *)banner_handle;

- (void)bannerSetHtmlMode:(void *)banner_handle
					   on:(BOOL)on;

- (void)bannerClear:(void *)banner_handle;

- (void)bannerSetSize:(void *)banner_handle
				 size:(NSUInteger)size
			sizeUnits:(NSUInteger)sizUnits
		   isAdvisory:(BOOL)isAdvisory;

- (void)bannerSizeToContents:(void *)banner_handle;

- (void)bannerGoto:(void *)banner_handle
			   row:(NSUInteger)row
			column:(NSUInteger)column;

@end

