//
//  XTAllocDeallocCounter.h
//  XTads
//
//  Created by Rune Berg on 08/07/2017.
//  Copyright © 2017 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface XTAllocDeallocCounter : NSObject

+ (instancetype)instance;

- (void)countAllocOf:(id)object;

- (void)countDeallocOf:(id)object;

+ (void)showStats;

+ (void)showStatsFiltered;

@end


#define OVERRIDE_ALLOC_FOR_COUNTER \
+ (instancetype)alloc \
{ \
	[[XTAllocDeallocCounter instance] countAllocOf:self]; \
	return [super alloc]; \
}

#define OVERRIDE_DEALLOC_FOR_COUNTER \
- (void)dealloc \
{ \
	[[XTAllocDeallocCounter instance] countDeallocOf:self]; \
}
