#include <adv.t>
#include <std.t>

startroom : room
  sdesc = "Sidewalk"
  ldesc = "You are standing out on a sidewalk.
  There is a mailbox here.  The sidewalk leads east toward a lake. "
  east = lake
;

mailbox : fixeditem
  location = startroom
  noun = 'mailbox'
  sdesc = "mailbox"
  ldesc = "It is a standard, United States mailbox. The penalty for
  tampering with mail is quite severe. "
  contentsVisible = nil
  contentsReachable = nil
  verIoPutIn(actor) = {}
  ioPutIn(actor, dobj) = 
  {
    "You open the mailbox door, put <<dobj.thedesc>> inside, and close
    the door.  You hear a thunk as <<dobj.thedesc>> lands inside the
    mailbox. ";
    dobj.moveInto(mailbox);
  }
  verOpen(actor) =
  {
    "You open the mailbox door, but of course, you can't actually see
    inside the mailbox while the door is open, so you let go and the
    door slams shut. ";
  }
  verClose(actor) =
  {
    "The mailbox is already closed. ";
  }
;

ash : item
  noun = 'pile'
  adjective = 'ash'
  sdesc = "pile of ash"
  ldesc = "The pile of ash is probably the charred remains of the bomb
  you detonated earlier. "
;

bomb : item
  location = startroom
  noun = 'bomb'
  sdesc = "bomb"
  isActive = nil 
  ldesc = 
  {
    "The tiny bomb has a small button. ";
    if (self.isActive)
    {
      "It's ticking loudly. ";
    }
  }
  explode =
  {
    "\b";   // Print a blank line before the explosion message
    
    // Special message if bomb explodes inside the mailbox
    if ( self.location == mailbox )
    {
      // Is the player where he can witness the explosion?
      if ( Me.location == mailbox.location )
      {
        "There is a huge explosion from within the mailbox.  Smoke
        comes pouring out for a moment, but surprisingly, the mailbox
        has suffered no visible damage.  These items must be well-
        built.  Of course, the mail inside has probably been completely
        obliterated.  You're in big trouble now! ";
      }
      else  // The player can't actually see the mailbox
      {
        "You hear a distant, muffled explosion. ";
      }
    }
    else      // bomb not in mailbox
    {
      // Is the player where he can witness the explosion?
      if( self.isIn(Me.location) )
      {
        "The bomb's explosion is the last thing you ever see. ";
        die();
      }
      else // bomb not nearby
      {
        "You hear an explosion off in the distance. ";
      }
    }
    
    // Message has been printed, now replace bomb with ash
    ash.moveInto(self.location);
    self.moveInto(nil);
  }
;

bombButton : fixeditem
  location = bomb
  noun = 'button'
  adjective = 'bomb'
  sdesc = "bomb button"
  ldesc = "A foreboding button protrudes from the bomb.  I wonder what
  it does... "
  verDoPush(actor) = {}
  doPush(actor) =
  {
    if (not bomb.isActive)
    {
      "The bomb starts ticking. ";
      notify(bomb, &explode, 3);
      bomb.isActive = true;
    }
    else
    {
      "The bomb goes quiet.  Whew! ";
      unnotify(bomb, &explode);
      bomb.isActive = nil;
    }
  }
;

lake : room
  sdesc = "Lake"
  ldesc = 
  {
    "It's a beautiful day out.  You are standing on a grassy lawn
    beside a blue lake. To the north lies a garden.  ";
    if (fisherman.location == self)
    {
      "A fisherman is peacefully fishing from his boat in the center of
      the lake. ";
    }
  }
  west = startroom
  north = garden
  
  enterRoom( actor ) =
  {
    if (fisherman.location == self)
    {
      notify( fisherman, &script, 0);
    }
    pass enterRoom;
  }
  leaveRoom( actor) =
  {
    unnotify (fisherman, &script);
    pass leaveRoom;
  }
;
 
fisherman : fixeditem
  location = lake
  noun = 'fisherman'
  sdesc = "fisherman"
  ldesc = "The fisherman sees you looking at him, and he waves back at
  you with a smile. "
  
  scriptNum = 0
  /*
  script =
  {
    self.scriptNum = self.scriptNum + 1;
    if (self.scriptNum == 1)
    {
      "\bThe fisherman fiddles with some bait. ";
    }
    if (self.scriptNum == 2)
    {
      "\bYou notice some bubbles rising up around the fisherman's boat.
      ";
    }
    if (self.scriptNum == 3)
    {
      "\bA fin appears in the lake, heading in the general direction of
      the boat, and then disappears. ";
    }
    if (self.scriptNum == 4)
    {
      "\bThe boat is rocked violently by some unseen force,
      tipping the fisherman out of his boat.  He flails in the
      water for a moment, screaming, before vanishing beneath
      the surface of the lake. ";
      fisherman.location = nil;
    }
    if (self.scriptNum == 5)
    {
      "\bYou think you see a pool of red in the center of the lake, but
      the color quickly dissipates. ";
      unnotify(self, &script);
    }
  }
  */
  script =
  {
    self.scriptNum = self.scriptNum + 1;
    switch (self.scriptNum)
    {
      case 1:
        "\bThe fisherman fiddles with some bait. ";
        break;
      case 2:
        "\bYou notice some bubbles rising up around the fisherman's 
        boat. ";
        break;
      case 3:
        "\bA fin appears in the lake, heading in the general direction of
        the boat, and then disappears. ";
        break;
      case 4:
        "\bThe boat is rocked violently by some unseen force,
        tipping the fisherman out of his boat.  He flails in the
        water for a moment, screaming, before vanishing beneath
        the surface of the lake. ";
        fisherman.location = nil;
        break;
      case 5:
        "\bYou think you see a pool of red in the center of the lake, but
        the color quickly dissipates. ";
        unnotify(self, &script);
        break;
    }
  }
;

garden : room
  sdesc = "Garden"
  ldesc = "You are in a beautiful outdoor garden with many flowers 
  and trees.  The lake is to the south. "
  south = lake
  enterRoom(actor) =
  {
    self.scriptNum = 0;
    notify (self, &script, 0);
    pass enterRoom;
  }
  leaveRoom(actor) =
  {
    unnotify(self, &script);
    pass leaveRoom;
  }
  scriptNum = 0
  script = 
  {
    self.scriptNum++;  
    // Above line is shorthand for self.scriptNum = self.scriptNum + 1
    switch(self.scriptNum)
    {
      case 1:
        "\bA squirrel scampers up a nearby oak tree. ";
        break;
      case 2:
      case 3:
        "\bThe squirrel pulls acorns off the tree. ";
        break;
      case 4:
        "\bThe squirrel scampers down the tree with one of the acorns and
        buries it in a little hole. ";
        // Reached end of script, so reset
        self.scriptNum = 0;
        break;
    }
  }
;

radio : item
  location = garden
  noun = 'radio'
  sdesc = "radio"
  ldesc = "The radio has a tuner dial and an on/off switch. "
  doTurnon -> radioSwitch
  doTurnoff -> radioSwitch
  doSwitch -> radioSwitch
  doTurnTo -> tunerDial
  /*
  script =
  {
    // Exit out of the script without doing anything if radio
    // isn't within reach, and therefore not audible
    if (not radio.isReachable(Me))
      return;
      
    if (tunerDial.setting == 1)
    {
      // Classical station
      switch(rand(3))
      {
        case 1: 
          "\bThe radio is playing a selection by Brahms. ";
          break;
        case 2:
          "\bThe radio is playing a selection by Beethoven. ";
          break;
        case 3:
          "\bThe radio is playing a selection by Grieg. ";
          break;
      }
    }
    
    if (tunerDial.setting == 2)
    {
      // Rock station
      switch(rand(3))
      {
        case 1: 
          "\bThe radio is playing a selection by Alanis Morissette. ";
          break;
        case 2:
          "\bThe radio is playing a selection by the Beatles. ";
          break;
        case 3:
          "\bThe radio is playing a selection by Phil Collins. ";
          break;
      }
    }
  }  
  */
  
  classicalSelections = ['Brahms' 'Beethoven' 'Grieg']
  rockSelections = ['Alanis Morissette' 'the Beatles' 'Phil Collins']
  script =
  {
    // Exit out of the script without doing anything if radio
    // isn't within reach, and therefore not audible
    if (not radio.isReachable(Me))
      return;

    "\bThe radio is playing a selection by ";
    if (tunerDial.setting == 1)
    {
      say(self.classicalSelections[rand(3)]);
    }
    if (tunerDial.setting == 2)
    {
      say(self.rockSelections[rand(3)]);
    }
    ". ";
  } 
;

radioSwitch : switchItem
  location = radio
  noun = 'switch'
  adjective = 'radio'
  sdesc = "radio switch"
  ldesc = "The radio is <<self.isActive ? "on" : "off">>. "
  doTurnon(actor) =
  {
    notify(radio, &script, 0);
    pass doTurnon;
  }
  doTurnoff(actor) =
  {
    unnotify(radio, &script);
    pass doTurnoff;
  }
  doSwitch(actor) =
  {
    if (self.isActive)
    {
      unnotify(radio, &script);
    }
    else
    {
      notify(radio, &script, 0);
    }
    pass doSwitch;
  }
;

tunerDial : dialItem
  location = radio
  noun = 'dial'
  adjective = 'radio' 'tuner'
  sdesc = "tuner dial"
  // ldesc already defined by dialItem class, says setting
  minsetting = 1
  maxsetting = 2
  setting = 1
;

