////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: showContCont() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _SHOW_CONT_CONT_T_
#define _SHOW_CONT_CONT_T_

#include <itemcount.t>
#include <listcont.t>
#include <listfixedcontcont.t>

#pragma C+

/*
 *   showContCont:  list the contents of the object, plus the contents of
 *   an fixeditem's contained by the object.  A complete sentence is shown.
 *   This is an internal routine used by listContCont and listFixedContCont.
 */
showContCont: function(obj) {
    if (itemCount(obj.contents)) {
        if (obj.isSurface) {
            if (!obj.isQsurface) {
                "Sitting on "; obj.theDesc;" is "; listCont(obj);
                ". ";
            }
        } else if (obj.canSenseContents(sight, nil) 
                && !obj.isQcontainer) {
            caps();
            obj.theDesc; " seem";
            if (!obj.isThem) "s";
            " to contain ";
            listCont(obj);
            ". ";
        }
    }
    if (obj.canSenseContents(sight, nil) && !obj.isQcontainer)
        listFixedContCont(obj);
}

#pragma C-

#endif /* _SHOW_CONT_CONT_T_ */
