////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: preparseCmd() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _PREPARSE_CMD_T_
#define _PREPARSE_CMD_T_

#include <composite.h>
#include <global.t>

#pragma C+

/*
 *  preparseCmd: function(cmd)
 *
 */
preparseCmd: function(cmd) {
	local o, p, ret;
		
	p = global.preparseObjList;
	o = car( p );
	while(o) {
	    if (proptype(o, &ppcoMethod) != DTY_NIL) {
		    ret = o.ppcoMethod( cmd );
		    if (ret != true) return ret;
	    }
		p = cdr( p );
		o = car( p );
	}
    return true;
}

#pragma C-

#endif /* _PREPARSE_CMD_T_ */
