////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: incScore() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _INC_SCORE_T_
#define _INC_SCORE_T_

#include <global.t>
#include <scorestatus.t>

#pragma C+

/*
 *  incScore: function(amount)
 *
 *  Adds amount to the total score, and updates the status line
 *  to reflect the new score.  The total score is kept in global.score.
 *  Always use this routine rather than changing global.score
 *  directly, since this routine ensures that the status line is
 *  updated with the new value.
 */
incScore: function(amount) {
    global.score += amount;
    scoreStatus(global.score, global.turnSoFar);
}

#pragma C-

#endif /* _INC_SCORE_T_ */
