////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Surface 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _SURFACE_H_
#define _SURFACE_H_

#include <item.h>
#include <itemcount.t>
#include <listcont.t>

#pragma C+

/*
 *  Surface: Item
 *
 *  Objects can be placed on a Surface.  Apart from using the
 *  preposition "on" rather than "in" to refer to objects
 *  contained by the object, a Surface is identical to a
 *  Container.  Note: an object cannot be both a
 *  Surface and a Container, because there is no
 *  distinction between the two internally.
 */
class Surface: Item
    isSurface = true  // Item can hold objects on its surface
    boardingPrep = "on"
    unboardingPrep = "off of"
    lDesc = {
        if (itemCount(self.contents)) {
            "On "; self.theDesc; " %you% see%s% "; listCont(self); ". ";
        } else {
            "There's nothing on "; self.theDesc; ". ";
        }
    }
    verIoPutOn(actor) = {}
    ioPutOn(actor, dobj) = {
        dobj.doPutOn(actor, self);
    }
    verDoSearch(actor) = {}
    doSearch(actor) = {
        if (itemCount(self.contents) != 0)
            "On <<self.theDesc>> %you% see%s% <<listCont(self)>>. ";
        else
            "There's nothing on <<self.theDesc>>. ";
    }
;

#pragma C-

#endif /* _SURFACE_H_ */
