////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: SearchHider 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _SEARCH_HIDER_H_
#define _SEARCH_HIDER_H_

#include <hider.h>

#pragma C+

/*
 *  SearchHider: Hider
 *
 *  This is just like an UnderHider, except that objects are hidden
 *  within this object in such a way that the object must be looked in
 *  or searched.  Objects to be hidden in this object should have their
 *  searchLoc property set to point to this object.  Note that this
 *  is different from a normal Container, in that the objects hidden within
 *  this object will not show up until the object is explicitly looked in
 *  or searched.
 *  
 *  The Items hidden with SearchHider must be of class Hidden.
 */
class SearchHider: Hider
    searchCont = []
    verDoLookin(actor) = {
        if (self.searchCont == nil)
            pass verDoLookin;
    }
    doLookin(actor) = {
        if (self.searchCont == nil)
            pass doLookin;
        else
            self.searchCont = self.searchObj(actor, self.searchCont);
    }
    verDoSearch(actor) = {}
    doSearch(actor) = {
        if (self.searchCont == nil)
            "There's nothing else in <<self.theDesc>>. ";
        else
            self.searchCont = self.searchObj(actor, self.searchCont);
    }
;

#pragma C-

#endif /* _SEARCH_HIDER_H_ */
