////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: ChairItem 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _CHAIR_ITEM_H_
#define _CHAIR_ITEM_H_

#include <fixture.h>
#include <chairable.h>
#include <surface.h>

#pragma C+

/*
 *  ChairItem: Fixeture, Chairable, Surface
 *
 *  Acts like a chair:  actors can sit on the object.  While sitting
 *  on the object, an actor can't go anywhere until standing up, and
 *  can only reach objects that are on the chair and in the chair's
 *  reachable list.  By default, nothing is in the reachable
 *  list.  
 */
class ChairItem: Fixture, Chairable, Surface
;

#pragma C-

#endif /* _CHAIR_ITEM_H_ */
