#include <adv.t>
#include <std.t>
#include <wateroom.t>

/*********************************************
In this part of the file, I have attempted to
demonstrate all the features I put in.  To play
this sample, compile and run water.t
*********************************************/

startroom: waterRoom
  sdesc = "Surface of lake"
  ldesc = "This is the surface of the lake. East is the shore. "
  bottom = Bottom
  south = surface2
  down = Bottom
  east = shore
;

Bottom: underwaterRoom
  sdesc = "Bottom of lake"
  ldesc = "This is the bottom of the lake. "
  south = Bottom2
  top = startroom
  up = startroom
;

surface2: waterRoom
  sdesc = "Surface of lake"
  ldesc = "This is the surface of the lake.  North is more lake. "
  bottom = Bottom2
  down = Bottom2
  north = startroom
;

Bottom2: underwaterRoom
  sdesc = "Bottom of lake"
  ldesc = "More lake bottom"
  top = surface2
  up = surface2
  north = Bottom
;

stone: item
  weight = 4
  noun = 'rock' 'stone'
  sdesc = "rock"
  ldesc = "It is heavy.  "
  location = Bottom
;

wood: floatItem
  buoyancy = 4
  noun = 'wood' 'log' 'chip'
  sdesc = "wood"
  ldesc = "It is light, and floats.  "
  location = startroom
;


/************************
A wool sweater, and you know
what happens when you get it
wet.
************************/

sweater: clothingItem
  wet = nil
  weight = 1
  noun = 'sweater'
  adjective = 'wool'
  sdesc = "Woolen sweater"
  ldesc = 
  {
    if (wet) "This is a rather soggy wool sweater.  It's quite heavy. ";
    "This is a nice wool sweater. ";
  }
  getwet =
  {
  local owner;

    if (wet) return ( nil );
     owner := self.location;
     "Oh dear, the sweater soaks up an incredible amount of water! ";
     self.wet := true;
     weight := 5;
  }
  location = shore
;

shore: room
  sdesc = "Shore"
  ldesc = "This is the shore. West is the water. "
  west = startroom
;

potionBottle: waterContainer, openable
  iswaterproof = nil
  isopen = true
  noun = 'bottle'
  sdesc = "bottle"
  getwet =
  {
   if (self.contents = [] and not (self.iswaterproof) and not (self.full) ) {
      self.fill;
      caps(); self.thedesc; " fills with water.\b ";
                                                        }
  }
     
  location = shore
  doOpen( actor ) =
  {
    if(isclass(Me.location, waterRoom) or
       isclass(Me.location, underwaterRoom) ) {
      GetWet(self.contents);
                                              }
    self.iswaterproof := nil;
    pass doOpen;
  }
  doClose( actor ) =
  {
    self.iswaterproof := true;
    pass doClose;
  }
;

potion: item
  noun = 'potion'
  verDoTake(actor) = { "Being liquid, it evades your grasp.  "; }
  sdesc = "potion"
  ldesc = "It is a nasty green. "
  location = potionBottle
  verDoDrink( actor) = {}
  doDrink( actor ) =
  {
     "You grow a set of gills. ";       // An example of using Me.hasair
     Me.hasair := true;
     self.moveInto( nil );
  }
  getwet =
  {
    "Your potion is diluted.\n ";
    self.location.fill;  // Since this is a watercontainer, it can fill itself up.
    self.moveInto(nil);
  }
;