#ifndef BUGFIX
#define BUGFIX
#pragma C+

/*
** Bugs.t -- bug fixes for TADS 2.2
**
** Please note that this module is intended to fix library bugs, not
** actual bugs within the TADS runtime itself.
**
** {BUGS FIXED}
** thing.cantReach() no longer quits w/o printing an error message if the
**   player is not in a nestedroom.  This was a problem if contentsReachable
**   was hand-set to nil.
** thing.doUnboard() no longer prints "Okay, you're no longer in xxx"
**   whether or not you're actually IN xxx.  By default, an object's
**   statusPrep is "on", so doUnboard() now prints "Okay, you're no longer
**   on xxx" unless you change statusPrep deliberately.  This fixes a
**   related bug with theFloor.
** thing.verDoTakeOut() now checks whether or not you can actually take
**   the item.
** lockable.verDoUnlockWith() now checks to see if the door requires a key to
**   be unlocked.
** Throwing items at the floor no longer results in the response "You
**   miss."
** Looking at the floor no longer gives the default response "There's
**   nothing on the floor" whether or not there is something in the room.
**   My solution to this was to prevent any description of the floor's
**   "contents" at all.
** vehicle messages now take statusPrep & outOfPrep into account.
** showcontcont() now checks for qsurfaces correctly.
** distantItems now allow you to ask or tell an actor about them without
**   the odd response, "It is too far away."
** The "undo" command now aborts after it is finished.  This should remove
**   some problems which occur when a player undoes past a fuse or daemon.
**
** {BUGS TOYED WITH}
** There seems to be problems with the random number generator.  To
**   try to avoid such problems, a new function RAND is added.
**
** This collection of bug fixes was compiled by Stephen Granade.  It
** is public domain--do whatever you like with it.  If you know of any
** other library bugs in TADS, please contact me for their inclusion in this
** module.  I can be reached at sgranade@phy.duke.edu.
**
** Credits:
**   Unbeknownst to them, Neil deMause, Magnus Olsson, Andrew Pontious, and
**   Patrick Kellum contributed to this file.
**
** Version history:
**   2 Aug 96 -- Initial release
**  22 Aug 96 -- lockable bug fix added
**   2 Sep 96 -- cantReach bug fix added
**  20 Sep 96 -- More changes to theFloor, suggested by Magnus Olssen
**  22 Nov 96 -- Patch applied to vehicle, making it use outOfPrep
*/

modify thing
    statusPrep = "on"        // So that everything has a preposition
    replace cantReach(actor) = {
        if (self.location == nil) {
            if (actor.location.location)
               "%You% can't reach that from <<actor.location.thedesc>>. ";
            else "%You% can't reach that. ";    // Added error message
            return;
        }
        if (!self.location.isopenable || self.location.isopen)
            self.location.cantReach(actor);
        else "%You%'ll have to open <<self.location.thedesc>> first. ";
    }
    replace verDoUnboard(actor) = {
        if (actor.location != self) {
            "%You're% not <<self.statusPrep>> <<self.thedesc>>! ";
        }
        else if (self.location == nil) {
            "%You% can't leave <<self.thedesc>>! ";
        }
    }
    replace doUnboard(actor) = {
        // Trivia: this is the only place "fastenitem" is referred to
        if (self.fastenitem) {
            "%You%'ll have to unfasten <<actor.location.fastenitem.thedesc
                >> first. ";
        }
        else {
            "Okay, %you're% no longer <<self.statusPrep>> <<self.thedesc>>. ";
            self.leaveRoom(actor);
            actor.moveInto(self.location);
        }
    }
    replace verDoTakeOut(actor, io) = {
        if (io != nil && !self.isIn(io))
            "\^<<self.thedesc>> isn't in <<io.thedesc>>. ";
        else self.verDoTake(actor);        // Make sure the obj can be taken
    }
;

// lockable modified so that trying to unlock a lockable with a key when one
//  isn't needed (i.e. mykey=nil) results in an error message
modify lockable
    replace verDoUnlockWith(actor, io) = {
        if (!self.islocked)
            "<<self.isThem ? "They're" : "It's">> not locked! ";
        else if (self.mykey == nil)
            "%You% %do%n't need anything to unlock <<self.isThem ? "them" :
                "it">>. ";
    }
;

// theFloor modified so that "throw xxx at floor" doesn't result in
//  "you miss," which seems rather silly. Its ldesc is also modified to
//  prevent "There is nothing on the floor" messages
modify theFloor
    ldesc = "It lies beneath you. "
    ioThrowAt(actor, dobj) = {
        "Thrown. ";
            dobj.moveInto(actor.location);
    }
;

// vehicle modified so that messages now take statusPrep & outOfPrep into
// account
modify vehicle
    verDoBoard(actor) = {
        if (actor.location == self)
            "%You're% already <<self.statusPrep>> <<self.thedesc>>! ";
        else if (actor.isCarrying(self))
            "%You%'ll have to drop <<self.thedesc>> first! ";
    }
    doBoard(actor) = {
        "Okay, %you're% now <<self.statusPrep>> <<self.thedesc>>. ";
        actor.moveInto(self);
    }
    noexit = {
        "%You're% not going anywhere until %you% get%s% <<self.outOfPrep>> <<
            self.thedesc>>. ";
        return (nil);
    }
    dobjGen(a, v, i, p) = {
        if (a.isIn(self) && v != inspectVerb && v != getOutVerb &&
            v != outVerb) {
            "%You%'ll have to get <<self.outOfPrep>> <<self.thedesc>> first. ";
            exit;
        }
    }
    iobjGen(a, v, d, p) = {
        if (a.isIn(self) && v != putVerb) {
            "%You%'ll have to get <<self.outOfPrep>> <<self.thedesc>> first. ";
            exit;
        }
    }
;

replace showcontcont: function(obj)
{
    if (itemcnt(obj.contents)) {
        if (obj.issurface) {
            if (!obj.isqsurface) {
                "Sitting on <<obj.thedesc>> is <<listcont(obj)>>. ";
            }
        }
        else if (obj.contentsVisible && !obj.isqcontainer) {
            "\^<<obj.thedesc>> seems to contain <<listcont(obj)>>. ";
        }
    }
    if (obj.contentsVisible && !obj.isqcontainer)
        listfixedcontcont( obj );
}

modify distantItem
    dobjGen(a, v, i, p) = {
        if (v != askVerb && v != tellVerb)
            pass dobjGen;
    }
;

// Make "undo" abort afterwards
// WARNING: the undoMove code was taken directly from adv.t.  Should adv.t
//          change undoMove, this will need to be updated as well
modify undoVerb
    undoMove(actor) = {
    /* do TWO undo's - one for this 'undo', one for previous command */
        if (undo() && undo()) {
            "(Undoing one command)\b";
            Me.location.lookAround(true);
            scoreStatus(global.score, global.turnsofar);
            abort;
        }
        else "No more undo information is available. ";
    }
;

RAND: function(x)
{
    return (((rand(16*x)-1)/16)+1);
}

#endif
