/* FIRST THINGS FIRST - Locations - far_past.t - Version Beta 3.00
/*  Copyright (c) 1996, 1997, 1999, 2000 by J. Robinson Wheeler. All Rights Reserved. */

/*
 *					********					 *********
 *					********	THE GAME CODE	 *********
 *					********					 *********
 */

/**************************************************************************
 *					The rooms of the FAR PAST.							  *
 **************************************************************************/

FPclearing: rodroom
	isFoliageRoom = true
	sdesc = "Forest"
	ldesc = "The woods surround you on all sides, although there is enough space
			around you to consider it a clearing of sorts. Light streams prettily 
			through the canopy of leaves above. The ground is hard and flat and clean.\b
			 
			You can hear the soft gurgling of a stream nearby, but the foliage is so 
			rich and dense that the sound of it is dispersed. You aren't sure 
			from which direction it originates. "
	xdesc = 
	{
		if ( self.noMaze )
			"You can see your usual path through the grove of trees to the northeast. ";
		else if ( self.hackexit )
			"The opening you hacked into the dense foliage is to the south. ";
		else
			"You can barely keep your bearings straight, as each direction looks the 
			same as every other. ";
	}
	lightDesc = "Light streams prettily through the canopy of leaves above. "
	listenDesc = 'You hear the sound of a stream gurgling somewhere nearby. '
	smellDesc = "You smell the fresh green forest air. "
	
	noexit =
	{
		"You get all turned around in the dense forest growth and end up back where 
		you started. ";
		return( nil );
	}
	noMaze = nil									// been through the maze yet?
	rodPoint = "<<self.noMaze?"northeast":"south">>"
	hackexit = nil
	my_hacked_path = FPclearing_hacked_path
	
	ne = 
	{
		if ( self.noMaze )							// if the player has been through
			return( FPwoods );					// the maze already, skip it
		else
			return( maze1 );
	}
	south =
	{
		if ( self.hackexit )
		{
			"You pass through the hacked-open path. ";
			return( maze4 );
		}
		else if ( diviningRod.isIn( Me ) )
		{
			"You almost lose your bearings again, but the divining wand seems to 
			pull you through. \b";
			return( maze1 );
		}
		else
			return( noexit );
	}
	firstseen =
	{
		incscore( 5 );
		global.scoreCard[5] := 1;
	}
;

FPdummyClearingItem: locationDesc
	sdesc = "clearing"
	adjective = 'FPclearing'
	location = FPclearing
;

mazeFoliage: block, floatingItem
	sdesc = "foliage"
	ldesc = "The foliage is thick and tangled. "
	noun = 'foliage' 'plant'
	plural = 'plants'
	adjective = 'vegetation' 'jungle' 'vines' 'growth' 'thick' 'tangled' 'tangle'
			'rich' 'dense' 'woods' 'trees' 'tree' 'wood' 'canopy' 'leaves'
			'forest'
	location = 
	{
		if ( Me.location && Me.location.isFoliageRoom )
			return( Me.location );
		if ( Me.location.location && Me.location.location.isFoliageRoom )
			return( Me.location.location );
		else
			return( nil );
	}
	
	verDoClimb( actor ) = 
	{
		"The trees here are young and not suitable for climbing. ";
	}
	
	hackCount = 0
	verDoHackWith( actor, io ) = {}
	doHackWith( actor, io ) = 
	{
		if ( io = machete )
		{
			local newroom;
			
			if ( self.location.hackexit )
			{
				"You have already hacked a path open here. ";
				return;
			}
			
			self.hackCount++;

			switch( self.hackCount )
			{
				case 1:
				case 2:
				case 3:
					"You raise the machete high and start hacking. The thick 
					foliage parts, and you trudge forward. \b";
					break;
				case 4:
				case 5:
					"Your arm is starting to get tired, but again you raise the 
					machete high and start hacking. The thick foliage parts, and 
					you trudge forward. \b";
					break;
				case 6:
					"Your arm is really getting tired, but again you raise the 
					machete high and start hacking. The thick foliage parts, and 
					you trudge forward. \b";
					break;
				case 7:
					"Your arm is now too fatigued to wield the machete with
					enough strength to cut the foliage. You need to rest it for
					a while. ";
					notify( self, &restoreArm, 8 );
					return( nil );
				default:
					"Your arm is now too fatigued to wield the machete with
					enough strength to cut the foliage. You need to rest it for
					a while. ";
					return( nil );
			}
			switch( Me.location )
			{
				case FPclearing: 
				case maze1: 
				case maze2: 
				case maze3: 
					newroom := maze4;
					break;
				case maze4:
				case maze5:
				case maze6:
				case maze7:
					newroom := maze8;
					break;
				case maze8:
				case maze9:
					newroom := maze10;
					break;
				case maze10:
					newroom := flowingStream;
					break;
				default: 
					newroom := maze1;
					break;
			}
			Me.location.hackexit := newroom;
			Me.location.my_hacked_path.moveInto( Me.location );
			Me.location.my_hacked_path.otherside.moveInto( newroom );
			Me.travelTo( newroom );
		}
		else
			"I don't know how to hack the foliage with that. ";
	}
	restoreArm = 
	{
		self.hackCount := 0;
		unnotify( self, &restoreArm );
	}
;

FPclearing_hacked_path: hacked_path
	adjective = 'south' 's'
	doordir = "south"
	doordest = maze4
	otherside = FPclearing_maze4_hacked_path
;

FPclearing_maze4_hacked_path: hacked_path
	adjective = 'north' 'n'
	doordir = "north"
	doordest = FPclearing
	otherside = FPclearing_hacked_path
;

maze1: mazeroom
	se = { return( self.rodDir ); }
	north = FPclearing
	nextMaze = maze2
	rodPoint = "southeast"
	my_hacked_path = maze1_hacked_path
;

maze1_hacked_path: hacked_path
	adjective = 'southeast' 'se'
	doordir = "southeast"
	doordest = maze4
	otherside = maze1_maze4_hacked_path
;

maze1_maze4_hacked_path: hacked_path
	adjective = 'northwest' 'nw'
	doordir = "northwest"
	doordest = maze1
	otherside = maze1_hacked_path
;

maze2: mazeroom
	north = { return( self.rodDir ); }
	nw = maze1
	ne = maze4
	west = maze3
	south = maze5
	nextMaze = maze3
	rodPoint = "north"
	my_hacked_path = maze2_hacked_path
;

maze2_hacked_path: hacked_path
	adjective = 'north' 'n'
	doordir = "north"
	doordest = maze4
	otherside = maze2_maze4_hacked_path
;

maze2_maze4_hacked_path: hacked_path
	adjective = 'south' 's'
	doordir = "south"
	doordest = maze2
	otherside = maze2_hacked_path
;

maze3: mazeroom
	east = { return( self.rodDir ); }
	south = maze2
	west = maze1
	nw = maze1
	se = maze2
	nextMaze = maze4
	rodPoint = "east"
	my_hacked_path = maze3_hacked_path
;

maze3_hacked_path: hacked_path
	adjective = 'east' 'e'
	doordir = "east"
	doordest = maze4
	otherside = maze3_maze4_hacked_path
;

maze3_maze4_hacked_path: hacked_path
	adjective = 'west' 'w'
	doordir = "west"
	doordest = maze1
	otherside = maze3_hacked_path
;

maze4: mazeroom
	ne = { return( self.rodDir ); }
	west = 
	{
		if ( maze3_maze4_hacked_path.location )
			return( maze3_maze4_hacked_path.destination );
		else
			return( maze3 );
	}
	east = maze1
	north = 
	{
		if ( FPclearing_maze4_hacked_path.location )
			return( FPclearing_maze4_hacked_path.destination );
		else
			return( self.noexit );
	}
	nw = 
	{
		if ( maze1_maze4_hacked_path.location )
			return( maze1_maze4_hacked_path.destination );
		else
			return( maze1 );
	}
	se = maze2
	south = 
	{
		if ( maze2_maze4_hacked_path.location )
			return( maze2_maze4_hacked_path.destination );
		else
			return( maze1 );
	}
	nextMaze = maze5
	rodPoint = "northeast"
	my_hacked_path = maze4_hacked_path
;

maze4_hacked_path: hacked_path
	adjective = 'northeast' 'ne'
	doordir = "northeast"
	doordest = maze8
	otherside = maze4_maze8_hacked_path
;

maze4_maze8_hacked_path: hacked_path
	adjective = 'southwest' 'sw'
	doordir = "southwest"
	doordest = maze4
	otherside = maze4_hacked_path
;

maze5: mazeroom
	ne = { return( self.rodDir ); }
	sw = maze4
	se = maze3
	east = maze2
	nw = maze2
	south = maze1
	north = maze1
	nextMaze = maze6
	rodPoint = "northeast"
	my_hacked_path = maze5_hacked_path
;

maze5_hacked_path: hacked_path
	adjective = 'northeast' 'ne'
	doordir = "northeast"
	doordest = maze8
	otherside = maze5_maze8_hacked_path
;

maze5_maze8_hacked_path: hacked_path
	adjective = 'south' 's'
	doordir = "south"
	doordest = maze5
	otherside = maze5_hacked_path
;

maze6: mazeroom
	nw = { return( self.rodDir ); }
	sw = maze5
	se = maze3
	ne = maze1
	west = maze3
	east = maze2
	south = maze2
	north = maze4
	nextMaze = maze7
	rodPoint = "northwest"
	my_hacked_path = maze6_hacked_path
;

maze6_hacked_path: hacked_path
	adjective = 'northwest' 'nw'
	doordir = "northwest"
	doordest = maze8
	otherside = maze6_maze8_hacked_path
;

maze6_maze8_hacked_path: hacked_path
	adjective = 'southeast' 'se'
	doordir = "southeast"
	doordest = maze6
	otherside = maze6_hacked_path
;

maze7: mazeroom
	west = { return( self.rodDir ); }
	se = maze6
	north = maze5
	south = maze4
	east = maze3
	sw = maze2
	nw = maze2
	nextMaze = maze8
	rodPoint = "west"
	my_hacked_path = maze7_hacked_path
;

maze7_hacked_path: hacked_path
	adjective = 'west' 'w'
	doordir = "west"
	doordest = maze8
	otherside = maze7_maze8_hacked_path
;

maze7_maze8_hacked_path: hacked_path
	adjective = 'east' 'e'
	doordir = "east"
	doordest = maze7
	otherside = maze7_hacked_path
;

maze8: mazeroom
	nw = { return( self.rodDir ); }
	east = 
	{
		if ( maze7_maze8_hacked_path.location )
			return( maze7_maze8_hacked_path.destination );
		else
			return( maze7 );
	}
	south = 
	{
		if ( maze5_maze8_hacked_path.location )
			return( maze5_maze8_hacked_path.destination );
		else
			return( maze5 );
	}
	north = maze4
	sw = 
	{
		if ( maze4_maze8_hacked_path.location )
			return( maze4_maze8_hacked_path.destination );
		else
			return( maze4 );
	}
	ne = maze5
	se = 
	{
		if ( maze6_maze8_hacked_path.location )
			return( maze6_maze8_hacked_path.destination );
		else
			return( maze6 );
	}
	west = maze2
	nextMaze = maze9
	rodPoint = "northwest"
	my_hacked_path = maze8_hacked_path
;

maze8_hacked_path: hacked_path
	adjective = 'northwest' 'nw'
	doordir = "northwest"
	doordest = maze10
	otherside = maze8_maze10_hacked_path
;

maze8_maze10_hacked_path: hacked_path
	adjective = 'south' 's'
	doordir = "south"
	doordest = maze8
	otherside = maze8_hacked_path
;

maze9: mazeroom
	ne = { return( self.rodDir ); }
	sw = maze8
	se = maze7
	south = maze6
	north = maze5
	east = maze4
	west = maze2
	nw = maze1
	nextMaze = maze10
	rodPoint = "northeast"
	my_hacked_path = maze9_hacked_path
;

maze9_hacked_path: hacked_path
	adjective = 'northeast' 'ne'
	doordir = "northeast"
	doordest = maze10
	otherside = maze9_maze10_hacked_path
;

maze9_maze10_hacked_path: hacked_path
	adjective = 'southwest' 'sw'
	doordir = "southwest"
	doordest = maze9
	otherside = maze9_hacked_path
;

maze10: mazeroom
	se = { return( self.rodDir ); }
	sw = 
	{
		if ( maze9_maze10_hacked_path.location )
			return( maze9_maze10_hacked_path.destination );
		else
			return( maze1 );
	}
	ne = maze2
	nw = maze1
	north = maze1
	south = 
	{
		if ( maze8_maze10_hacked_path.location )
			return( maze8_maze10_hacked_path.destination );
		else
			return( maze1 );
	}
	east = maze1
	west = maze1
	nextMaze = flowingStream
	rodPoint = "southeast"
	my_hacked_path = maze10_hacked_path
;

maze10_hacked_path: hacked_path
	adjective = 'southeast' 'se'
	doordir = "southeast"
	doordest = flowingStream
	otherside = maze10_flowingStream_hacked_path
;

maze10_flowingStream_hacked_path: hacked_path
	adjective = 'northwest' 'nw'
	doordir = "northwest"
	doordest = maze10
	otherside = maze10_hacked_path
;

flowingStream: rodroom
	sdesc = "Flowing stream"
	ldesc = "The foliage parts at last to reveal a sparkling forest stream. Light 
			dapples gently through the leaves to highlight slick, wet rocks and 
			the bright green of fresh growth. "
	xdesc =	"The stream flows, about half a meter wide, from the north to the 
			southwest. "
	listenDesc = 'You listen to the quiet rushing of the stream. '
	lightDesc = "The light is warm and tranquil here. "
	north = FPwoods
	sw = grotto
	nw = 
	{
		if ( maze10_flowingStream_hacked_path.location )
			return( maze10_flowingStream_hacked_path.destination );
		else
		{
			"You lose yourself in the forest again. ";
			return( maze10 );
		}
	}
	rodPoint = "stream"
	
	firstseen = 
	{
		incscore( 4 );
		global.scoreCard[10] := 1;
	}
;

streamblock: waterItem
	isEquivalent = true
	sdesc = "stream"
	ldesc = "The stream is fast, but shallow. From the looks of it, it is just a glimmer of 
			the rushing fullness it once was, and will soon dry up forever. "
	listenDesc = 'You listen to the quiet rushing of the stream. '
	noun = 'stream' 'spring' 'water'
	adjective = 'forest' 'sparkling' 'fast' 'shallow' 'wet' 'slick'
	location = flowingStream
;

wetRocks: fixedBlock, floatingItem
	sdesc = "rocks"
	noun = 'rock'
	plural = 'rocks'
	isThem = true
	adjective = 'wet'
	location = 
	{
		if ( Me.location = flowingStream || Me.location = grotto )
			return( Me.location );
		else
			return( nil );
	}
;

freshGrowth: fixedBlock
	sdesc = "fresh growth"
	ldesc = "The fresh growth is bright green and soul-soothing. "
	noun = 'growth' 'green' 'greenery' 'moss' 'fern'
	plural = 'plants' 'ferns'
	adjective = 'fresh' 'bright'
	location = flowingStream
;

grotto: rodroom
	sdesc = "Grotto"
	ldesc = "The multiverdant greenery fed by the churning stream seems to end here in a 
			place of stillness and serenity surrounding a deep pool of clear water. 
			Even the very air itself seems to obey the call to quiet. "
	xdesc = "The only exit is northeast. "
	smellDesc = "The air smells fresh, green, and sweet. "
	listenDesc = 'You hear the soothing gurgle of the stream as it pools here. '
	lightDesc = "The light is warm and tranquil here. "
	ne = flowingStream
	rodPoint = "stream"
	herring = true
;

grottoScenery: fixedBlock
	sdesc = "grotto"
	noun = 'grotto'
	adjective = 'multiverdant' 'greenery' 'green' 'flora' 'fauna' 'stillness'
	ldesc = "The multiverdant greenery fed by the churning stream seems to end here in a 
			place of stillness and serenity. Even the very air itself seems to obey 
			the call to quiet. "
	location = grotto
;

streamblock2: waterItem
	isEquivalent = true
	sdesc = "stream"
	ldesc = "The stream is fast, but shallow. From the looks of it, it is just a glimmer of 
			the rushing fullness it once was, and will soon dry up forever. It ends
			here in a deep pool. "
	listenDesc = 'You listen to the quiet rushing of the stream. '
	noun = 'stream' 'spring' 'water'
	adjective = 'forest' 'sparkling' 'fast' 'shallow' 'wet' 'slick'
;

grottoPool: waterItem
	sdesc = "pool"
	ldesc = "The water in the pool is clear and clean. The slick brown-green
			algae at the bottom covers the smooth limestone bowl of the 
			pool. It deepens considerably at the northern end, the bottom
			disappearing underneath a lush growth of ferns. "
	listenDesc = 'You hear the soothing gurgle of the stream as it pools here. '
	noun = 'pool'
	adjective = 'water' 'slick' 'brown-green' 'brown' 'green' 'algae' 'bottom'
			'limestone' 'bowl' 'bottom' 'deep' 'clear' 'clean'
	location = grotto
	
	doWadeIn( actor ) = { self.doEnter( actor ); }
	
	verDoSwimIn( actor ) = {}
	doSwimIn( actor ) = { self.doEnter( actor ); }
	
	verDoEnter( actor ) = {}
	doEnter( actor ) = 
	{
		if ( length( Me.contents ) > 0 )
		{
			"You should probably leave your things here before you
			do that. ";
		}
		else
		{
			"As you step into the cool water pool, you find it difficult to
			keep your footing. You move slowly towards the deeper end, and
			suddenly the bottom takes a sudden drop. Losing your balance,
			you slide under the water, pulled along by a deep current you
			didn't imagine was lurking under the still surface. \b
			
			Looking out through the water's surface, you see the sunlight
			disappear. Air returns to your lungs just as the light goes
			away, and you feel your body sluicing down into groundwater
			caverns. \b
			
			When the motion stops, all you hear is the dripping of shallow
			water. You crawl forward and find a hard but dry spot. It is 
			not completely dark here, but it takes a few minutes for your
			eyes to adjust. In the misty light you find yourself in a ... \b";
			
			Me.travelTo( limestoneCrawl );
		}
	}
;

freshGreenery: fixedBlock
	sdesc = "fresh greenery"
	ldesc = "The fresh greenery is bright green and soul-soothing. "
	noun = 'growth' 'green' 'greenery' 'moss' 'fern'
	plural = 'plants' 'ferns'
	adjective = 'fresh' 'bright'
	location = grotto
;

FPwoods: room
	sdesc = "Path in the woods"
	ldesc = "A natural path made by the stream winds through a natural grove of cedar 
			and live oak trees. A large rock juts up out of the ground right in your way, 
			and the stream does an abrupt curve around it. "
	xdesc = "The stream runs from the northeast to the south, and a clearing is visible 
			to the southwest. "
	south = flowingStream
	ne = diggingSpot
	reopenedPath = nil
	sw = 
	{
		if ( !self.reopenedPath )
		{
			"You push your way into the clearing, opening your usual 
			path once again. ";
			FPclearing.noMaze := true;
		}
		return( FPclearing );
	}
	rodPoint = "stream"
;

FProck: chairitem
	sdesc = "large rock"
	ldesc = "The rock is a five foot grey boulder, almost egg-shaped, 
		a single piece of heavy, textured granite. Polished smooth over
		time, a wedge shape sheared from the top ages ago provides a
		comfortable place to sit. "
	noun = 'rock' 'boulder' 'stone'
	adjective = 'large' 'wedge' 'shape' 'chipped' 'chip' 'top' 'granite'
				'heavy' 'textured'
	location = FPwoods
	ne = { self.getOff; return( self.location.ne ); }
	sw = { self.getOff; return( self.location.sw ); }
	noexit = { self.getOff; return( self.location.noexit ); }
	isdroploc = true
	statusPrep = "on"
	outOfPrep = "off of"
	
	getOff = 
	{
		if ( Me.location = self )
		{
			"You get off the rock.\n ";
			Me.moveInto( self.location );
		}
	}
	verDoStandon( actor ) = { self.verDoSiton( actor ); }
	doStandon( actor ) =
	{
		"You stand up on top of the rock. The view isn't much better, but
		it is very serene and peaceful. ";
		actor.moveInto( self );
	}
	verDoSiton( actor ) = 
	{
		if ( actor.location = self )
			"You are already on the rock. ";
	}
	doSiton( actor ) =
	{
		"You sit down on top of the rock. It is very serene and peaceful. ";
		Me.moveInto( self );
	}
	
	verDoTake( actor ) =
	{
		"The rock is made of solid granite and conservatively weighs
		one and a half tons. You are unable to move it. ";
	}
	verDoMove( actor ) = { self.verDoTake( actor ); }
	verDoPush( actor ) = { self.verDoTake( actor ); }
	verDoPull( actor ) = { self.verDoTake( actor ); }
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Sometimes it's nice to have a big ol' rock to
				sit on when you need to think.\" ";
				return( true );
			case Laura:
				"Laura says, \"That sounds like a great spot to sit and 
				meditate.\" ";
				return( true );
			case Architect:
				"He says, \"Ah yes, that old rock just down in the woods. I made
				a special point of preserving it. It would have been such a 
				shame to blast it. I've made something of a habit of taking 
				walks down there to clear my head and think.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

woodstream: waterItem
	herring = true
	isEquivalent = true
	sdesc = "stream"
	ldesc = "The stream does an abrupt curve around the large rock. "
	noun = 'stream' 'spring' 'water'
	adjective = 'forest' 'sparkling' 'fast' 'shallow' 'wet' 'slick'
	location = FPwoods
;

diggingSpot: room
	sdesc = "Sloping wood"
	ldesc = "The ground slopes down here, eroded by the nearby stream. Grasses heavy 
			with fresh dew and spring-saturated soil give the area a soft, spongy 
			feel beneath your feet. "
	xdesc = "The stream leads back southwest, and far ahead through the trees 
			to the northeast, you can see a road of some kind. "
	sw = FPwoods
	ne = linkRoad
;

softSpot: block
	isListed = true
	sdesc = "soft spot"
	ldesc = "There is a spot here which is particularly moist and soft. "
	noun = 'spot' 'soil' 'earth' 'dirt' 'grasses' 'grass' 'dew'
	adjective = 'soft' 'moist' 'spring-saturated' 'saturated' 'wet' 'spongy'
	location = diggingSpot
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Sounds like a good place to dig.\" ";
				return( true );
			case Laura:
				"Laura says, \"I've got a soft spot for a lot of things. 
				Romantic dinners. Warm ski cabins. Babies. Oh, sorry, my
				mind was wandering there.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

acornHole: fixeditem
	isListed = true
	sdesc = "hole"
	ldesc = "It's the perfect size for planting a big, ripe acorn. Fancy that. "
	location = nil
	noun = 'hole'
	adjective = 'nice' 'perfect'
	
	verIoPutIn( actor ) = {}
	ioPutIn( actor, dobj ) = { self.ioPourIn( actor, dobj ); }
	
	verIoPourIn( actor ) = {}
	ioPourIn( actor, dobj ) =
	{
		switch( dobj )
		{
			case acorn:
			{
				"You put the acorn into the hole, and scoop the dirt over it, leaving a 
				noticeable little mound. ";
				
				acornHole.moveInto( nil );
				acorn.moveInto( nil );
				acornMound.moveInto( diggingSpot );
				bareSpot.moveInto( nil );
				softSpot.moveInto( nil );
				sapling.moveInto( PsouthOfHouse );
				tinyTree.moveInto( southOfHouse );
				FtinyTree.moveInto( FsouthOfHouse );
				
				incscore( 6 );
				global.scoreCard[11] := 1;
				
				break;
			}
			case jug1:
			case jug2:
			case jug3:
			case jug4:
			case jug5:
			case liquid1:
			case liquid2:
			case liquid3:
			case liquid4:
			case liquid5:
			{
				"I hate to be a voice of pessimism, but pouring the liquid into the 
				little hole without first planting the acorn in it will really just 
				waste your time. ";
				break;
			}
			default:
				"There isn't much point to that. ";
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Dig a hole, plant something in it.\" ";
				return( true );
			case Laura:
				"Laura says, \"I bet you could plant a tree in a nice
				hole like that.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

acornMound: fixeditem
	isListed = true
	sdesc = "little mound of dirt"
	ldesc = "The little mound of dirt marks where you planted the acorn. "
	noun = 'mound' 'dirt' 'hole'
	adjective = 'little' 'mound of'
	location = nil
	groCount = 0

	verDoDigWith( actor, iobj ) =
	{
		"Sorry, that would be traumatic to the little acorn. I can't let you do that. ";
	}
	
	verIoPutIn( actor ) = {}
	ioPutIn( actor, dobj ) = { self.ioPourIn( actor, dobj ); }
	
	verIoPutOn( actor ) = {}
	ioPutOn( actor, dobj ) = { self.ioPutIn( actor, dobj ); }
	
	verIoPourIn( actor ) = {}
	ioPourIn( actor, dobj ) =
	{
		local old_count, source;
		
		old_count := self.groCount;
		
		if ( dobj.isJug )
			source := dobj.pourItem;
		else
			source := dobj;
		
		if ( source.isFertilizer )
		{
			self.groCount++;
			source.moveInto( nil );
			source.jugItem.pourItem := nil;
			source.jugItem.emptyJug.moveInto( source.jugItem.location );
			setit( source.jugItem.emptyJug );
			source.jugItem.moveInto( nil );
			self.checkGrowth( self.groCount, old_count );
		}
		else
			"There isn't much point to that. ";
	}
	checkGrowth( new_count, old_count ) =
	{
		if ( new_count > old_count )
		{
			"The liquid seeps into the mound of dirt with a nourishing sigh. ";
			
			if ( self.groCount = 1 )
			{
				tinyTree.moveInto( nil );					// replace tiny tree with 
				tree.moveInto( southOfHouse );				// full-sized one
				FtinyTree.moveInto( nil );
				future.state += 2;							// update future state
			}
			if ( self.groCount = 2 )
			{
				incscore( 3 );								// points for getting at least
				global.scoreCard[13] := 1;					// two jugs to the spot
			}
			if ( self.groCount = 3 )
			{
				tireSwing.moveInto( southOfHouse );			// the tree is big enough
				swingRope.moveInto( southOfHouse );			// to support a tree swing
				distantBranch.moveInto( southOfHouse );
				rope.moveInto( midTree );
				distantTire.moveInto( midTree );
			}
			if ( self.groCount = 4 )
			{
				jug5.moveInto( insideShed );				// make the fifth jug appear
				Blackie.moveInto( insideShed );
				notify( Blackie, &actorDaemon, 0 );
			}
			if ( self.groCount = 5 )
			{
				incscore( 5 );								// points for all five
				global.scoreCard[14] := 1;
			}
		}
	}

	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"You know, trees need help when they get started.
				Like, you have to put fertilzer in there, something to help
				it grow besides water.\" ";
				return( true );
			case Laura:
				"Laura says, \"Newly planted trees need a lot of nutrients in
				the soil to get started. If you've got something like that, I'd
				suggest pouring it on there.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

linkRoad: room
	sdesc = "Oakwood drive"
	ldesc = "This pleasant road wanders peacefully through the lush tree growths
			native to the area. In the intervening years, they'll straighten 
			the road and widen it, cutting down dozens of these thirty- to 
			eighty-year-old live oaks. "
	xdesc = "The road leads north into the old shopping village, and a path winds 
			back into the forest to the southwest. "
	north = FPvillage
	sw = diggingSpot
;

oakTrees: block
	sdesc = "live oak trees"
	ldesc = "The aging live oaks rise to thirty or forty feet in height at their 
			bushiest. "
	location = linkRoad
	noun = 'tree' 
	plural = 'trees' 'oaks' 
	isThem = true
	adjective = 'oak' 'live' 'growth' 'lush' 'old' 'native'

	verDoClimb( actor ) =
	{
		"These trees are not suitable for climbing. ";
	}
;

windingRoad: fixedBlock
	sdesc = "pleasant road"
	location = linkRoad
	noun = 'road' 'street'
	adjective = 'winding' 'pleasant' 'wandering'
;

dummyPath4: block
	sdesc = "path"
	location = linkRoad
	noun = 'path'
;

dummyForest: fixedBlock
	sdesc = "forest"
	noun = 'forest'
	location = linkRoad
;

FPvillage: room
	sdesc = "In the village"
	ldesc = "The little shopping village looks a lot different than you're used to 
			seeing it. The sandwich shop is there, to the north, but it 
			doesn't look like it's open for business yet. "
	xdesc = "To the west is the bank, which seems like it's always been here and 
			always will. To the east is an antique store, where the public 
			library will be. The road leading back is south. "
	north = { FPdummyShop.ldesc; return( nil ); }
	east = antiqueStore
	west = FPbank
	south = linkRoad
	in = { askdo; }
;

FPdummyShop: lockableDoorway, readable
	herring = true
	sdesc = "sandwich shop"
	ldesc = "The sandwich shop is there, to the north, but it doesn't look like 
		it's open for business yet. A sign on the shop says:  \"Grand Opening 
		in 1 Week!\" "
	noun = 'sign'
	adjective = 'sandwich' 'shop'
	location = FPvillage
	mykey = villageKey
;

antiqueStoreExterior: fixedBlock
	sdesc = "antique store"
	ldesc = "This little antique shop sits where the library will someday be. "
	noun = 'store'
	adjective = 'antique'
	location = FPvillage
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"I think I remember there used to be an antique store
				across from here, where the library is now. They went out of business
				a long time ago, though.\" ";
				return( true );
			case Laura:
				"Laura says, \"I love browsing in there after work. You never know
				what you'll find in there that someone's gotten rid of.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

FPbank: lockableDoorway
	isopen = true
	islocked = nil
	sdesc = "bank"
	ldesc = "This bank has been here as long as you can remember. In fact, it's been
			around even longer than that, because here it is, and open for business. "
	noun = 'bank'
	doordest = inTheBank
	location = FPvillage
	mykey = villageKey
;

inTheBank: room
	sdesc = "In the bank"
	ldesc = "The bank interior is polished and impeccable. "
	xdesc = "A desk to the south says \"New Accounts.\"  A teller window to the 
			north is labeled \"Deposits and Withdrawals.\" A hallway leads
			west into the bank's back offices. The exit is east. "
	
	out = { return( self.east ); }
	east = 
	{
		switch( global.timeLoc )
		{
			case 1: return( FPvillage );
			case 2: return( Pvillage );
			case 3: return( village );
			case 4: return( stripMall );
			case 5: return;
		}
	}
	south = 
	{
		switch( global.timeLoc )
		{
			case 1: return( newAccounts );
			case 2: return( PnewAccounts );
			default: 
				"[BUG - timeLoc = "; 
				say( global.timeLoc ); 
				" ] "; 
				return;
		}
	}
	north = tellerWindow
	west = 
	{
		if ( global.timeLoc != 2 )
			"The teller says, \"Excuse me, but bank customers are 
			not allowed to go into the back offices.\" ";
		else if ( PLaura.location != PLaurasOffice )
			"The teller says, \"Excuse me, but bank customers are 
			not allowed to go into the back offices.\" ";
		else return( PLaurasOffice );
	}
	
	enterRoom( actor ) = 
	{
		setit( Laura, 2 );
		setit( teller, 1 );
		pass enterRoom;
	}
;

dummyNewAccountsDesk: fixedBlock
	sdesc = "desk"
	ldesc = 
	{
		"You walk over to the new accounts desk. \n";
		if ( global.timeLoc = 1 )
			Me.travelTo( newAccounts );
		else if ( global.timeLoc = 2 )
			Me.travelTo( PnewAccounts );
	}
	noun = 'desk'
	adjective = 'new' 'accounts'
	location = inTheBank
;

newAccounts: room
	sdesc = "New accounts"
	ldesc = "The new accounts area is a clean little area in the corner of the
			bank. "
	xdesc = "The lobby is back to the north. "
	north = inTheBank
;

Laura: NPC
	isHer = true
	noun = 'Laura' 'lady' 'miss' 'mrs' 'ms' 'woman' 'employee' 'suit'
	adjective = 'short' 'dark'
	sdesc = "Laura"
	adesc = "Laura"
	thedesc = "Laura"
	ldesc = "Laura is a friendly young woman with flashing green eyes. She looks 
			genuinely pleased to meet you. "
	location = newAccounts
	
	sayHello = 
	{
		if ( not self.greetedOnce )
			"Laura smiles and says, \"Good morning. How can I help you?\" ";
		else
		{
			"Laura smiles and says, \"Hi again! Can I help you?\" ";
			self.greetedOnce := true;
		}
	}
	actorDesc =
	{
		"Laura, a bank employee, is sitting at the new accounts desk. ";
	}
	
	askingAboutMe( who ) =
	{
		return( askingAboutLaura.askingAboutMe( who ) );
	}
	
	talkAboutMyself =
	{
		"Laura says, \"Oh, my life's pretty boring. Grew up, started working 
		here right after college. Blah blah blah. Still no idea what I want
		to do with my life! I've got plans, though. Gotta have plans.\" ";
	}
	responseToThanks = 
	{
		if ( account.isopen ) 
			"\^<<self.thedesc>> says, \"Oh, you're very welcome. Come again.\" ";
		else
			"\^<<self.thedesc>> says, \"Have a nice day.\" ";
	}
	
	knowWhereIsList = [ teller account ]
	sayWhereIs( it ) =
	{
		"\^<<self.thedesc>> says, \"";
		switch( it )
		{
			case teller: "He's at the window, just north of here.";
				break;
			case account:
				if ( account.isopen ) 
					"It's ready to go. Just see the teller if 
					you want to make further deposits.";
				else
					"You don't have an open account here yet.";
				break;
		}
		"\" ";
	}
	
	MAX_actions = 60
	action = 0
	actorDaemon = 
	{
		if ( Me.location = self.location )
		{
			if ( self.wasTalkedTo = nil )
			{
				local temp;
				if ( ( self.action > self.MAX_actions ) or ( self.action < 0 ) )
					self.action := 0;
				doLauraAction( self.action );
				self.action++;
			}
		}
		self.wasTalkedTo := nil;
	}
	ioGiveTo( actor, dobj ) = 
	{
		if ( dobj = sealedEnvelope )
		{
			"Laura reacts with curious surprise as you hold out the sealed
			envelope to her. \"What's this?\" she asks. She gingerly breaks the
			red wax seal, trying to preserve it. \"How fancy,\" she says, drawing
			out a letter written on brittle, translucent stationery. \b
			
			Laura begins to read the letter. Before she even finishes the first
			page, she abruptly stands up, her hand going to her throat. She looks
			at you, and you stare blankly back. \"Did ...\"\ she starts to say,
			but breaks off. She reads the remaining two pages, then folds them
			back into the envelope and closes it. \b
			
			\"Could you excuse me for a moment? I think I have to quit my job
			now.\" She looks like she's in a state of mild shock as she turns
			on her heels and walks, almost in slow motion, from her desk and
			into the back corridors of the bank. ";
			
			sealedEnvelope.moveInto( nil );
			self.moveInto( nil );
			PLaura.moveInto( nil );
			PLaurasOffice.changed := true;
			incscore( 10 );
			global.scoreCard[23] := 1;
			newFuture.isHere := true;
		}
		else pass ioGiveTo;
	}
;

laurasDesk: unimportantItem
	sdesc = "Laura's desk"
	adesc = "Laura's desk"
	thedesc = "Laura's desk"
	noun = 'desk'
	adjective = 'laura\'s'
	location = newAccounts
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Laura:
				"Laura taps the desk. \"Yup, it's my desk. Personally, I kind of
				want to get out from behind it. Just don't tell my boss that.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

tellerWindow: room, fixedBlock, seeThruItem
	sdesc = "Teller window"
	ldesc = "The teller stands ready at the window, with a polite but grim expression. "
	noun = 'window'
	adjective = 'teller'
	location = inTheBank
	out = { return( self.location.east ); }
	east = { return( self.location.east ); }
	south = inTheBank
	statusPrep = "at"
	outOfPrep = "back from"
	contentsVisible = { return true; }
	contentsReachable = { return true; }
	dispBeginSdesc = "\b\(At the "
	noexit = 
	{
		"You step away from <<self.thedesc>>. "; 
		return( self.location );
	}
	
	moveToWindow =
	{
		if ( Me.location != tellerWindow )
		{
			"(first approaching the teller window) \n";
			Me.moveInto( tellerWindow );
		}
	}
	
	enterRoom( actor ) = 
	{
		inherited.enterRoom( actor );
		teller.greetCustomer;
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case teller:
				self.moveToWindow;
				teller.greetCustomer;
				return( true );
			case Laura:
				"Laura says, \"Once you've got an account, you need to go to 
				the teller window to handle your transactions.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

deposit: fixedBlock
	sdesc = "deposit"
	noun = 'deposit'
	plural = 'deposits'
	
	verDoMake( actor ) = 
	{
		if ( actor.location = stripMall )
			"You'll have to use the ATM to do that. ";
		else if ( not actor.isIn( inTheBank ) )
			"You can't do that here. ";
	}
	doMake( actor ) = 
	{
		tellerWindow.moveToWindow;
		teller.handleDeposit;
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Laura:
				"\"You'll want to see the teller in the main lobby about 
				that,\" she says, smiling. \"I'm only here to set up new 
				accounts, not to help manage them.\" ";
				return( true );
			case teller:
				if ( not account.isopen ) 
					"The teller says, \"I'm sorry, sir, you don't seem to have
					an account with us. You should talk to Laura at the new accounts
					desk about setting one up. Then I'll be happy to help you with
					any transactions.\" ";
				else {
					Me.moveInto( tellerWindow );
					teller.handleDeposit;
				}
				return( true );
			default: 
				return( nil );
		}
	}
;

withdrawal: fixedBlock
	sdesc = "withdrawal"
	noun = 'withdrawal' 'withdrawl'
	plural = 'withdrawals' 'withdrawls'
	
	verDoMake( actor ) = 
	{
		if ( actor.location = stripMall )
			"You'll have to use the ATM to do that. ";
		else if ( not actor.isIn( inTheBank ) )
			"You can't do that here. ";
	}
	doMake( actor ) = 
	{
		if ( account.value > 100 )
		{
			tellerWindow.moveToWindow;
			teller.handleWithdrawal;
		}
		else
			"You don't have enough money in the account to make a withdrawal. ";
	}
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Laura:
				"\"You'll want to see the teller in the main lobby about 
				that,\" she says, smiling. \"I'm only here to set up new 
				accounts, not to help manage them.\" ";
				return( true );
			case teller:
				if ( not account.isopen ) 
					"The teller says, \"I'm sorry, sir, you don't seem to have
					an account with us. You should talk to Laura at the new accounts
					desk about setting one up. Then I'll be happy to help you with
					any transactions.\" ";
				else {
					if ( account.value > 100 )
					{
						tellerWindow.moveToWindow;
						teller.handleWithdrawal;
					}
					else
						"The teller says, \"I'm sorry, sir. You don't have 
						enough money in the account to make a withdrawal. 
						The minimum balance we require is $100, and you are
						already below that.\" ";
				}
				return( true );
			default: 
				return( nil );
		}
	}
;

account: fixedBlock, floatingItem
	sdesc = "account"
	ldesc = 
	{
		if ( not self.isopen )
			"You don't have an open account. ";
		else
		{
			tellerWindow.moveToWindow;
			"The teller says, \"";
			self.doCheck( Me );
			"\" ";
		}
	}
	adesc = "an account"
	noun = 'account' 
	plural = 'accounts'
	adjective = 'new' 'my'
	location = 
	{
		if ( Me.location = inTheBank || Me.location = newAccounts || 
			Me.location = tellerWindow )
			return( Me.location );
		else if ( Me.location = PnewAccounts )
			"No one is here to help you with that. ";
		return( nil );
	}
	isopen = nil
	PINnumber = 1234
	
	value = 0
	FP = 0
	P = 0
	PT = 0
	F = 0
	FF = 0
	
	verDoCheck( actor ) = 
	{
		if ( not self.isopen )
			"You do not have an open account. ";
	}
	doCheck( actor ) = 
	{
		local balance;
		
		"You currently have ";
		
		switch( global.timeLoc )
		{
			case 1: balance := self.FP; break;
			case 2: balance := self.P; break;
			case 3: balance := self.PT; break;
			case 4: balance := self.F; break;
			case 5: balance := self.FF; break;
		}
		
		if ( balance = 0 )
			"no money";
		else
		{
			sayPrefixCount( balance );
			" <<balance = 1 ? "dollar" : "dollars">>";
		}
		" in your account.";
	}
	
	verDoTake( actor ) = 
	{
		"If you want to take your account, you'll have to make a withdrawal. ";
	}
	verDoOpen( actor ) = 
	{
		if ( self.isopen )
			"You already have an account. ";
	}
	doOpen( actor ) = 
	{
		Laura.isSeen := true;
		setupAccount( self );
	}
	verDoClose( actor ) = 
	{
		if ( not self.isopen )
			"You don't have an account to close. ";
	}
	doClose( actor ) =
	{
		tellerWindow.moveToWindow;
		"The teller frowns. \"I'm sorry, all requests for account closure must 
		be made in writing.\" ";
	}
	
	verIoPutIn( actor ) = {}
	ioPutIn( actor, dobj ) = 
	{
		tellerWindow.moveToWindow;
		teller.handleDeposit;
	}
	verIoTakeOut( actor ) = {}
	ioTakeOut( actor, dobj ) = 
	{
		if ( !isclass( dobj, moneyItem ) )
		{
			"That isn't something you can withdraw from your account. ";
		}
		else if ( account.value > 100 )
		{
			tellerWindow.moveToWindow;
			teller.handleWithdrawal;
		}
		else
			"You don't have enough money in the account to make a withdrawal. ";
	}
	
	verIoDepositIn( actor ) =  {}
	ioDepositIn( actor, dobj ) = 
	{
		tellerWindow.moveToWindow;
		teller.handleDeposit;
	}
	ioWithdrawFrom( actor, dobj ) =
	{
		tellerWindow.moveToWindow;
		teller.handleWithdrawal;
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Laura:
				if ( self.isopen )
					"Laura says, \"You'll have to take any other matters concerning 
					your new account to the teller window. Thanks!\" ";
				else
				{
					local yesno;
					
					"Laura asks, \"Yes, would you care to open a new account?\" \b>>";
					
					yesno := yorn();

//					"\n";

					if ( yesno = 1 ) {
						setupAccount( self );
					}
					else
						"\"Okay, have a nice day, then.\" ";
				}
				return( true );
			case teller:
				if ( self.isopen )
				{
					"\^<<who.thedesc>> says, \"I can handle any deposits
					you'd like to make at this time.\" ";
				}
				else
				{
					"\^<<who.thedesc>> says, \"If you'd like to open an
					account, you'll have to see ";
					if ( global.timeLoc = 1 )
						"Laura at our new accounts desk. She'll be
						happy to help you.\" ";
					else
						"our new accounts clerk when he gets back from
						lunch.\" ";
				}
				return( true );
			default: 
				"\^<<who.thedesc>> says, \"What do I look like, a bank?\" ";
				return( true );
		}
	}
;

teller: NPC
	isHim = true
	sdesc = "teller"
	thedesc = "the teller"
	adesc = "the teller"
	ldesc = "The bank teller is a short, skinny man with brown hair and a 
			white shirt. "
	noun = 'teller'
	location = tellerWindow
	actorDesc = "The bank teller is standing behind the teller window. "
	sayHello = "The teller says, \"Good morning.\" "
	disavow( it ) = 
	{
		"The teller says, \"I'm sorry, but I can only help you with 
		withdrawals and deposits.\" ";
	}
	talkAboutMyself = {
		"The teller says, \"I can help you with any deposits or withdrawals
		you would like to make today.\" ";
	}
	responseToThanks = 
	{
		"\^<<self.thedesc>> says, \"Thank you. Come again.\" ";
	}
	doWhoAmI( actor ) = {
		if ( account.isopen ) 
			"The teller says, \"You're our favorite customer, of course.\" ";
		else
			"The teller says, \"I really have no idea, since you aren't one
			of our customers. If you would like to set up an account, please
			talk to Laura.\" ";
	}
	knowWhereIsList = [ Laura PLaura FLaura FFLaura laurasDesk PnewAccountsDesk ]
	sayWhereIs( it ) =
	{
		"\^<<self.thedesc>> says, \"";
		switch( it )
		{
			case Laura:
			case PLaura: 
			case FLaura:
			case FFLaura:
				if ( global.timeLoc = 1 )
					"She's at the new accounts desk, just south of here.";
				else if ( global.timeLoc = 2 )
				{
					"Ms. Remick? ";
					if ( PLaura.location = PLaurasOffice )
						"I believe she's in her office right now.
						Just west of here.";
					else
						"I believe she's stepped out for the moment.
						She didn't say when she'd be back.";
				}
				break;
			case laurasDesk:
			case PnewAccountsDesk: 
				"The new accounts desk is just south of here.";
				break;
		}
		"\" ";
	}
	
	greetCustomer = 
	{
		local response, check, loop;
		
		"\bThe teller says, \"Good morning. Would you care to make a deposit
		or a withdrawal today?\" \b>>";
		
		loop := nil;
		
		do
		{
			response := inputline();
			check := lower( response );
		
			if ( check = 'withdrawal' || check = 'withdrawl' || check = 'w' )
			{
				self.handleWithdrawal;
				loop := true;
				break;
			}
			else if ( check = 'deposit' || check = 'dep' || check = 'd' )
			{
				self.handleDeposit;
				loop := true;
				break;
			}
			else if ( check = 'no' || check = 'n' || check = 'neither' 
				|| check = 'q' || check = 'quit' || check = 'bye' ||
				check = 'goodbye' )
			{
				self.sayGoodbye;
				loop := true;
				break;
			}
			else
				"The teller repeats, \"Deposit or withdrawal?\" \bTeller>";
		} while ( loop = nil );
	}
	
	handleWithdrawal = 
	{
		if ( not account.isopen )
		{
			if ( global.timeLoc = 1 )
				"\"I'm sorry. You don't seem to have an open account. 
				Please see Laura at the new accounts desk first.\" ";
			else 
				"\"I'm sorry. You don't seem to have an open account. 
				Our new accounts clerk will be happy to help you when
				he gets back from lunch.\" ";
		}
		else
			"\"I'm sorry. You can't make any withdrawals at this time.\" ";
		
		self.sayGoodbye;
		return;
	}
	
	depositCount = 0
	handleDeposit = 
	{
		local response, check, loop;
		
		"\bThe teller says, \"A deposit. Very good.\" He punches some 
		numbers on his computer. ";
		
		if ( not account.isopen )
		{
			"\"I'm sorry. You don't seem to have an open account. Please
			see Laura at the new accounts desk first.\" ";
			
			self.sayGoodbye;
			return;
		}
		if ( account.value > 750000 )
		{
			"\"Oh dear,\" he says. \"There seems to be a problem with
			the computer. I'm afraid I can't accept any more deposits
			at this time. I'm very sorry about this.\" ";
			
			self.sayGoodbye;
			return;
		}
		
		"\"How much will you be depositing today?\" \b$>";
		
		loop := true;
		do
		{
			response := inputline();
			check := cvtnum( response );
			
			if ( check > playerCash.value )
			{
				"You don't have that much money on you. ";
			}
			else if ( check > 0 )
			{
				"The teller says, \"Very good.\" ";
				loop := nil;
				break;
			}
			else {
				check := lower( response );
				switch ( check ) {
					case 'quit':
					case 'q':
					case 'n':
					case '0':
						self.sayGoodbye;
						return;
					case 'i':
					case 'inv':
					case 'inventory':
						if ( not playerCash.deepIsIn( inTheBank ) ) {
							"You don't have any money with you. ";
							break;
						}
						"You are currently holding $<<playerCash.value>>. ";
				}
			}
			"\bThe teller repeats, \"How much will you be depositing today?\" \b$>";
		} while ( loop = true );
		
		account.value += check;
		playerCash.value -= check;
		global.money := playerCash.value;
		updateAccount( account );
		
		if ( playerCash.value = 0 )
			playerCash.moveInto( nil );
		
		"\bThe teller takes the money and fiddles with his computer for a moment. ";
		account.ldesc;
		self.depositCount++;
		self.sayGoodbye;
		return;
	}
	
	sayGoodbye = 
	{
		"\bThe teller says, \"Have a nice day.\" ";
		Me.travelTo( inTheBank );
	}
;

antiqueStore: room
	sdesc = "Antique store"
	ldesc = "Stocked full of knickknacks and ancient collectibles, this shop is 
			pervaded by a rich, musty odor. Taking a look around, you are 
			somewhat ashamed to admit that you really can't tell one item 
			from another. None of it looks any more valuable or 
			rare than the collection you keep heaped in your garage. "
	xdesc = "The only exit is west into the village. "
	smellDesc = "This shop is pervaded by a rich, musty odor. "
	west = FPvillage
	out = FPvillage
	lightningRodHere = { return( lightningRod.location = self ); }
	
	leaveList = [ lightningRod metalSuitcase wheelbarrow2 ] 
	
	leaveRoom(actor) =
	{
		local tmplist, thisobj, i, j, tot;
		
		tmplist := self.leaveList;
		tot := length( tmplist );
		i := 1;
		j := [];
		while (i <= tot)
		{
			thisobj := tmplist[i];
			if ( thisobj.leaving( actor ) )
				self.leaveList := self.leaveList - thisobj;
			else 
			{
				if ( thisobj.location ) 
				{
					if ( thisobj.location != self )
					{
						j := j + thisobj;
						thisobj.moveInto( self );
					}
				}
			}
			i++;
		}
		if ( length( j ) > 0 )
		{
			"\bAs you start to walk out the door, the merchant 
			makes sure you're not taking "; 
			
			switch( length( j ) )
			{
				case 1: "<<j[1].thedesc>>"; break;
				case 2: "<<j[1].thedesc>> and <<j[2].thedesc>>"; break;
				case 3: "anything"; break;
			}
			
			" with you. ";
			
			"\bThe merchant says, \"Sorry, ";
			if ( length( j ) > 1 )
				"those have ";
			else "that has ";
			" to stay in the store.\" ";
		}
		else
		{
			if ( tot > length( self.leaveList ) )
				"\bThe merchant says, \"Thank you, come again!\" ";
		}
	}
	
	enterRoom( actor ) = 
	{
		self.lookAround( ( not self.isseen ) or global.verbose );
		setit( antiques );
		setit( antiqueMerchant, 2 );
		if ( wheelbarrow.location = self ) { 
			if ( not self.isseen ) {
				wheelbarrow.antiqueMerchantNotice := true;
				"\bAs you enter, you notice the antiques merchant casting
				an interested eye up and down your creaky old wheelbarrow. ";
			}
			else {
				"\bThe merchant greets you with a smile and a pair of raised 
				eyebrows as you enter. \"Back again, are we?\"\ she says. ";
				antiqueMerchant.justAskedYesOrNoQuestion := true;
				if ( wheelbarrow.antiqueMerchantNotice = nil ) {
					wheelbarrow.antiqueMerchantNotice := true;
					"\bYou notice that her gaze was drawn straight to
					your creaky old wheelbarrow the moment you wheeled
					the thing in. She eyes it up and down with interest. ";
				}
			}
		}
		else {
			"\bShe says, \"Good morning. Feel free to browse around.\" ";
		}
		if ( not self.isseen ) {
			self.firstseen;
			self.isseen := true;
		}
	}
;

antiqueMerchant: NPC
	isHer = true
	sdesc = "antiques merchant"
	thedesc = "the merchant"
	adesc = "the merchant"
	ldesc = "She's a feisty old lady with sharp eyebrows. Her deep-set green eyes
			have a somewhat piercing power, as if they were her most-trained
			tool. "
	noun = 'merchant' 'herself' 'marchant'
	adjective = 'feisty' 'old' 'lady' 'sharp' 'eyebrow' 'eyebrows' 'deep-set' 'deep'
		'set' 'green' 'eyes' 'piercing' 'power' 'most-trained' 'tool'
		'most' 'trained'
	location = antiqueStore
	
	responseToThanks = 
	{
		"\^<<self.thedesc>> says, \"Have a nice day.\" ";
	}
	yesOrNoAnswer( thisverb ) = 
	{
		if ( thisverb = yesVerb ) 
			"\^<<self.thedesc>> says, \"Good, good. Well, take your time.\" ";
		else 
			"\^<<self.thedesc>> looks confused for a moment. She says, \"Well, 
			take your time, take your time.\" ";
	}
	actorDesc = "The antiques merchant is here, puttering around her shop. "
	ioShowTo( actor, dobj ) =
	{
		if ( isclass( dobj, sellable ) )
			self.ioSellTo( actor, dobj );
		else if ( !dobj.scrutinizedOnce ) 
		{
			dobj.scrutinizedOnce := true;
			
			if ( isclass( dobj, NPC ) )
			{
				if ( dobj = self )
					"\^<<self.thedesc>> laughs and says, \"You can't sell
					me to myself. At least, I don't think so.\" ";
				else
				{
					"\^<<self.thedesc>> laughs and says, \"I don't think
					your friend is an antique.\" ";
					if ( dobj = Fred )
						"\bFred says, \"I still got a few good years left.\" ";
				}
			}
			else if ( dobj = Me )
			{
				"\^<<self.thedesc>> throws her head back and laughs. \"No 
				offense, dear, but I don't think I'm interested in appraising
				you.\" ";
			}
			else
				"\^<<self.thedesc>> says, \"I'm not interested in that.\" ";
		}
		else
		{
			if ( isclass( dobj, NPC ) )
			{
				if ( dobj = self )
					"\^<<self.thedesc>> says, \"I'm still not for 
					sale, and I'm still not buying.\" ";
				else
				{
					"\^<<self.thedesc>> says, \"That joke is getting
					old.\" ";
					if ( dobj = Fred )
						"\bFred says, \"Do you buy and sell old jokes?\" ";
				}
			}
			else if ( dobj = Me )
			{
				"\^<<self.thedesc>> says, \"Have you got anything to 
				show to me besides yourself? Because that's just not
				going to happen.\" ";
			}
			else
				"\^<<self.thedesc>> says, \"I told you, I'm not interested 
				in that. I'm not going to change my mind about it, either.\" ";
		}
	}
	disavow( it ) =
	{
		if ( it.isIn( self.location ) )
		{
			if ( isclass( it, buyable ) && it.myMerchant = self )
			{
				if ( it.boughtOnce )
					"You already bought <<it.thedesc>>. ";
				else
					it.doBuy( Me );
			}
			else if ( isclass( it, sandwichItem ) )
				"The merchant says, \"It'd have to be a damn ancient sandwich
				for it to qualify as an antique!\" She laughs brusquely. ";
			else
				self.ioSellTo( Me, it );
		}
		else if ( it.isNPC )
			"The merchant says, \"Can't say that I've ever met <<it.isHer ?
			"the lady" : "the man">>.\" ";
		else if ( isclass( it, cartItem ) ) 
			it.doSellTo( Me, antiqueMerchant );
		else if ( it.isfixed || not it.isListed )
			"The merchant says, \"Can't say that I have any opinion about
			<<it.thatdesc>>.\" ";
		else if ( isclass( it, sellable ) )
			"The merchant says, \"Hmmm. I might be able to take that off
			your hands. I'd have to see it to be sure. Bring it in and I'll
			give it the once over. Maybe we can make a deal.\" ";
		else if ( isclass( it, sandwichItem ) )
			"The merchant says, \"It'd have to be a damn ancient sandwich
			for it to qualify as an antique!\" She laughs brusquely. ";
		else if ( isclass( it, buyable ) && it.myMerchant = self )
		{
			if ( it.boughtOnce )
				"The merchant says, \"I already sold you that, didn't I?
				I hope it's working out for you.\" ";
			else
				"The merchant says, \"Eh? I don't see that here.\" ";
		}
		else
			"The merchant says, \"That doesn't sound like something I'd
			be interested in buying. I'd have to take a look at it to be
			sure, but I'm rarely wrong about these things.\" ";
	}
	
	verIoSellTo( actor ) = {}
	ioSellTo( actor, dobj ) =
	{
		if ( isclass( dobj, antiqueItem ) ) 
			"The merchant gives you a funny look and says, \"I'd go out of
			business if I ran the shop that way.\" ";
		else if ( isclass( dobj, NPC ) )
			"The merchant looks <<dobj.thedesc>> up and down. Finally, she
			can't keep a straight face and laughs. \"Your friend is very
			charming, but I'm not going to buy <<dobj.fmtYoum>> from you.\" ";
		else if ( dobj = Me ) 
			"The merchant says, \"I'm not going to buy you!\" ";
		
		else
		{
			switch( _rand( 2 ) )
			{
				case 1:
					"The merchant gives <<dobj.itobjdesc>> a quick once-over with 
					her expertly trained eyeballs. \b";
					break;
				case 2:
					"The merchant gives <<dobj.thedesc>> the once-over with her 
					keen pair of eyeballs. \b";
			}
			
			if ( isclass( dobj, sellable ) )
				dobj.doSellTo( actor, self );
			else
				"The merchant shakes her head and says, \"Sorry, <<dobj.thatdesc>> 
				<<dobj.isntdesc>>	something I can consider buying from you.\" ";
		}
	}
;

antiques: staticItem, searchHider
	sdesc = "antiques"
	ldesc = 
	{
		if ( self.searchCont = nil )
			"The collection of antiques is disordered, and contains nothing
			important. ";
		else
			"The collection of antiques is disordered, and most of it doesn't
			look important. You think you might turn something up if you gave 
			it a good search, though. ";
	}
	noun = 'store'
	plural = 'antiques' 'collectibles' 'knickknacks' 'knick-knacks' 'knacks' 'shelves' 
	isThem = true
	adjective = 'antique' 'knick' 'knack' 'collection' 'stuff' 'stock' 'shelf'
	location = antiqueStore
	autoTake = nil
	serialSearch = true
	
	verDoTake( actor ) = { "You can't take the collection of antiques. "; }
//	verDoSearch( actor ) = { "You find nothing of interest. "; }
	verDoBuy( actor ) = { self.ldesc; }
	verDoBuyFrom( actor, io ) = { self.ldesc; }
		
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"I don't know much about antiques, but any
				store with a collection of knickknacks is going to have
				something hidden away somewhere that'll be valuable.\" ";
				return( true );
			case Laura:
				"Laura says, \"I love browsing in antique stores. You never
				know what you'll find if you search around.\" ";
				return( true );
			case antiqueMerchant: 
				"The merchant says, \"Feel free to browse through them and
				see if anything catches your fancy.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

lightningRod: hiddenItem, antiqueItem
	sdesc = "lightning rod"
	ldesc =
	{
		"It is a long spear of conducting metal. ";
		
		if ( self.attached )
			"It is securely attached to the peak of the roof by a baseplate 
			and screws. The whole assembly feeds into a grounding wire that 
			trails away, hidden along the edge of the house. ";
	}
	noun = 'spear'
	adjective = 'lightning' 'rod' 'metal' 'conducting' 'long' 
				'attached' 'installed' 'shaft' 'craftsman' 'craftsman\'s'
				'initials' 'initial'
	bulk = 2
	cost = 85
	searchLoc = antiques
	salesPitch = "The merchant says, \"Ah yes. Let me tell you about this 
				lightning rod. You can't just run down to the local 
				hardware store to find a lightning rod like this one. 
				Assuming there were a local hardware store, that is.\" \b
				She looks it up and down. \"This was made by a 
				company in Boise, Idaho, that made lifetime guarantees
				for their lightning rods. Back in the 1930s, they made
				the best of the best. Cheap, mass-produced lightning
				rods eventually forced them out of the market. If you 
				really want to protect your house, though, this is the 
				one to get.\" "
	
	verDoAttachTo( actor, io ) = 
	{
		if ( self.attached )
			"The lightning rod is already fixed in place. ";
		else if ( io = roofPeak )
			"You are unequipped to properly attach the lightning rod to the 
			roof. It requires a set of the proper tools and equipment, such
			as a baseplate, safety braces, bolts, a 40-foot grounding wire,
			and some old-fashioned know-how, none of which are in your 
			possession. ";
		else if ( io = shingles2 || io = shingles1 || io = chimney )
			"The proper place to attach the lightning rod would be to the 
			peak of the south roof, not <<io.thedesc>>. ";
		else if ( io = Fshingles2 || io = Fshingles1 || io = Fchimney )
			"Since the damage done by the lightning has already occurred, it
			is a little after-the-fact to attach the lightning rod here
			and now. ";
		else
			"I don't know how to attach the lightning rod to that. ";
	}
/*
	doAttachTo( actor, io ) =
	{
		"You attach the lightning rod to the peak of the roof. ";
		self.attached := true;
		future.state += 4;		// update future state
		self.moveInto( southRoof );
	}
*/	
	verDoTake( actor ) = 
	{
		if ( self.attached )
			"The lightning rod is attached to the house and can no
			longer be taken. ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Hey, I wouldn't go carrying that around. What if
				there's a storm? You need to get someone who knows what they're
				doing to attach that to your roof.\" ";
				return( true );
			case Laura:
				"Laura says, \"Anything to do with lightning, I'm completely
				clueless. Wish I could help. You probably want to talk to 
				someone who knows how to install them properly.\" ";
				return( true );
			case Architect:
				if ( self.attached )
				 	"He says, \"It will be installed on the south roof at the
				 	proper time. Don't worry.\" ";
				else if ( self.askedOnce )
					"He says, \"As I told you, if you give me a lightning rod,
					I will make sure the lightning rod is installed on the
				 	roof for safety.\" ";
				else
				{
					"He says, \"Hmmm. You really have a good memory for
					details, but the installation of a lightning rod
					is more your personal business as the owner of the house
					than it is mine.\" \b
					
					He pauses and rubs his eyes blearily. \"However, I 
					suppose that if you were to give me a lightning rod,
					I would tell the men to attach it after they finish the
					roofing. It is a safety concern";
					
					if ( future.state > 1 )
						", especially when that tree at the south of the
						house grows up. If it gets big enough, it'll be its
						own lightning rod";
					
					", after all.\" ";
					
				 	self.askedOnce := true;
				}
				return( true );
			case antiqueMerchant:
				if ( self.boughtOnce = true )
					return( nil );
				self.salesPitch;
				return( true );
			default: 
				return( nil );
		}
	}
;

metalSuitcase: hiddenItem, antiqueItem, openable
	sdesc = "metal suitcase"
	ldesc = 
	{	"It's a solid suitcase with a shiny aluminum case, capable of
		transporting a volume of material securely. ";
		pass ldesc;
	}
	noun = 'suitcase' 'briefcase'
	adjective = 'metal' 'suit' 'case' 'shiny' 'aluminum'
	searchLoc = antiques
	isopen = nil
	bulk = 5
	maxbulk = 50
	cost = 45
	salesPitch = "The merchant says, \"The son of a traveling salesman brought this
			in recently. It's a design they don't make any more. Rather roomier
			on the inside than it looks.\" "
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Snazzy case you got there.\" ";
				return( true );
			case antiqueMerchant:
				if ( self.boughtOnce = true )
					return( nil );
				self.salesPitch;
				return( true );
			default: 
				return( nil );
		}
	}
;

wheelbarrow2: antiqueItem, cartItem
	isListed = true
	rodRoom = true										// kludge
	sdesc = "wheelbarrow"
	ldesc = 
	{
		"This filthy beast from, apparently, the last century, has a busted
		front wheel. It's still a little wobbly, but the bolt is holding it tight. ";
		
		if ( self.contentsVisible and itemcnt( self.contents ) != 0 )
		{
			"In "; self.thedesc; " %you% see%s%:\n "; 
			nestlistcont( self, 1 ); "\n";
		}
		else
		{
			"There's nothing in "; self.thedesc; ". ";
		}
	}
	noun = 'wheelbarrow' 'wheelb' 'wheelba' 'wheelbar' 'wheelbarr' 'wheelbarro'
			'barrow' 'barro' 'barr' 'wb' 'cart'
	adjective = 'filthy' 'beast'
	maxbulk = 150
	myMerchant = antiqueMerchant
	startLoc = antiqueStore
	cost = 120
	
	verDoTake( actor ) =
	{
		if ( not self.boughtOnce )
			"You have to buy <<self.thedesc>>. ";
		else
			"You can't pick up the wheelbarrow. It must weigh 100 pounds. ";
	}
	
	doBuy( actor ) =
	{
		if ( playerCash.value >= self.cost )
		{
			local yesno;
			
			"The merchant says, \"$<<self.cost>> for it. Deal?\" \b>>";
			
			yesno := yorn();
		
			if ( yesno = 1 )
			{
				"The merchant says, \"All righty. It's all yours. Again. 
				Thank you.\" ";
				
				self.boughtOnce := true;
				playerCash.value -= self.cost;
				global.money := playerCash.value;
				
				if ( playerCash.value = 0 )
					playerCash.moveInto( nil );
				
				return( true );
			}
			else
			{
				"The mechant says, \"Well, whatever. Have a nice day.\" ";
			}
			return( true );
		}
		else if ( global.money > 0 )
			"Don't waste <<self.myMerchant.thedesc>>'s time. You don't have 
			enough money. ";
		else
			"Don't waste <<self.myMerchant.thedesc>>'s time. You don't have 
			any money. ";
		return( nil );
	}
	
	verDoSell( actor ) = 
	{
		if ( not self.boughtOnce )
			"You can't sell something you don't even own yet! ";
	}
	doSell( actor ) = { askio( toPrep ); }
	
	verDoSellTo( actor, io ) = 
	{
		if ( not self.boughtOnce )
			"You can't sell something you don't even own yet! ";
	}
	doSellTo( actor, io ) =
	{
		if ( self.location = nil ) {
			wheelbarrow.doSellTo( actor, io );
			return( true );
		}
		"The merchant gives you a funny look. She says, \"What are you doing,
		playing games? Buy, sell, buy sell. You should go into the stock 
		market, not the antiques business.\" ";
		return( nil );
	}
	
	leaving( actor ) = 
	{
		return( self.boughtOnce );
	}
	verDoPutOn( actor, io ) =
	{
		if ( io != platform && io != timeMachine )
			"%You% can't put <<self.thedesc>> on that. ";
	}
	verDoPull( actor ) = 
	{
		if ( self.location != platform )
			"You pull the wheelbarrow and it moves back a foot or two. Otherwise, 
			it has no useful effect. ";
	}
	doPull( actor ) =
	{
		"You pull the wheelbarrow off the platform. ";
		self.moveInto( platform.location );
	}
	
	verDoPush( actor ) = 
	{
		if ( Me.location = platform && self.location = platform )
		{
			"You push the wheelbarrow off the platform. ";
			self.moveInto( platform.location );
		}
		else
			"%You% seem able to push <<self.thedesc>> around with %you%. ";
	}
	
	verDoMoveN( actor ) = 
	{
		if ( not self.boughtOnce )
			"You have to buy <<self.thedesc>>. ";
	}
	verDoMoveS( actor ) =
	{
		if ( not self.boughtOnce )
			"You have to buy <<self.thedesc>>. ";
	}
	verDoMoveE( actor ) =
	{
		if ( not self.boughtOnce )
			"You have to buy <<self.thedesc>>. ";
	}
	verDoMoveW( actor ) =
	{
		if ( not self.boughtOnce )
			"You have to buy <<self.thedesc>>. ";
	}
	verDoMoveNE( actor ) =
	{
		if ( not self.boughtOnce )
			"You have to buy <<self.thedesc>>. ";
	}
	verDoMoveNW( actor ) =
	{
		if ( not self.boughtOnce )
			"You have to buy <<self.thedesc>>. ";
	}
	verDoMoveSE( actor ) =
	{
		if ( not self.boughtOnce )
			"You have to buy <<self.thedesc>>. ";
	}
	verDoMoveSW( actor ) =
	{
		if ( not self.boughtOnce )
			"You have to buy <<self.thedesc>>. ";
	}
		
	doFixWith -> frontWheel2
	doSprayWith -> frontWheel2
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Wheelbarrows can hold a lot of stuff. That's
				sort of what they're designed to do, after all.\" ";
				return( true );
			case Laura:
				"Laura says, \"If you need to move a lot of heavy stuff, 
				sure. Use a wheelbarrow if you have one.\" ";
				return( true );
			case Architect:
				"He says, \"Yes, wheelbarrows. Carting stuff around. Very
				fascinating.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

frontWheel2: fixedBlock
	sdesc = "front wheel"
	ldesc = "It looks like you hit it on a rock and loosened the bolt, as well 
			as twisted the axle out of shape. It's still a little wobbly, but 
			the bolt is holding it tight. "
	noun = 'wheel' 'bolt'
	adjective = 'busted' 'front' 'axle' 'twisted' 'bolt' 'wobbly'
	location = wheelbarrow2
	
	verDoTake( actor ) =
	{
		"It's attached to the wheelbarrow. ";
	}
	
	verDoFixWith( actor, io ) = 
	{
		"The front wheel of the wheelbarrow is already repaired. ";
	}
	
	doBuy -> wheelbarrow2
	doBuyFrom -> wheelbarrow2
	doSell -> wheelbarrow2
	doSellTo -> wheelbarrow2
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Sounds like you should fix the wheel before you
				try hauling something heavy in the wheelbarrow. Don't you have
				a screwdriver?\" ";
				return( true );
			case Laura:
				"Laura says, \"I don't really know much about fixing busted
				wheels, I'm afraid, but if you had the right tool you could
				probably do it.\" ";
				return( true );
			case Architect:
				"He says, \"If it isn't broke, don't fix it. Then again, if 
				it is broken, then do fix it.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

undergroundWaters: waterItem, floatingItem
	sdesc = "underground waters"
	ldesc = "They are dark and swift-moving. "
	noun = 'stream' 'spring' 'water' 'waters'
	adjective = 'sparkling' 'fast' 'shallow' 'wet' 'slick' 'underground'
			'swift-moving' 'swift' 'moving' 'dark'
	location = 
	{
		if ( Me.location.cave )
			return( Me.location );
		else return( nil );
	}
	
	doWadeIn( actor ) = 
	{
		"You wade into the water for a bit. It would be more refreshing
		if you weren't soaked already. ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Yeah, there used to be a lot of underground
				springs in the area. I remember exploring them when I was
				a kid. They've all but dried up by now.\" ";
				return( true );
			case Architect:
				"He says, \"Yes, there used to be springs running underneath
				this property. We did some surveying to find out whether this
				site was suitable for building, and the geological surveys said
				that the groundwater was dried up and the limestone was solid.\" ";
				return( true );
			default: return( nil );
		}
	}
;

undergroundLimestone: unimportantItem, floatingItem
	sdesc = "limestone"
	ldesc = "The limestone is loose and chalky white. There are jagged edges
			where layers of sediment have crumbled, but where water has 
			carved it out, it is slick and smooth. "
	noun = 'limestone' 'stone'
	adjective = 'lime' 'chalky' 'white' 'loose' 'jagged' 'shale' 'shales' 'rock'
			'rocks' 'cave' 'tunnel' 'caves' 'cavern' 'caverns' 'walls' 'wall'
			'crawl' 'crawlway' 'tight' 'bend' 'bulge'
	location = 
	{
		if ( Me.location.cave )
			return( Me.location );
		else return( nil );
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Yeah, there are a lot of natural limestone
				caverns around here. I used to explore them as a kid.\" ";
				return( true );
			case Architect: 
				"He says, \"Come now. Haven't we grown up past the point
				of going cave-crawling?\" ";
				return( true );
			default: return( nil );
		}
	}
;

stalactites: unimportantItem, floatingItem
	sdesc = "stalactites"
	noun = 'stalactite'
	plural = 'stalactites'
	isThem = true
	
	location = 
	{
		if ( Me.location.cave )
			return( Me.location );
		else return( nil );
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Yeah, there are a lot of natural limestone
				caverns around here. I used to explore them as a kid.\" ";
				return( true );
			case Architect: 
				"He says, \"Come now. Haven't we grown up past the point
				of going cave-crawling?\" ";
				return( true );
			default: return( nil );
		}
	}
;

stalagmites: unimportantItem, floatingItem
	sdesc = "stalagmites"
	noun = 'stalagmite'
	plural = 'stalagmites'
	isThem = true
	
	location = 
	{
		if ( Me.location.cave )
			return( Me.location );
		else return( nil );
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Yeah, there are a lot of natural limestone
				caverns around here. I used to explore them as a kid.\" ";
				return( true );
			case Architect: 
				"He says, \"Come now. Haven't we grown up past the point
				of going cave-crawling?\" ";
				return( true );
			default: return( nil );
		}
	}
;

limestoneCrawl: caveRoom
	sdesc = "Limestone crawl"
	ldesc = "You are in a tiny crawlway carved by the flow of ancient waters
			through soft limestone. The natural groundwater springs are 
			drying up, and soon will be gone. A current of dark but shallow
			water swirls nearby. Light leaks down from a vertical sluice
			that leads up into the deep end of the grotto. "
	xdesc = "You can leave through careful navigation up the sluice, or follow
			the crawlway, which leads north. "
	lightDesc = 
	{
		"Light leaks down from a vertical sluice that leads up into the 
		deep end of the grotto. ";
		
		pass lightDesc;
	}
	up = 
	{
		"It's a somewhat torturous ascent, but with patience and resolve
		you manage to make your way up the sluice. Your head again goes 
		underwater for a moment, but you follow the light. Your hands 
		grope and find a hold on the shallow bottom of the pool. Emerging,
		you shake yourself dry as best you can. ";
		
		return( grotto );
	}
	out = 
	{
		"It's a somewhat torturous ascent, but with patience and resolve
		you manage to make your way up the sluice. Your head again goes 
		underwater for a moment, but you follow the light. Your hands 
		grope and find a hold on the shallow bottom of the pool. Emerging,
		you shake yourself dry as best you can. ";
		
		return( grotto );
	}
	north = narrowCrawl
;

verticalSluice: fixedBlock
	sdesc = "sluice"
	ldesc = "Light leaks down from a vertical sluice that leads up into the 
			deep end of the grotto. "
	noun = 'sluice' 'shaft'
	adjective = 'vertical' 'grotto'
	location = limestoneCrawl
	
	verDoEnter( actor ) = {}
	doEnter( actor ) = { self.doClimbUp( actor ); }
	
	verDoClimb( actor ) = {}
	doClimb( actor ) = { self.doClimbUp( actor ); }
	
	verDoClimbUp( actor ) = {}
	doClimbUp( actor ) =
	{
		"It's a somewhat torturous ascent, but with patience and resolve
		you manage to make your way up the sluice. Your head again goes 
		underwater for a moment, but you follow the light. Your hands 
		grope and find a hold on the shallow bottom of the pool. Emerging,
		you shake yourself dry as best you can. ";
		
		Me.travelTo( grotto );
	}
;

narrowCrawl: caveRoom
	sdesc = "Narrow north-south crawl"
	ldesc = "You are in a narrow north-south crawlway that bulges slightly, giving you
			more room to maneuver. "
	xdesc = "The crawlway heads north and then bends, making it difficult to see
			farther ahead, and slopes downward to the south. "
	north = tightBend
	south = limestoneCrawl
	down = limestoneCrawl
;

tightBend: caveRoom
	sdesc = "Tight bend"
	ldesc = "The tunnel you have been following makes a tight bend here. Chalky 
			dust swirls in the damp air, stirred up by your arrival. "
	xdesc = "The crawl widens to the south, and turns here to the southeast,
			making a sudden drop as it does so. "
	south = narrowCrawl
	se = crumbleRoom
	down = crumbleRoom
;

chalkyDust: unimportantItem
	sdesc = "chalky dust"
	ldesc = "Chalky dust swirls in the damp air, stirred up by your arrival. "
	noun = 'dust'
	adjective = 'chalky'
	location = tightBend
;

crumbleRoom: caveRoom
	sdesc = "Crumbling tunnel"
	ldesc = "Eroding limestone has caused the floor here to give way recently. 
			You find your footing on the crumbling chunks of limestone, but
			only after making a scary drop of about four feet. The walls of
			the tunnel sport all manner of jagged cracks, but you don't feel
			any shifting or settling. Perhaps it is safe to continue, but
			probably not much farther. "
	xdesc = "The limestone shelf is up and back to the northwest. The tunnel 
			continues forward to the north, descending even further as it
			does so. "
	up = tightBend
	nw = tightBend
	north = darkPassage
	down = darkPassage
;

darkPassage: caveRoom
	sdesc = "Dark passage"
	ldesc = "The light you have been following darkens here, making you wonder
			how much faith you have in the ambiguous light source. You can 
			no longer make out any colors, only grainy shades of light and
			dark, but there wouldn't be many other colors to see even in 
			full light. "
	xdesc = "The passage continues ahead, zigzagging to the northwest, and 
			to the south. "
	south = crumbleRoom
	nw = zigzag
;

zigzag: caveRoom
	sdesc = "Zigzag passage"
	ldesc = "The passage takes a series of sharp, zigzag turns here. As it does so, 
			you feel your ears pop in adjustment to changing altitude. "
	xdesc = "East you can discern a strange but growing brightness. This 
		passage zigzags into the darkness to the southeast. "
	se = darkPassage
	ne = ledgeSouth
;

ledgeSouth: caveRoom
	sdesc = "Ledge"
	ldesc = 
	{
		if ( !self.isseen && !ledgeNorth.isseen )
		{
			"The brightness coming from the bend in the tunnel to the north
			nearly distracts you from watching your footing. The sharp echo
			of a carelessly kicked stone, that rattles down for ten or twelve
			seconds before coming to a splashing halt, stops you in your tracks.\b
			
			You are standing on a narrow ledge at the south end of a jagged 
			east-west gap in the cave floor. The gap plunges straight down, 
			erosion having eaten everything away underneath. It is not a wide 
			gap, and you are capable of crossing it without difficulty. However, 
			you are aware that if you had stepped directly into it, your story 
			would have ended here, in the darkness and the deep. ";
		}
		else
		{
			"You are standing on a narrow ledge at the south end of a jagged 
			east-west gap in the cave floor. The gap plunges straight down, 
			erosion having eaten everything away underneath. It is not a wide 
			gap, and you are capable of crossing it without difficulty. ";
		}
	}
	xdesc = "Across the gap, the tunnel goes north and takes <<crystalCavern.isseen?
			"a bend into the crystal cavern":"another bend">>, and on this side
			it exits to the west. "
	west = zigzag
	down = "There is no point in risking it. "
	north = 
	{
		"You carefully cross to the other side of the gap and continue on.\n";
		return( brightBend );
	}
;

narrowLedgeSouth: fixedBlock
	sdesc = "narrow ledge"
	noun = 'ledge'
	adjective = 'narrow' 'other' 'side'
	location = ledgeSouth
	
	doLeapTo -> jaggedGapSouth
;

jaggedGapSouth: block
	sdesc = "jagged gap"
	ldesc = "The gap plunges straight down, erosion having eaten everything away 
			underneath. It is not a wide gap, and you are capable of crossing 
			it without difficulty. "
	noun = 'gap'
	adjective = 'jagged' 'erosion' 'east-west' 'west-east' 'north'
	location = ledgeSouth
	
	verDoLookin( actor ) = {}
	doLookin( actor ) = { self.ldesc; }
	
	verDoCross( actor ) = {}
	doCross( actor ) = 
	{
		"You carefully cross to the north side of the gap. ";
		Me.moveInto( ledgeNorth );
	}
	
	verDoLeapTo( actor ) = {}
	doLeapTo( actor ) = 
	{
		"You jump across to the north side of the gap. ";
		Me.moveInto( ledgeNorth );
	}
	
	verDoEnter( actor ) = 
	{
		"There is no point in risking it. ";
	}
	
	verDoBoard( actor ) = 
	{
		"There is no point in risking it. ";
	}
	
	verIoPutIn( actor ) = {}
	ioPutIn( actor, dobj ) =
	{
		"You drop <<dobj.thedesc>> down <<self.thedesc>>. It clinks and clunks
		on its way down, finally settling with a distant, echoing splatter. ";
		
		dobj.moveInto( nil );
	}
;

ledgeNorth: caveRoom
	sdesc = "Ledge"
	ldesc = 
	{
		if ( !self.isseen && !ledgeSouth.isseen )
		{
			"As your eyes are still adjusted to the brightness of the
			crystal cavern, you slow your pace to shuffling steps. Just as
			your toes fail to find solid floor, the sharp echo of a carelessly 
			kicked stone, that rattles down for ten or twelve seconds before 
			coming to a splashing halt, stops you in your tracks.\b
			
			You are standing on a narrow ledge at the north end of a jagged 
			west-east gap in the cave floor. The gap plunges straight down, 
			erosion having eaten everything away underneath. It is not a wide 
			gap, and you are capable of crossing it without difficulty. However, 
			you are aware that if you had stepped directly into it, your story 
			would have ended here, in the darkness and the deep. ";
		}
		else
		{
			"You are standing on a narrow ledge at the north end of a jagged 
			west-east gap in the cave floor. The gap plunges straight down, 
			erosion having eaten everything away underneath. It is not a wide 
			gap, and you are capable of crossing it without difficulty. ";
		}
	}
	xdesc = "Across the gap, the tunnel goes southwest, and it continues back
			north and takes a bend into the crystal cavern. "
	sw = 
	{
		"You carefully cross to the other side of the gap and continue on.\n";
		return( zigzag );
	}
	down = "There is no point in risking it. "
	north = brightBend
;

narrowLedgeNorth: fixedBlock
	sdesc = "narrow ledge"
	noun = 'ledge'
	adjective = 'narrow' 'other' 'side'
	location = ledgeNorth
	
	doLeapTo -> jaggedGapNorth
;

jaggedGapNorth: block
	sdesc = "jagged gap"
	ldesc = "The gap plunges straight down, erosion having eaten everything away 
			underneath. It is not a wide gap, and you are capable of crossing 
			it without difficulty. "
	noun = 'gap'
	adjective = 'jagged' 'erosion' 'east-west' 'west-east' 'south'
	location = ledgeNorth
	
	verDoLookin( actor ) = {}
	doLookin( actor ) = { self.ldesc; }
	
	verDoCross( actor ) = {}
	doCross( actor ) = 
	{
		"You carefully cross to the south side of the gap. ";
		Me.moveInto( ledgeSouth );
	}
	
	verDoLeapTo( actor ) = {}
	doLeapTo( actor ) = 
	{
		"You jump across to the south side of the gap. ";
		Me.moveInto( ledgeSouth );
	}
	
	verDoEnter( actor ) = 
	{
		"There is no point in risking it. ";
	}
	
	verDoBoard( actor ) = 
	{
		"There is no point in risking it. ";
	}
	
	verIoPutIn( actor ) = {}
	ioPutIn( actor, dobj ) =
	{
		"You drop <<dobj.thedesc>> down <<self.thedesc>>. It clinks and clunks
		on its way down, finally settling with a distant, echoing splatter. ";
		
		dobj.moveInto( nil );
	}
;

brightBend: caveRoom
	sdesc = "Bright bend"
	ldesc = "Bright blue illumination shines from the opening to a larger
			cavern to the east. The light shimmers and ripples on the walls,
			wavelike patterns that dance and intermingle, shining all the
			more brightly where they overlap. "
	xdesc = 
	{
		"The cavern is east, and the tunnel bends south, where it ";
		
		if ( ledgeSouth.isseen || ledgeNorth.isseen )
			"meets a ledge. ";
		else
			"disappears into growing darkness. ";
	}
	south = ledgeNorth
	east = crystalCavern
;

crystalCavern: caveRoom
	sdesc = "Crystal cavern"
	ldesc = "You are in a large cavern that seems to be an enormous natural
			geode, with crystals as big as your head growing in splints
			and shafts from every direction. A pool of white water catches
			the reflected and refracted light and spins it back into the
			room, where it is caught and re-refracted. The original source
			of the light seems to be a series of pinholes in the roof of
			the cavern high above, but you don't think it could be sunlight.
			You have lost track of how deep you have gone, perhaps twenty, 
			perhaps forty feet under the surface, but too far down to see 
			sunlight, you would have thought. It is possible that sunlight
			has periscoped down a set of small crystal encrusted shafts that
			lead far enough up to see the open sky. In any case, it is 
		literally mesmerizing to be here. "
	xdesc = "The only exit is a tunnel to the west. "
	lightDesc = "A pool of white water catches the reflected and refracted light 
			and spins it back into the room, where it is caught and re-refracted. 
			The original source of the light seems to be a series of pinholes 
			in the roof of the cavern high above, but you don't think it 
			could be sunlight. "
	west = brightBend
	out = brightBend
;

crystals: item
	sdesc = "crystals"
	adesc = "crystals"
	ldesc = "Crystals as big as your head and as delicately small as your 
			fingernail are growing in splints and shafts from every
			direction. "
	noun = 'geode'
	plural = 'crystals'
	isThem = true
	adjective = 'splint' 'splints' 'shaft' 'shafts' 'geode' 'crystal'
	location = crystalCavern
	
	verDoTake( actor ) = 
	{
		if ( blueCrystal.location )
			"There aren't any other crystals loose enough to take. ";
	}
	doTake( actor ) =
	{
		"You search for a crystal loose enough to take without breaking it
		or a larger crystal. After a short search, you discover a perfect
		blue crystal, which you take. ";
		
		blueCrystal.moveInto( actor );
		incscore( blueCrystal.takevalue ); 	// add the "takevalue" to the score
		blueCrystal.hasScored := true;	 	// note that we have scored
		global.scoreCard[27] += blueCrystal.takevalue;
	}
	
	verDoSearch( actor ) = { self.verDoTake( actor ); }
	doSearch( actor ) = { self.doTake( actor ); }
	
	verDoBreak( actor ) =
	{
		"You can't even conceive of harming such a delicate natural 
		wonder. ";
	}
;

blueCrystal: treasure
	sdesc = "perfect blue crystal"
	ldesc = "The crystal is about an inch long, with perfect hexagonal symmetry.
			It is a dazzling little keepsake. "
	noun = 'crystal'
	adjective = 'perfect' 'blue' 'hexagonal' 'hexagon' 'symmetry' 'keepsake'
			'dazzling'
	location = nil
	takevalue = 3
	
	verDoBreak( actor ) =
	{
		"You can't even conceive of harming such a delicate natural 
		wonder. ";
	}
;

pinholes: unimportantItem
	sdesc = "pinholes"
	ldesc = { crystalCavern.lightDesc; }
	noun = 'pinhole' 'hole'
	plural = 'pinholes' 'holes'
	isThem = true
	adjective = 'series' 'pin'
	location = crystalCavern
;

crystalCavernPool: fixedBlock, waterItem
	sdesc = "pool of white water"
	ldesc = "The pool of white water is silent and slightly rippled, calmer than
		the vibrant dance of light on its surface. "
	noun = 'water'
	adjective = 'pool' 'of' 'white' 'surface'
	location = crystalCavern
	
	verDoDrink( actor ) =
	{
		"The water's white color indicates a strong mineral content. 
		It probably is not good for drinking. ";
	}
	
	verDoWadeIn( actor ) = {}
	doWadeIn( actor ) = 
	{
		"You don't want to disturb the pool's calm beauty by wading in it. ";
	}
;


/* eof */
