// johndoe.t: A goofy little test/demo program for Chatter.

#include <adv.t>
#include <std.t>

#include "chatter.t"

#pragma C+

startroom: room
  sdesc = "Room"
  ldesc = "It's a room. To the east is a closet."

  east = closet
;

closet: room
  sdesc = "Closet"
  ldesc = "It's a closet."

  west = startroom
;

johndee: Actor
  sdesc = "John"
  thedesc = "John"
  adesc = "John"
  noun = 'john'
  isHim = true
  location = nil
;

bookDouble: infoSource
  sdesc = "book 2"
  noun = 'book'
  adjective = '2'
  location = nil
;
  
johndoe: Actor
  sdesc = "John"
  thedesc = "John"
  adesc = "John"
  noun = 'john'
  isHim = true
  location = startroom
  mytopic = johnTopic
  bananaInEar = nil

  canInteract(verbType) = {
    if (self.bananaInEar) {
      if (verbType == 1)
        "John can't hear you. He has a banana in his ear.";
      else if (verbType == 2)
        "John doesn't notice.";
      else
        "John doesn't notice your offer.";
      return nil;
    }
    else
      return true;
  }

  askDefault = "\"Don't know much about that.\""
  askForDefault = "\"Don't have that.\""
  tellDefault = "\"That's nice.\""
  showDefault = "\"Wow.\""
  giveDefault = "\"Don't want it.\""
  actionDefault = "\"Don't go ordering me around!\""
  yesNoDefault = "\"Hullabaloo\""
  helpResponse = "\"Help! Police!\""
  helloResponse = "\"Hi there.\""
  goodbyeResponse = "\"Bye.\""
  thankResponse = "\"You're welcome.\""
  sorryResponse = "\"That's okay.\""
  sayHandler(str) = "\"Yuhhuh. String is '<<str>>'\""

  askForRedirect = [thingyTopic]
  showRedirect = [ALL_EXCEPT barTopic]
  tellRedirect = true
  giveRedirect = [lanternItem]

  reportObjwords(w) = {
    local len = length(w);
    local i;

    "Here's objwords:";
    for (i=1; i <= len; i++)
      " '<<w[i]>>'";
  }

  askTopics(topic, words) = {
    "In askabout <<self.reportObjwords(words)>>\n";
    if (topic == thingyTopic) {
      "\"Thingy.\"";
      return true;
    }
    else if (topic == doohickeyTopic) {
      "Yay, you asked about doohickey. Now you know about thingy.";
      thingyTopic.known = true;
      return true;
    }
    else if (topic == eastTopic) {
      "You asked about east.";
      return true;
    }
    else if (topic == pcTopic) {
      "Yay, you asked about yourself. Here's a yes/no question.";
      ynFoobar.flag;
      return true;
    }
    else if (topic == johnTopic) {
      "Yay. That's me.";
      return true;
    }
    else if (topic == boxTopic) {
      if (self.askedAbout(topic))
        "You already asked about the box.";
      else
        "Yay. You asked about the box.";
      return true;
    }
    else if (topic == lanternTopic) {
      if (self.askedAbout(topic) == 2) {
        "Stop asking about the lantern!";
        return 2;
      }
      else if (self.askedAbout(topic) == 1) {
        "This is the second time you've asked about the lantern.";
        return 2;
      }
      else {
        "Xyzzy.";
        return 1;
      }
    }
    else if (topic == tribblesTopic) {
      "Tribbles are trouble.";
      return true;
    }
    return nil;
  }

  askForTopics(topic, words) = {
    "In askfor <<self.reportObjwords(words)>>\n";
    if (topic == boxTopic) {
      "You asked for the box.";
      return true;
    }
    return nil;
  }

  tellTopics(topic, words) = {
    "In tellabout <<self.reportObjwords(words)>>\n";
    if (topic == lifeTopic) {
      "That's nice.";
      return true;
    }
    else
      return nil;
  }
;

modify Me
  laryngitis = nil
  canSpeak = {
    if (self.laryngitis) {
      "You can't speak.";
      return nil;
    }
    else
      return true;
  }
;

bananaVerb: deepverb
  sdesc = "banana"
  verb = 'banana'
  action(actor) = {
    if (johndoe.bananaInEar) {
      "John can hear again.";
      johndoe.bananaInEar = nil;
    }
    else {
      "John is now deaf.";
      johndoe.bananaInEar = true;
    }
  }
;

laryngitisVerb: deepverb
  sdesc = "laryngitis"
  verb = 'laryngitis'
  action(actor) = {
    if (Me.laryngitis) {
      "You can speak again.";
      Me.laryngitis = nil;
    }
    else {
      "You now have laryngitis.";
      Me.laryngitis = true;
    }
  }
;

ynFoobar: yesno
  actor = johndoe
  yesText = "You answered yes."
  noText = "You answered no."
;

box: fixeditem
  sdesc = "box"
  noun = 'box'
  location = startroom
  mytopic = boxTopic
;

lanternItem: item
  sdesc = "lantern"
  noun = 'lantern'
  location = Me
  mytopic = lanternTopic
;

barItem: item
  sdesc = "bar"
  noun = 'bar'
  location = Me
  mytopic = barTopic
;

tribblesItem: item
  sdesc = "tribbles"
  noun = 'tribbles'
  isThem = true
  location = startroom
  mytopic = tribblesTopic
;

book: infoSource
  sdesc = "book 1"
  noun = 'book'
  adjective = '1'
  location = startroom
  lookupTopics(topic, words) = {
    if (topic == tribblesTopic) {
      if (self.lookedUp(topic))
        "You asked me about tribbles again.";
      else
        "Yay tribbles.";
      return true;
    }
    else
      return nil;
  }
;

eastTopic: knownTopic
  sdesc = "east passage"
  noun = 'passage'
  adjective = 'east'
;

johnTopic: knownTopic
  sdesc = "John"
  noun = 'john'
  whatis = "That's John."
;

thingyTopic: topic
  sdesc = "thingy"
  noun = 'thingy' 'foo'
;

doohickeyTopic: knownTopic
  sdesc = "doohickey"
  noun = 'doohickey' 'foo'
;

whatsitTopic: knownTopic
  sdesc = "whatsit"
  noun = 'whatsit'
;

boxTopic: knownTopic
  sdesc = "box"
  noun = 'box'
  adjective = 'hers' 'his' 'my' 'mine' 'john\'s'
  whatis = {"It's cubical.";}
;

lanternTopic: knownTopic
  sdesc = "lantern"
  noun = 'lantern'
  whatis = "It's a shiny thing."
;

barTopic: knownTopic
  sdesc = "bar"
  noun = 'bar'
;

tribblesTopic: knownTopic
  sdesc = "tribbles"
  noun = 'tribbles'
  isThem = true
  whatis = "They're trouble."
;

lifeTopic: knownTopic
  sdesc = "life"
  noun = 'life'
;

comeHitherVerb: deepverb
  sdesc = "comehither"
  verb = 'comehither'
  action(actor) = {
    johndee.moveInto(startroom);
    bookDouble.moveInto(startroom);
  }
;

printTopicRecordsVerb: deepverb
  sdesc = "printrecords"
  verb = 'printrecords'
  action(actor) = {
    local i, len;

    "Asked about:\n";
    "  Topics: ";
    len = length(johndoe.askedAboutList);
    for (i=1; i <= len; i++) {
      if (i > 1)
        ", ";
      "<<johndoe.askedAboutList[i].sdesc>>";
    }
    "\n";
    "  Status codes: ";
    for (i=1; i <= len; i++) {
      if (i > 1)
        ", ";
      if (datatype(johndoe.askedAboutStatus[i]) == DTY_TRUE)
        "true";
      else
        "<<johndoe.askedAboutStatus[i]>>";
    }
    "\b";

    "Told about:\n";
    "  Topics: ";
    len = length(johndoe.toldAboutList);
    for (i=1; i <= len; i++) {
      if (i > 1)
        ", ";
      "<<johndoe.toldAboutList[i].sdesc>>";
    }
    "\n";
    "  Status codes: ";
    for (i=1; i <= len; i++) {
      if (i > 1)
        ", ";
      if (datatype(johndoe.toldAboutStatus[i]) == DTY_TRUE)
        "true";
      else
        "<<johndoe.toldAboutStatus[i]>>";
    }
    "\b";

    "Asked for:\n";
    "Topics: ";
    len = length(johndoe.askedForList);
    for (i=1; i <= len; i++) {
      if (i > 1)
        ", ";
      "<<johndoe.askedForList[i].sdesc>>";
    }
    "\n";
    "Status codes: ";
    for (i=1; i <= len; i++) {
      if (i > 1)
        ", ";
      if (datatype(johndoe.askedForStatus[i]) == DTY_TRUE)
        "true";
      else
        "<<johndoe.askedForStatus[i]>>";
    }
    "\b";

    "Book:\n";
    "Topics: ";
    len = length(book.lookedUpList);
    for (i=1; i <= len; i++) {
      if (i > 1)
        ", ";
      "<<book.lookedUpList[i].sdesc>>";
    }
    "\n";
    "Status codes: ";
    for (i=1; i <= len; i++) {
      if (i > 1)
        ", ";
      if (datatype(book.lookedUpStatus[i]) == DTY_TRUE)
        "true";
      else
        "<<book.lookedUpStatus[i]>>";
    }
  }
;
