/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.swingui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.zmpp.io.IOSystem;
import org.zmpp.io.InputStream;
import org.zmpp.swingui.AppletMachineFactory;
import org.zmpp.swingui.DisplaySettings;
import org.zmpp.swingui.GameThread;
import org.zmpp.swingui.LineEditorImpl;
import org.zmpp.swingui.TextViewport;
import org.zmpp.swingui.Viewport6;
import org.zmpp.vm.Machine;
import org.zmpp.vm.ScreenModel;
import org.zmpp.vm.StatusLine;

public class ZmppApplet
extends JApplet
implements InputStream,
StatusLine,
IOSystem {
    private static final long serialVersionUID = 1L;
    private static final Map<String, Integer> colormap = new HashMap<String, Integer>();
    private JLabel global1ObjectLabel;
    private JLabel statusLabel;
    private ScreenModel screen;
    private Machine machine;
    private LineEditorImpl lineEditor;
    private GameThread currentGame;
    private DisplaySettings settings;
    private boolean savetofile;

    public void init() {
        this.requestFocusInWindow();
        String string = this.getParameter("storyfile");
        String string2 = this.getParameter("blorbfile");
        String string3 = this.getParameter("saveto");
        String string4 = this.getParameter("fixedfontsize");
        String string5 = this.getParameter("stdfontsize");
        String string6 = this.getParameter("defaultbg");
        String string7 = this.getParameter("defaultfg");
        int n = 12;
        int n2 = 12;
        int n3 = -1000;
        int n4 = -1000;
        this.savetofile = "file".equalsIgnoreCase(string3);
        n2 = this.parseInt(string4, n2);
        n = this.parseInt(string5, n);
        n3 = this.parseColor(string6, n3);
        n4 = this.parseColor(string7, n4);
        this.settings = new DisplaySettings(n, n2, n3, n4);
        try {
            URL uRL = null;
            if (string2 != null) {
                uRL = new URL(this.getDocumentBase(), string2);
            }
            AppletMachineFactory appletMachineFactory = null;
            if (string != null) {
                URL uRL2 = new URL(this.getDocumentBase(), string);
                appletMachineFactory = new AppletMachineFactory(this, uRL2, uRL, this.savetofile);
            } else {
                appletMachineFactory = new AppletMachineFactory(this, uRL, this.savetofile);
            }
            this.machine = appletMachineFactory.buildMachine();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private int parseInt(String string, int n) {
        int n2 = n;
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    private int parseColor(String string, int n) {
        return colormap.get(string) == null ? n : colormap.get(string);
    }

    private void createUI(Machine machine) {
        this.lineEditor = new LineEditorImpl(machine.getGameData().getStoryFileHeader(), machine.getGameData().getZsciiEncoding());
        JComponent jComponent = null;
        if (machine.getGameData().getStoryFileHeader().getVersion() == 6) {
            jComponent = new Viewport6(machine, this.lineEditor);
            this.screen = (ScreenModel)((Object)jComponent);
        } else {
            jComponent = new TextViewport(machine, this.lineEditor, this.settings);
            this.screen = (ScreenModel)((Object)jComponent);
        }
        jComponent.setPreferredSize(new Dimension(640, 480));
        jComponent.setMinimumSize(new Dimension(400, 300));
        if (machine.getGameData().getStoryFileHeader().getVersion() <= 3) {
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            JPanel jPanel2 = new JPanel(new FlowLayout(0));
            JPanel jPanel3 = new JPanel(new FlowLayout(2));
            jPanel.add(jPanel2);
            jPanel.add(jPanel3);
            this.global1ObjectLabel = new JLabel(" ");
            this.statusLabel = new JLabel(" ");
            jPanel2.add(this.global1ObjectLabel);
            jPanel3.add(this.statusLabel);
            this.getContentPane().add((Component)jPanel, "North");
            this.getContentPane().add((Component)jComponent, "Center");
        } else {
            this.setContentPane(jComponent);
        }
        this.addKeyListener(this.lineEditor);
        jComponent.addKeyListener(this.lineEditor);
        jComponent.addMouseListener(this.lineEditor);
    }

    public void initUI(final Machine machine) {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    ZmppApplet.this.createUI(machine);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void start() {
        this.currentGame = new GameThread(this.machine, this.screen);
        this.currentGame.start();
    }

    public ScreenModel getScreenModel() {
        return this.screen;
    }

    public void updateStatusScore(final String string, final int n, final int n2) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ZmppApplet.this.global1ObjectLabel.setText(string);
                ZmppApplet.this.statusLabel.setText(n + "/" + n2);
            }
        });
    }

    public void updateStatusTime(final String string, final int n, final int n2) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ZmppApplet.this.global1ObjectLabel.setText(string);
                ZmppApplet.this.statusLabel.setText(n + ":" + n2);
            }
        });
    }

    public Writer getTranscriptWriter() {
        return new OutputStreamWriter(System.out);
    }

    public Reader getInputStreamReader() {
        File file = new File(System.getProperty("user.dir"));
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setDialogTitle("Set input stream file ...");
        if (jFileChooser.showOpenDialog(this) == 0) {
            try {
                return new FileReader(jFileChooser.getSelectedFile());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    public void close() {
    }

    public void cancelInput() {
        this.lineEditor.cancelInput();
    }

    public short getZsciiChar() {
        this.enterEditMode();
        short s = this.lineEditor.nextZsciiChar();
        this.leaveEditMode();
        return s;
    }

    private void enterEditMode() {
        if (!this.lineEditor.isInputMode()) {
            this.screen.resetPagers();
            this.lineEditor.setInputMode(true);
        }
    }

    private void leaveEditMode() {
        this.lineEditor.setInputMode(false);
    }

    static {
        colormap.put("black", 2);
        colormap.put("red", 3);
        colormap.put("green", 4);
        colormap.put("yellow", 5);
        colormap.put("blue", 6);
        colormap.put("magenta", 7);
        colormap.put("cyan", 8);
        colormap.put("white", 9);
        colormap.put("gray", 10);
    }
}

