Alan Library v0.6.2
===================

A recovered copy of the last version of ALAN Library v0.6.x, for compiling old
Alan adventures.

Edited by [Tristano Ajmone] to ensure compatibility with Alan 3.0beta6.

[Tristano Ajmone]: https://github.com/tajmone

Last edited on April 4, 2019.

License: Artistic License 2.0.



Library Info
============

To the best of my knowledge, Library v0.6.2 was the latest update in the v0.x
series, later succeeded by Library v1, and then by the Standard Library 2.

This is a old version of the Alan Library, originally created for Alan 2 and
then ported to Alan 3. It's revival is mainly for historical reasons, to allow
compiling old adventures that depend on it.

The sources of Library v0.6.2 were recovered from the [ALAN repository] on
Bitbucket (were the Library was originally hosted), from [commit c44766fa] 
(2017-04-17), which was the last commit before its removal from the repository.

[ALAN repository]: https://bitbucket.org/alanif/alan

[commit c44766fa]: https://bitbucket.org/alanif/alan/commits/c44766faea7539806a01fa6e8bee2c84fa0b2c36


License
-------

The Library is released under the terms of the Artistic License 2.0.
You can read the full license text in:

* [`COPYING`](./COPYING)



Changes List
============

    Alan Library v0.6.2 -- update 1 (2019-04-04)

The Library sources were edited by [Tristano Ajmone] who carried out a few
minor tweaks to ensure its compatibility with the current Alan release, plus
some aesthetic changes.

The goal is to preserve a usable copy of Lib 0.6.2, to compile legacy Alan
adventures. For this reason, and because this legacy library is no longer
actively developed, its version number was left unaltered. If future updates
of the Alan language will break compatibility with the library, further updates
to its code might be attempted in order to keep it compilable, if possible.

As it's customary within the collaborative spirit of the Alan community, before
publishing this code the proposed changes were announced and discussed on the
Alan IF Yahoo list, to ensure they met the approval of the original authors and
to allow all members of the community to express their opinions:

* https://groups.yahoo.com/neo/groups/alan-if/conversations/messages/3773

Here's the list of changes.



Aesthetic Changes
-----------------

* Enforce prose-like casing of Alan keywords.
* Fix indentation, using two-spaces instead of tabs.
* Apply consistent styling and formatting across all sources.



Code Fixes
----------

* `invent.i`
    * Changed `THE worn ISA thing IN hero` to `THE worn ISA entity`.

    This was actually one of the intended changes in v0.6.2, as mentioned in
    the source header comments:
          
        changed 'the Worn' from a 'thing' to an 'entity'

    It looks like something went wrong during the upstream commit. In any case,
    this was causing a compile error, so it had to be changed, for it deals
    with a backward-compatiblity breaking change in the Alan language.

* `talk.i`
    * Replaced `$o` with `$1`, for the former special parameter symbol is now
      depracated and might not be safe to use in future versions of Alan. 




Restored Code from Lib v0.6.1
-----------------------------

I've restored some default attributes and CHECKS from v0.6.1 that were no longer
present in Lib v0.6.2:

* `open.i`
    * Restored the `AND obj1 IS openable` CHECK.
* `people.i` 
    * Restored in `person` class definition:
        * `IS NOT named.`
        * Customized `DESCRIPTION` based on `named` attribute.

My assumption here is that there were multiple variations of the Library going
around at that time, and that the above might have been lost due to divergent
versions — in any case, it seemed a sensible choice to preserve them for the
sake of maximum compatibility with old adventures (which might expect them to
be in place).




Outdated Info and Links
-----------------------

Some references and links were no longer valid and were updated accordingly.

* `help.i`
    * The text of the `credits` verb contained some outdated or obsolete info:
        * Changed "Thomas Nilsson" to "Thomas Nilefalk"
          (Thomas recently changed his surname to Nilefalk).
        
        * The old email contact
          
            <thomas.nilsson@progindus.se>
          
            was replaced with the new email from Alan website:
          
            <thomas@alanif.se>.
        
        * ALAN website link: replaced the old (now dead) link
          
            http://www.welcome.to/alan-if
          
            with the current (new) Alan website link
          
            https://www.alanif.se/



Markdown Documents
------------------

To provide a better GitHub preview experience of the text documents of the
Library, the following files were converted from plain text to markdown:

- `ReadMe`    — now `README.md`
- `index.txt` — add `INDEX.md` (original preserved too)
- `notes.txt` — now `NOTES.md`

Special care was taken to preserve their readability in pure text format, and
at the same time provide the benefits of markdown formatting and links.



# Original ReadMe

Here follows the text from the orginal `ReadMe` file:

```
Proposed Alan Library v0.6.something
------------------------------------

---------------------------------
About this version of the library
---------------------------------
The files in this distribution constitutes a development version of an
Alan v3 standard library. As Alan v3 is still in development stages
this is work in progress and use is on your own risk. The basis for
this library is a conversion from the proposed Alan standard library
version 0.4.1.

NOTE that the content of version compatibility lines, index.txt and
list of changes is not going to be updated while Alan v3 is in
development state.

The actual library files (the files with a filename extension of ".i")
are added to the source code of your game by importing the main
file called std.i -- see the text file 'notes.txt' for details.

The library is only meant as a help to get started. It is not actually
a library, but a set of file with definitions that you might arrive at
after writing a number of games. So it is suggested that you do not try
to maintain a single copy, but instead have one copy per game. In that
way you are free to tweak and improve the library, not just by adding
to it, but also to change what is in it, and how it works.


-------------------------------------
About the abandonded version markings
-------------------------------------
The second line of each library file lists the previous library
versions with which it is completely compatible.

For example, if its completely compatible with, or unchanged from, the
last three library versions then the line will read:

    -- Library version 0.2, 0.3, 0.4

Files which are changed so that they are not *exactly* compatible with
any previous versions except for library 0.4.1 then the second line
will be:

    -- Library version 0.4.1

This might make it easier to decide if this new version of the library
will affect your work. Note however that even very small incompatible
changes are considered *incompatible*. For example, the introduction
of one single "the" in a message might seem trivial but might change
the appearance of the message if the author had made allowance for
this deficency in his work.


------------------------
About how to find things
------------------------
You can find an index of sorts in the file 'index.txt'. Additional
notes and tips about using std.i are in the file 'notes.txt'.


-----------------------------------------------------
About the structure of the library (partly out-dated)
-----------------------------------------------------
The library consists of a set of files each focusing on one aspect of
player commands or actions. One such file should contain everything
that is necessary to use the Alan definitions.

E.g. the CHECKs in the EAT verbs in 'eat.i' refers to a edible
attribute, so the file should also define such an attribute to be
available for all OBJECTs. It should also (and does) contain
the necessary SYNTAX for the eat VERB.

Breaking up the library in many small pieces has one huge
advantage. If you need to do some modification to the library you can
do that in just one file. Furthermore, by using the include directory
switches/options to the Alan compiler you can keep the complete
library in a separate directory (say C:\ALAN\LIBRARY) and only copy
the library files you want to modify to your games directory (say
C:\MY\GAME). The Alan compiler will always try to find an included
file in the current directory first and only if not found there try
the directories listed with -include options on the command line (or
equivalent).

So a viable set of commands to modify the eat.i file *just for this
game* would be:

    C:\> cd MY\GAME
    C:\MY\GAME> copy \ALAN\LIBRARY\eat.i eat.i
    C:\MY\GAME> edit eat.i
    C:\MY\GAME> alan -include \ALAN\LIBRARY game.alan

(supposing game.alan included the main library file std.i)

When a modified library is released it should (in theory) be possible
just to start using the new library, thus benefiting from new
features in the new version of the library, except where you made your
local modifications, eg:

    C:\MY\GAME> alan -include \ALAN\LIBRARY game.alan

This is the reasoning behind the multi-file library structure. 

----

The library is a work in progress. Comments and expansions to this 
library are most welcome!

The 'proposed standard library was written by Thomas Nilsson
<thomas.nilsson@progindus.se>. This version of the library has been 
updated by Stephen Griffiths (sg@xtra.co.nz). Please email bug reports 
and suggestions to Stephen.

The library was converted to V3 with some radical updates, such as
named_actor and scenery classes, printing of definite and indefinite
forms etc. by Thomas Nilsson.

----

Visit the Alan Home Pages at

    http://www.alanif.se


Steve's comments:


General comments
----------------
I'm thinking of the standard library as remaining simple and general.
Stuff like handling light and darkness and other such things in
chapter six of manual could be added but then it would make using the
library much harder for beginners.

I like the split into separate files. It gives structure and helps an
author isolate their own customisation from the standard library. There
are disadvantages when trying to find particular items though. (Especially
for people like me without an editor that can open and search all the
separate files simultaneously.)

Perhaps some sort of index would be handy especially if the library
gets much bigger. Something documenting all the default attributes,verbs
etc in one list somewhere, eg:
-- OBJECT ATTRIBUTES
-- Closeable    -- Open.i
-- Open         -- Open.i
-- On           -- Turn.i

Especially useful for finding verbs like 'Put_...' which I'd have
sprayed all over library - mostly in put.i but put_down would be in take.i
coz its synonomous with 'drop' amd put_on in wear.i (as in "put on hat" as
opposed to put_on as in "put hat on hat-stand")

       

My Changes to 0.0(2)
--------------------
(Changes that I expect may be controversial have been marked with ***

I made some comments about things that I didn't change, the points that
are only comments have "(no change made)" at the end.)



std.i
-----
    - added filename and space for version info at top of each file (useful
    if concatenate all the files into one perhaps to print or global search)
    - list verbs in each file if not the in the file's name
    - added $include for read.i and put.i
    - added turn.i for switching things off and on
    - added new files talk, give.i (for NPC interaction)
    *** added new files attack, kiss.i (in most games I get frustrated enough
    to hit something or bored enough to kiss someone at some stage in a game.)
    *** I looked through standard.ala. I found verbs in there that I did
    NOT want to add to std.i. (no change made) But maybe they should be
    included :
            - wear/put on and remove/take off clothes (coz while its easy to
            do 'put on hat' its not so easy to program the need to put socks
            on before shoes etc)
            - play,play_with, pull
            - light, extinguish, put out (light source object)


take.i
------
    - concerned about 'can't take people' msg in case the actors aren't
    people (could be monsters, animals); can't think of anything good to
    replace it with though - just "You can only take objects."  (no change made) 
    - combined the pickup verbs with take as definition is the same
    - changed "u" to "up" in syntax of pick_up verbs to match the
    redefinition of direction words in nowhere.i
    ***added put down verbs as alternatives to drop, syntax definitions are
    in put.i with the other put verbs (a bit of an awkward arrangement)
    ***added take_from (from container object or actor)

open.i
------
    - is it necessary to have openable AND closeable attributes? I'm trying
    to think of something that could be one but not the other. I think you
    could just test the closeable attribute to see if something can be
    opened (no change made) 
    - same concern about assuming non-objects are people as take.i  (no change made) 
    - changed 'close' to 'open' in 2nd class-check msg for open_with syntax

lock.i
------
    - why have check obj here when its an Alan default check? I couldn't
    think why so I took the checks out
    ***added checks for whether the key was in inventory
    - added a DOES section to the _with verbs

throw.i
-------
    ***what is the UNLESS doing in these verbs, its commented out so I just
    removed them to be tidy

push.i
------
    - the verbs do nothing, maybe should have default "You push the $1"
    response even if the only reason is so newbie authors know something
    happened. I presume you're presuming that every push will need to
    be handled as a special case within an object or whatever.(no change made)

touch.i
-------
    - as with push, the verbs do nothing, maybe should have default
    "You touch the $1" response (no change made)

examine.i
---------
    - added x as synonym
    - added 'look at' as verb alternative for examine
    - added search synonym for examine, maybe should be separate but
    synonomous verb?
    ***disabled "examine all", ie:removed multiple indicator from examine
    and look_at

give.i
------
    - added this verb

turn.i
------
    - have created both "turn on" and "switch on" verbs rather than make
    switch a synonym for turn coz are likely to also have a "turn (obj)"
    verb where "turn" = "rotate"

help.i
------
    - added hint, credits verbs

nowhere.i
---------
    ***changed the directions to full words and the synonyms to
    abbreviations, a personal preference, mainly so verbs like
    pick up (obj) can be be defined as such rather than pick u (obj)


talk.i
------
    - new file with some basic ask/tell verbs (done quickly so its
    particularly ugly, sorry)


meta.i
------
    - added restart, again and undo verbs
```
