# Minix-ST Makefile for ELVIS - a clone of `vi`

# Use `make` to to compile all programs
# Use `make install` to copy all programs to /usr/bin
# Use `make clean` to remove all object files
# Use `make clobber` to remove everything except source & documentation
# Use `make tags` to build new "tags" and "refs" files
# Use `make tar` to produce uuencoded compressed tar archives of the source

SRC=	blk.c cmd1.c cmd2.c curses.c cut.c ex.c input.c main.c misc.c\
	modify.c move1.c move2.c move3.c move4.c opts.c redraw.c regexp.c\
	regsub.c system.c tio.c tmp.c vars.c vcmd.c vi.c
OBJS=	blk.o cmd1.o cmd2.o curses.o cut.o ex.o input.o main.o misc.o\
	modify.o move1.o move2.o move3.o move4.o opts.o redraw.o regexp.o\
	regsub.o system.o tio.o tmp.o vars.o vcmd.o vi.o recycle.o
EXTRA=
CFLAGS=	-DCRUNCH
LIBS=	
BIN=	/usr/bin

all: elvis ctags ref virecover cgrind refont

elvis: $(OBJS)
	$(CC) -o elvis $(OBJS) $(EXTRA) $(LIBS)

ctags: ctags.c
	$(CC) ctags.c -o ctags

ref: ref.c
	$(CC) ref.c -o ref

virecover: virecover.c
	$(CC) $(CFLAGS) virecover.c -o virecover

cgrind: cgrind.c
	$(CC) cgrind.c -o cgrind

refont: refont.c
	$(CC) refont.c -o refont

regexp: regexp.c regexp.h
	$(CC) -DTEST regexp.c -o regexp

# The file cmd1.c is compiled with the extra flag -DDATE="today's date".
# This date is reported when elvis is run and the :version command is given.
# If you have trouble defining the date in this way, then just comment out
# these two lines so cmd1.c is compiled normally.  The :version command
# won't report the compilation date, but that's really no big deal.
cmd1.o: cmd1.c vi.h
	eval $(CC) -c $(CFLAGS) -DDATE=\'\"`date`\"\' cmd1.c

install: elvis ctags ref virecover cgrind refont
	cp elvis ctags ref virecover cgrind refont $(BIN)
	(cd $(BIN); chown bin elvis ctags ref virecover cgrind refont)
	(cd $(BIN); chmod 755 elvis ctags ref virecover cgrind refont)
	rm -f $(BIN)/ex $(BIN)/view $(BIN)/vi
	ln $(BIN)/elvis $(BIN)/ex
	ln $(BIN)/elvis $(BIN)/view
	ln $(BIN)/elvis $(BIN)/vi

clean:
	rm -f *.o *.uue core

clobber: clean
	rm -f tags refs elvis ctags ref virecover cgrind refont

tags refs: ctags
	./ctags -r *.[ch]

tar: elvis1.uue elvis2.uue elvis3.uue elvis4.uue elvis5.uue elvis6.uue\
		elvis7.uue elvis8.uue

elvis1.uue:
	tar c elvis1.tar doc/[a-z]*
	cp doc/README elvis1.uue
	compress -b13 elvis1.tar
	uuencode elvis1.tar.Z <elvis1.tar.Z >>elvis1.uue
	rm elvis1.tar*

elvis2.uue:
	tar c elvis2.tar doc/[A-Z]* ctags.c ref.c virecover.c cgrind.c refont.c
	compress -b13 elvis2.tar
	uuencode elvis2.tar.Z <elvis2.tar.Z >elvis2.uue
	rm elvis2.tar*

elvis3.uue:
	tar c elvis3.tar Makefile.* cmd1.c cmd2.c
	compress -b13 elvis3.tar
	uuencode elvis3.tar.Z <elvis3.tar.Z >elvis3.uue
	rm elvis3.tar*

elvis4.uue: curses.c curses.h cut.c ex.c input.c main.c
	tar c elvis4.tar curses.c curses.h cut.c ex.c input.c main.c
	compress -b13 elvis4.tar
	uuencode elvis4.tar.Z <elvis4.tar.Z >elvis4.uue
	rm elvis4.tar*

elvis5.uue:
	tar c elvis5.tar misc.c modify.c move1.c move2.c move3.c move4.c blk.c recycle.c
	compress -b13 elvis5.tar
	uuencode elvis5.tar.Z <elvis5.tar.Z >elvis5.uue
	rm elvis5.tar*

elvis6.uue:
	tar c elvis6.tar opts.c regexp.c regexp.h regsub.c
	compress -b13 elvis6.tar
	uuencode elvis6.tar.Z <elvis6.tar.Z >elvis6.uue
	rm elvis6.tar*

elvis7.uue:
	tar c elvis7.tar system.c tio.c tmp.c vars.c vcmd.c
	compress -b13 elvis7.tar
	uuencode elvis7.tar.Z <elvis7.tar.Z >elvis7.uue
	rm elvis7.tar*

elvis8.uue:
	tar c elvis8.tar vi.c vi.h redraw.c
	compress -b13 elvis8.tar
	uuencode elvis8.tar.Z <elvis8.tar.Z >elvis8.uue
	rm elvis8.tar*
