# UserMaint V1.0 by Charles A. Eads
#
# Copyright (c) 1993 The Regents of the University of California.
# All rights reserved.
# 
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose, without fee, and without written agreement is
# hereby granted, provided that the above copyright notice and the following
# two paragraphs appear in all copies of this software.
# 
# IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
# OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
# CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
# 
# THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

proc apply_init {w} \
{
	global TMP_DIRECTORY

	set children [winfo children [expr "{$w} == {} ? {.} : {$w}"]]
	if {[lsearch $children ".edit-*"] > -1} \
	{
		if {[query "There are currently users being edited.  Do you wish to continue with apply?"] == 0}  return
	} else \
	{
		if {[lsearch $children ".add-*"] > -1} \
		{
			if {[query "There are currently users being added.  Do you wish to continue with apply?"] == 0}  return
		}
	}

	set children [winfo children [expr "{$w} == {} ? {.} : {$w}"]]
	foreach child $children \
	{
		if {[string match ".edit-*" $child] == 1} {destroy $child}
		if {[string match ".add-*" $child] == 1} {destroy $child}
		if {[string match ".query-*" $child] == 1} {destroy $child}
	}

	wm withdraw [expr "{$w} == {} ? {.} : {$w}"]

	upvar #0 active_delete 0
	set index [userlist_tag_find $w .delete-current]
	if {$index > -1} \
	{
		userlist_tag_remove $w $index [userlist_get_user_entry $w $index] .delete-current
		userlist_tag $w $index .delete
	}

	if {[userlist_tag_find $w .delete] > -1} \
	{
		if {[query "There are users taged for deletion.  Continue with delete?"] == 1} \
		{
			useredit_delete_handler $w
		}
	}

	create_message "Distributing passwd and group files."

	set tmp_passwd_file_name "$TMP_DIRECTORY/tmp_passwd"
	set tmp_group_file_name "$TMP_DIRECTORY/tmp_group"

	if {[file exists $tmp_passwd_file_name] == 1} {exec rm -f $tmp_passwd_file_name}
	if {[file exists $tmp_group_file_name] == 1} {exec rm -f $tmp_group_file_name}

	upvar #0 tmp_passwd_text([expr "{$w} == {} ? {.} : {$w}"]) tmp_passwd_text
	passwd_write_to_file $tmp_passwd_text $tmp_passwd_file_name

	global group_text
	group_write_to_file $group_text $tmp_group_file_name

	global DISTRIBUTE_DESTINATIONS_PASSWD
	foreach dest $DISTRIBUTE_DESTINATIONS_PASSWD \
	{
		catch {exec rcp $tmp_passwd_file_name $dest}
	}	

	global DISTRIBUTE_DESTINATIONS_GROUP
	foreach dest $DISTRIBUTE_DESTINATIONS_GROUP \
	{
		catch {exec rcp $tmp_group_file_name $dest}
	}

	set userlist_added {}
	set userlist_edited {}

	while (1) \
	{
		set index [userlist_tag_find $w .added]
		if {$index == -1} \
		{
			set index [userlist_tag_find $w .edited]
			if {$index == -1} \
			{
				break
			} else \
			{
				set passwd_entry [lindex $tmp_passwd_text $index]
				lappend userlist_edited $passwd_entry
			}
		} else \
		{
			set passwd_entry [lindex $tmp_passwd_text $index]
			lappend userlist_added $passwd_entry
		}
		userlist_tag_remove $w $index [userlist_get_user_entry $w $index] .edited
		userlist_tag_remove $w $index [userlist_get_user_entry $w $index] .added
	}

	destroy_message

	global HOOK_LIST

	upvar #0 userlist_deleted deleted_users
	foreach hook $HOOK_LIST \
	{
		catch {$hook $userlist_added $userlist_edited $deleted_users}
	}

	passwd_global_unlock
	passwd_unlock
	destroy .
}
