 /*
  * Khoros: $Id: display.c,v 1.2 1991/12/18 09:16:06 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: display.c,v 1.2 1991/12/18 09:16:06 dkhoros Exp $";
#endif

 /*
  * $Log: display.c,v $
 * Revision 1.2  1991/12/18  09:16:06  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "xvutils.h"	


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    	    file name: display.c                      <<<<
   >>>>                                                       <<<<
   >>>>		 Create a Display Widget		      <<<<
   >>>>                                                       <<<<
   >>>>                xvf_create_display_widget()	      <<<<              
   >>>>                xvf_update_display_widget()	      <<<<              
   >>>>                xvf_quit_display()	      	      <<<<              
   >>>>                xvf_unglyph_display()	      	      <<<<              
   >>>>                xvf_glyph_display()	      	      <<<<              
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/************************************************************
*
*  Routine Name:  xvf_create_display_widget()
*
*      Purpose:   Create a large read-only text widget in which an ascii
*		  file is displayed, until the user clicks on "Quit".
*		  Will not grab events from the application program.
*		  Can have the contents of the text widget updated 
*		  with xvf_update_display_widget().
*
*        Input:   filename  - character string containing the name 
*			     (and path) of the ascii file to be displayed 
*			     in help widget.  The filename may be specified
*			     using a '~' since the ~ will be expanded
*			     for the current machine.  
*
*                 display_label    - short label for top of widget.
*			             NULL gives default of "DISPLAY".
*
*       Output:   Returns a pointer to DisplayWid_Data
*
*    Called By:   the application program
*
*   Written By:   Danielle Argiro
*
*
*************************************************************/

#define DISPLAY_WIDTH  60
#define DISPLAY_HEIGHT 40

DisplayWid_Data *xvf_create_display_widget(filename, display_label)
char *filename;
char *display_label;
{
   DisplayWid_Data *display_data;
   Widget quit;	  /* quit button to get rid of help */
   Widget glyph_button;  /* glyph widget on help pane */
   Widget glyph_to_form; /* command widget of glyph */
   char   *fullpath, *top_name, *cap_top_name;
   char    name[MaxLength], glyph_name[MaxLength];
   Arg    arg[25];
   int    i, stat, label_width;
   

   display_data = (DisplayWid_Data *) calloc(1, sizeof(DisplayWid_Data));

   if (filename == NULL)
   {
      fprintf(stderr,"xvf_create_displaywid:\n");
      fprintf(stderr,"need the name of the file to display!\n");
      return(false);
   }

   if (display_label == NULL)
   {
	display_label = xvf_strcpy("Display File");
   }

   /*
    *  make sure that specified file is available
    */
   fullpath = vfullpath(filename, NULL, NULL);
   stat = open(fullpath,O_RDONLY,0664);
   if (stat <= 0)
   {  /* file not there, or cannot be opened */
      xvf_error_wait("Sorry, unable to find appropriate help file",
	  "HELP ERROR","OK");
      return(false);
   }
   (void) close(stat);

   /*
    * create identifying widget name
    */
   sprintf(name,"%d_display",Display_cnt);
   sprintf(glyph_name,"%d_display_glyph",Display_cnt); Display_cnt++;
   top_name = xvf_strcpy(glyph_name);
   cap_top_name = xvf_cap_first_letter(top_name);

   /* 
    *  create the glyph, and add it to the list of toplevels
    *  that is used with journal playback.
    */
 
   i = 0;
   XtSetArg(arg[i], XtNscreen, xvf_screen); 		i++;
   XtSetArg(arg[i], XtNargc, xvf_ac); 	         	i++;
   XtSetArg(arg[i], XtNargv, xvf_av);	          	i++;
   XtSetArg(arg[i], XtNwinGravity, StaticGravity);	i++; 
   XtSetArg(arg[i],XtNmappedWhenManaged,False);         i++;
   display_data->glyph = XtAppCreateShell(top_name,cap_top_name,
	applicationShellWidgetClass, xvf_display, arg, i);
   xvf_add_toplevel(display_data->glyph);

   i = 0;
   XtSetArg(arg[i],XtNwidth,10*xvf_font_width);		i++;
   XtSetArg(arg[i],XtNheight, (Dimension) 2*xvf_font_height);	i++;
   XtSetArg(arg[i],XtNlabel, "help glyph");		i++;
   XtSetArg(arg[i],XtNmappedWhenManaged,True);     	i++;
   glyph_to_form = XtCreateManagedWidget("glyph_to_form",
	commandWidgetClass,display_data->glyph,arg,i);
   XtAddCallback(glyph_to_form,XtNcallback,xvf_unglyph_display,display_data);

   top_name = xvf_strcpy(name);
   cap_top_name = xvf_cap_first_letter(top_name);

   /* 
    *  create the display's toplevel widget, and
    *  add it to the list of toplevels
    *  that is used with journal playback.
    */
   i = 0;
   XtSetArg(arg[i], XtNscreen, xvf_screen); 		i++;
   XtSetArg(arg[i], XtNargc, xvf_ac); 	         	i++;
   XtSetArg(arg[i], XtNargv, xvf_av);	          	i++;
   XtSetArg(arg[i], XtNwinGravity, StaticGravity);	i++; 
   display_data->toplevel = XtAppCreateShell(top_name, cap_top_name,
	                     applicationShellWidgetClass, xvf_display, arg, i);
   xvf_add_toplevel(display_data->toplevel);

   /*
    *  add the browser toplevel widget to the list of toplevels
    *  that is used with journal playback.
    */

   /* 
    * create the backplane widget 
    */
   i = 0;
   XtSetArg(arg[i],XtNmappedWhenManaged,True);          i++;
   XtSetArg(arg[i],XtNborderWidth,1);			i++;
   XtSetArg(arg[i],XtNdefaultDistance,4);		i++;
   display_data->back = XtCreateManagedWidget("form_back",
		                formWidgetClass, display_data->toplevel,arg,i);  

   /* 
    * create the glyph button widget 
    */
   i = 0;
   XtSetArg(arg[i],XtNlabel,xvf_strcpy("glyph"));		i++;
   XtSetArg(arg[i],XtNwidth,(Dimension) 6*xvf_font_width);	i++;
   XtSetArg(arg[i],XtNmappedWhenManaged,True);			i++;
   if (xvf_font != NULL)
   {
	XtSetArg(arg[i],XtNfont,xvf_font);              	i++;
   }
   glyph_button = XtCreateManagedWidget("glyph",
      	commandWidgetClass,display_data->back,arg,i);
   XtAddCallback(glyph_button,XtNcallback,xvf_glyph_display,display_data);

   /* 
    * create the label widget 
    */
   i = 0;
   label_width = DISPLAY_WIDTH*xvf_font_width - 13*xvf_font_width;
   XtSetArg(arg[i],XtNlabel,xvf_strcpy(display_label)); i++;
   XtSetArg(arg[i],XtNwidth,(Dimension) label_width);	i++;
   XtSetArg(arg[i],XtNmappedWhenManaged,True);		i++;
   XtSetArg(arg[i],XtNfromHoriz,glyph_button);		i++;
   if (xvf_font != NULL)
   {
	XtSetArg(arg[i],XtNfont,xvf_font);              i++;
   }
   display_data->label = XtCreateManagedWidget("display_wid",
                labelWidgetClass,display_data->back,arg,i);

   /* 
    * create text widget 
    */
   i = 0;
   XtSetArg(arg[i],XtNeditType,XawtextRead);		i++;
   XtSetArg(arg[i],XtNtype,    XawAsciiFile);		i++;
   XtSetArg(arg[i],XtNstring,  fullpath);		i++;
   XtSetArg(arg[i],XtNscrollVertical,  
		XawtextScrollWhenNeeded);		i++;
   XtSetArg(arg[i],XtNwrap,    XawtextWrapWord);	i++;
   XtSetArg(arg[i],XtNheight,(Dimension) 
		DISPLAY_HEIGHT*xvf_font_height);	i++;
   XtSetArg(arg[i],XtNwidth ,(Dimension) 
		DISPLAY_WIDTH*xvf_font_width);		i++;
   XtSetArg(arg[i],XtNleftMargin,LEFT_MARGIN);		i++;
   XtSetArg(arg[i],XtNfromVert, display_data->label);	i++;
   if (xvf_font != NULL)
   {
	XtSetArg(arg[i],XtNfont,xvf_font);                  i++;
   }
   display_data->text=  XtCreateManagedWidget("text",
		asciiTextWidgetClass, display_data->back,arg,i); 

   /* 
    * create the quit button 
    */
   i = 0;
   XtSetArg(arg[i],XtNfromVert,NULL);			i++;
   XtSetArg(arg[i],XtNfromHoriz,display_data->label);	i++;
   XtSetArg(arg[i],XtNlabel,"Quit");			i++;
   XtSetArg(arg[i],XtNwidth,5*xvf_font_width);		i++;
   if (xvf_font != NULL)
   {
	XtSetArg(arg[i],XtNfont,xvf_font);            	i++;
   }
   quit = XtCreateManagedWidget("quit_wid",
	commandWidgetClass,display_data->back,arg,i);
   XtAddCallback(quit,XtNcallback,xvf_quit_display,display_data);

   XtRealizeWidget(display_data->toplevel);
   XtRealizeWidget(display_data->glyph);

   xvf_add_protocol_handler(display_data->toplevel, "WM_DELETE_WINDOW", 
			    xvf_quit_display, display_data);

   XFlush(XtDisplay(display_data->toplevel));
   return(display_data);
}


/************************************************************
*
*  Routine Name:  xvf_update_display_widget()
*
*      Purpose:   Supplied with the display_data that was returned
*		  by xvf_create_display_widget(),  will change the
*		  file that is currently displayed in the display widget
*
*        Input:   display_data - the DisplayWid_Data structure that was
*			         passed back to the application by 
*				 xvf_create_display_widget.  Note that
*				 this structure MUST be STATIC OR GLOBAL
*				 for this routine to work!!
*
*		  filename  - character string containing the name 
*			     (and path) of the ascii file to be displayed 
*			     in help widget.  The filename may be specified
*			     using a '~' since the ~ will be expanded
*			     for the current machine.  
*
*
*       Output:   Returns True on success, False on failure
*
*    Called By:   the application program
*
*   Written By:   Danielle Argiro
*
*
*************************************************************/

int xvf_update_display_widget(display_data, filename)
DisplayWid_Data *display_data;
char   *filename;
{
    int   i, stat;
    Arg   arg[MaxArgs];
    char  *fullpath;

   /*
    *  make sure that specified file is available
    */
    fullpath = vfullpath(filename, NULL, NULL);
    stat = open(fullpath,O_RDONLY,0664);
    if (stat <= 0)
    {  /* file not there, or cannot be opened */
       xvf_error_wait("Sorry, unable to find appropriate help file",
 	  "HELP ERROR","OK");
       return(false);
    }
   (void) close(stat);

    i = 0;
    XtSetArg(arg[i],XtNstring,  fullpath);   i++;
    XtSetValues(display_data->text, arg, i);

    XFlush(XtDisplay(display_data->text));
    return(true);

}


/* callback used to exit help */

void xvf_quit_display(widget, clientData, callData)
Widget widget;
caddr_t clientData, callData;
{
   DisplayWid_Data *display_data;

   display_data = (DisplayWid_Data *) clientData;

   xvf_remove_protocol_handler(display_data->toplevel, "WM_DELETE_WINDOW", 
			       xvf_quit_display, display_data);
   /*
    * delete the display toplevel & glyph toplevel
    * from the list used by journal playback before destroying them
    */
   xvf_delete_toplevel(display_data->toplevel);
   xvf_delete_toplevel(display_data->glyph);

   XtDestroyWidget(display_data->label);
   XtDestroyWidget(display_data->text);
   XtDestroyWidget(display_data->back);
   XtDestroyWidget(display_data->toplevel);
   XtDestroyWidget(display_data->glyph);

   display_data->label= NULL;
   display_data->text= NULL;
   display_data->back= NULL;
   display_data->toplevel = NULL;
   display_data->glyph    = NULL;

   DISPLAY_DONE = true;
}


void xvf_unglyph_display(widget, clientData, callData)
Widget widget;
caddr_t clientData, callData;
{
   DisplayWid_Data *display_data;

   display_data = (DisplayWid_Data *) clientData;

   XtUnmapWidget(display_data->glyph);
   XtMapWidget(display_data->toplevel);
   XSync(xvf_display,0);
}


void xvf_glyph_display(widget, clientData, callData)
Widget widget;
caddr_t clientData, callData;
{
   DisplayWid_Data *display_data;

   display_data = (DisplayWid_Data *) clientData;

   XtUnmapWidget(display_data->toplevel);
   XtMapWidget(display_data->glyph);
   XSync(xvf_display,0);
}
